<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys-front-edition="org.ametys.plugins.frontedition.AmetysFrontEditionHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="skin://stylesheets/helper/comments.xsl"/>   
    
    <xsl:template name="common-content-head-css">
        <!-- Richtext Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <!-- End Richtext Styles -->
        
        <!-- breadcrumbs styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/breadcrumbs/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/breadcrumbs/scss/print.css')}" />
        <!-- End breadcrumbs styles -->
        
         <!-- comment styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/comment/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/comment/scss/print.css')}" />
        <!-- END::comment styles -->
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script src="{ametys:skinURL('templates/common/plugins/readingtime/readingtime.js')}"></script>
        
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/linkify/linkify.js')}"></script>
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/linkify/linkify-html.js')}"></script>
    </xsl:template>    
    
	<xsl:template name="common-content-body-content">
        <article class="ametys-main__inner--padding ametys-mb-30">
		  <div class="ametys-main__inner__md--inside">
                <!-- Header -->
                <xsl:call-template name="common-content-body-news-header"/>
                
                <div class="container">
                    <div class="ametys-cms-content-side-spaces">
                        <!-- Title -->
                        <xsl:call-template name="common-content-body-content-title"/>
                        
                        <!-- Main illustration -->
                        <xsl:call-template name="common-content-body-image-bigsize">
                            <xsl:with-param name="maxWidth" select="'435'"/>
                            <xsl:with-param name="maxHeight" select="'260'"/>
                        </xsl:call-template>  
                        
                        <!-- Rich content -->
                        <div class="ametys-richtext" data-ametys-metadata="{@id};content">
                            <xsl:call-template name="common-content-body-content-rich"/>
                        </div>
                    </div>
                </div>                        
          </div>
        </article>
        
        <script type="text/javascript">
            $j(function() {
                $j('article').readingTime({
                    readingTimeAsNumber: false,
                    readingTimeTarget: $j('.reading-time'),
                    wordsPerMinute: 270,
                    round: true,
                    lang: '<xsl:value-of select="$lang"/>',
                    success: function(data) {
                        if (data.eta.minutes &gt; 0)
                        {
                            // display reading time if greater than 1 min
                            $j('.reading-time').closest("div").show();
                        }
                    },
                    error: function(data) {
                        console.log(data.error);
                    }
                });
            });
        </script>
        
        <div class="ametys-comment ametys-comment--noshadow" data-content-id="{@id}">
            <xsl:call-template name="common-content-body-comments"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-content-title">
        <div class="text-center-sm">
            <h1 data-ametys-metadata="{@id};title"><xsl:value-of select="metadata/title"/></h1>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-news-header">
        <div class="ametys-top-crumbs d-flex flex-column justify-content-center mb-4">
            <div class="d-flex">
                <div class="ametys-top-crumbs__list mx-auto">
                    <!-- Date -->
                    <xsl:call-template name="common-content-body-start-date"/>
                    <!-- Reading time -->
                    <xsl:call-template name="common-content-body-reading-time"/>
                    <!-- Comments -->
                    <xsl:call-template name="common-content-body-nb-comments"/>
                    <!-- Author -->
                    <xsl:call-template name="common-content-body-author"/>
                    <!-- Category -->
                    <xsl:call-template name="common-content-body-category"/>
                </div>
            </div>
            
            <!-- Tags -->
            <xsl:call-template name="common-content-body-news-tags"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-start-date">
        <xsl:choose>
            <xsl:when test="metadata/start-date">
                <div>
                    <span class="ametys-top-crumbs__list_txt">
                        <span data-ametys-metadata="{@id};start-date">
                            <xsl:call-template name="news-date-pattern">
                                <xsl:with-param name="date" select="metadata/start-date"/>
                                <xsl:with-param name="role" select="'dtstart'"/>
                            </xsl:call-template>
                        </span>
                    </span>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="front-edition-placeholder" style="display: none"><span class="ametys-top-crumbs__list_txt" ><span data-ametys-metadata="{@id};start-date"><i18n:text i18n:key="SKIN_CONTENT_ADD_DATE" i18n:catalogue="skin.{$skin}"/></span></span></div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="common-content-body-reading-time">
        <div style="display:none">
            <span class="ametys-top-crumbs__list_txt">
                <i18n:text i18n:key="SKIN_CONTENT_HEADER_READING_TIME" i18n:catalogue="skin.{$skin}"/>
                <span class="reading-time"></span>
            </span>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:choose>
            <xsl:when test="$image">
                <div class="content-illustration {$class}" data-ametys-metadata="{@id};illustration/image">
                    <img alt="{$alternative}">
                        <xsl:attribute name="src">
                            <xsl:choose>
                                <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                    </img>
                </div>
            </xsl:when>  
            <xsl:otherwise>
                <div class="front-edition-placeholder content-illustration {$class}" data-ametys-metadata="{@id};illustration/image" style="display: none;">
                    <img src="{ametys:skinURL('img/add_image.png')}" alt="" width="435"/>
                </div>
            </xsl:otherwise>   
        </xsl:choose>   
    </xsl:template>  
    
    <xsl:template name="common-content-body-nb-comments">
        <div>
            <span class="ametys-top-crumbs__list_txt">
                <span data-ametys-nb-comments="true"></span><span data-ametys-nb-comments-text="true"><i18n:text i18n:key="SKIN_CONTENT_HEADER_COMMENTS" i18n:catalogue="skin.{$skin}"/></span>
            </span>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-author">
        <xsl:variable name="rawAuthor">
            <xsl:call-template name="user-info">
                <xsl:with-param name="userIdentity" select="@creator"/>
                <xsl:with-param name="imgWidth">40</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="author" select="exslt:node-set($rawAuthor)"/>
        
        <div>
            <div class="ametys-top-crumbs__list_usr">
                <div class="ametys-top-crumbs__list_usr_img">
                    <img src="{$author/user/imgUrl}" alt="" />
                </div>
                <div class="ametys-top-crumbs__list_usr_txt">
                    <div class="ametys-top-crumbs__list_usr_txt-title"><xsl:value-of select="$author/user/fullname"/></div>
                    <xsl:if test="$author/user/organisationAccronym != ''">
                       <span title="{$author/user/organisation}" class="ametys-tag ametys-tag--xs ametys-tag--gray"><xsl:value-of select="$author/user/organisationAccronym"/></span>
                    </xsl:if>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-category">
        <xsl:variable name="rawCategories">
            <categories>
                <xsl:for-each select="tags/*[starts-with(local-name(), 'WORKSPACES_CATEGORY_')]">
                    <xsl:variable name="color" select="project:categoryColor(substring-after(local-name(), 'WORKSPACES_CATEGORY_'))"/>
                    <xsl:if test="$color">
                        <category>
                            <label><xsl:value-of select="."/></label>
                            <xsl:copy-of select="$color"/>
                        </category>
                    </xsl:if>
                </xsl:for-each>
            </categories>
        </xsl:variable>
        <xsl:variable name="categories" select="exslt:node-set($rawCategories)/categories"/>
        
        <xsl:if test="$categories/category">
            <div>
                <span class="ametys-tag ametys-tag--sm" style="background-color: {$categories/category/color/main}; color: {$categories/category/color/text}"><xsl:value-of select="$categories/category/label"/></span>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-content-body-news-tags">
        <xsl:call-template name="news-tags"/>
    </xsl:template>
    
    <xsl:template name="news-tags">
        <xsl:param name="tagPrefix">WORKSPACES_KEYWORD_</xsl:param>
        <xsl:param name="maxlength">3</xsl:param>
        
        <xsl:if test="tags/*[starts-with(local-name(), $tagPrefix)]">
            <xsl:variable name="orderedKeywords">
                <keywords>
                    <xsl:for-each select="tags/*[starts-with(local-name(), $tagPrefix)]">
                        <xsl:sort select="local-name()" order="ascending"/>
                        <xsl:copy-of select="."/>
                    </xsl:for-each>
                </keywords>
            </xsl:variable>
            <xsl:variable name="keywords" select="exslt:node-set($orderedKeywords)/keywords"/>
            
            <div class="d-flex flex-wrap align-items-center mx-auto mt-4">
                <xsl:for-each select="$keywords/*[position() &lt;= $maxlength]">
                    <span class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent-light">
                        <i class="fas fa-hashtag"></i>
                        <xsl:value-of select="."/>
                    </span>
                </xsl:for-each>
                
                <xsl:if test="count($keywords/*) &gt; $maxlength">
                    <a class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent-light" href="javascript:;">
                        <xsl:attribute name="data-ametys-tooltip">
                            <xsl:for-each select="$keywords/*[position() &gt; $maxlength]">
                                <xsl:value-of select="."/><xsl:if test="position() != last()">, </xsl:if>
                            </xsl:for-each>
                        </xsl:attribute>
                        <i class="fas fa-plus"></i>
                        <xsl:value-of select="count($keywords/*[position() &gt; $maxlength])"/>
                    </a>
                </xsl:if>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ametys-front-edition-insert-button-simple">
        <xsl:param name="button-text"/>
        <xsl:param name="javascript-function"/>
        <xsl:param name="class"/>
        <xsl:param name="title-i18n"/>
        <xsl:param name="style"/>
        <xsl:param name="id"/>
        
        <a class="{$class}" data-ametys-tooltip="{$title-i18n}" i18n:attr="data-ametys-tooltip" href="javascript:void(0)" onclick="{$javascript-function}">
            <xsl:if test="$style != ''"><xsl:attribute name="style"><xsl:value-of select="$style"/></xsl:attribute></xsl:if>
            <xsl:if test="$id != ''"><xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute></xsl:if>
            <span><xsl:copy-of select="$button-text"/></span>
        </a>
    </xsl:template>
    
    <!-- Override to wrap comments into 'ametys-main__inner__md' -->
    <xsl:template name="comments-inner">
        <div class="ametys-comment__bottom" id="content-comments-wrapper-{$uniqueId}" data-ametys-comments-wrapper="{@id}">
            <div class="ametys-main__inner__md">
                <xsl:call-template name="comments-header"/>
                
                <xsl:call-template name="comment-form"/>
                
                <div id="content-comments-{$uniqueId}" data-ametys-comments="{@id}">
                    <!-- Comments will be inserted here -->
                </div>
                
                <!-- Show/hide more comments -->
                <div class="ametys-comment__bottom__list_footer" data-show-other-comments="true" style="display: none">
                    <span class="ametys-comments-show"><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_SHOW_COMMENTS" i18n:catalogue="plugin.workspaces"/></span>
                    <span class="ametys-comments-hide d-none"><i18n:text i18n:key="PLUGINS_WORKSPACES_WALL_CONTENT_HIDE_COMMENTS" i18n:catalogue="plugin.workspaces"/></span>
                </div>
            </div>
        </div>
    </xsl:template>
    
</xsl:stylesheet>