<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="skin://stylesheets/variables.xsl"/>
    
    <xsl:template name="footer">
        <footer class="ametys-footer">  
            <div class="ametys-footer-inner">
            
                <!-- Logo -->
                <xsl:call-template name="footer-logo"/>
            
                <div class="ametys-footer-r">
                    <!-- Footer links -->                    
                    <xsl:call-template name="footer-links"/>

                    <!-- Social links -->
                    <xsl:call-template name="footer-socials"/>
                </div>
            </div>  
        </footer>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <a class="ametys-footer-logo" href="{$catalogHomeUrl}">
            <img class="ametys-footer-logo__img" src="{ametys:skinURL('templates/common/img/logo-colorful.svg')}" alt="Ametys" />
        </a>
    </xsl:template>
    
    <xsl:template name="footer-links">
        <xsl:if test="$catalogSiteName != ''">
            <xsl:variable name="footerPageIds" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_FOOTER_LINK')"/>
            <xsl:if test="$footerPageIds">
                <ul class="ametys-footer-list">
                    <xsl:for-each select="$footerPageIds">
                        <xsl:variable name="footerPage" select="ametys:sitemap(@id, 0)"/>
                        <xsl:apply-templates select="$footerPage" mode="footer-link"/>
                    </xsl:for-each>
                </ul>
            </xsl:if>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link">
        <li>
            <a href="{resolver:resolve('page', @sitemap:id)}">
                <xsl:apply-templates select="." mode="footer-link-attributes"/>
                <xsl:value-of select="@sitemap:title"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link-attributes">
        <xsl:choose>
            <xsl:when test="@PLUGIN_TAGS_WORKSPACES_CONTACT = 'empty'">
                <xsl:attribute name="data-ametys-mobile-user-link">true</xsl:attribute>
                <xsl:attribute name="data-ametys-mobile-user-link-icon">far fa-envelope</xsl:attribute>
            </xsl:when>
            <xsl:when test="@PLUGIN_TAGS_WORKSPACES_CGU = 'empty'">
                <xsl:attribute name="data-ametys-mobile-user-link">true</xsl:attribute>
                <xsl:attribute name="data-ametys-mobile-user-link-icon">far fa-copyright</xsl:attribute>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="footer-socials">
        <div class="ametys-footer-socials">
            <xsl:call-template name="footer-socials-facebook"/>
            <xsl:call-template name="footer-socials-twitter"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-socials-facebook">
        <a href="javascript:;">
            <i class="fab fa-facebook-f"></i>
        </a>
    </xsl:template>
    
    <xsl:template name="footer-socials-twitter">
        <a href="javascript:;">
            <i class="fab fa-x-twitter"></i>
        </a>
    </xsl:template>
</xsl:stylesheet>