<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:exslt="http://exslt.org/common"
                            exclude-result-prefixes="sitemap resolver ametys exslt">

    <xsl:import href="plugin:core-impl://stylesheets/vuejs/helper.xsl" /> 
    <xsl:import href="skin://stylesheets/additionnal-body.xsl"/>
    
    <xsl:import href="skin://stylesheets/utils.xsl" />
    <xsl:import href="skin://stylesheets/variables.xsl" />
    <xsl:import href="skin://stylesheets/head.xsl" />
    <xsl:import href="skin://stylesheets/zones.xsl" />
    <xsl:import href="skin://stylesheets/menus.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl"/>
    <xsl:import href="skin://stylesheets/footer.xsl"/>
    
    <xsl:import href="skin://stylesheets/activities.xsl"/>

    <xsl:variable name="sitemap" select="/cms/inputData/sitemap" />
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')" />

    <!-- + | BASE + -->
    <xsl:template name="template">
        <html>
            <xsl:call-template name="head" />
            <xsl:call-template name="body" />
        </html>
    </xsl:template>
    
    <xsl:template name="body">
        <body>
            <xsl:call-template name="mobile-media-js"/>
            
            <xsl:call-template name="header"/>
            
            <main class="ametys-main">
                
                <xsl:call-template name="main-banner"/>
                
                <xsl:call-template name="main-content"/>
                
            </main>
            
            <xsl:call-template name="footer"/>
            
            <xsl:call-template name="scroll-top"/>
            
            <!-- Recent activities -->
            <xsl:call-template name="recent-activities"/>
            
            <xsl:call-template name="mobile-header"/>
            
            <xsl:call-template name="additionnal-body"/>
        </body>
    </xsl:template>
    
    <xsl:template name="scroll-top">
        <div class="ametys__scrolltop" style="display: none;">
            <img src="{ametys:skinURL('templates/common/img/icons/arrow-up.svg')}" alt="Scroll Top" />
        </div>
    </xsl:template>
    
    <xsl:template name="mobile-media-js">
        <script type="text/javascript">
            function onResize(e) {
                if (e.matches) {
                    // the viewport is wide
                    $j(document.body).removeClass('mobile');
                }
                else
                {
                    $j(document.body).addClass('mobile');
                }
            }
        
            var mql = window.matchMedia('(min-width: 768px) and (min-height: 500px)');
            mql.addListener(onResize);
            onResize(mql);
            if (!mql.matches)
            {
                // add loading class to wait mobile vue component
                $j(document.body).addClass('mobile-loading');
            }
        </script>    
    </xsl:template>
    
    <xsl:template name="main-banner"/>
    
    <xsl:template name="main-content"/>
    
    <xsl:template name="mobile-header">
        <xsl:call-template name="vuejs">          
            <xsl:with-param name="component">mobile-layout</xsl:with-param>          
            <xsl:with-param name="location" select="ametys:pluginResourceURL('workspaces', 'vuejs/mobile-layout')"/>   
            <xsl:with-param name="uniqueId">v-mobile-header</xsl:with-param>
            <xsl:with-param name="config"><xsl:call-template name="mobile-header-config"/></xsl:with-param>
        </xsl:call-template> 
    </xsl:template>
    
    <xsl:template name="mobile-header-config">
        <xsl:variable name="config">
            {
                logo: "<xsl:call-template name="mobile-header-logo"/>",
                whiteLogo: "<xsl:call-template name="mobile-header-logo-white"/>",
                logoAlt: "<xsl:call-template name="mobile-header-logo-alt"/>",
                banner: "<xsl:call-template name="mobile-header-banner"/>",
                title: "<xsl:call-template name="mobile-header-title"/>",
                user: <xsl:call-template name="mobile-header-user"/>,
                simpleMode: <xsl:call-template name="mobile-header-simplemode"/>,
                links: <xsl:call-template name="mobile-header-menu-items"/>,
                withTabs: <xsl:call-template name="mobile-header-withtabs"/>,
                searchUrl: "<xsl:call-template name="mobile-search-url"/>",
                catalogHomeUrl: "<xsl:value-of select="$catalogHomeUrl"/>"
            }
        </xsl:variable>
        <xsl:value-of select="$config"/>
    </xsl:template>
    
    <xsl:template name="mobile-header-logo">
        <xsl:value-of select="ametys:skinURL('templates/common/img/icons/logo_ametys.svg')"/>
    </xsl:template>
    
    <xsl:template name="mobile-header-logo-white">
        <xsl:value-of select="ametys:skinURL('templates/common/img/icons/logo_ametys_blanc.svg')"/>
    </xsl:template>
    
    <xsl:template name="mobile-header-logo-alt">
        <i18n:text i18n:key="SKIN_LOGO_ALT" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="mobile-header-title"/>
    
    <xsl:template name="mobile-header-simplemode">true</xsl:template>
    
    <xsl:template name="mobile-header-withtabs">false</xsl:template>
    
    <xsl:template name="mobile-search-url">
         <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag($catalogSiteName, $lang, 'WORKSPACES_SEARCH')"/>
         <xsl:if test="$searchPage/@id"><xsl:value-of select="resolver:resolve('page', $searchPage/@id)"/></xsl:if>
    </xsl:template>
    
    <xsl:template name="mobile-header-banner"/>
    
    <xsl:template name="mobile-header-menu-items">
       [<xsl:if test="$sitemap/page[@sitemap:name = 'index']">
            { href: "<xsl:value-of select="concat($site-uri-prefix, '/', $lang, '/index.html')"/>", title: "<xsl:value-of select="$sitemap/page[@sitemap:name = 'index']/@sitemap:title"/>"<xsl:if test="$sitemap/page[@sitemap:name = 'index']/@sitemap:in-path='true'">, isActive: true</xsl:if>},
        </xsl:if>
        <xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and @sitemap:name != 'index' and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]|$sitemap/page[@sitemap:path='minisite']/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
            { href: "<xsl:value-of select="resolver:resolve('page', @sitemap:id)"/>", title: "<xsl:value-of select="@sitemap:title"/>"<xsl:if test="@sitemap:in-path">, isActive: true</xsl:if>}<xsl:if test="position() != last()">,</xsl:if>
        </xsl:for-each>]
    </xsl:template>
    
    <xsl:template name="mobile-header-user">
        {<xsl:for-each select="$currentUser/user/*">
            <xsl:choose>
                <xsl:when test="local-name() = 'pageId'">"pageUrl":"<xsl:if test="$currentUser/user/pageId != ''"><xsl:value-of select="resolver:resolve('page', $currentUser/user/pageId)"/></xsl:if>"<xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    "<xsl:value-of select="local-name()"/>": "<xsl:value-of select="."/>"<xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>}
    </xsl:template>

</xsl:stylesheet>
