/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository;

import java.io.IOException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.plugins.repositoryapp.RepositoryProvider;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DescriptorsGenerator
extends ServiceableGenerator {
    protected RepositoryProvider _repositoryProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._repositoryProvider = (RepositoryProvider)((Object)serviceManager.lookup(RepositoryProvider.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String[] descriptorKeys;
        Repository repository = this._repositoryProvider.getRepository();
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"repository");
        for (String key : descriptorKeys = repository.getDescriptorKeys()) {
            Value[] values = repository.getDescriptorValues(key);
            AttributesImpl descAttrs = new AttributesImpl();
            descAttrs.addCDATAAttribute("key", key);
            descAttrs.addCDATAAttribute("standard", String.valueOf(repository.isStandardDescriptor(key)));
            descAttrs.addCDATAAttribute("singleValue", String.valueOf(repository.isSingleValueDescriptor(key)));
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"descriptor", (Attributes)descAttrs);
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"values");
            if (values != null) {
                for (Value value : values) {
                    try {
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addCDATAAttribute("value", value.getString());
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"value", (Attributes)attrs);
                    }
                    catch (RepositoryException e) {
                        this.getLogger().error("Error while retrieving a repository descriptor.", (Throwable)e);
                    }
                }
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"values");
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"descriptor");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"repository");
        this.contentHandler.endDocument();
    }
}

