/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.repository.maintenance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.ametys.workspaces.repository.maintenance.AbstractMaintenanceTask;
import org.ametys.workspaces.repository.maintenance.TaskProgress;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.check.ReportItem;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckTask
extends AbstractMaintenanceTask
implements ConsistencyCheckListener {
    protected RepositoryContext _repositoryContext;
    protected Session _session;
    private IterablePersistenceManager[] _pmList;

    @Override
    protected void initialize() throws RepositoryException {
        int i;
        this._repositoryContext = RepositoryContext.create((RepositoryConfig)this._repositoryConfig);
        this._session = this._repositoryContext.getRepository().login((Credentials)new SimpleCredentials("__MAINTENANCE_TASK__", "".toCharArray()));
        ArrayList<PersistenceManager> pmList = new ArrayList<PersistenceManager>();
        InternalVersionManagerImpl vm = this._repositoryContext.getInternalVersionManager();
        pmList.add(vm.getPersistenceManager());
        String[] wspNames = this._repositoryContext.getWorkspaceManager().getWorkspaceNames();
        for (i = 0; i < wspNames.length; ++i) {
            pmList.add(this.getPM(wspNames[i]));
        }
        this._pmList = new IterablePersistenceManager[pmList.size()];
        for (i = 0; i < pmList.size(); ++i) {
            IterablePersistenceManager[] pm = (IterablePersistenceManager[])pmList.get(i);
            if (!(pm instanceof IterablePersistenceManager)) {
                this._pmList = null;
                break;
            }
            this._pmList[i] = (IterablePersistenceManager)pm;
        }
        int count = 0;
        try {
            for (IterablePersistenceManager pm : this._pmList) {
                count += pm.getAllNodeIds(null, 0).size();
            }
            this._progress = new TaskProgress(count);
        }
        catch (Exception e) {
            this._progress = new TaskProgress(0.0f);
            this._progress.setInErrorState(e);
            this._logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    protected void setLogger() {
        this.setLogger(LoggerFactory.getLogger(ConsistencyCheckTask.class));
    }

    @Override
    protected void apply() throws RepositoryException {
        for (IterablePersistenceManager pm : this._pmList) {
            if (!(pm instanceof AbstractBundlePersistenceManager)) continue;
            ConsistencyReport report = ((AbstractBundlePersistenceManager)pm).check(null, true, false, null, (ConsistencyCheckListener)this);
            this._logger.info("Consistency check done for persistence manager : '" + pm.toString() + "' in " + (float)report.getElapsedTimeMs() / 1000.0f + " s.");
            this._logger.info(report.getNodeCount() + " nodes were checked.");
            this._logger.info(report.getItems().isEmpty() ? "No consistency problems were reported." : report.getItems().size() + " consistency problems were reported.");
        }
    }

    @Override
    protected void close() {
        if (this._session != null) {
            this._session.logout();
        }
        if (this._repositoryContext != null && this._repositoryContext.getRepository() != null) {
            this._repositoryContext.getRepository().shutdown();
        }
        if (this._progress != null) {
            this._progress.progressRelativePercentage(100);
        }
    }

    protected PersistenceManager getPM(String workspaceName) {
        try {
            Object workspaceInfo = ConsistencyCheckTask.findAndInvokeMethod(this._repositoryContext.getRepository(), "getWorkspaceInfo", new Object[]{workspaceName});
            return (PersistenceManager)ConsistencyCheckTask.findAndInvokeMethod(workspaceInfo, "getPersistenceManager", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Object findAndInvokeMethod(Object obj, String name, Object[] parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = null;
        Method[] ms = obj.getClass().getDeclaredMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method x = ms[i];
            if (!x.getName().equals(name)) continue;
            m = x;
            m.setAccessible(true);
            return m.invoke(obj, parameters);
        }
        return null;
    }

    public void startCheck(String id) {
        if (this._progress != null) {
            this._progress.progress();
        }
    }

    public void report(ReportItem item) {
        this._logger.warn(item.toString());
    }

    public void error(String id, String message) {
        this._logger.error("error during the consistency check -> id : [ " + id + "]\n" + message);
    }

    public void info(String id, String message) {
        this._logger.info("error during the consistency check -> id : [ " + id + "]\n" + message);
    }
}

