/*
 * Decompiled with CFR 0.152.
 */
package io.bit3.jsass.function;

import io.bit3.jsass.annotation.DebugFunction;
import io.bit3.jsass.annotation.ErrorFunction;
import io.bit3.jsass.annotation.WarnFunction;
import io.bit3.jsass.context.Context;
import io.bit3.jsass.context.ImportStack;
import io.bit3.jsass.function.FunctionArgumentSignature;
import io.bit3.jsass.function.FunctionArgumentSignatureFactory;
import io.bit3.jsass.function.FunctionDeclaration;
import io.bit3.jsass.function.FunctionWrapper;
import io.bit3.jsass.function.arguments.converter.ArgumentConverter;
import io.bit3.jsass.function.arguments.converter.ObjectArgumentConverter;
import io.bit3.jsass.function.arguments.factory.ArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.BooleanArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.ByteArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.CharacterArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.ContextArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.DoubleArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.FloatArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.IntegerArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.LastImportArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.LongArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.ShortArgumentConverterFactory;
import io.bit3.jsass.function.arguments.factory.StringArgumentConverterFactory;
import io.bit3.jsass.type.SassString;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionWrapperFactory {
    private final FunctionArgumentSignatureFactory functionArgumentSignatureFactory;
    private final List<ArgumentConverterFactory> argumentConverterFactories;

    public FunctionWrapperFactory(FunctionArgumentSignatureFactory functionArgumentSignatureFactory) {
        this.functionArgumentSignatureFactory = functionArgumentSignatureFactory;
        this.argumentConverterFactories = new LinkedList<ArgumentConverterFactory>();
        this.argumentConverterFactories.add(new BooleanArgumentConverterFactory());
        this.argumentConverterFactories.add(new ByteArgumentConverterFactory());
        this.argumentConverterFactories.add(new CharacterArgumentConverterFactory());
        this.argumentConverterFactories.add(new ContextArgumentConverterFactory());
        this.argumentConverterFactories.add(new DoubleArgumentConverterFactory());
        this.argumentConverterFactories.add(new FloatArgumentConverterFactory());
        this.argumentConverterFactories.add(new IntegerArgumentConverterFactory());
        this.argumentConverterFactories.add(new LastImportArgumentConverterFactory());
        this.argumentConverterFactories.add(new LongArgumentConverterFactory());
        this.argumentConverterFactories.add(new ShortArgumentConverterFactory());
        this.argumentConverterFactories.add(new StringArgumentConverterFactory());
    }

    public List<FunctionWrapper> compileFunctions(ImportStack importStack, Context context, List<?> objects) {
        LinkedList<FunctionWrapper> callbacks = new LinkedList<FunctionWrapper>();
        for (Object object : objects) {
            List<FunctionWrapper> objectCallbacks = this.compileFunctions(importStack, context, object);
            callbacks.addAll(objectCallbacks);
        }
        return callbacks;
    }

    public List<FunctionWrapper> compileFunctions(ImportStack importStack, Context context, Object object) {
        Class<?> functionClass = object.getClass();
        Method[] methods = functionClass.getDeclaredMethods();
        LinkedList<FunctionDeclaration> declarations = new LinkedList<FunctionDeclaration>();
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            FunctionDeclaration declaration = this.createDeclaration(importStack, context, object, method);
            declarations.add(declaration);
        }
        return declarations.stream().map(FunctionWrapper::new).collect(Collectors.toList());
    }

    public FunctionDeclaration createDeclaration(ImportStack importStack, Context context, Object object, Method method) {
        StringBuilder signature = new StringBuilder();
        Parameter[] parameters = method.getParameters();
        ArrayList<ArgumentConverter> argumentConverters = new ArrayList<ArgumentConverter>(method.getParameterCount());
        signature.append(method.getName()).append("(");
        int parameterCount = 0;
        for (Parameter parameter : parameters) {
            ArgumentConverter argumentConverter = this.createArgumentConverter(object, method, parameter);
            argumentConverters.add(argumentConverter);
            List<FunctionArgumentSignature> list = argumentConverter.argumentSignatures(object, method, parameter, this.functionArgumentSignatureFactory);
            for (FunctionArgumentSignature functionArgumentSignature : list) {
                String name = functionArgumentSignature.getName();
                Object defaultValue = functionArgumentSignature.getDefaultValue();
                if (parameterCount > 0) {
                    signature.append(", ");
                }
                signature.append("$").append(name);
                if (null != defaultValue) {
                    signature.append(": ").append(this.formatDefaultValue(defaultValue));
                }
                ++parameterCount;
            }
        }
        signature.append(")");
        if (method.isAnnotationPresent(WarnFunction.class)) {
            signature.setLength(0);
            signature.append("@warn");
        } else if (method.isAnnotationPresent(ErrorFunction.class)) {
            signature.setLength(0);
            signature.append("@error");
        } else if (method.isAnnotationPresent(DebugFunction.class)) {
            signature.setLength(0);
            signature.append("@debug");
        }
        return new FunctionDeclaration(importStack, context, signature.toString(), object, method, argumentConverters);
    }

    private String formatDefaultValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "true" : "false";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Collection) {
            return this.formatCollectionValue((Collection)value);
        }
        String string = value.toString();
        if (string.startsWith("$")) {
            return string;
        }
        return SassString.escape(string);
    }

    private String formatCollectionValue(Collection value) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        boolean first = true;
        for (Object item : value) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(this.formatDefaultValue(item));
        }
        builder.append(")");
        return builder.toString();
    }

    private ArgumentConverter createArgumentConverter(Object object, Method method, Parameter parameter) {
        Class<?> type = parameter.getType();
        for (ArgumentConverterFactory factory : this.argumentConverterFactories) {
            if (!factory.canHandle(type)) continue;
            return factory.create(object, method, parameter);
        }
        return new ObjectArgumentConverter(type);
    }
}

