/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.blocking;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.constructs.blocking.UpdatingCacheEntryFactory;
import net.sf.ehcache.constructs.concurrent.Mutex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdatingSelfPopulatingCache
extends SelfPopulatingCache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache == null ? (class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache = UpdatingSelfPopulatingCache.class$("net.sf.ehcache.constructs.blocking.UpdatingSelfPopulatingCache")) : class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache).getName());
    static /* synthetic */ Class class$net$sf$ehcache$constructs$blocking$UpdatingSelfPopulatingCache;

    public UpdatingSelfPopulatingCache(Ehcache cache, UpdatingCacheEntryFactory factory) throws CacheException {
        super(cache, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element get(Object key) throws LockTimeoutException {
        String oldThreadName = Thread.currentThread().getName();
        this.setThreadName("get", key);
        try {
            Ehcache backingCache = this.getCache();
            Element element = backingCache.get(key);
            if (element == null) {
                element = super.get(key);
            } else {
                Mutex lock = this.getLockForKey(key);
                try {
                    lock.acquire();
                    this.update(key);
                }
                finally {
                    lock.release();
                }
            }
            Element element2 = element;
            return element2;
        }
        catch (Throwable throwable) {
            this.setThreadName("put", key);
            this.put(new Element(key, null));
            throw new LockTimeoutException("Could not fetch object for cache entry \"" + key + "\".", throwable);
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }

    private void update(Object key) {
        try {
            Ehcache backingCache = this.getCache();
            Element element = backingCache.getQuiet(key);
            if (element == null && LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getName() + ": entry with key " + key + " has been removed - skipping it"));
            }
            this.refreshElement(element, backingCache);
        }
        catch (Exception e) {
            LOG.warn((Object)(this.getName() + "Could not refresh element " + key), (Throwable)e);
        }
    }

    public void refresh() throws CacheException {
        throw new CacheException("UpdatingSelfPopulatingCache objects should not be refreshed.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

