/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import org.rrd4j.DsType;
import org.rrd4j.core.Util;

public class DsDef {
    static final String FORCE_ZEROS_FOR_NANS_SUFFIX = "!";
    private final String dsName;
    private final DsType dsType;
    private final long heartbeat;
    private final double minValue;
    private final double maxValue;

    public DsDef(String dsName, DsType dsType, long heartbeat, double minValue, double maxValue) {
        if (dsName == null) {
            throw new IllegalArgumentException("Null datasource name specified");
        }
        if (dsName.length() == 0) {
            throw new IllegalArgumentException("Datasource name length equal to zero");
        }
        if (dsName.length() > 20) {
            throw new IllegalArgumentException("Datasource name [" + dsName + "] too long (" + dsName.length() + " chars found, only " + 20 + " allowed)");
        }
        if (dsType == null) {
            throw new IllegalArgumentException("Null datasource type specified");
        }
        if (heartbeat <= 0L) {
            throw new IllegalArgumentException("Invalid heartbeat, must be positive: " + heartbeat);
        }
        if (!Double.isNaN(minValue) && !Double.isNaN(maxValue) && minValue >= maxValue) {
            throw new IllegalArgumentException("Invalid min/max values specified: " + minValue + "/" + maxValue);
        }
        this.dsName = dsName;
        this.dsType = dsType;
        this.heartbeat = heartbeat;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getDsName() {
        return this.dsName;
    }

    public DsType getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + (Object)((Object)this.dsType) + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, "U", false) + ":" + Util.formatDouble(this.maxValue, "U", false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DsDef) {
            DsDef dsObj = (DsDef)obj;
            return this.dsName.equals(dsObj.dsName);
        }
        return false;
    }

    public int hashCode() {
        return this.dsName.hashCode();
    }

    boolean exactlyEqual(DsDef def) {
        return this.dsName.equals(def.dsName) && this.dsType == def.dsType && this.heartbeat == def.heartbeat && Util.equal(this.minValue, def.minValue) && Util.equal(this.maxValue, def.maxValue);
    }
}

