/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.Util;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private final AtomicInteger usage = new AtomicInteger(0);
    private final ReentrantLock countLock = new ReentrantLock();
    private final Condition full = this.countLock.newCondition();
    private int maxCapacity = 200;
    private final ConcurrentMap<String, RrdEntry> pool = new ConcurrentHashMap<String, RrdEntry>(200);

    public static RrdDbPool getInstance() {
        return RrdDbPoolSingletonHolder.instance;
    }

    RrdDbPool() {
        if (!(RrdBackendFactory.getDefaultFactory() instanceof RrdFileBackendFactory)) {
            throw new RuntimeException("Cannot create instance of " + this.getClass().getName() + " with " + "a default backend factory not derived from RrdFileBackendFactory");
        }
    }

    public int getOpenFileCount() {
        return this.usage.get();
    }

    public String[] getOpenFiles() {
        HashSet files = new HashSet();
        files.addAll(this.pool.keySet());
        return files.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RrdEntry getEntry(String path, boolean cancreate) throws IOException, InterruptedException {
        canonicalPath = Util.getCanonicalPath(path);
        do {
            if ((ref = (RrdEntry)this.pool.get(canonicalPath)) == null) {
                try {
                    this.countLock.lockInterruptibly();
                    while (ref == null && this.usage.get() >= this.maxCapacity && cancreate) {
                        this.full.await();
                        ref = (RrdEntry)this.pool.get(canonicalPath);
                    }
                    if (ref != null || !cancreate || (ref = this.pool.putIfAbsent(canonicalPath, new RrdEntry(true, canonicalPath))) != null) ** GOTO lbl24
                    ref = new RrdEntry(false, canonicalPath);
                    this.usage.incrementAndGet();
                }
                finally {
                    if (this.countLock.isHeldByCurrentThread()) {
                        this.countLock.unlock();
                    }
                }
            } else {
                if (!ref.placeholder) {
                    if (this.pool.replace(canonicalPath, ref, new RrdEntry(true, canonicalPath))) continue;
                    ref = new RrdEntry(true, canonicalPath);
                    continue;
                }
                ref.inuse.await();
            }
lbl24:
            // 5 sources

        } while (ref != null && ref.placeholder);
        return ref;
    }

    private void passNext(ACTION a, RrdEntry e) {
        RrdEntry o = null;
        switch (a) {
            case SWAP: {
                o = this.pool.put(e.canonicalPath, e);
                break;
            }
            case DROP: {
                o = (RrdEntry)this.pool.remove(e.canonicalPath);
                if (this.usage.decrementAndGet() >= this.maxCapacity) break;
                try {
                    this.countLock.lockInterruptibly();
                    this.full.signalAll();
                    this.countLock.unlock();
                    break;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (o != null) {
            o.inuse.countDown();
        }
    }

    public void release(RrdDb rrdDb) throws IOException {
        RrdEntry ref;
        if (rrdDb == null) {
            return;
        }
        try {
            ref = this.getEntry(rrdDb.getPath(), false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("release interrupted for " + rrdDb, e);
        }
        if (ref == null) {
            return;
        }
        if (ref.count <= 0) {
            this.passNext(ACTION.DROP, ref);
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], the file was never requested");
        }
        if (--ref.count == 0) {
            if (ref.rrdDb == null) {
                this.passNext(ACTION.DROP, ref);
                throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], pool corruption");
            }
            ref.rrdDb.close();
            this.passNext(ACTION.DROP, ref);
            ref.waitempty.countDown();
        } else {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    public RrdDb requestRrdDb(String path) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(path, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for " + path, e);
        }
        if (ref.count == 0) {
            try {
                ref.rrdDb = new RrdDb(path);
            }
            catch (IOException e) {
                this.passNext(ACTION.DROP, ref);
                throw e;
            }
        }
        ++ref.count;
        this.passNext(ACTION.SWAP, ref);
        return ref.rrdDb;
    }

    private RrdEntry waitEmpty(String path) throws IOException, InterruptedException {
        RrdEntry ref = this.getEntry(path, true);
        try {
            while (ref.count != 0) {
                this.passNext(ACTION.SWAP, ref);
                ref.waitempty.await();
                ref = this.getEntry(path, true);
            }
            return ref;
        }
        catch (InterruptedException e) {
            this.passNext(ACTION.DROP, ref);
            throw e;
        }
    }

    private RrdEntry requestEmpty(String path) throws InterruptedException, IOException {
        RrdEntry ref = this.waitEmpty(path);
        ref.count = 1;
        return ref;
    }

    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.requestEmpty(rrdDef.getPath());
            RrdDb rrdDb = ref.rrdDb = new RrdDb(rrdDef);
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for new rrdDef " + rrdDef.getPath(), e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    public RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.requestEmpty(path);
            RrdDb rrdDb = ref.rrdDb = new RrdDb(path, sourcePath);
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("request interrupted for new rrd " + path, e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int newCapacity) {
        int oldUsage = this.usage.getAndSet(this.maxCapacity);
        try {
            if (oldUsage != 0) {
                throw new RuntimeException("Can only be done on a empty pool");
            }
        }
        finally {
            this.usage.set(oldUsage);
        }
        this.maxCapacity = newCapacity;
    }

    public int getCapacity() {
        return this.maxCapacity;
    }

    public int getOpenCount(RrdDb rrdDb) throws IOException {
        return this.getOpenCount(rrdDb.getPath());
    }

    public int getOpenCount(String path) throws IOException {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(path, false);
            if (ref == null) {
                int n = 0;
                return n;
            }
            int n = ref.count;
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("getOpenCount interrupted", e);
        }
        finally {
            if (ref != null) {
                this.passNext(ACTION.SWAP, ref);
            }
        }
    }

    private static enum ACTION {
        SWAP,
        DROP;

    }

    private static class RrdEntry {
        RrdDb rrdDb = null;
        int count = 0;
        final CountDownLatch waitempty;
        final CountDownLatch inuse;
        final boolean placeholder;
        final String canonicalPath;

        RrdEntry(boolean placeholder, String canonicalPath) {
            this.placeholder = placeholder;
            this.canonicalPath = canonicalPath;
            if (placeholder) {
                this.inuse = new CountDownLatch(1);
                this.waitempty = null;
            } else {
                this.inuse = null;
                this.waitempty = new CountDownLatch(1);
            }
        }
    }

    private static class RrdDbPoolSingletonHolder {
        static final RrdDbPool instance = new RrdDbPool();

        private RrdDbPoolSingletonHolder() {
        }
    }
}

