/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource xmlInputSource) throws IOException {
        super(xmlInputSource);
    }

    public RrdDefTemplate(String xmlString) throws IOException {
        super(xmlString);
    }

    public RrdDefTemplate(File xmlFile) throws IOException {
        super(xmlFile);
    }

    public RrdDef getRrdDef() {
        Node[] arcNodes;
        Node[] dsNodes;
        if (!"rrd_def".equals(this.root.getTagName())) {
            throw new IllegalArgumentException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String path = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(path);
        try {
            String startStr = this.getChildValue(this.root, "start");
            Calendar startGc = Util.getCalendar(startStr);
            rrdDef.setStartTime(startGc);
        }
        catch (Exception startStr) {
            // empty catch block
        }
        try {
            long step = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(step);
        }
        catch (Exception step) {
            // empty catch block
        }
        for (Node dsNode : dsNodes = RrdDefTemplate.getChildNodes(this.root, "datasource")) {
            this.validateTagsOnlyOnce(dsNode, new String[]{"name", "type", "heartbeat", "min", "max"});
            String name = this.getChildValue(dsNode, "name");
            DsType type = DsType.valueOf(this.getChildValue(dsNode, "type"));
            long heartbeat = this.getChildValueAsLong(dsNode, "heartbeat");
            double min = this.getChildValueAsDouble(dsNode, "min");
            double max = this.getChildValueAsDouble(dsNode, "max");
            rrdDef.addDatasource(name, type, heartbeat, min, max);
        }
        for (Node arcNode : arcNodes = RrdDefTemplate.getChildNodes(this.root, "archive")) {
            this.validateTagsOnlyOnce(arcNode, new String[]{"cf", "xff", "steps", "rows"});
            ConsolFun consolFun = ConsolFun.valueOf(this.getChildValue(arcNode, "cf"));
            double xff = this.getChildValueAsDouble(arcNode, "xff");
            int steps = this.getChildValueAsInt(arcNode, "steps");
            int rows = this.getChildValueAsInt(arcNode, "rows");
            rrdDef.addArchive(consolFun, xff, steps, rows);
        }
        return rrdDef;
    }
}

