/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rrd4j.core.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class XmlTemplate {
    private static final String PATTERN_STRING = "\\$\\{(\\w+)\\}";
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    protected Element root;
    private HashMap<String, Object> valueMap = new HashMap();
    private HashSet<Node> validatedNodes = new HashSet();

    protected XmlTemplate(InputSource xmlSource) throws IOException {
        this.root = Util.Xml.getRootElement(xmlSource);
    }

    protected XmlTemplate(String xmlString) throws IOException {
        this.root = Util.Xml.getRootElement(xmlString);
    }

    protected XmlTemplate(File xmlFile) throws IOException {
        this.root = Util.Xml.getRootElement(xmlFile);
    }

    public void clearValues() {
        this.valueMap.clear();
    }

    public void setVariable(String name, String value) {
        this.valueMap.put(name, value);
    }

    public void setVariable(String name, int value) {
        this.valueMap.put(name, new Integer(value));
    }

    public void setVariable(String name, long value) {
        this.valueMap.put(name, new Long(value));
    }

    public void setVariable(String name, double value) {
        this.valueMap.put(name, new Double(value));
    }

    public void setVariable(String name, Color value) {
        String r = this.byteToHex(value.getRed());
        String g = this.byteToHex(value.getGreen());
        String b = this.byteToHex(value.getBlue());
        String a = this.byteToHex(value.getAlpha());
        this.valueMap.put(name, "#" + r + g + b + a);
    }

    private String byteToHex(int i) {
        String s = Integer.toHexString(i);
        while (s.length() < 2) {
            s = "0" + s;
        }
        return s;
    }

    public void setVariable(String name, Date value) {
        this.setVariable(name, Util.getTimestamp(value));
    }

    public void setVariable(String name, Calendar value) {
        this.setVariable(name, Util.getTimestamp(value));
    }

    public void setVariable(String name, boolean value) {
        this.valueMap.put(name, Boolean.toString(value));
    }

    public boolean hasVariables() {
        return PATTERN.matcher(this.root.toString()).find();
    }

    public String[] getVariables() {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = PATTERN.matcher(this.root.toString());
        while (m.find()) {
            String var = m.group(1);
            if (list.contains(var)) continue;
            list.add(var);
        }
        return list.toArray(new String[list.size()]);
    }

    protected static Node[] getChildNodes(Node parentNode, String childName) {
        return Util.Xml.getChildNodes(parentNode, childName);
    }

    protected static Node[] getChildNodes(Node parentNode) {
        return Util.Xml.getChildNodes(parentNode, null);
    }

    protected static Node getFirstChildNode(Node parentNode, String childName) {
        return Util.Xml.getFirstChildNode(parentNode, childName);
    }

    protected boolean hasChildNode(Node parentNode, String childName) {
        return Util.Xml.hasChildNode(parentNode, childName);
    }

    protected String getChildValue(Node parentNode, String childName) {
        return this.getChildValue(parentNode, childName, true);
    }

    protected String getChildValue(Node parentNode, String childName, boolean trim) {
        String value = Util.Xml.getChildValue(parentNode, childName, trim);
        return this.resolveMappings(value);
    }

    protected String getValue(Node parentNode) {
        return this.getValue(parentNode, true);
    }

    protected String getValue(Node parentNode, boolean trim) {
        String value = Util.Xml.getValue(parentNode, trim);
        return this.resolveMappings(value);
    }

    private String resolveMappings(String templateValue) {
        if (templateValue == null) {
            return null;
        }
        Matcher matcher = PATTERN.matcher(templateValue);
        StringBuilder result = new StringBuilder();
        int lastMatchEnd = 0;
        while (matcher.find()) {
            String var = matcher.group(1);
            if (this.valueMap.containsKey(var)) {
                result.append(templateValue.substring(lastMatchEnd, matcher.start()));
                result.append(this.valueMap.get(var).toString());
                lastMatchEnd = matcher.end();
                continue;
            }
            throw new IllegalArgumentException("No mapping found for template variable ${" + var + "}");
        }
        result.append(templateValue.substring(lastMatchEnd));
        return result.toString();
    }

    protected int getChildValueAsInt(Node parentNode, String childName) {
        String valueStr = this.getChildValue(parentNode, childName);
        return Integer.parseInt(valueStr);
    }

    protected int getValueAsInt(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Integer.parseInt(valueStr);
    }

    protected long getChildValueAsLong(Node parentNode, String childName) {
        String valueStr = this.getChildValue(parentNode, childName);
        return Long.parseLong(valueStr);
    }

    protected long getValueAsLong(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Long.parseLong(valueStr);
    }

    protected double getChildValueAsDouble(Node parentNode, String childName) {
        String valueStr = this.getChildValue(parentNode, childName);
        return Util.parseDouble(valueStr);
    }

    protected double getValueAsDouble(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Util.parseDouble(valueStr);
    }

    protected boolean getChildValueAsBoolean(Node parentNode, String childName) {
        String valueStr = this.getChildValue(parentNode, childName);
        return Util.parseBoolean(valueStr);
    }

    protected boolean getValueAsBoolean(Node parentNode) {
        String valueStr = this.getValue(parentNode);
        return Util.parseBoolean(valueStr);
    }

    protected Paint getValueAsColor(Node parentNode) {
        String rgbStr = this.getValue(parentNode);
        return Util.parseColor(rgbStr);
    }

    protected boolean isEmptyNode(Node node) {
        return node.getNodeName().equals("#comment") || node.getNodeName().equals("#text") && node.getNodeValue().trim().length() == 0;
    }

    protected void validateTagsOnlyOnce(Node parentNode, String[] allowedChildNames) {
        Node[] childs;
        if (this.validatedNodes.contains(parentNode)) {
            return;
        }
        block0: for (Node child : childs = XmlTemplate.getChildNodes(parentNode)) {
            String childName = child.getNodeName();
            for (int j = 0; j < allowedChildNames.length; ++j) {
                if (allowedChildNames[j].equals(childName)) {
                    allowedChildNames[j] = "<--removed-->";
                    continue block0;
                }
                if (allowedChildNames[j].equals(childName + "*")) continue block0;
            }
            if (this.isEmptyNode(child)) continue;
            throw new IllegalArgumentException("Unexpected tag encountered: <" + childName + ">");
        }
        this.validatedNodes.add(parentNode);
    }
}

