/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.timespec;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.rrd4j.core.Util;
import org.rrd4j.core.timespec.TimeParser;

public class Epoch
extends JFrame {
    private static final String[] supportedFormats = new String[]{"MM/dd/yy HH:mm:ss", "dd.MM.yy HH:mm:ss", "yy-MM-dd HH:mm:ss", "MM/dd/yy HH:mm", "dd.MM.yy HH:mm", "yy-MM-dd HH:mm", "MM/dd/yy", "dd.MM.yy", "yy-MM-dd", "HH:mm MM/dd/yy", "HH:mm dd.MM.yy", "HH:mm yy-MM-dd", "HH:mm:ss MM/dd/yy", "HH:mm:ss dd.MM.yy", "HH:mm:ss yy-MM-dd"};
    private static final SimpleDateFormat[] parsers = new SimpleDateFormat[supportedFormats.length];
    private static final String helpText;
    private Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Epoch.this.showTimestamp();
        }
    });
    private JLabel topLabel = new JLabel("Enter timestamp or readable date:");
    private JTextField inputField = new JTextField(25);
    private JButton convertButton = new JButton("Convert");
    private JButton helpButton = new JButton("Help");
    private static final SimpleDateFormat OUTPUT_DATE_FORMAT;

    Epoch() {
        super("Epoch");
        this.constructUI();
        this.timer.start();
    }

    private void constructUI() {
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout(3, 3));
        c.add((Component)this.topLabel, "North");
        c.add((Component)this.inputField, "West");
        c.add((Component)this.convertButton, "Center");
        this.convertButton.setToolTipText(helpText);
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Epoch.this.convert();
            }
        });
        c.add((Component)this.helpButton, "East");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Epoch.this.helpButton, helpText, "Epoch Help", 1);
            }
        });
        this.inputField.requestFocus();
        this.getRootPane().setDefaultButton(this.convertButton);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.centerOnScreen();
        this.setVisible(true);
    }

    void centerOnScreen() {
        Toolkit t = Toolkit.getDefaultToolkit();
        Dimension screenSize = t.getScreenSize();
        Dimension frameSize = this.getPreferredSize();
        double x = (screenSize.getWidth() - frameSize.getWidth()) / 2.0;
        double y = (screenSize.getHeight() - frameSize.getHeight()) / 2.0;
        this.setLocation((int)x, (int)y);
    }

    private void convert() {
        String time = this.inputField.getText().trim();
        if (time.length() > 0) {
            try {
                long timestamp = Long.parseLong(time);
                Date date = new Date(timestamp * 1000L);
                this.formatDate(date);
            }
            catch (NumberFormatException nfe) {
                try {
                    this.inputField.setText(Long.toString(this.parseDate(time)));
                }
                catch (Exception e) {
                    this.inputField.setText("Could not convert, sorry");
                }
            }
        }
    }

    private void showTimestamp() {
        long timestamp = Util.getTime();
        this.setTitle(timestamp + " seconds since epoch");
    }

    void formatDate(Date date) {
        this.inputField.setText(OUTPUT_DATE_FORMAT.format(date));
    }

    private long parseDate(String time) {
        for (SimpleDateFormat parser : parsers) {
            try {
                return Util.getTimestamp(parser.parse(time));
            }
            catch (ParseException parseException) {
            }
        }
        return new TimeParser(time).parse().getTimestamp();
    }

    public static void main(String[] args) {
        new Epoch();
    }

    static {
        for (int i = 0; i < parsers.length; ++i) {
            Epoch.parsers[i] = new SimpleDateFormat(supportedFormats[i]);
            parsers[i].setLenient(true);
        }
        StringBuilder tooltipBuff = new StringBuilder("<html><b>Supported input formats:</b><br>");
        for (String supportedFormat : supportedFormats) {
            tooltipBuff.append(supportedFormat).append("<br>");
        }
        tooltipBuff.append("<b>AT-style time specification</b><br>");
        tooltipBuff.append("timestamp<br><br>");
        tooltipBuff.append("Copyright (c) 2013 The RRD4J Authors. Copyright (c) 2001-2005 Sasa Markovic and Ciaran Treanor. Copyright (c) 2013 The OpenNMS Group, Inc. Licensed under the Apache License, Version 2.0.</html>");
        helpText = tooltipBuff.toString();
        OUTPUT_DATE_FORMAT = new SimpleDateFormat("MM/dd/yy HH:mm:ss EEE");
    }
}

