/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.BitSet;
import java.util.Enumeration;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.impl.AbstractReadWriteStore;

public abstract class AbstractFilesystemStore
extends AbstractReadWriteStore
implements Store,
ThreadSafe {
    protected File m_directoryFile;
    protected volatile String m_directoryPath;
    static BitSet charactersDontNeedingEncoding;
    static final int characterCaseDiff = 32;

    public void setDirectory(String directory) throws IOException {
        this.setDirectory(new File(directory));
    }

    public void setDirectory(File directory) throws IOException {
        this.m_directoryFile = directory;
        this.m_directoryPath = this.getFullFilename(this.m_directoryFile);
        this.m_directoryPath = this.m_directoryPath + File.separator;
        if (!this.m_directoryFile.exists() && !this.m_directoryFile.mkdir()) {
            throw new IOException("Error creating store directory '" + this.m_directoryPath + "': ");
        }
        if (!this.m_directoryFile.isDirectory()) {
            throw new IOException("'" + this.m_directoryPath + "' is not a directory");
        }
        if (!this.m_directoryFile.canRead() || !this.m_directoryFile.canWrite()) {
            throw new IOException("Directory '" + this.m_directoryPath + "' is not readable/writable");
        }
    }

    public String getDirectoryPath() {
        return this.m_directoryPath;
    }

    protected Object doGet(Object key) {
        File file = this.fileFromKey(key);
        if (file != null && file.exists()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found file: " + key);
            }
            try {
                return this.deserializeObject(file);
            }
            catch (Exception any) {
                this.getLogger().error("Error during deseralization.", (Throwable)any);
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("NOT Found file: " + key);
        }
        return null;
    }

    protected void doStore(Object key, Object value) throws IOException {
        File file = this.fileFromKey(key);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (value == null) {
            if (file.exists() && !file.delete()) {
                this.getLogger().error("File cannot be deleted: " + file.toString());
                return;
            }
            file.mkdir();
        } else if (value instanceof String) {
            this.serializeString(file, (String)value);
        } else {
            this.serializeObject(file, value);
        }
    }

    protected void doRemove(Object key) {
        File file = this.fileFromKey(key);
        if (file != null) {
            file.delete();
        }
    }

    protected void doClear() {
        Enumeration enumer = this.keys();
        while (enumer.hasMoreElements()) {
            Object key = enumer.nextElement();
            if (key == null) continue;
            this.remove(key);
        }
    }

    protected boolean doContainsKey(Object key) {
        File file = this.fileFromKey(key);
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    protected Enumeration doGetKeys() {
        FSEnumeration enumer = new FSEnumeration();
        this.addKeys(enumer, this.m_directoryFile);
        return enumer;
    }

    protected int doGetSize() {
        return this.countKeys(this.m_directoryFile);
    }

    protected void addKeys(FSEnumeration enumer, File directory) {
        int subStringBegin = this.m_directoryFile.getAbsolutePath().length() + 1;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addKeys(enumer, files[i]);
                continue;
            }
            enumer.add(this.decode(files[i].getAbsolutePath().substring(subStringBegin)));
        }
    }

    protected int countKeys(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                count += this.countKeys(files[i]);
                continue;
            }
            ++count;
        }
        return count;
    }

    protected File fileFromKey(Object key) {
        File file = new File(this.m_directoryFile, this.encode(key.toString()));
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return file;
    }

    public String getString(Object key) throws IOException {
        File file = this.fileFromKey(key);
        if (file != null) {
            return this.deserializeString(file);
        }
        return null;
    }

    public void free() {
    }

    protected void doFree() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object getObject(Object key) throws IOException, ClassNotFoundException {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                File file = this.fileFromKey(key);
                if (file == null) return null;
                Object object = this.deserializeObject(file);
                return object;
            }
            finally {
                sync.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected String decode(String filename) {
        if (filename.length() > 127) {
            int c = filename.length() / 127;
            StringBuffer out = new StringBuffer(filename);
            for (int pos = c * 127; pos > 0; pos -= 127) {
                out.delete(pos, pos + 1);
            }
            filename = out.toString();
        }
        return URLDecoder.decode(filename);
    }

    protected String encode(String s) {
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charactersDontNeedingEncoding.get(c)) {
                out.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
        }
        for (int pos = 127; out.length() > pos; pos += 127) {
            out.insert(pos, File.separatorChar);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeString(File file, String string) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            fw.write(string);
            ((Writer)fw).flush();
        }
        finally {
            if (fw != null) {
                ((Writer)fw).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deserializeString(File file) throws IOException {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        FileReader reader = new FileReader(file);
        try {
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeObject(File file, Object object) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(object);
            oos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserializeObject(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        Object object = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
            object = ois.readObject();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return object;
    }

    public String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    static {
        int i;
        charactersDontNeedingEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            charactersDontNeedingEncoding.set(i);
        }
        charactersDontNeedingEncoding.set(45);
        charactersDontNeedingEncoding.set(95);
        charactersDontNeedingEncoding.set(40);
        charactersDontNeedingEncoding.set(41);
    }

    final class FSEnumeration
    implements Enumeration {
        private String[] array = new String[16];
        private int index = 0;
        private int length = 0;

        FSEnumeration() {
        }

        public void add(String key) {
            if (this.length == this.array.length) {
                String[] newarray = new String[this.length + 16];
                System.arraycopy(this.array, 0, newarray, 0, this.array.length);
                this.array = newarray;
            }
            this.array[this.length] = key;
            ++this.length;
        }

        public boolean hasMoreElements() {
            return this.index < this.length;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                ++this.index;
                return this.array[this.index - 1];
            }
            return null;
        }
    }
}

