/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user.action;

import java.security.Principal;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.principal.UnknownPrincipal;
import org.apache.jackrabbit.core.security.user.action.AbstractAuthorizableAction;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlAction
extends AbstractAuthorizableAction {
    private static final Logger log = LoggerFactory.getLogger(AccessControlAction.class);
    private String[] groupPrivilegeNames = new String[0];
    private String[] userPrivilegeNames = new String[0];

    @Override
    public void onCreate(Group group, Session session) throws RepositoryException {
        this.setAC((Authorizable)group, session);
    }

    @Override
    public void onCreate(User user, String password, Session session) throws RepositoryException {
        this.setAC((Authorizable)user, session);
    }

    public void setGroupPrivilegeNames(String privilegeNames) {
        if (privilegeNames != null && privilegeNames.length() > 0) {
            this.groupPrivilegeNames = AccessControlAction.split(privilegeNames);
        }
    }

    public void setUserPrivilegeNames(String privilegeNames) {
        if (privilegeNames != null && privilegeNames.length() > 0) {
            this.userPrivilegeNames = AccessControlAction.split(privilegeNames);
        }
    }

    private void setAC(Authorizable authorizable, Session session) throws RepositoryException {
        String path = authorizable.getPath();
        JackrabbitAccessControlList acl = null;
        AccessControlManager acMgr = session.getAccessControlManager();
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy plc = it.nextAccessControlPolicy();
            if (!(plc instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)plc;
            break;
        }
        if (acl == null) {
            log.warn("Cannot process AccessControlAction: no applicable ACL at " + path);
        } else {
            UnknownPrincipal principal = new UnknownPrincipal(authorizable.getPrincipal().getName());
            boolean modified = false;
            if (authorizable.isGroup()) {
                if (this.groupPrivilegeNames.length > 0) {
                    modified = acl.addAccessControlEntry((Principal)((Object)principal), AccessControlAction.getPrivileges(this.groupPrivilegeNames, acMgr));
                }
            } else if (this.userPrivilegeNames.length > 0) {
                modified = acl.addAccessControlEntry((Principal)((Object)principal), AccessControlAction.getPrivileges(this.userPrivilegeNames, acMgr));
            }
            if (modified) {
                acMgr.setPolicy(path, (AccessControlPolicy)acl);
            }
        }
    }

    private static Privilege[] getPrivileges(String[] privNames, AccessControlManager acMgr) throws RepositoryException {
        if (privNames == null || privNames.length == 0) {
            return new Privilege[0];
        }
        Privilege[] privileges = new Privilege[privNames.length];
        for (int i = 0; i < privNames.length; ++i) {
            privileges[i] = acMgr.privilegeFromName(privNames[i]);
        }
        return privileges;
    }

    private static String[] split(String configParam) {
        ArrayList<String> nameList = new ArrayList<String>();
        for (String pn : Text.explode((String)configParam, (int)44, (boolean)false)) {
            String privName = pn.trim();
            if (privName.length() <= 0) continue;
            nameList.add(privName);
        }
        return nameList.toArray(new String[nameList.size()]);
    }
}

