/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;

public class RrdToolkit {
    private static final String SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME = "Source and destination paths are the same";

    private RrdToolkit() {
    }

    public static void addDatasource(String sourcePath, String destPath, DsDef newDatasource) throws IOException {
        RrdToolkit.addDatasources(sourcePath, destPath, Collections.singleton(newDatasource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDatasources(String sourcePath, String destPath, Iterable<DsDef> newDatasources) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException(SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME);
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            for (DsDef newDatasource : newDatasources) {
                rrdDef.addDatasource(newDatasource);
            }
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void addDatasource(String sourcePath, DsDef newDatasource, boolean saveBackup) throws IOException {
        RrdToolkit.addDatasources(sourcePath, Collections.singleton(newDatasource), saveBackup);
    }

    public static void addDatasources(String sourcePath, Iterable<DsDef> newDatasources, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addDatasources(sourcePath, destPath, newDatasources);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDatasource(String sourcePath, String destPath, String dsName) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException(SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME);
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeDatasource(dsName);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void removeDatasource(String sourcePath, String dsName, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeDatasource(sourcePath, destPath, dsName);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatasource(String sourcePath, String oldDsName, String newDsName) throws IOException {
        block4: {
            try (RrdDb rrd = new RrdDb(sourcePath);){
                if (rrd.containsDs(oldDsName)) {
                    Datasource datasource = rrd.getDatasource(oldDsName);
                    datasource.setDsName(newDsName);
                    break block4;
                }
                throw new IllegalArgumentException("Could not find datasource [" + oldDsName + "] in file " + sourcePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int forceZerosForNans(String sourcePath, String dsName) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource[] datasources;
            if (dsName == null) {
                datasources = rrd.getDatasources();
            } else if (rrd.containsDs(dsName)) {
                datasources = new Datasource[]{rrd.getDatasource(dsName)};
            } else {
                throw new IllegalArgumentException("Could not find datasource [" + dsName + "] in file " + sourcePath);
            }
            int count = 0;
            for (Datasource datasource : datasources) {
                String currentDsName = datasource.getName();
                if (currentDsName.endsWith("!")) continue;
                datasource.setDsName(currentDsName + "!");
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addArchive(String sourcePath, String destPath, ArcDef newArchive) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException(SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME);
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.addArchive(newArchive);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void addArchive(String sourcePath, ArcDef newArchive, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addArchive(sourcePath, destPath, newArchive);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeArchive(String sourcePath, String destPath, ConsolFun consolFun, int steps) throws IOException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new IllegalArgumentException(SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME);
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeArchive(consolFun, steps);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void removeArchive(String sourcePath, ConsolFun consolFun, int steps, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeArchive(sourcePath, destPath, consolFun, steps);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(String sourcePath, String destPath, boolean saveBackup) throws IOException {
        File source = new File(sourcePath);
        File dest = new File(destPath);
        if (saveBackup) {
            String backupPath = RrdToolkit.getBackupPath(destPath);
            File backup = new File(backupPath);
            RrdToolkit.deleteFile(backup);
            if (!dest.renameTo(backup)) {
                throw new IOException("Could not create backup file " + backupPath);
            }
        }
        RrdToolkit.deleteFile(dest);
        if (!source.renameTo(dest)) {
            FileChannel sourceStream = null;
            AbstractInterruptibleChannel destinationStream = null;
            try {
                sourceStream = new FileInputStream(source).getChannel();
                destinationStream = new FileOutputStream(dest).getChannel();
                long size = sourceStream.size();
                for (long count = 0L; count < size; count += ((FileChannel)destinationStream).transferFrom(sourceStream, count, size - count)) {
                }
                RrdToolkit.deleteFile(source);
            }
            finally {
                if (sourceStream != null) {
                    sourceStream.close();
                }
                if (destinationStream != null) {
                    destinationStream.close();
                }
            }
        }
    }

    private static String getBackupPath(String destPath) {
        String backupPath = destPath;
        while (Util.fileExists(backupPath = backupPath + ".bak")) {
        }
        return backupPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String sourcePath, String datasourceName, long newHeartbeat) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setHeartbeat(newHeartbeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String sourcePath, int dsIndex, long newHeartbeat) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(dsIndex);
            ds.setHeartbeat(newHeartbeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinValue(String sourcePath, String datasourceName, double newMinValue, boolean filterArchivedValues) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinValue(newMinValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMaxValue(String sourcePath, String datasourceName, double newMaxValue, boolean filterArchivedValues) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMaxValue(newMaxValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinMaxValue(String sourcePath, String datasourceName, double newMinValue, double newMaxValue, boolean filterArchivedValues) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinMaxValue(newMinValue, newMaxValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setArcXff(String sourcePath, ConsolFun consolFun, int steps, double newXff) throws IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Archive arc = rrd.getArchive(consolFun, steps);
            arc.setXff(newXff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resizeArchive(String sourcePath, String destPath, ConsolFun consolFun, int numSteps, int newRows) throws IOException {
        block8: {
            if (Util.sameFilePath(sourcePath, destPath)) {
                throw new IllegalArgumentException(SOURCE_AND_DESTINATION_PATHS_ARE_THE_SAME);
            }
            if (newRows < 2) {
                throw new IllegalArgumentException("New archive size must be at least 2");
            }
            try (RrdDb rrdSource = new RrdDb(sourcePath);){
                RrdDef rrdDef = rrdSource.getRrdDef();
                ArcDef arcDef = rrdDef.findArchive(consolFun, numSteps);
                if (arcDef.getRows() == newRows) break block8;
                arcDef.setRows(newRows);
                rrdDef.setPath(destPath);
                try (RrdDb rrdDest = new RrdDb(rrdDef);){
                    rrdSource.copyStateTo(rrdDest);
                }
            }
        }
    }

    public static void resizeArchive(String sourcePath, ConsolFun consolFun, int numSteps, int newRows, boolean saveBackup) throws IOException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.resizeArchive(sourcePath, destPath, consolFun, numSteps, newRows);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(String sourcePath) throws IOException {
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            String[] dsNames;
            for (String dsName : dsNames = rrdSource.getDsNames()) {
                RrdDef rrdDef = rrdSource.getRrdDef();
                rrdDef.setPath(RrdToolkit.createSplitPath(dsName, sourcePath));
                rrdDef.saveSingleDatasource(dsName);
                try (RrdDb rrdDest = new RrdDb(rrdDef);){
                    rrdSource.copyStateTo(rrdDest);
                }
            }
        }
    }

    public static String[] getCanonicalPaths(String directory, String extension, boolean resursive) throws IOException {
        File baseDir = new File(directory);
        if (!baseDir.isDirectory()) {
            throw new IOException("Not a directory: " + directory);
        }
        LinkedList<String> fileList = new LinkedList<String>();
        RrdToolkit.traverseDirectory(new File(directory), extension, resursive, fileList);
        Object[] result = fileList.toArray(new String[fileList.size()]);
        Arrays.sort(result);
        return result;
    }

    private static void traverseDirectory(File directory, String extension, boolean recursive, List<String> list) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory() && recursive) {
                RrdToolkit.traverseDirectory(file, extension, recursive, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(extension)) continue;
            list.add(file.getCanonicalPath());
        }
    }

    private static String createSplitPath(String dsName, String sourcePath) {
        File file = new File(sourcePath);
        String newName = dsName + "-" + file.getName();
        String path = file.getAbsolutePath();
        String parentDir = path.substring(0, 1 + path.lastIndexOf(Util.getFileSeparator()));
        return parentDir + newName;
    }
}

