/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractMetaModule;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.cocoon.xml.dom.DocumentWrapper;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLMetaModule
extends AbstractMetaModule
implements ThreadSafe {
    protected String rootName = "root";
    protected String ignore;
    protected String use;
    protected String strip;
    protected Object config;
    protected XPathProcessor xpathProcessor;
    protected static final String CACHE_OBJECT_NAME = "org.apache.cocoon.component.modules.input.XMLMetaModule";
    static final Vector returnNames;

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        this.inputConf = config.getChild("input-module");
        this.defaultInput = this.inputConf.getAttribute("name", this.defaultInput);
        this.rootName = this.inputConf.getAttribute("root", this.rootName);
        this.ignore = this.inputConf.getAttribute("ignore", this.ignore);
        this.use = this.inputConf.getAttribute("use", this.use);
        this.strip = this.inputConf.getAttribute("strip", this.strip);
        this.config = config;
        this.rootName = config.getChild("root").getValue(this.rootName);
        this.ignore = config.getChild("ignore").getValue(this.ignore);
        this.use = config.getChild("use").getValue(this.use);
        this.strip = config.getChild("strip").getValue(this.strip);
    }

    @Override
    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Configuration inputConfig = null;
        String inputName = null;
        String rootName = this.rootName;
        String ignore = this.ignore;
        String use = this.use;
        String strip = this.strip;
        if (modeConf != null) {
            inputName = modeConf.getChild("input-module").getAttribute("name", null);
            rootName = modeConf.getAttribute("root", this.rootName);
            ignore = modeConf.getAttribute("ignore", this.ignore);
            use = modeConf.getAttribute("use", this.use);
            strip = modeConf.getAttribute("strip", this.strip);
            rootName = modeConf.getChild("root").getValue(rootName);
            ignore = modeConf.getChild("ignore").getValue(ignore);
            use = modeConf.getChild("use").getValue(use);
            strip = modeConf.getChild("strip").getValue(strip);
            if (inputName != null) {
                inputConfig = modeConf.getChild("input-module");
            }
        }
        Request request = ObjectModelHelper.getRequest(objectModel);
        HashMap<Configuration, Document> cache = (HashMap<Configuration, Document>)request.getAttribute(CACHE_OBJECT_NAME);
        Object key = modeConf != null ? modeConf : this.config;
        Document doc = null;
        if (cache != null && cache.containsKey(key)) {
            doc = (Document)cache.get(key);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("using cached copy " + doc);
            }
            return doc;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("no cached copy " + cache + " / " + key);
        }
        InputModule input = null;
        if (inputName != null) {
            input = this.obtainModule(inputName);
        }
        Iterator names = this.getNames(objectModel, this.input, this.defaultInput, this.inputConf, input, inputName, inputConfig);
        TreeSet<String> set = new TreeSet<String>();
        String aName = null;
        while (names.hasNext()) {
            aName = (String)names.next();
            if (use != null && !aName.startsWith(use) || ignore != null && aName.startsWith(ignore)) continue;
            set.add(aName);
        }
        try {
            names = set.iterator();
            doc = DOMUtil.createDocument();
            Element elem = doc.createElement(rootName);
            doc.appendChild(elem);
            while (names.hasNext()) {
                aName = (String)names.next();
                Object[] value = this.getValues(aName, objectModel, this.input, this.defaultInput, this.inputConf, input, inputName, inputConfig);
                if (strip != null && aName.startsWith(strip)) {
                    aName = aName.substring(strip.length());
                }
                if (value.length <= 0) continue;
                Node node = DOMUtil.selectSingleNode(doc.getDocumentElement(), aName, this.xpathProcessor);
                node.appendChild(node.getOwnerDocument().createTextNode(value[0].toString()));
                if (value.length <= 1) continue;
                int endPos = aName.length() - (aName.endsWith("/") ? 1 : 0);
                int startPos = aName.lastIndexOf("/", endPos) + 1;
                String nodeName = aName.substring(startPos, endPos);
                if (nodeName.indexOf("[") != -1) {
                    endPos = nodeName.lastIndexOf("]");
                    startPos = nodeName.indexOf("[") + 1;
                    nodeName = nodeName.substring(startPos, endPos);
                }
                Node parent = node.getParentNode();
                for (int i = 1; i < value.length; ++i) {
                    Element newNode = parent.getOwnerDocument().createElementNS(null, nodeName);
                    parent.appendChild(newNode);
                    newNode.appendChild(newNode.getOwnerDocument().createTextNode(value[i].toString()));
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
        if (input != null) {
            this.releaseModule(input);
        }
        doc = new DocumentWrapper(doc);
        if (cache == null) {
            cache = new HashMap<Configuration, Document>();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("no cached copy " + cache + " / " + key);
        }
        cache.put((Configuration)key, doc);
        request.setAttribute(CACHE_OBJECT_NAME, cache);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("returning " + doc.toString());
        }
        return doc;
    }

    @Override
    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        return returnNames.iterator();
    }

    @Override
    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        if (!this.initialized) {
            this.lazy_initialize();
        }
        if (this.defaultInput == null) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("No input module given. FAILING");
            }
            return null;
        }
        Object[] values = new Object[]{this.getAttribute(name, modeConf, objectModel)};
        return values;
    }

    @Override
    public void compose(ComponentManager manager) throws ComponentException {
        super.compose(manager);
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    @Override
    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.xpathProcessor);
            this.xpathProcessor = null;
        }
        super.dispose();
    }

    static {
        Vector<String> tmp = new Vector<String>();
        tmp.add("XML");
        returnNames = tmp;
    }
}

