/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.components.pipeline.impl.AbstractCachingProcessingPipeline;
import org.apache.cocoon.components.sax.XMLDeserializer;
import org.apache.cocoon.components.sax.XMLSerializer;
import org.apache.cocoon.components.sax.XMLTeePipe;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;

public class CachingProcessingPipeline
extends AbstractCachingProcessingPipeline {
    @Override
    protected void cacheResults(Environment environment, OutputStream os) throws Exception {
        if (this.toCacheKey != null) {
            CachedResponse response;
            Long expiresObj = (Long)environment.getObjectModel().get("expires");
            if (this.cacheCompleteResponse) {
                response = new CachedResponse(this.toCacheSourceValidities, ((CachingOutputStream)os).getContent(), expiresObj);
                response.setContentType(environment.getContentType());
            } else {
                response = new CachedResponse(this.toCacheSourceValidities, (byte[])this.xmlSerializer.getSAXFragment(), expiresObj);
            }
            this.cache.store(this.toCacheKey, response);
        }
    }

    @Override
    protected ComponentCacheKey newComponentCacheKey(int type, String role, Serializable key) {
        return new ComponentCacheKey(type, role, key);
    }

    @Override
    protected void connectCachingPipeline(Environment environment) throws ProcessingException {
        try {
            XMLSerializer localXMLSerializer = null;
            if (!this.cacheCompleteResponse) {
                localXMLSerializer = this.xmlSerializer = (XMLSerializer)this.manager.lookup(XMLSerializer.ROLE);
            }
            if (this.cachedResponse == null) {
                XMLConsumer next2;
                XMLProducer prev = this.generator;
                int cacheableTransformerCount = this.firstNotCacheableTransformerIndex;
                for (XMLConsumer next2 : this.transformers) {
                    if (localXMLSerializer != null) {
                        if (cacheableTransformerCount == 0) {
                            next2 = new XMLTeePipe(next2, localXMLSerializer);
                            localXMLSerializer = null;
                        } else {
                            --cacheableTransformerCount;
                        }
                    }
                    this.connect(environment, prev, next2);
                    prev = (XMLProducer)((Object)next2);
                }
                next2 = this.lastConsumer;
                if (localXMLSerializer != null) {
                    next2 = new XMLTeePipe(next2, localXMLSerializer);
                    localXMLSerializer = null;
                }
                this.connect(environment, prev, next2);
            } else {
                XMLConsumer next3;
                XMLProducer prev = this.xmlDeserializer = (XMLDeserializer)this.manager.lookup(XMLDeserializer.ROLE);
                int cacheableTransformerCount = 0;
                for (XMLConsumer next3 : this.transformers) {
                    if (cacheableTransformerCount >= this.firstProcessedTransformerIndex) {
                        if (localXMLSerializer != null && cacheableTransformerCount == this.firstNotCacheableTransformerIndex) {
                            next3 = new XMLTeePipe(next3, localXMLSerializer);
                            localXMLSerializer = null;
                        }
                        this.connect(environment, prev, next3);
                        prev = (XMLProducer)((Object)next3);
                    }
                    ++cacheableTransformerCount;
                }
                next3 = this.lastConsumer;
                if (localXMLSerializer != null) {
                    next3 = new XMLTeePipe(next3, localXMLSerializer);
                    localXMLSerializer = null;
                }
                this.connect(environment, prev, next3);
            }
        }
        catch (ComponentException e) {
            throw new ProcessingException("Could not connect pipeline.", e);
        }
    }
}

