/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.sax;

import java.util.ArrayList;
import org.apache.cocoon.components.sax.XMLByteStreamConstants;
import org.apache.cocoon.xml.DefaultLexicalHandler;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLProducer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AbstractXMLByteStreamInterpreter
implements XMLProducer,
XMLByteStreamConstants {
    private ArrayList list = new ArrayList();
    protected static final ContentHandler EMPTY_CONTENT_HANDLER = new DefaultHandler();
    protected ContentHandler contentHandler = EMPTY_CONTENT_HANDLER;
    protected LexicalHandler lexicalHandler = DefaultLexicalHandler.NULL_HANDLER;

    @Override
    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)((Object)consumer));
        this.setLexicalHandler((LexicalHandler)((Object)consumer));
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void recycle() {
        this.contentHandler = EMPTY_CONTENT_HANDLER;
        this.lexicalHandler = DefaultLexicalHandler.NULL_HANDLER;
        this.list.clear();
    }

    protected void parse() throws SAXException {
        this.list.clear();
        this.checkProlog();
        int event = -1;
        int lastEvent = -1;
        block20: while ((event = this.readEvent()) != -1) {
            lastEvent = event;
            switch (event) {
                case 0: {
                    this.contentHandler.startDocument();
                    continue block20;
                }
                case 1: {
                    this.contentHandler.endDocument();
                    continue block20;
                }
                case 2: {
                    this.contentHandler.startPrefixMapping(this.readString(), this.readString());
                    continue block20;
                }
                case 3: {
                    this.contentHandler.endPrefixMapping(this.readString());
                    continue block20;
                }
                case 4: {
                    int attributes = this.readAttributes();
                    AttributesImpl atts = new AttributesImpl();
                    for (int i = 0; i < attributes; ++i) {
                        atts.addAttribute(this.readString(), this.readString(), this.readString(), this.readString(), this.readString());
                    }
                    this.contentHandler.startElement(this.readString(), this.readString(), this.readString(), atts);
                    continue block20;
                }
                case 5: {
                    this.contentHandler.endElement(this.readString(), this.readString(), this.readString());
                    continue block20;
                }
                case 6: {
                    int len;
                    char[] chars = this.readChars();
                    for (len = chars.length; len > 0 && chars[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.contentHandler.characters(chars, 0, len);
                    continue block20;
                }
                case 7: {
                    int len;
                    char[] spaces = this.readChars();
                    for (len = spaces.length; len > 0 && spaces[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.contentHandler.characters(spaces, 0, len);
                    continue block20;
                }
                case 8: {
                    this.contentHandler.processingInstruction(this.readString(), this.readString());
                    continue block20;
                }
                case 9: {
                    int len;
                    char[] chars = this.readChars();
                    for (len = chars.length; len > 0 && chars[len - 1] == '\u0000'; --len) {
                    }
                    if (len <= 0) continue block20;
                    this.lexicalHandler.comment(chars, 0, len);
                    continue block20;
                }
                case 10: {
                    String publicId = this.readString();
                    String systemId = this.readString();
                    int lineNumber = this.read();
                    int columnNumber = this.read();
                    LocatorImpl locator = new LocatorImpl();
                    locator.setPublicId(publicId);
                    locator.setSystemId(systemId);
                    locator.setLineNumber(lineNumber);
                    locator.setColumnNumber(columnNumber);
                    this.contentHandler.setDocumentLocator(locator);
                    continue block20;
                }
                case 11: {
                    this.lexicalHandler.startDTD(this.readString(), this.readString(), this.readString());
                    continue block20;
                }
                case 12: {
                    this.lexicalHandler.endDTD();
                    continue block20;
                }
                case 13: {
                    this.lexicalHandler.startCDATA();
                    continue block20;
                }
                case 14: {
                    this.lexicalHandler.endCDATA();
                    continue block20;
                }
                case 15: {
                    this.contentHandler.skippedEntity(this.readString());
                    continue block20;
                }
                case 16: {
                    this.lexicalHandler.startEntity(this.readString());
                    continue block20;
                }
                case 17: {
                    this.lexicalHandler.endEntity(this.readString());
                    continue block20;
                }
            }
            throw new SAXException("parsing error: event not supported: " + event);
        }
        if (lastEvent != 1) {
            throw new SAXException("parsing error: premature end of stream (lastEvent was " + lastEvent + ").");
        }
    }

    protected int readEvent() throws SAXException {
        return this.read();
    }

    private int readAttributes() throws SAXException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    private String readString() throws SAXException {
        int length = this.readWord();
        if (length >= 32768) {
            int index = length & Short.MAX_VALUE;
            return (String)this.list.get(index);
        }
        if (length == Short.MAX_VALUE && (length = this.readLong()) >= Integer.MIN_VALUE) {
            int index = length & Integer.MAX_VALUE;
            return (String)this.list.get(index);
        }
        char[] chars = this.readChars(length);
        int len = chars.length;
        if (len > 0) {
            while (chars[len - 1] == '\u0000') {
                --len;
            }
        }
        String str = len == 0 ? "" : new String(chars, 0, len);
        this.list.add(str);
        return str;
    }

    private char[] readChars() throws SAXException {
        int length = this.readWord();
        if (length == Short.MAX_VALUE) {
            length = this.readLong();
        }
        return this.readChars(length);
    }

    protected abstract int read() throws SAXException;

    protected abstract int read(byte[] var1) throws SAXException;

    private char[] readChars(int len) throws SAXException {
        char[] str = new char[len];
        byte[] bytearr = new byte[len];
        int count = 0;
        int i = 0;
        this.readBytes(bytearr);
        block5: while (count < len) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[i++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte char2 = bytearr[(count += 2) - 1];
                    str[i++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte char2 = bytearr[(count += 3) - 2];
                    byte char3 = bytearr[count - 1];
                    str[i++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new SAXException("UTFDataFormatException");
        }
        return str;
    }

    private void readBytes(byte[] b) throws SAXException {
        int bytesRead = this.read(b);
        if (bytesRead < b.length) {
            throw new SAXException("End of is reached.");
        }
    }

    private int readWord() throws SAXException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    private int readLong() throws SAXException {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private void checkProlog() throws SAXException {
        int valid = 0;
        int ch = 0;
        ch = this.read();
        if (ch == 67) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
        ch = this.read();
        if (ch == 88) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
        ch = this.read();
        if (ch == 77) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
        ch = this.read();
        if (ch == 76) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
        ch = this.read();
        if (ch == 1) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
        ch = this.read();
        if (ch == 0) {
            ++valid;
        } else {
            throw new SAXException("Unrecognized file format (." + valid + "," + ch + ")");
        }
    }
}

