/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class EHDefaultStore
extends AbstractLogEnabled
implements Store,
Contextualizable,
Serviceable,
Parameterizable,
Initializable,
Disposable,
ThreadSafe {
    private static final String CONFIG_FILE = "org/apache/cocoon/components/store/impl/ehcache.xml";
    private static int instanceCount = 0;
    private Cache cache;
    private CacheManager cacheManager;
    private final String cacheName = "cocoon-ehcache-" + ++instanceCount;
    private int maxObjects;
    private boolean overflowToDisk;
    private boolean diskPersistent;
    private boolean eternal;
    private long timeToLiveSeconds;
    private long timeToIdleSeconds;
    private ServiceManager manager;
    private StoreJanitor storeJanitor;
    private File workDir;
    private File cacheDir;
    private String diskStorePath;

    public void contextualize(Context context) throws ContextException {
        this.workDir = (File)context.get((Object)"work-directory");
        this.cacheDir = (File)context.get((Object)"cache-directory");
    }

    public void service(ServiceManager aManager) throws ServiceException {
        this.manager = aManager;
        this.storeJanitor = (StoreJanitor)this.manager.lookup(StoreJanitor.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.maxObjects = parameters.getParameterAsInteger("maxobjects", 10000);
        this.overflowToDisk = parameters.getParameterAsBoolean("overflow-to-disk", true);
        this.diskPersistent = parameters.getParameterAsBoolean("disk-persistent", true);
        this.eternal = parameters.getParameterAsBoolean("eternal", true);
        if (!this.eternal) {
            this.timeToLiveSeconds = parameters.getParameterAsLong("timeToLiveSeconds", 0L);
            this.timeToIdleSeconds = parameters.getParameterAsLong("timeToIdleSeconds", 0L);
        }
        try {
            if (parameters.getParameterAsBoolean("use-cache-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using cache directory: " + this.cacheDir);
                }
                this.setDirectory(this.cacheDir);
            } else if (parameters.getParameterAsBoolean("use-work-directory", false)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using work directory: " + this.workDir);
                }
                this.setDirectory(this.workDir);
            } else if (parameters.getParameter("directory", null) != null) {
                String dir = parameters.getParameter("directory");
                dir = org.apache.cocoon.util.IOUtils.getContextFilePath(this.workDir.getPath(), dir);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Using directory: " + dir);
                }
                this.setDirectory(new File(dir));
            } else {
                try {
                    this.setDirectory(this.workDir);
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            throw new ParameterException("Unable to set directory", (Throwable)e);
        }
    }

    private void setDirectory(File directory) throws IOException {
        String directoryPath = EHDefaultStore.getFullFilename(directory);
        directoryPath = directoryPath + File.separator;
        if (!directory.exists() && !directory.mkdir()) {
            throw new IOException("Error creating store directory '" + directoryPath + "': ");
        }
        if (!directory.isDirectory()) {
            throw new IOException("'" + directoryPath + "' is not a directory");
        }
        if (!directory.canRead() || !directory.canWrite()) {
            throw new IOException("Directory '" + directoryPath + "' is not readable/writable");
        }
        this.diskStorePath = directoryPath;
    }

    private static String getFullFilename(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    public void initialize() throws Exception {
        String config = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(CONFIG_FILE));
        config = StringUtils.replace((String)config, (String)"${diskstorepath}", (String)this.diskStorePath);
        this.cacheManager = CacheManager.create((InputStream)new ByteArrayInputStream(config.getBytes("utf-8")));
        this.cache = new Cache(this.cacheName, this.maxObjects, MemoryStoreEvictionPolicy.LRU, this.overflowToDisk, this.diskStorePath, this.eternal, this.timeToLiveSeconds, this.timeToIdleSeconds, this.diskPersistent, 120L, null, null);
        this.cacheManager.addCache(this.cache);
        this.storeJanitor.register((Store)this);
        this.getLogger().info("EHCache cache \"" + this.cacheName + "\" initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.storeJanitor != null) {
            this.storeJanitor.unregister((Store)this);
            this.manager.release((Object)this.storeJanitor);
            this.storeJanitor = null;
        }
        this.manager = null;
        Cache cache = this.cache;
        synchronized (cache) {
            if (Status.STATUS_ALIVE == this.cache.getStatus()) {
                try {
                    this.getLogger().info("Disposing EHCache cache \"" + this.cacheName + "\".");
                    this.cacheManager.shutdown();
                }
                catch (IllegalStateException e) {
                    this.getLogger().error("Error disposing EHCache cache \"" + this.cacheName + "\".", (Throwable)e);
                }
            } else {
                this.getLogger().info("EHCache cache \"" + this.cacheName + "\" already disposed.");
            }
        }
        this.cacheManager = null;
        this.cache = null;
    }

    public Object get(Object key) {
        Serializable value = null;
        try {
            Element element = this.cache.get((Serializable)key);
            if (element != null) {
                value = element.getValue();
            }
        }
        catch (CacheException e) {
            this.getLogger().error("Failure retrieving object from store", (Throwable)e);
        }
        if (this.getLogger().isDebugEnabled()) {
            if (value != null) {
                this.getLogger().debug("Found key: " + key);
            } else {
                this.getLogger().debug("NOT Found key: " + key);
            }
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Store object " + value + " with key " + key);
        }
        if (!(key instanceof Serializable)) {
            throw new IOException("Key of class " + key.getClass().getName() + " is not Serializable");
        }
        if (!(value instanceof Serializable)) {
            throw new IOException("Value of class " + value.getClass().getName() + " is not Serializable");
        }
        Element element = new Element((Serializable)key, (Serializable)value);
        this.cache.put(element);
    }

    public void free() {
        block5: {
            try {
                List keys = this.cache.getKeysNoDuplicateCheck();
                if (!keys.isEmpty()) {
                    Serializable key = (Serializable)keys.get(0);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Freeing cache");
                        this.getLogger().debug("key: " + key);
                        this.getLogger().debug("value: " + this.cache.get(key));
                    }
                    if (!this.cache.remove(key) && this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Concurrency condition in free()");
                    }
                }
            }
            catch (CacheException e) {
                if (!this.getLogger().isWarnEnabled()) break block5;
                this.getLogger().warn("Error in free()", (Throwable)e);
            }
        }
    }

    public void remove(Object key) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Removing item " + key);
        }
        this.cache.remove((Serializable)key);
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Clearing the store");
        }
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException e) {
            this.getLogger().error("Failure to clearing store", (Throwable)e);
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.isKeyInCache((Object)((Serializable)key));
    }

    public Enumeration keys() {
        List keys = null;
        try {
            keys = this.cache.getKeys();
        }
        catch (CacheException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Error while getting cache keys", (Throwable)e);
            }
            keys = Collections.EMPTY_LIST;
        }
        return Collections.enumeration(keys);
    }

    public int size() {
        try {
            return (int)this.cache.getMemoryStoreSize();
        }
        catch (IllegalStateException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Error while getting cache size", (Throwable)e);
            }
            return 0;
        }
    }
}

