/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.store.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class StoreJanitorImpl
extends AbstractLogEnabled
implements StoreJanitor,
Parameterizable,
ThreadSafe,
Runnable,
Startable {
    private static final String ALG_ROUND_ROBIN = "round-robin";
    private static final String ALG_ALL_STORES = "all-stores";
    private int minFreeMemory = -1;
    private int maxHeapSize = -1;
    private int threadInterval = -1;
    private int minThreadInterval = 500;
    private boolean adaptiveThreadInterval;
    private int priority = -1;
    private String freeingAlgorithm = "all-stores";
    private double fraction;
    protected boolean invokeGC;
    private Runtime jvm;
    private ArrayList storelist;
    private int index = -1;
    private boolean doRun;
    protected long inUse;
    private boolean firstRun = true;
    protected long interval = Long.MAX_VALUE;
    private long maxRateOfChange = 1L;

    public void parameterize(Parameters params) throws ParameterException {
        this.jvm = Runtime.getRuntime();
        this.minFreeMemory = params.getParameterAsInteger("freememory", 0x100000);
        this.maxHeapSize = params.getParameterAsInteger("heapsize", 66600000);
        this.threadInterval = params.getParameterAsInteger("cleanupthreadinterval", 10) * 1000;
        this.adaptiveThreadInterval = params.getParameterAsBoolean("adaptivethreadinterval", false);
        this.priority = params.getParameterAsInteger("threadpriority", Thread.currentThread().getPriority());
        int percent = params.getParameterAsInteger("percent_to_free", 10);
        this.invokeGC = params.getParameterAsBoolean("invokegc", this.invokeGC);
        this.freeingAlgorithm = params.getParameter("freeingalgorithm", ALG_ROUND_ROBIN);
        if (this.getMinFreeMemory() < 1) {
            throw new ParameterException("StoreJanitorImpl freememory parameter has to be greater then 1");
        }
        if (this.getMaxHeapSize() < 1) {
            throw new ParameterException("StoreJanitorImpl heapsize parameter has to be greater then 1");
        }
        if (this.getThreadInterval() < 1) {
            throw new ParameterException("StoreJanitorImpl cleanupthreadinterval parameter has to be greater then 1");
        }
        if (this.getPriority() < 1 || this.getPriority() > 10) {
            throw new ParameterException("StoreJanitorImpl threadpriority has to be between 1 and 10");
        }
        if (percent > 100 && percent < 1) {
            throw new ParameterException("StoreJanitorImpl percent_to_free, has to be between 1 and 100");
        }
        if (!this.freeingAlgorithm.equals(ALG_ROUND_ROBIN) && !this.freeingAlgorithm.equals(ALG_ALL_STORES)) {
            throw new ParameterException("StoreJanitorImpl freeingAlgorithm, has to be 'round-robin' or 'all-stores'. '" + this.freeingAlgorithm + "' is not supported.");
        }
        this.fraction = (double)percent / 100.0;
        this.storelist = new ArrayList();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("minimum free memory=" + this.getMinFreeMemory());
            this.getLogger().debug("heapsize=" + this.getMaxHeapSize());
            this.getLogger().debug("thread interval=" + this.getThreadInterval());
            this.getLogger().debug("adaptivethreadinterval=" + this.getAdaptiveThreadInterval());
            this.getLogger().debug("priority=" + this.getPriority());
            this.getLogger().debug("percent=" + percent);
            this.getLogger().debug("invoke gc=" + this.invokeGC);
        }
    }

    public void start() throws Exception {
        this.doRun = true;
        Thread checker = new Thread(this);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Intializing checker thread");
        }
        checker.setPriority(this.getPriority());
        checker.setDaemon(true);
        checker.setName("checker");
        checker.start();
    }

    public void stop() {
        this.doRun = false;
    }

    @Override
    public void run() {
        this.inUse = this.memoryInUse();
        while (this.doRun) {
            this.checkMemory();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sleeping for " + this.interval + "ms");
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.firstRun) continue;
            this.firstRun = false;
            this.inUse = this.memoryInUse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMemory() {
        if (this.getAdaptiveThreadInterval()) {
            long change = this.memoryInUse() - this.inUse;
            long rateOfChange = this.longDiv(change * 1000L, this.interval);
            if (this.maxRateOfChange < rateOfChange) {
                this.maxRateOfChange = (this.maxRateOfChange + rateOfChange) / 2L;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Waking after " + this.interval + "ms, in use change " + change + "b to " + this.memoryInUse() + "b, rate " + rateOfChange + "b/sec, max rate " + this.maxRateOfChange + "b/sec");
            }
        }
        if (this.memoryLow()) {
            if (this.invokeGC) {
                this.freePhysicalMemory();
            }
            StoreJanitorImpl storeJanitorImpl = this;
            synchronized (storeJanitorImpl) {
                if (!this.invokeGC || this.memoryLow() && this.getStoreList().size() > 0) {
                    this.freeMemory();
                    this.setIndex(this.getIndex() + 1);
                }
            }
        }
        if (this.getAdaptiveThreadInterval()) {
            this.interval = this.minTimeToFill(this.maxRateOfChange) * 1000L / 2L;
            if (this.interval > (long)this.threadInterval) {
                this.interval = this.threadInterval;
            } else if (this.interval < (long)this.minThreadInterval) {
                this.interval = this.minThreadInterval;
            }
            this.inUse = this.memoryInUse();
        } else {
            this.interval = this.threadInterval;
        }
    }

    private boolean memoryLow() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JVM Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
        if (this.getJVM().totalMemory() >= (long)this.getMaxHeapSize() && this.getJVM().freeMemory() < (long)this.getMinFreeMemory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Memory is low!");
            }
            return true;
        }
        return false;
    }

    protected long memoryInUse() {
        return this.jvm.totalMemory() - this.jvm.freeMemory();
    }

    private long minTimeToFill(long rate) {
        return this.longDiv(this.jvm.freeMemory(), rate);
    }

    private long longDiv(long top, long bottom) {
        try {
            return top / bottom;
        }
        catch (Exception e) {
            return top > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public synchronized void register(Store store) {
        this.getStoreList().add(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Registered store instance " + store + ". Stores now: " + this.getStoreList().size());
        }
    }

    public synchronized void unregister(Store store) {
        this.getStoreList().remove(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Unregistered store instance " + store + ". Stores now: " + this.getStoreList().size());
        }
    }

    public Iterator iterator() {
        return this.getStoreList().iterator();
    }

    private void freeMemory() {
        try {
            if (this.freeingAlgorithm.equals(ALG_ALL_STORES)) {
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    this.removeStoreObjects((Store)i.next());
                }
                return;
            }
            if (this.getIndex() < this.getStoreList().size()) {
                if (this.getIndex() == -1) {
                    this.setIndex(0);
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Restarting from the beginning");
                }
                this.setIndex(0);
            }
            this.removeStoreObjects((Store)this.getStoreList().get(this.getIndex()));
        }
        catch (Exception e) {
            this.getLogger().error("Error in freeMemory()", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.getLogger().error("OutOfMemoryError in freeMemory()");
        }
    }

    private void removeStoreObjects(Store store) {
        int limit = this.calcToFree(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Freeing " + limit + " items from store " + store + " with " + store.size() + " items.");
        }
        for (int i = 0; i < limit; ++i) {
            try {
                store.free();
                continue;
            }
            catch (OutOfMemoryError e) {
                this.getLogger().error("OutOfMemoryError while releasing an object from the store.");
            }
        }
    }

    private int calcToFree(Store store) {
        int cnt = store.size();
        if (cnt < 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Unknown size of the store: " + store);
            }
            return 0;
        }
        int res = (int)((double)cnt * this.fraction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Calculating size for store " + store + " with size " + cnt + ": " + res);
        }
        return res;
    }

    private void freePhysicalMemory() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Invoking GC. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
        this.getJVM().runFinalization();
        this.getJVM().gc();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("GC complete. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
    }

    private int getMinFreeMemory() {
        return this.minFreeMemory;
    }

    private int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    private int getPriority() {
        return this.priority;
    }

    private int getThreadInterval() {
        return this.threadInterval;
    }

    private boolean getAdaptiveThreadInterval() {
        return this.adaptiveThreadInterval;
    }

    private Runtime getJVM() {
        return this.jvm;
    }

    private ArrayList getStoreList() {
        return this.storelist;
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int _index) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting index=" + _index);
        }
        this.index = _index;
    }
}

