/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.matching.PreparableMatcher;
import org.apache.cocoon.sitemap.PatternException;

public class PreparableMatchNode
extends SimpleSelectorProcessingNode
implements ParameterizableProcessingNode,
Composable,
Disposable {
    private String pattern;
    private String name;
    private Object preparedPattern;
    private Map parameters;
    private PreparableMatcher threadSafeMatcher;
    protected ComponentManager manager;

    public PreparableMatchNode(String type, String pattern, String name) throws PatternException {
        super(type);
        this.pattern = pattern;
        this.name = name;
    }

    @Override
    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.setSelector((ComponentSelector)manager.lookup(Matcher.ROLE + "Selector"));
        PreparableMatcher matcher = (PreparableMatcher)this.selector.select((Object)this.componentName);
        if (matcher instanceof ThreadSafe) {
            this.threadSafeMatcher = matcher;
        }
        try {
            this.preparedPattern = matcher.preparePattern(this.pattern);
        }
        catch (PatternException pe) {
            String msg = "Invalid pattern '" + this.pattern + "' for matcher at " + this.getLocation();
            throw new ComponentException(null, msg, (Throwable)((Object)pe));
        }
        finally {
            if (this.threadSafeMatcher == null) {
                this.selector.release((Component)matcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        Map objectModel = env.getObjectModel();
        Parameters resolvedParams = VariableResolver.buildParameters(this.parameters, context, objectModel);
        Map result = null;
        if (this.threadSafeMatcher != null) {
            result = this.threadSafeMatcher.preparedMatch(this.preparedPattern, objectModel, resolvedParams);
        } else {
            PreparableMatcher matcher = (PreparableMatcher)this.selector.select((Object)this.componentName);
            try {
                result = matcher.preparedMatch(this.preparedPattern, objectModel, resolvedParams);
            }
            finally {
                this.selector.release((Component)matcher);
            }
        }
        if (result != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Matcher '" + this.componentName + "' matched prepared pattern '" + this.pattern + "' at " + this.getLocation());
            }
            return this.invokeNodes(this.children, env, context, this.name, result);
        }
        return false;
    }

    public void dispose() {
        if (this.threadSafeMatcher != null) {
            this.selector.release((Component)this.threadSafeMatcher);
            this.threadSafeMatcher = null;
        }
        if (this.selector != null) {
            this.manager.release((Component)this.selector);
            this.selector = null;
        }
        this.manager = null;
    }
}

