/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;

public class ReadNode
extends AbstractProcessingNode
implements ParameterizableProcessingNode {
    private String readerName;
    private VariableResolver source;
    private VariableResolver mimeType;
    private int statusCode;
    private Map parameters;

    public ReadNode(String name, VariableResolver source, VariableResolver mimeType, int statusCode) {
        this.readerName = name;
        this.source = source;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
    }

    @Override
    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    @Override
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        ProcessingPipeline pipeline = context.getProcessingPipeline();
        pipeline.setReader(this.readerName, this.source.resolve(context, objectModel), VariableResolver.buildParameters(this.parameters, context, objectModel), this.mimeType.resolve(context, objectModel));
        if (this.statusCode >= 0) {
            env.setStatus(this.statusCode);
        }
        if (!context.isBuildingPipelineOnly()) {
            return pipeline.process(env);
        }
        return true;
    }
}

