/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.transformation.helpers.IncludeCacheStorageProxy;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;

public final class IncludeCacheManagerSession {
    private long expires;
    private boolean purge;
    private boolean preemptive;
    private boolean parallel;
    private IncludeCacheStorageProxy storage;
    private Map threadList;
    private SourceValidity validity;
    private Map sourceList = new HashMap(10);

    IncludeCacheManagerSession(Parameters configuration, IncludeCacheStorageProxy proxy) {
        this.expires = configuration.getParameterAsLong("expires", 0L);
        this.purge = configuration.getParameterAsBoolean("purge", false);
        this.preemptive = configuration.getParameterAsBoolean("preemptive", false);
        this.parallel = configuration.getParameterAsBoolean("parallel", false);
        this.storage = proxy;
    }

    IncludeCacheStorageProxy getCacheStorageProxy() {
        return this.storage;
    }

    public long getExpires() {
        return this.expires;
    }

    public SourceValidity getExpiresValidity() {
        if (this.expires > 0L && this.validity == null) {
            this.validity = new ExpiresValidity(this.expires * 1000L);
        }
        return this.validity;
    }

    public boolean isPurging() {
        return this.purge;
    }

    public boolean isPreemptive() {
        return this.preemptive;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    void add(String uri, Object object) {
        if (null == this.threadList) {
            this.threadList = new HashMap(10);
        }
        this.threadList.put(uri, object);
    }

    Object get(String uri) {
        if (null != this.threadList) {
            return this.threadList.get(uri);
        }
        return null;
    }

    void setPreemptive(boolean value) {
        this.preemptive = value;
    }

    public Source resolveURI(String uri, SourceResolver resolver) throws IOException {
        Source source = (Source)this.sourceList.get(uri);
        if (null == source) {
            source = resolver.resolveURI(uri);
            this.sourceList.put(source.getURI(), source);
        }
        return source;
    }

    void cleanup(SourceResolver resolver) {
        for (Source source : this.sourceList.values()) {
            resolver.release(source);
        }
    }

    public String toString() {
        return "CacheManagerSession(" + this.hashCode() + ") -" + " expires: " + this.expires + " parallel: " + this.parallel + " preemptive: " + this.preemptive + " purge: " + this.purge;
    }
}

