/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class MRUBucketMap
implements Map {
    private static final int DEFAULT_BUCKETS = 255;
    private final Node[] m_buckets;
    private final Object[] m_locks;
    private final Node m_header = new Node();
    private int m_size = 0;

    public MRUBucketMap() {
        this(255);
    }

    public MRUBucketMap(int numBuckets) {
        int size = Math.max(17, numBuckets);
        if (size % 2 == 0) {
            --size;
        }
        this.m_buckets = new Node[size];
        this.m_locks = new Object[size];
        for (int i = 0; i < size; ++i) {
            this.m_locks[i] = new Object();
        }
        this.m_header.mru_next = this.m_header.mru_previous = this.m_header;
    }

    private final int getHash(Object key) {
        int hash = key.hashCode() % this.m_buckets.length;
        return hash < 0 ? hash * -1 : hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        for (int i = 0; i < this.m_buckets.length; ++i) {
            Object object = this.m_locks[i];
            synchronized (object) {
                Node n = this.m_buckets[i];
                while (n != null) {
                    keySet.add(n.key);
                    n = n.next;
                }
                continue;
            }
        }
        return keySet;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Node node;
        if (null == key || null == value) {
            return null;
        }
        int isNew = 0;
        Object oldValue = null;
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            if (n == null) {
                node = new Node();
                node.key = key;
                node.value = value;
                this.m_buckets[hash] = node;
                isNew = 1;
            } else {
                Node next = n;
                while (next != null) {
                    n = next;
                    if (n.key.equals(key)) {
                        oldValue = n.value;
                        n.value = value;
                        break;
                    }
                    next = next.next;
                }
                if (oldValue == null) {
                    node = new Node();
                    node.key = key;
                    node.value = value;
                    n.next = node;
                    isNew = 1;
                } else {
                    node = n;
                }
            }
        }
        object = this.m_header;
        synchronized (object) {
            if (isNew == 0) {
                node.mru_previous.mru_next = node.mru_next;
                node.mru_next.mru_previous = node.mru_previous;
            }
            node.mru_previous = this.m_header;
            node.mru_next = this.m_header.mru_next;
            node.mru_previous.mru_next = node;
            node.mru_next.mru_previous = node;
            this.m_size += isNew;
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Node n;
        if (null == key) {
            return null;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            n = this.m_buckets[hash];
            while (n != null && !n.key.equals(key)) {
                n = n.next;
            }
        }
        if (n != null) {
            object = this.m_header;
            synchronized (object) {
                n.mru_previous.mru_next = n.mru_next;
                n.mru_next.mru_previous = n.mru_previous;
                n.mru_previous = this.m_header;
                n.mru_next = this.m_header.mru_next;
                n.mru_previous.mru_next = n;
                n.mru_next.mru_previous = n;
            }
            return n.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            Node n = this.m_buckets[hash];
            while (n != null) {
                if (n.key.equals(key)) {
                    return true;
                }
                n = n.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        if (null == value) {
            return false;
        }
        Node node = this.m_header;
        synchronized (node) {
            Node n = this.m_header.mru_next;
            while (n != this.m_header) {
                if (n.value.equals(value)) {
                    return true;
                }
                n = n.mru_next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        HashSet<Object> valueSet = new HashSet<Object>();
        Node node = this.m_header;
        synchronized (node) {
            Node n = this.m_header.mru_next;
            while (n != this.m_header) {
                valueSet.add(n.value);
                n = n.mru_next;
            }
        }
        return valueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        HashSet<Node> entrySet = new HashSet<Node>();
        Node node = this.m_header;
        synchronized (node) {
            Node n = this.m_header.mru_next;
            while (n != this.m_header) {
                entrySet.add(n);
                n = n.mru_next;
            }
        }
        return entrySet;
    }

    public void putAll(Map other) {
        for (Map.Entry me : other.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Node n;
        if (null == key) {
            return null;
        }
        int hash = this.getHash(key);
        Object object = this.m_locks[hash];
        synchronized (object) {
            n = this.m_buckets[hash];
            Node prev = null;
            while (n != null) {
                if (n.key.equals(key)) {
                    if (null == prev) {
                        this.m_buckets[hash] = n.next;
                        break;
                    }
                    prev.next = n.next;
                    break;
                }
                prev = n;
                n = n.next;
            }
        }
        if (n != null) {
            object = this.m_header;
            synchronized (object) {
                n.mru_previous.mru_next = n.mru_next;
                n.mru_next.mru_previous = n.mru_previous;
                --this.m_size;
            }
            return n.value;
        }
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return this.m_size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Node node = this.m_header;
        synchronized (node) {
            for (int i = 0; i < this.m_buckets.length; ++i) {
                this.m_buckets[i] = null;
            }
            this.m_header.mru_next = this.m_header.mru_previous = this.m_header;
            this.m_size = 0;
        }
    }

    public Map.Entry removeLast() {
        Node node = this.m_header.mru_previous;
        if (node == this.m_header) {
            throw new NoSuchElementException("MRUBucketMap is empty");
        }
        this.remove(node.key);
        node.mru_next = null;
        node.mru_previous = null;
        return node;
    }

    static class X {
        String x;

        public X(String s) {
            this.x = s;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return this.x;
        }
    }

    private static final class Node
    implements Map.Entry {
        protected Object key;
        protected Object value;
        protected Node next;
        protected Node mru_previous;
        protected Node mru_next;

        private Node() {
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object val) {
            Object retVal = this.value;
            this.value = val;
            return retVal;
        }
    }
}

