/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.cocoon.util.HashMap;

public final class ReflectionUtils {
    private static DefaultIndexer defaultIndexer = new DefaultIndexer();
    private static DefaultMatcher defaultMatcher = new DefaultMatcher();

    public static Map discoverFields(Class pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverFields(pClazz, pMatcher, defaultIndexer);
    }

    public static Map discoverFields(Class pClazz) {
        return ReflectionUtils.discoverFields(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map discoverFields(Class pClazz, Matcher pMatcher, Indexer pIndexer) {
        System.out.println("discovering fields on " + pClazz.getName());
        HashMap result = new HashMap();
        Class current = pClazz;
        do {
            Field[] fields = current.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String fname = fields[i].getName();
                if (!pMatcher.matches(fname)) continue;
                pIndexer.put(result, fname, fields[i]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    public static Map discoverMethods(Class pClazz, Matcher pMatcher) {
        return ReflectionUtils.discoverMethods(pClazz, pMatcher, defaultIndexer);
    }

    public static Map discoverMethods(Class pClazz) {
        return ReflectionUtils.discoverMethods(pClazz, defaultMatcher, defaultIndexer);
    }

    public static Map discoverMethods(Class pClazz, Matcher pMatcher, Indexer pIndexer) {
        System.out.println("discovering methods on " + pClazz.getName());
        HashMap result = new HashMap();
        Class current = pClazz;
        do {
            Method[] methods = current.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String mname = methods[i].getName();
                if (!pMatcher.matches(mname)) continue;
                pIndexer.put(result, mname, methods[i]);
            }
        } while ((current = current.getSuperclass()) != null);
        return result;
    }

    private static class DefaultIndexer
    implements Indexer {
        private DefaultIndexer() {
        }

        @Override
        public void put(Map pMap, String pKey, Object pObject) {
            String name = Character.toLowerCase(pKey.charAt(2)) + pKey.substring(3);
            System.out.println("reflecting " + name);
            pMap.put(name, pObject);
        }
    }

    private static class DefaultMatcher
    implements Matcher {
        private DefaultMatcher() {
        }

        @Override
        public boolean matches(String pName) {
            return pName.startsWith("do");
        }
    }

    public static interface Indexer {
        public void put(Map var1, String var2, Object var3);
    }

    public static interface Matcher {
        public boolean matches(String var1);
    }
}

