/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cocoon.util.location.LocatableException;
import org.apache.cocoon.util.location.LocatedException;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.apache.cocoon.util.location.MultiLocatable;
import org.apache.commons.lang.exception.NestableRuntimeException;

public class LocatedRuntimeException
extends NestableRuntimeException
implements LocatableException,
MultiLocatable {
    private List locations;

    public LocatedRuntimeException(String message) {
        this(message, null, null, true);
    }

    public LocatedRuntimeException(String message, Throwable cause) throws LocatedRuntimeException {
        this(message, cause, null, true);
    }

    public LocatedRuntimeException(String message, Location location) {
        this(message, null, location, true);
    }

    public LocatedRuntimeException(String message, Throwable cause, Location location) throws LocatedRuntimeException {
        this(message, cause, location, true);
    }

    public LocatedRuntimeException(String message, Throwable cause, Location location, boolean rethrowLocated) throws LocatedRuntimeException {
        super(message, cause);
        if (rethrowLocated && cause instanceof LocatedRuntimeException) {
            LocatedRuntimeException lreCause = (LocatedRuntimeException)((Object)cause);
            lreCause.addLocation(location);
            throw lreCause;
        }
        LocatedException.ensureCauseChainIsSet(cause);
        LocatedException.addCauseLocations(this, cause);
        this.addLocation(location);
    }

    @Override
    public Location getLocation() {
        return this.locations == null ? null : (Location)this.locations.get(0);
    }

    @Override
    public List getLocations() {
        return this.locations == null ? Collections.EMPTY_LIST : this.locations;
    }

    @Override
    public String getRawMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        return LocatedException.getMessage(super.getMessage(), this.locations);
    }

    @Override
    public void addLocation(Location loc) {
        if (LocationUtils.isUnknown(loc)) {
            return;
        }
        if (this.locations == null) {
            this.locations = new ArrayList(1);
        }
        this.locations.add(LocationImpl.get(loc));
    }
}

