/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml.dom;

import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.dom.DOMFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMBuilder
extends AbstractXMLPipe {
    protected static final SAXTransformerFactory FACTORY = (SAXTransformerFactory)TransformerFactory.newInstance();
    protected SAXTransformerFactory factory;
    protected Listener listener;
    protected DOMResult result;
    protected Node parentNode;

    public DOMBuilder() {
        this((Listener)null, (Node)null);
    }

    public DOMBuilder(SAXTransformerFactory factory) {
        this(factory, null, null);
    }

    public DOMBuilder(DOMFactory factory) {
        this((Listener)null, (Node)null);
    }

    public DOMBuilder(Listener listener) {
        this(listener, null);
    }

    public DOMBuilder(DOMFactory factory, Listener listener) {
        this(listener, null);
    }

    public DOMBuilder(DOMFactory domFactory, Listener listener, Node parentNode) {
        this(listener, parentNode);
    }

    public DOMBuilder(Node parentNode) {
        this(null, parentNode);
    }

    public DOMBuilder(Listener listener, Node parentNode) {
        this((SAXTransformerFactory)null, listener, parentNode);
    }

    public DOMBuilder(SAXTransformerFactory factory, Listener listener, Node parentNode) {
        this.factory = factory == null ? FACTORY : factory;
        this.listener = listener;
        this.parentNode = parentNode;
        this.setup();
    }

    private void setup() {
        try {
            TransformerHandler handler = this.factory.newTransformerHandler();
            this.setContentHandler(handler);
            this.setLexicalHandler(handler);
            this.result = this.parentNode != null ? new DOMResult(this.parentNode) : new DOMResult();
            handler.setResult(this.result);
        }
        catch (TransformerException local) {
            throw new CascadingRuntimeException("Fatal-Error: Unable to get transformer handler", (Throwable)local);
        }
    }

    @Override
    public void recycle() {
        super.recycle();
        this.setup();
    }

    public Document getDocument() {
        if (this.result == null || this.result.getNode() == null) {
            return null;
        }
        if (this.result.getNode().getNodeType() == 9) {
            return (Document)this.result.getNode();
        }
        return this.result.getNode().getOwnerDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.notifyListener();
    }

    protected void notifyListener() throws SAXException {
        if (this.listener != null) {
            this.listener.notify(this.getDocument());
        }
    }

    public static interface Listener {
        public void notify(Document var1) throws SAXException;
    }
}

