/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.IncrementalScopeCreator;
import com.google.javascript.jscomp.IndexProvider;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.PersistentInputStore;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMapInput;
import com.google.javascript.jscomp.TypeMismatch;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.jscomp.parsing.parser.trees.Comment;
import com.google.javascript.jscomp.type.ReverseAbstractInterpreter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractCompiler
implements SourceExcerptProvider {
    static final DiagnosticType READ_ERROR = DiagnosticType.error("JSC_READ_ERROR", "Cannot read file {0}: {1}");
    protected Map<String, Object> annotationMap = new HashMap<String, Object>();
    private LifeCycleStage stage = LifeCycleStage.RAW;
    @Nullable
    private PersistentInputStore persistentInputStore;

    abstract void beforePass(String var1);

    abstract void afterPass(String var1);

    public abstract CompilerInput getInput(InputId var1);

    @Nullable
    abstract SourceFile getSourceFileByName(String var1);

    @Nullable
    abstract Node getScriptNode(String var1);

    abstract JSModuleGraph getModuleGraph();

    abstract List<CompilerInput> getInputsInOrder();

    abstract int getNumberOfInputs();

    public abstract void addExportedNames(Set<String> var1);

    public abstract Set<String> getExportedNames();

    public abstract void setVariableMap(VariableMap var1);

    public abstract void setPropertyMap(VariableMap var1);

    public abstract void setStringMap(VariableMap var1);

    public abstract void setFunctionNames(FunctionNames var1);

    public abstract FunctionNames getFunctionNames();

    public abstract void setCssNames(Map<String, Integer> var1);

    public abstract void setIdGeneratorMap(String var1);

    public abstract IdGenerator getCrossModuleIdGenerator();

    public abstract void setAnonymousFunctionNameMap(VariableMap var1);

    abstract void setMostRecentTypechecker(MostRecentTypechecker var1);

    abstract MostRecentTypechecker getMostRecentTypechecker();

    public abstract JSTypeRegistry getTypeRegistry();

    public abstract TypeIRegistry getTypeIRegistry();

    public abstract void clearTypeIRegistry();

    abstract void forwardDeclareType(String var1);

    abstract ScopeCreator getTypedScopeCreator();

    public abstract TypedScope getTopScope();

    abstract IncrementalScopeCreator getScopeCreator();

    abstract void putScopeCreator(IncrementalScopeCreator var1);

    public abstract void report(JSError var1);

    abstract void throwInternalError(String var1, Throwable var2);

    public abstract CodingConvention getCodingConvention();

    public abstract void reportChangeToEnclosingScope(Node var1);

    public abstract void reportChangeToChangeScope(Node var1);

    abstract void reportFunctionDeleted(Node var1);

    abstract void setCssRenamingMap(CssRenamingMap var1);

    abstract CssRenamingMap getCssRenamingMap();

    abstract Node getNodeForCodeInsertion(@Nullable JSModule var1);

    abstract TypeValidator getTypeValidator();

    abstract Iterable<TypeMismatch> getTypeMismatches();

    abstract Iterable<TypeMismatch> getImplicitInterfaceUses();

    abstract <T extends TypeIRegistry> T getGlobalTypeInfo();

    abstract void setExternExports(String var1);

    abstract Node parseSyntheticCode(String var1);

    abstract Node parseSyntheticCode(String var1, String var2);

    @VisibleForTesting
    abstract Node parseTestCode(String var1);

    public abstract String toSource();

    public abstract String toSource(Node var1);

    abstract ErrorReporter getDefaultErrorReporter();

    public abstract ReverseAbstractInterpreter getReverseAbstractInterpreter();

    LifeCycleStage getLifeCycleStage() {
        return this.stage;
    }

    abstract Supplier<String> getUniqueNameIdSupplier();

    abstract boolean hasHaltingErrors();

    abstract void addChangeHandler(CodeChangeHandler var1);

    abstract void removeChangeHandler(CodeChangeHandler var1);

    abstract void addIndexProvider(IndexProvider<?> var1);

    abstract <T> T getIndex(Class<T> var1);

    abstract int getChangeStamp();

    abstract List<Node> getChangedScopeNodesForPass(String var1);

    abstract List<Node> getDeletedScopeNodesForPass(String var1);

    abstract void incrementChangeStamp();

    abstract Node getJsRoot();

    abstract boolean hasScopeChanged(Node var1);

    abstract Config getParserConfig(ConfigContext var1);

    abstract void prepareAst(Node var1);

    public abstract ErrorManager getErrorManager();

    void setLifeCycleStage(LifeCycleStage stage) {
        this.stage = stage;
    }

    abstract boolean areNodesEqualForInlining(Node var1, Node var2);

    abstract void setHasRegExpGlobalReferences(boolean var1);

    abstract boolean hasRegExpGlobalReferences();

    abstract CheckLevel getErrorLevel(JSError var1);

    abstract void process(CompilerPass var1);

    public abstract Node getRoot();

    abstract CompilerOptions getOptions();

    abstract FeatureSet getFeatureSet();

    abstract void setFeatureSet(FeatureSet var1);

    abstract void updateGlobalVarReferences(Map<Var, ReferenceCollection> var1, Node var2);

    abstract GlobalVarReferenceMap getGlobalVarReferences();

    abstract CompilerInput getSynthesizedExternsInput();

    abstract CompilerInput getSynthesizedExternsInputAtEnd();

    public abstract double getProgress();

    abstract String getLastPassName();

    abstract void setProgress(double var1, @Nullable String var3);

    abstract Node ensureLibraryInjected(String var1, boolean var2);

    abstract void setExternProperties(Set<String> var1);

    abstract Set<String> getExternProperties();

    public abstract void addInputSourceMap(String var1, SourceMapInput var2);

    abstract void addComments(String var1, List<Comment> var2);

    abstract ImmutableMap<String, PropertyAccessKind> getExternGetterAndSetterProperties();

    abstract void setExternGetterAndSetterProperties(ImmutableMap<String, PropertyAccessKind> var1);

    abstract ImmutableMap<String, PropertyAccessKind> getSourceGetterAndSetterProperties();

    abstract void setSourceGetterAndSetterProperties(ImmutableMap<String, PropertyAccessKind> var1);

    abstract List<Comment> getComments(String var1);

    abstract void setDefaultDefineValues(ImmutableMap<String, Node> var1);

    abstract ImmutableMap<String, Node> getDefaultDefineValues();

    abstract ModuleLoader getModuleLoader();

    abstract CompilerInput.ModuleType getModuleTypeByName(String var1);

    void setAnnotation(String key, Object object) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)"The stored annotation value cannot be null.");
        Preconditions.checkArgument((!this.annotationMap.containsKey(key) ? 1 : 0) != 0, (String)"Cannot overwrite the existing annotation '%s'.", (Object)key);
        this.annotationMap.put(key, object);
    }

    @Nullable
    Object getAnnotation(String key) {
        return this.annotationMap.get(key);
    }

    void setPersistentInputStore(PersistentInputStore persistentInputStore) {
        this.persistentInputStore = persistentInputStore;
    }

    @Nullable
    PersistentInputStore getPersistentInputStore() {
        return this.persistentInputStore;
    }

    public static enum PropertyAccessKind {
        NORMAL(0),
        GETTER_ONLY(1),
        SETTER_ONLY(2),
        GETTER_AND_SETTER(3);

        final byte flags;

        private PropertyAccessKind(int flags) {
            this.flags = (byte)flags;
        }

        boolean hasGetter() {
            return (this.flags & 1) != 0;
        }

        boolean hasSetter() {
            return (this.flags & 2) != 0;
        }

        boolean hasGetterOrSetter() {
            return (this.flags & 3) != 0;
        }

        PropertyAccessKind unionWith(PropertyAccessKind other) {
            int combinedFlags = this.flags | other.flags;
            switch (combinedFlags) {
                case 0: {
                    return NORMAL;
                }
                case 1: {
                    return GETTER_ONLY;
                }
                case 2: {
                    return SETTER_ONLY;
                }
                case 3: {
                    return GETTER_AND_SETTER;
                }
            }
            throw new IllegalStateException("unexpected value: " + combinedFlags);
        }
    }

    static enum LifeCycleStage implements Serializable
    {
        RAW,
        NORMALIZED,
        NORMALIZED_OBFUSCATED;


        boolean isNormalized() {
            return this == NORMALIZED || this == NORMALIZED_OBFUSCATED;
        }

        boolean isNormalizedUnobfuscated() {
            return this == NORMALIZED;
        }

        boolean isNormalizedObfuscated() {
            return this == NORMALIZED_OBFUSCATED;
        }
    }

    static enum ConfigContext {
        DEFAULT,
        EXTERNS;

    }

    static enum MostRecentTypechecker {
        NONE,
        OTI,
        NTI;

    }
}

