/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.debugging.sourcemap.FilePosition;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.TypedCodeGenerator;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeIRegistry;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public final class CodePrinter {
    private static String toSource(Node root, Format outputFormat, CompilerOptions options, SourceMap sourceMap, boolean tagAsTypeSummary, boolean tagAsExterns, boolean tagAsStrict, boolean lineBreak, Builder.CodeGeneratorFactory codeGeneratorFactory) {
        Preconditions.checkState((options.sourceMapDetailLevel != null ? 1 : 0) != 0);
        boolean createSourceMap = sourceMap != null;
        MappedCodePrinter mcp = outputFormat == Format.COMPACT ? new CompactCodePrinter(lineBreak, options.preferLineBreakAtEndOfFile, options.lineLengthThreshold, createSourceMap, options.sourceMapDetailLevel) : new PrettyCodePrinter(options.lineLengthThreshold, createSourceMap, options.sourceMapDetailLevel);
        CodeGenerator cg = codeGeneratorFactory.getCodeGenerator(outputFormat, mcp);
        if (tagAsExterns) {
            cg.tagAsExterns();
        }
        if (tagAsTypeSummary) {
            cg.tagAsTypeSummary();
        }
        if (tagAsStrict) {
            cg.tagAsStrict();
        }
        cg.add(root);
        mcp.endFile();
        String code = mcp.getCode();
        if (createSourceMap) {
            mcp.generateSourceMap(code, sourceMap);
        }
        return code;
    }

    public static enum Format {
        COMPACT,
        PRETTY,
        TYPED;


        static Format fromOptions(CompilerOptions options, boolean outputTypes, boolean prettyPrint) {
            if (outputTypes) {
                return TYPED;
            }
            if (prettyPrint || options.getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT6_TYPED) {
                return PRETTY;
            }
            return COMPACT;
        }
    }

    public static final class Builder {
        private final Node root;
        private CompilerOptions options = new CompilerOptions();
        private boolean lineBreak;
        private boolean prettyPrint;
        private boolean outputTypes = false;
        private SourceMap sourceMap = null;
        private boolean tagAsExterns;
        private boolean tagAsTypeSummary;
        private boolean tagAsStrict;
        private TypeIRegistry registry;
        private CodeGeneratorFactory codeGeneratorFactory = new CodeGeneratorFactory(){

            @Override
            public CodeGenerator getCodeGenerator(Format outputFormat, CodeConsumer cc) {
                return outputFormat == Format.TYPED ? new TypedCodeGenerator(cc, options, registry) : new CodeGenerator(cc, options);
            }
        };

        public Builder(Node node) {
            this.root = node;
        }

        public Builder setCompilerOptions(CompilerOptions options) {
            this.options = options;
            this.prettyPrint = options.isPrettyPrint();
            this.lineBreak = options.lineBreak;
            return this;
        }

        public Builder setTypeRegistry(TypeIRegistry registry) {
            this.registry = registry;
            return this;
        }

        public Builder setPrettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder setLineBreak(boolean lineBreak) {
            this.lineBreak = lineBreak;
            return this;
        }

        public Builder setOutputTypes(boolean outputTypes) {
            this.outputTypes = outputTypes;
            return this;
        }

        public Builder setSourceMap(SourceMap sourceMap) {
            this.sourceMap = sourceMap;
            return this;
        }

        public Builder setTagAsTypeSummary(boolean tagAsTypeSummary) {
            this.tagAsTypeSummary = tagAsTypeSummary;
            return this;
        }

        public Builder setTagAsExterns(boolean tagAsExterns) {
            this.tagAsExterns = tagAsExterns;
            return this;
        }

        public Builder setTagAsStrict(boolean tagAsStrict) {
            this.tagAsStrict = tagAsStrict;
            return this;
        }

        public Builder setCodeGeneratorFactory(CodeGeneratorFactory factory) {
            this.codeGeneratorFactory = factory;
            return this;
        }

        public String build() {
            if (this.root == null) {
                throw new IllegalStateException("Cannot build without root node being specified");
            }
            return CodePrinter.toSource(this.root, Format.fromOptions(this.options, this.outputTypes, this.prettyPrint), this.options, this.sourceMap, this.tagAsTypeSummary, this.tagAsExterns, this.tagAsStrict, this.lineBreak, this.codeGeneratorFactory);
        }

        public static interface CodeGeneratorFactory {
            public CodeGenerator getCodeGenerator(Format var1, CodeConsumer var2);
        }
    }

    static class CompactCodePrinter
    extends MappedCodePrinter {
        private final boolean lineBreak;
        private final boolean preferLineBreakAtEndOfFile;
        private int lineStartPosition = 0;
        private int preferredBreakPosition = 0;
        private int prevCutPosition = 0;
        private int prevLineStartPosition = 0;

        private CompactCodePrinter(boolean lineBreak, boolean preferLineBreakAtEndOfFile, int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            super(lineLengthThreshold, createSrcMap, sourceMapDetailLevel);
            this.lineBreak = lineBreak;
            this.preferLineBreakAtEndOfFile = preferLineBreakAtEndOfFile;
        }

        @Override
        void append(String str) {
            this.code.append(str);
            this.lineLength += str.length();
            int newlines = CharMatcher.is((char)'\n').countIn((CharSequence)str);
            if (newlines > 0) {
                this.lineIndex += newlines;
                this.lineLength = str.length() - str.lastIndexOf(10);
            }
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.prevCutPosition = this.code.length();
                this.prevLineStartPosition = this.lineStartPosition;
                this.code.append('\n');
                this.lineLength = 0;
                ++this.lineIndex;
                this.lineStartPosition = this.code.length();
            }
        }

        @Override
        void maybeLineBreak() {
            char ch;
            int len;
            if (this.lineBreak && this.sawFunction) {
                this.startNewLine();
                this.sawFunction = false;
            }
            if (this.preferredBreakPosition == (len = this.code.length()) - 1 && (ch = this.code.charAt(len - 1)) == ';') {
                this.preferredBreakPosition = len;
            }
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                if (this.preferredBreakPosition > this.lineStartPosition && this.preferredBreakPosition < this.lineStartPosition + this.lineLength) {
                    int position = this.preferredBreakPosition;
                    this.code.insert(position, '\n');
                    this.prevCutPosition = position;
                    this.reportLineCut(this.lineIndex, position - this.lineStartPosition, true);
                    ++this.lineIndex;
                    this.lineLength -= position - this.lineStartPosition;
                    this.prevLineStartPosition = this.lineStartPosition;
                    this.lineStartPosition = position + 1;
                } else {
                    this.startNewLine();
                }
            }
        }

        @Override
        void notePreferredLineBreak() {
            this.preferredBreakPosition = this.code.length();
        }

        @Override
        void endFile() {
            super.endFile();
            if (!this.preferLineBreakAtEndOfFile) {
                return;
            }
            if (this.lineLength > this.lineLengthThreshold / 2) {
                this.append(";");
                this.startNewLine();
            } else if (this.prevCutPosition > 0) {
                this.code.setCharAt(this.prevCutPosition, ' ');
                this.lineStartPosition = this.prevLineStartPosition;
                this.lineLength = this.code.length() - this.lineStartPosition;
                int prevLineEndPosition = this.prevCutPosition - this.prevLineStartPosition + 1;
                this.reportLineCut(this.lineIndex, prevLineEndPosition, false);
                --this.lineIndex;
                this.prevCutPosition = 0;
                this.prevLineStartPosition = 0;
                this.append(";");
                this.startNewLine();
            }
        }
    }

    static class PrettyCodePrinter
    extends MappedCodePrinter {
        static final String INDENT = "  ";
        private int indent = 0;

        private PrettyCodePrinter(int lineLengthThreshold, boolean createSourceMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            super(lineLengthThreshold, createSourceMap, sourceMapDetailLevel);
        }

        @Override
        void append(String str) {
            if (this.lineLength == 0) {
                for (int i = 0; i < this.indent; ++i) {
                    this.code.append(INDENT);
                    this.lineLength += INDENT.length();
                }
            }
            this.code.append(str);
            this.lineLength += str.length();
            int newlines = CharMatcher.is((char)'\n').countIn((CharSequence)str);
            if (newlines > 0) {
                this.lineIndex += newlines;
                this.lineLength = str.length() - str.lastIndexOf(10);
            }
        }

        @Override
        void addNumber(double x, Node n) {
            double d;
            if (PrettyCodePrinter.isNegativeZero(x)) {
                super.addNumber(x, n);
                return;
            }
            String numberFromSource = PrettyCodePrinter.getNumberFromSource(n);
            if (numberFromSource == null) {
                super.addNumber(x, n);
                return;
            }
            if (x < 0.0) {
                numberFromSource = "-" + numberFromSource;
            }
            try {
                d = Double.parseDouble(numberFromSource);
            }
            catch (NumberFormatException e) {
                super.addNumber(x, n);
                return;
            }
            if (x != d) {
                super.addNumber(x, n);
                return;
            }
            this.addConstant(numberFromSource);
        }

        @Override
        void startNewLine() {
            if (this.lineLength > 0) {
                this.code.append('\n');
                ++this.lineIndex;
                this.lineLength = 0;
            }
        }

        @Override
        void maybeLineBreak() {
            this.maybeCutLine();
        }

        @Override
        void maybeCutLine() {
            if (this.lineLength > this.lineLengthThreshold) {
                this.startNewLine();
            }
        }

        @Override
        void endLine() {
            this.startNewLine();
        }

        @Override
        void appendBlockStart() {
            this.maybeInsertSpace();
            this.append("{");
            ++this.indent;
        }

        @Override
        void appendBlockEnd() {
            this.maybeEndStatement();
            this.endLine();
            --this.indent;
            this.append("}");
        }

        @Override
        void listSeparator() {
            this.add(", ");
            this.maybeLineBreak();
        }

        @Override
        void endFunction(boolean statementContext) {
            super.endFunction(statementContext);
            if (statementContext) {
                this.startNewLine();
            }
        }

        @Override
        void beginCaseBody() {
            super.beginCaseBody();
            ++this.indent;
            this.endLine();
        }

        @Override
        void endCaseBody() {
            super.endCaseBody();
            --this.indent;
        }

        @Override
        void appendOp(String op, boolean binOp) {
            if (this.getLastChar() != ' ' && binOp && op.charAt(0) != ',') {
                this.append(" ");
            }
            this.append(op);
            if (binOp) {
                this.append(" ");
            }
        }

        @Override
        boolean shouldPreserveExtraBlocks() {
            return true;
        }

        @Override
        void maybeInsertSpace() {
            if (this.getLastChar() != ' ' && this.getLastChar() != '\n') {
                this.add(" ");
            }
        }

        private static Node getTryForCatch(Node n) {
            return n.getGrandparent();
        }

        @Override
        boolean breakAfterBlockFor(Node n, boolean isStatementContext) {
            Preconditions.checkState((boolean)n.isNormalBlock(), (Object)n);
            Node parent = n.getParent();
            Token type = parent.getToken();
            switch (type) {
                case DO: {
                    return false;
                }
                case FUNCTION: {
                    return false;
                }
                case TRY: {
                    return n != parent.getFirstChild();
                }
                case CATCH: {
                    return !NodeUtil.hasFinally(PrettyCodePrinter.getTryForCatch(parent));
                }
                case IF: {
                    return n == parent.getLastChild();
                }
            }
            return true;
        }

        @Override
        void endStatement(boolean needsSemicolon) {
            this.append(";");
            this.endLine();
            this.statementNeedsEnded = false;
        }

        @Override
        void endFile() {
            this.maybeEndStatement();
        }

        private static String getNumberFromSource(Node n) {
            int offset;
            String srcCode;
            if (!n.isNumber()) {
                return null;
            }
            StaticSourceFile staticSrc = NodeUtil.getSourceFile(n);
            if (!(staticSrc instanceof SourceFile)) {
                return null;
            }
            SourceFile src = (SourceFile)staticSrc;
            try {
                srcCode = src.getCode();
            }
            catch (IOException e) {
                return null;
            }
            try {
                offset = n.getSourceOffset();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            int endOffset = offset + n.getLength();
            if (offset < 0 || endOffset > srcCode.length()) {
                return null;
            }
            return srcCode.substring(offset, endOffset);
        }
    }

    private static abstract class MappedCodePrinter
    extends CodeConsumer {
        private final Deque<Mapping> mappings;
        private final List<Mapping> allMappings;
        private final boolean createSrcMap;
        private final SourceMap.DetailLevel sourceMapDetailLevel;
        protected final StringBuilder code = new StringBuilder(1024);
        protected final int lineLengthThreshold;
        protected int lineLength = 0;
        protected int lineIndex = 0;

        MappedCodePrinter(int lineLengthThreshold, boolean createSrcMap, SourceMap.DetailLevel sourceMapDetailLevel) {
            Preconditions.checkState((sourceMapDetailLevel != null ? 1 : 0) != 0);
            this.lineLengthThreshold = lineLengthThreshold <= 0 ? Integer.MAX_VALUE : lineLengthThreshold;
            this.createSrcMap = createSrcMap;
            this.sourceMapDetailLevel = sourceMapDetailLevel;
            this.mappings = createSrcMap ? new ArrayDeque() : null;
            this.allMappings = createSrcMap ? new ArrayList() : null;
        }

        @Override
        void startSourceMapping(Node node) {
            Preconditions.checkState((this.sourceMapDetailLevel != null ? 1 : 0) != 0);
            Preconditions.checkState((node != null ? 1 : 0) != 0);
            if (this.createSrcMap && node.getSourceFileName() != null && node.getLineno() > 0 && this.sourceMapDetailLevel.apply(node)) {
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                Mapping mapping = new Mapping();
                mapping.node = node;
                mapping.start = new FilePosition(line, index);
                this.mappings.push(mapping);
                this.allMappings.add(mapping);
            }
        }

        @Override
        void endSourceMapping(Node node) {
            if (this.createSrcMap && !this.mappings.isEmpty() && this.mappings.peek().node == node) {
                Mapping mapping = this.mappings.pop();
                int line = this.getCurrentLineIndex();
                int index = this.getCurrentCharIndex();
                Preconditions.checkState((line >= 0 ? 1 : 0) != 0);
                mapping.end = new FilePosition(line, index);
            }
        }

        void generateSourceMap(String code, SourceMap map) {
            if (this.createSrcMap) {
                ImmutableList<Integer> lineLengths = MappedCodePrinter.computeLineLengths(code);
                for (Mapping mapping : this.allMappings) {
                    map.addMapping(mapping.node, mapping.start, MappedCodePrinter.adjustEndPosition(lineLengths, mapping.end));
                }
            }
        }

        void reportLineCut(int lineIndex, int charIndex, boolean insertion) {
            if (this.createSrcMap) {
                for (Mapping mapping : this.allMappings) {
                    mapping.start = MappedCodePrinter.convertPosition(mapping.start, lineIndex, charIndex, insertion);
                    if (mapping.end == null) continue;
                    mapping.end = MappedCodePrinter.convertPosition(mapping.end, lineIndex, charIndex, insertion);
                }
            }
        }

        private static FilePosition convertPosition(FilePosition position, int lineIndex, int characterPosition, boolean insertion) {
            int originalLine = position.getLine();
            int originalChar = position.getColumn();
            if (insertion) {
                if (originalLine == lineIndex && originalChar >= characterPosition) {
                    return new FilePosition(originalLine + 1, originalChar - characterPosition);
                }
                return position;
            }
            if (originalLine == lineIndex) {
                return new FilePosition(originalLine - 1, originalChar + characterPosition);
            }
            if (originalLine > lineIndex) {
                throw new IllegalStateException("Cannot undo line cut on a previous line.");
            }
            return position;
        }

        public String getCode() {
            return this.code.toString();
        }

        @Override
        char getLastChar() {
            return this.code.length() > 0 ? this.code.charAt(this.code.length() - 1) : (char)'\u0000';
        }

        protected final int getCurrentCharIndex() {
            return this.lineLength;
        }

        protected final int getCurrentLineIndex() {
            return this.lineIndex;
        }

        private static ImmutableList<Integer> computeLineLengths(String code) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int lineStartPos = 0;
            int lineEndPos = code.indexOf(10);
            while (lineEndPos > -1) {
                builder.add((Object)(lineEndPos - lineStartPos));
                lineStartPos = lineEndPos + 1;
                lineEndPos = code.indexOf(10, lineStartPos);
            }
            return builder.build();
        }

        private static FilePosition adjustEndPosition(List<Integer> lineLengths, FilePosition endPosition) {
            int line = endPosition.getLine();
            if (line >= lineLengths.size()) {
                return endPosition;
            }
            Preconditions.checkState((endPosition.getColumn() <= lineLengths.get(line) ? 1 : 0) != 0, (String)"End position %s points to a column larger than line length %s", (Object)endPosition, (Object)lineLengths.get(line));
            if (endPosition.getColumn() == lineLengths.get(line).intValue()) {
                return new FilePosition(line + 1, 0);
            }
            return endPosition;
        }

        private static class Mapping {
            Node node;
            FilePosition start;
            FilePosition end;

            private Mapping() {
            }

            public String toString() {
                return "Mapping: start " + this.start + ", end " + this.end + ", node " + this.node;
            }
        }
    }
}

