/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class DiagnosticGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ImmutableSet<DiagnosticType> types;
    private final String name;
    private static final Map<DiagnosticType, DiagnosticGroup> singletons = new HashMap<DiagnosticType, DiagnosticGroup>();

    DiagnosticGroup(String name, DiagnosticType ... types) {
        this.name = name;
        this.types = ImmutableSet.copyOf(Arrays.asList(types));
    }

    public DiagnosticGroup(DiagnosticType ... types) {
        this((String)null, types);
    }

    private DiagnosticGroup(DiagnosticType type) {
        this.name = null;
        this.types = ImmutableSet.of((Object)type);
    }

    public DiagnosticGroup(DiagnosticGroup ... groups) {
        this((String)null, groups);
    }

    public DiagnosticGroup(String name, DiagnosticGroup ... groups) {
        ImmutableSet.Builder set = ImmutableSet.builder();
        for (DiagnosticGroup group : groups) {
            set.addAll(group.types);
        }
        this.name = name;
        this.types = set.build();
    }

    public static synchronized DiagnosticGroup forType(DiagnosticType type) {
        singletons.computeIfAbsent(type, k -> new DiagnosticGroup((DiagnosticType)k));
        return singletons.get(type);
    }

    public boolean matches(JSError error) {
        return this.matches(error.getType());
    }

    public boolean matches(DiagnosticType type) {
        return this.types.contains((Object)type);
    }

    boolean isSubGroup(DiagnosticGroup group) {
        for (DiagnosticType type : group.types) {
            if (this.matches(type)) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<DiagnosticType> getTypes() {
        return this.types;
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.name == null ? super.toString() : "DiagnosticGroup<" + this.name + ">";
    }
}

