/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class DisambiguateProperties
implements CompilerPass {
    private static final int MAX_INVALIDATION_WARNINGS_PER_PROPERTY = 10;
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    private static final Pattern NONWORD_PATTERN = Pattern.compile("[^\\w$]");
    private final AbstractCompiler compiler;
    private final InvalidatingTypes invalidatingTypes;
    private final TypeIRegistry registry;
    private final ObjectTypeI BOTTOM_OBJECT;
    private final Multimap<TypeI, Supplier<JSError>> invalidationMap;
    private final Map<String, CheckLevel> propertiesToErrorFor;
    private Map<FunctionTypeI, Iterable<ObjectTypeI>> ancestorInterfaces;
    private Map<String, IdentityHashMap<TypeI, ObjectTypeI>> gtwpCache;
    private final Map<String, Property> properties = new LinkedHashMap<String, Property>();

    private ObjectTypeI gtwpCacheGet(String field, TypeI type) {
        IdentityHashMap<TypeI, ObjectTypeI> m = this.gtwpCache.get(field);
        return m == null ? null : m.get(type);
    }

    private void gtwpCachePut(String field, TypeI type, ObjectTypeI top) {
        IdentityHashMap<TypeI, ObjectTypeI> m = this.gtwpCache.get(field);
        if (m == null) {
            m = new IdentityHashMap();
            this.gtwpCache.put(field, m);
        }
        Preconditions.checkState((null == m.put(type, top) ? 1 : 0) != 0);
    }

    DisambiguateProperties(AbstractCompiler compiler, Map<String, CheckLevel> propertiesToErrorFor) {
        this.compiler = compiler;
        this.registry = compiler.getTypeIRegistry();
        this.BOTTOM_OBJECT = this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE).toMaybeObjectType();
        this.propertiesToErrorFor = propertiesToErrorFor;
        this.invalidationMap = propertiesToErrorFor.isEmpty() ? null : LinkedHashMultimap.create();
        this.invalidatingTypes = new InvalidatingTypes.Builder(this.registry).recordInvalidations(this.invalidationMap).addTypesInvalidForPropertyRenaming().addAllTypeMismatches(compiler.getTypeMismatches()).addAllTypeMismatches(compiler.getImplicitInterfaceUses()).allowEnumsAndScalars().build();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED ? 1 : 0) != 0);
        this.ancestorInterfaces = new HashMap<FunctionTypeI, Iterable<ObjectTypeI>>();
        this.gtwpCache = new HashMap<String, IdentityHashMap<TypeI, ObjectTypeI>>();
        NodeTraversal.traverseEs6(this.compiler, externs, new FindExternProperties());
        NodeTraversal.traverseEs6(this.compiler, root, new FindRenameableProperties());
        this.renameProperties();
    }

    protected Property getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, new Property(name));
        }
        return this.properties.get(name);
    }

    void renameProperties() {
        int propsRenamed = 0;
        int propsSkipped = 0;
        int instancesRenamed = 0;
        int instancesSkipped = 0;
        int singleTypeProps = 0;
        HashSet<String> reported = new HashSet<String>();
        for (Property prop : this.properties.values()) {
            if (prop.shouldRename()) {
                UnionFind<TypeI> pTypes = prop.getTypes();
                Map<TypeI, String> propNames = this.buildPropNames(prop);
                ++propsRenamed;
                prop.expandTypesToSkip();
                for (Map.Entry<Node, TypeI> entry : prop.rootTypesByNode.entrySet()) {
                    Node node = entry.getKey();
                    TypeI rootType = entry.getValue();
                    if (prop.shouldRename(rootType)) {
                        String newName = propNames.get(pTypes.find(rootType));
                        node.setString(newName);
                        this.compiler.reportChangeToEnclosingScope(node);
                        ++instancesRenamed;
                        continue;
                    }
                    ++instancesSkipped;
                    CheckLevel checkLevelForProp = this.propertiesToErrorFor.get(prop.name);
                    if (checkLevelForProp == null || checkLevelForProp == CheckLevel.OFF || reported.contains(prop.name)) continue;
                    reported.add(prop.name);
                    this.compiler.report(JSError.make(node, checkLevelForProp, Warnings.INVALIDATION_ON_TYPE, prop.name, rootType.toString(), ""));
                }
                continue;
            }
            if (prop.skipRenaming) {
                ++propsSkipped;
                continue;
            }
            ++singleTypeProps;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Renamed " + instancesRenamed + " instances of " + propsRenamed + " properties.");
            logger.fine("Skipped renaming " + instancesSkipped + " invalidated properties, " + propsSkipped + " instances of properties that were skipped for specific types and " + singleTypeProps + " properties that were referenced from only one type.");
        }
    }

    private Map<TypeI, String> buildPropNames(Property prop) {
        UnionFind<TypeI> pTypes = prop.getTypes();
        String pname = prop.name;
        HashMap<TypeI, String> names = new HashMap<TypeI, String>();
        for (Set<TypeI> set : pTypes.allEquivalenceClasses()) {
            Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
            TypeI representative = pTypes.find(set.iterator().next());
            String typeName = null;
            for (TypeI type : set) {
                String typeString = type.toString();
                if (typeName != null && typeString.compareTo(typeName) >= 0) continue;
                typeName = typeString;
            }
            String newName = "{...}".equals(typeName) ? pname : NONWORD_PATTERN.matcher(typeName).replaceAll("_") + '$' + pname;
            names.put(representative, newName);
        }
        return names;
    }

    @VisibleForTesting
    Multimap<String, Collection<TypeI>> getRenamedTypesForTesting() {
        HashMultimap ret = HashMultimap.create();
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property prop = entry.getValue();
            if (prop.skipRenaming) continue;
            for (Collection collection : prop.getTypes().allEquivalenceClasses()) {
                if (collection.isEmpty() || prop.typesToSkip.contains(collection.iterator().next())) continue;
                ret.put((Object)entry.getKey(), (Object)collection);
            }
        }
        return ret;
    }

    private TypeI getType(Node node) {
        if (node == null || node.getTypeI() == null) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return node.getTypeI();
    }

    private ImmutableSet<TypeI> getTypesToSkipForType(TypeI type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            ImmutableSet.Builder types = ImmutableSet.builder();
            types.add((Object)type);
            for (TypeI typeI : type.getUnionMembers()) {
                types.addAll(this.getTypesToSkipForTypeNonUnion(typeI));
            }
            return types.build();
        }
        if (type.isEnumElement()) {
            return this.getTypesToSkipForType(type.getEnumeratedTypeOfEnumElement());
        }
        return ImmutableSet.copyOf(this.getTypesToSkipForTypeNonUnion(type));
    }

    private Set<TypeI> getTypesToSkipForTypeNonUnion(TypeI type) {
        HashSet<TypeI> types = new HashSet<TypeI>();
        TypeI skipType = type;
        while (skipType != null) {
            types.add(skipType);
            ObjectTypeI objSkipType = skipType.toMaybeObjectType();
            if (objSkipType == null) break;
            skipType = objSkipType.getPrototypeObject();
        }
        return types;
    }

    private boolean isTypeToSkip(TypeI type) {
        return type.isEnumObject() || type.isBoxableScalar();
    }

    private Iterable<? extends TypeI> getTypeAlternatives(TypeI type) {
        FunctionTypeI constructor;
        if (type.isUnionType()) {
            return type.getUnionMembers();
        }
        ObjectTypeI objType = type.toMaybeObjectType();
        FunctionTypeI functionTypeI = constructor = objType != null ? objType.getConstructor() : null;
        if (constructor != null && constructor.isInterface()) {
            ArrayList<ObjectTypeI> list = new ArrayList<ObjectTypeI>();
            for (FunctionTypeI impl : constructor.getDirectSubTypes()) {
                list.add(impl.getInstanceType());
            }
            return list.isEmpty() ? null : list;
        }
        return null;
    }

    private ObjectTypeI getTypeWithProperty(String field, TypeI type) {
        if (type == null) {
            return null;
        }
        ObjectTypeI foundType = this.gtwpCacheGet(field, type);
        if (foundType != null) {
            return foundType.equals(this.BOTTOM_OBJECT) ? null : foundType;
        }
        if (type.isEnumElement()) {
            foundType = this.getTypeWithProperty(field, type.getEnumeratedTypeOfEnumElement());
            this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
            return foundType;
        }
        if (!type.isObjectType()) {
            if (type.isBoxableScalar()) {
                foundType = this.getTypeWithProperty(field, type.autobox());
                this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
                return foundType;
            }
            this.gtwpCachePut(field, type, this.BOTTOM_OBJECT);
            return null;
        }
        if ("prototype".equals(field)) {
            this.gtwpCachePut(field, type, this.BOTTOM_OBJECT);
            return null;
        }
        ObjectTypeI objType = type.toMaybeObjectType();
        if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
            ObjectTypeI topInterface = objType.getTopDefiningInterface(field);
            if (topInterface != null && topInterface.getConstructor() != null) {
                foundType = topInterface.getPrototypeObject();
            }
        } else {
            while (objType != null && !Objects.equals(objType.getPrototypeObject(), objType)) {
                if (objType.hasOwnProperty(field)) {
                    foundType = objType;
                }
                objType = objType.getPrototypeObject();
            }
        }
        if (foundType == null) {
            ObjectTypeI maybeType;
            TypeI subtypeWithProp = type.getGreatestSubtypeWithProperty(field);
            ObjectTypeI objectTypeI = maybeType = subtypeWithProp == null ? null : subtypeWithProp.toMaybeObjectType();
            if (maybeType != null && maybeType.hasOwnProperty(field)) {
                foundType = maybeType;
            }
        }
        if (foundType != null && foundType.isGenericObjectType()) {
            foundType = foundType.getRawType();
        }
        if (foundType != null && foundType.isLegacyNamedType()) {
            foundType = foundType.getLegacyResolvedType().toMaybeObjectType();
        }
        this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
        return foundType;
    }

    private TypeI getInstanceFromPrototype(Node n) {
        FunctionTypeI f;
        if (n.isGetProp() && n.getLastChild().getString().equals("prototype") && (f = n.getFirstChild().getTypeI().toMaybeFunctionType()) != null && f.hasInstanceType()) {
            return f.getInstanceType();
        }
        return null;
    }

    private void recordInterfaces(FunctionTypeI constructor, TypeI relatedType, Property p) {
        Iterable<ObjectTypeI> interfaces = this.ancestorInterfaces.get(constructor);
        if (interfaces == null) {
            interfaces = constructor.getAncestorInterfaces();
            this.ancestorInterfaces.put(constructor, interfaces);
        }
        for (ObjectTypeI itype : interfaces) {
            ObjectTypeI top = this.getTypeWithProperty(p.name, itype);
            if (top != null) {
                p.addType(itype, relatedType);
            }
            if (!p.skipRenaming) continue;
            return;
        }
    }

    private FunctionTypeI getConstructor(TypeI type) {
        ObjectTypeI objType = type.toMaybeObjectType();
        if (objType == null) {
            return null;
        }
        FunctionTypeI constructor = null;
        constructor = objType.isFunctionType() ? objType.toMaybeFunctionType() : (objType.isPrototypeObject() ? objType.getOwnerFunction() : objType.getConstructor());
        return constructor;
    }

    private class FindRenameableProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindRenameableProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                this.handleGetProp(t, n);
            } else if (n.isObjectLit()) {
                this.handleObjectLit(t, n);
            } else if (n.isCall()) {
                this.handleCall(t, n);
            }
        }

        private void handleGetProp(NodeTraversal t, Node n) {
            String name = n.getLastChild().getString();
            TypeI type = DisambiguateProperties.this.getType(n.getFirstChild());
            Property prop = DisambiguateProperties.this.getProperty(name);
            if (!prop.scheduleRenaming(n.getLastChild(), this.processProperty(t, prop, type, null)) && DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) {
                String suggestion = "";
                if (type.isTop() || type.isUnknownType()) {
                    if (n.getFirstChild().isThis()) {
                        suggestion = "The \"this\" object is unknown in the function, consider using @this";
                    } else {
                        String qName = n.getFirstChild().getQualifiedName();
                        suggestion = "Consider casting " + qName + " if you know its type.";
                    }
                } else {
                    ArrayList<String> errors = new ArrayList<String>();
                    this.printErrorLocations(errors, type);
                    if (!errors.isEmpty()) {
                        suggestion = "Consider fixing errors for the following types:\n";
                        suggestion = suggestion + Joiner.on((String)"\n").join(errors);
                    }
                }
                DisambiguateProperties.this.compiler.report(JSError.make(n, (CheckLevel)DisambiguateProperties.this.propertiesToErrorFor.get(name), Warnings.INVALIDATION, name, String.valueOf(type), n.toString(), suggestion));
            }
        }

        private void handleObjectLit(NodeTraversal t, Node n) {
            if (n.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(n.getParent())) {
                return;
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                if (child.isQuotedString()) continue;
                String name = child.getString();
                TypeI objlitType = DisambiguateProperties.this.getType(n);
                Property prop = DisambiguateProperties.this.getProperty(name);
                if (prop.scheduleRenaming(child, this.processProperty(t, prop, objlitType, null)) || !DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) continue;
                DisambiguateProperties.this.compiler.report(JSError.make(child, (CheckLevel)DisambiguateProperties.this.propertiesToErrorFor.get(name), Warnings.INVALIDATION, name, String.valueOf(objlitType), n.toString(), ""));
            }
        }

        private void handleCall(NodeTraversal t, Node call) {
            Node target = call.getFirstChild();
            if (!target.isQualifiedName()) {
                return;
            }
            String functionName = target.getOriginalQualifiedName();
            if (functionName != null && DisambiguateProperties.this.compiler.getCodingConvention().isPropertyRenameFunction(functionName)) {
                this.handlePropertyRenameFunctionCall(t, call, functionName);
            } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
                this.handleObjectDefineProperties(t, call);
            }
        }

        private void handlePropertyRenameFunctionCall(NodeTraversal t, Node call, String renameFunctionName) {
            int childCount = call.getChildCount();
            if (childCount != 2 && childCount != 3) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " Must be called with 1 or 2 arguments"));
                return;
            }
            if (!call.getSecondChild().isString()) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must be a string literal."));
                return;
            }
            String propName = call.getSecondChild().getString();
            if (propName.contains(".")) {
                DisambiguateProperties.this.compiler.report(JSError.make(call, Warnings.INVALID_RENAME_FUNCTION, renameFunctionName, " The first argument must not be a property path."));
                return;
            }
            Node obj = call.getChildAtIndex(2);
            TypeI type = DisambiguateProperties.this.getType(obj);
            Property prop = DisambiguateProperties.this.getProperty(propName);
            if (!prop.scheduleRenaming(call.getSecondChild(), this.processProperty(t, prop, type, null)) && DisambiguateProperties.this.propertiesToErrorFor.containsKey(propName)) {
                String suggestion = "";
                if (type.isTop() || type.isUnknownType()) {
                    if (obj.isThis()) {
                        suggestion = "The \"this\" object is unknown in the function, consider using @this";
                    } else {
                        String qName = obj.getQualifiedName();
                        suggestion = "Consider casting " + qName + " if you know its type.";
                    }
                } else {
                    ArrayList<String> errors = new ArrayList<String>();
                    this.printErrorLocations(errors, type);
                    if (!errors.isEmpty()) {
                        suggestion = "Consider fixing errors for the following types:\n";
                        suggestion = suggestion + Joiner.on((String)"\n").join(errors);
                    }
                }
                DisambiguateProperties.this.compiler.report(JSError.make(call, (CheckLevel)DisambiguateProperties.this.propertiesToErrorFor.get(propName), Warnings.INVALIDATION, propName, String.valueOf(type), renameFunctionName, suggestion));
            }
        }

        private void handleObjectDefineProperties(NodeTraversal t, Node call) {
            Node typeObj = call.getSecondChild();
            TypeI type = DisambiguateProperties.this.getType(typeObj);
            Node objectLiteral = typeObj.getNext();
            if (!objectLiteral.isObjectLit()) {
                return;
            }
            for (Node key : objectLiteral.children()) {
                if (key.isQuotedString()) continue;
                String propName = key.getString();
                Property prop = DisambiguateProperties.this.getProperty(propName);
                prop.scheduleRenaming(key, this.processProperty(t, prop, type, null));
            }
        }

        private void printErrorLocations(List<String> errors, TypeI t) {
            if (!t.isObjectType() || t.isTop()) {
                return;
            }
            if (t.isUnionType()) {
                for (TypeI typeI : t.getUnionMembers()) {
                    this.printErrorLocations(errors, typeI);
                }
                return;
            }
            FluentIterable invalidations = FluentIterable.from((Iterable)DisambiguateProperties.this.invalidationMap.get((Object)t)).transform(Suppliers.supplierFunction()).limit(10);
            for (JSError error : invalidations) {
                errors.add(t + " at " + error.sourceName + ":" + error.lineNumber);
            }
        }

        private TypeI processProperty(NodeTraversal t, Property prop, TypeI type, TypeI relatedType) {
            Iterable alternatives;
            type = type.restrictByNotNullOrUndefined();
            if (prop.skipRenaming || DisambiguateProperties.this.invalidatingTypes.isInvalidating(type)) {
                return null;
            }
            ObjectTypeI maybeObj = type.toMaybeObjectType();
            if (maybeObj != null) {
                type = maybeObj.withoutStrayProperties();
            }
            if ((alternatives = DisambiguateProperties.this.getTypeAlternatives(type)) != null) {
                TypeI firstType = relatedType;
                for (TypeI subType : alternatives) {
                    TypeI lastType = this.processProperty(t, prop, subType, firstType);
                    if (lastType == null) continue;
                    firstType = firstType == null ? lastType : firstType;
                }
                return firstType;
            }
            ObjectTypeI topType = DisambiguateProperties.this.getTypeWithProperty(prop.name, type);
            if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(topType)) {
                return null;
            }
            prop.addType(type, relatedType);
            return topType;
        }
    }

    private class FindExternProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                Node recv = n.getFirstChild();
                TypeI recvType = DisambiguateProperties.this.getType(recv);
                Property prop = DisambiguateProperties.this.getProperty(n.getLastChild().getString());
                if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(recvType) || this.isStructuralInterfacePrototype(recv)) {
                    prop.invalidate();
                } else if (!prop.skipRenaming) {
                    prop.addTypeToSkip(recvType);
                    recvType = DisambiguateProperties.this.getInstanceFromPrototype(recv);
                    if (recvType != null) {
                        prop.getTypes().add(recvType);
                        prop.typesToSkip.add(recvType);
                    }
                }
            }
        }

        private boolean isStructuralInterfacePrototype(Node n) {
            return n.isGetProp() && n.getLastChild().getString().equals("prototype") && n.getFirstChild().getTypeI().isStructuralInterface();
        }
    }

    private class Property {
        final String name;
        private UnionFind<TypeI> types;
        Set<TypeI> typesToSkip = new HashSet<TypeI>();
        boolean skipRenaming;
        Map<Node, TypeI> rootTypesByNode = new HashMap<Node, TypeI>();
        private final Set<TypeI> recordInterfacesCache = new HashSet<TypeI>();

        Property(String name) {
            this.name = name;
        }

        UnionFind<TypeI> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind<TypeI>();
            }
            return this.types;
        }

        void addType(TypeI type, TypeI relatedType) {
            Preconditions.checkState((!this.skipRenaming ? 1 : 0) != 0, (String)"Attempt to record skipped property: %s", (Object)this.name);
            ObjectTypeI top = DisambiguateProperties.this.getTypeWithProperty(this.name, type);
            if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(top)) {
                this.invalidate();
                return;
            }
            if (DisambiguateProperties.this.isTypeToSkip(top)) {
                this.addTypeToSkip(top);
            }
            if (relatedType == null) {
                this.getTypes().add(top);
            } else {
                this.getTypes().union(top, relatedType);
            }
            FunctionTypeI constructor = DisambiguateProperties.this.getConstructor(type);
            if (constructor != null && this.recordInterfacesCache.add(type)) {
                DisambiguateProperties.this.recordInterfaces(constructor, top, this);
            }
        }

        void addTypeToSkip(TypeI type) {
            for (TypeI skipType : DisambiguateProperties.this.getTypesToSkipForType(type)) {
                this.typesToSkip.add(skipType);
                this.getTypes().union(skipType, type);
            }
        }

        void expandTypesToSkip() {
            block4: {
                int originalTypesSize;
                if (!this.shouldRename()) break block4;
                int count = 0;
                do {
                    Preconditions.checkState((++count < 10 ? 1 : 0) != 0, (Object)"Stuck in loop expanding types to skip.");
                    HashSet<TypeI> rootTypesToSkip = new HashSet<TypeI>();
                    for (TypeI subType : this.typesToSkip) {
                        rootTypesToSkip.add(this.types.find(subType));
                    }
                    this.typesToSkip.addAll(rootTypesToSkip);
                    HashSet<TypeI> newTypesToSkip = new HashSet<TypeI>();
                    Set<TypeI> allTypes = this.types.elements();
                    originalTypesSize = allTypes.size();
                    for (TypeI subType : allTypes) {
                        if (this.typesToSkip.contains(subType) || !this.typesToSkip.contains(this.types.find(subType))) continue;
                        newTypesToSkip.add(subType);
                    }
                    for (TypeI newType : newTypesToSkip) {
                        this.addTypeToSkip(newType);
                    }
                } while (this.types.elements().size() != originalTypesSize);
            }
        }

        boolean shouldRename() {
            return !this.skipRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRename(TypeI type) {
            return !this.skipRenaming && !this.typesToSkip.contains(type);
        }

        boolean invalidate() {
            boolean changed = !this.skipRenaming;
            this.skipRenaming = true;
            this.types = null;
            this.typesToSkip = null;
            this.rootTypesByNode = null;
            return changed;
        }

        boolean scheduleRenaming(Node node, TypeI type) {
            if (!this.skipRenaming) {
                if (DisambiguateProperties.this.invalidatingTypes.isInvalidating(type)) {
                    this.invalidate();
                    return false;
                }
                this.rootTypesByNode.put(node, type);
            }
            return true;
        }
    }

    static class Warnings {
        static final DiagnosticType INVALIDATION = DiagnosticType.disabled("JSC_INVALIDATION", "Property disambiguator skipping all instances of property {0} because of type {1} node {2}. {3}");
        static final DiagnosticType INVALIDATION_ON_TYPE = DiagnosticType.disabled("JSC_INVALIDATION_TYPE", "Property disambiguator skipping instances of property {0} on type {1}. {2}");
        static final DiagnosticType INVALID_RENAME_FUNCTION = DiagnosticType.error("JSC_INVALID_RENAME_FUNCTION", "{0} call is invalid: {1}");

        Warnings() {
        }
    }
}

