/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;

public final class EarlyEs6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType BAD_REST_PARAMETER_ANNOTATION = DiagnosticType.warning("BAD_REST_PARAMETER_ANNOTATION", "Missing \"...\" in type annotation for rest parameter.");
    private static final String REST_INDEX = "$jscomp$restIndex";
    private static final String REST_PARAMS = "$jscomp$restParams";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private static final FeatureSet requiredForFeatures = FeatureSet.ES6.without(FeatureSet.ES5);
    private static final FeatureSet featuresTranspiledAway = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ARRAY_PATTERN_REST, FeatureSet.Feature.REST_PARAMETERS, FeatureSet.Feature.SPREAD_EXPRESSIONS);

    public EarlyEs6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, requiredForFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, requiredForFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, featuresTranspiledAway);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, requiredForFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, featuresTranspiledAway);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case REST: {
                this.visitRestParam(t, n, parent);
                break;
            }
            case FOR_OF: {
                Es6ToEs3Util.preloadEs6RuntimeFunction(this.compiler, "makeIterator");
                break;
            }
            case GETTER_DEF: 
            case SETTER_DEF: {
                if (this.compiler.getOptions().getLanguageOut() != CompilerOptions.LanguageMode.ECMASCRIPT3) break;
                Es6ToEs3Util.cannotConvert(this.compiler, n, "ES5 getters/setters (consider using --language_out=ES5)");
                return false;
            }
            case FUNCTION: {
                if (n.isAsyncFunction()) {
                    throw new IllegalStateException("async functions should have already been converted");
                }
                if (!n.isGeneratorFunction()) break;
                this.compiler.ensureLibraryInjected("es6/generator_engine", false);
                break;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getToken()) {
            case NAME: {
                if (n.isFromExterns() || !this.isGlobalSymbol(t, n)) break;
                this.initSymbolBefore(n);
                break;
            }
            case GETPROP: {
                if (n.isFromExterns()) break;
                this.visitGetprop(t, n);
                break;
            }
            case ARRAYLIT: 
            case NEW: 
            case CALL: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
        }
    }

    private boolean isGlobalSymbol(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol")) {
            return false;
        }
        Var var = (Var)t.getScope().getVar("Symbol");
        return var == null || var.isGlobal();
    }

    private void initSymbolBefore(Node n) {
        this.compiler.ensureLibraryInjected("es6/symbol", false);
        Node statement = NodeUtil.getEnclosingStatement(n);
        Node initSymbol = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbol"), new Node[0]));
        statement.getParent().addChildBefore(initSymbol.useSourceInfoFromForTree(statement), statement);
        this.compiler.reportChangeToEnclosingScope(initSymbol);
    }

    private void visitGetprop(NodeTraversal t, Node n) {
        if (!n.matchesQualifiedName("Symbol.iterator")) {
            return;
        }
        if (this.isGlobalSymbol(t, n.getFirstChild())) {
            this.compiler.ensureLibraryInjected("es6/symbol", false);
            Node statement = NodeUtil.getEnclosingStatement(n);
            Node init = IR.exprResult(IR.call(NodeUtil.newQName(this.compiler, "$jscomp.initSymbolIterator"), new Node[0]));
            statement.getParent().addChildBefore(init.useSourceInfoFromForTree(statement), statement);
            this.compiler.reportChangeToEnclosingScope(init);
        }
    }

    private void visitRestParam(NodeTraversal t, Node restParam, Node paramList) {
        Node functionBody = paramList.getNext();
        int restIndex = paramList.getIndexOfChild(restParam);
        String paramName = restParam.getFirstChild().getString();
        Node nameNode = IR.name(paramName);
        nameNode.setVarArgs(true);
        nameNode.setJSDocInfo(restParam.getJSDocInfo());
        paramList.replaceChild(restParam, nameNode);
        JSTypeExpression type = null;
        JSDocInfo info = restParam.getJSDocInfo();
        JSDocInfo functionInfo = NodeUtil.getBestJSDocInfo(paramList.getParent());
        if (info != null) {
            type = info.getType();
        } else if (functionInfo != null) {
            type = functionInfo.getParameterType(paramName);
        }
        if (type != null && type.getRoot().getToken() != Token.ELLIPSIS) {
            this.compiler.report(JSError.make(restParam, BAD_REST_PARAMETER_ANNOTATION, new String[0]));
        }
        if (!functionBody.hasChildren()) {
            t.reportCodeChange();
            return;
        }
        Node newBlock = IR.block().useSourceInfoFrom(functionBody);
        Node name = IR.name(paramName);
        Node let = IR.let(name, IR.name(REST_PARAMS)).useSourceInfoIfMissingFromForTree(functionBody);
        newBlock.addChildToFront(let);
        for (Node child : functionBody.children()) {
            newBlock.addChildToBack(child.detach());
        }
        if (type != null) {
            Node memberType;
            Node arrayType = IR.string("Array");
            Node typeNode = type.getRoot();
            Node node = memberType = typeNode.getToken() == Token.ELLIPSIS ? typeNode.getFirstChild().cloneTree() : typeNode.cloneTree();
            if (functionInfo != null) {
                memberType = this.replaceTypeVariablesWithUnknown(functionInfo, memberType);
            }
            arrayType.addChildToFront(new Node(Token.BLOCK, memberType).useSourceInfoIfMissingFrom(typeNode));
            JSDocInfoBuilder builder = new JSDocInfoBuilder(false);
            builder.recordType(new JSTypeExpression(new Node(Token.BANG, arrayType), restParam.getSourceFileName()));
            name.setJSDocInfo(builder.build());
        }
        Node newArr = IR.var(IR.name(REST_PARAMS), IR.arraylit(new Node[0]));
        functionBody.addChildToFront(newArr.useSourceInfoIfMissingFromForTree(restParam));
        Node init = IR.var(IR.name(REST_INDEX), IR.number(restIndex));
        Node cond = IR.lt(IR.name(REST_INDEX), IR.getprop(IR.name("arguments"), IR.string("length")));
        Node incr = IR.inc(IR.name(REST_INDEX), false);
        Node body = IR.block(IR.exprResult(IR.assign(IR.getelem(IR.name(REST_PARAMS), IR.sub(IR.name(REST_INDEX), IR.number(restIndex))), IR.getelem(IR.name("arguments"), IR.name(REST_INDEX)))));
        functionBody.addChildAfter(IR.forNode(init, cond, incr, body).useSourceInfoIfMissingFromForTree(restParam), newArr);
        functionBody.addChildToBack(newBlock);
        this.compiler.reportChangeToEnclosingScope(newBlock);
    }

    private Node replaceTypeVariablesWithUnknown(JSDocInfo functionJsdoc, Node typeAst) {
        ImmutableList<String> typeVars = functionJsdoc.getTemplateTypeNames();
        if (typeVars.isEmpty()) {
            return typeAst;
        }
        NodeUtil.visitPreOrder(typeAst, new NodeUtil.Visitor((List)typeVars){
            final /* synthetic */ List val$typeVars;
            {
                this.val$typeVars = list;
            }

            @Override
            public void visit(Node n) {
                if (n.isString() && n.getParent() != null && this.val$typeVars.contains(n.getString())) {
                    n.replaceWith(new Node(Token.QMARK));
                }
            }
        });
        return typeAst;
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        if (node.isArrayLit()) {
            this.visitArrayLitWithSpread(node, parent);
        } else if (node.isCall()) {
            this.visitCallWithSpread(node, parent);
        } else {
            Preconditions.checkArgument((boolean)node.isNew(), (Object)node);
            this.visitNewWithSpread(node, parent);
        }
    }

    private List<Node> extractSpreadGroups(Node parentNode) {
        Preconditions.checkArgument((parentNode.isCall() || parentNode.isArrayLit() || parentNode.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node currElement = parentNode.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                Node spreadExpression = currElement.removeFirstChild();
                if (spreadExpression.isArrayLit()) {
                    if (currGroup == null) {
                        currGroup = spreadExpression;
                    } else {
                        currGroup.addChildrenToBack(spreadExpression.removeChildren());
                    }
                } else {
                    if (currGroup != null) {
                        groups.add(currGroup);
                        currGroup = null;
                    }
                    groups.add(Es6ToEs3Util.arrayFromIterable(this.compiler, spreadExpression));
                }
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = parentNode.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        return groups;
    }

    private void visitArrayLitWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((boolean)node.isArrayLit());
        List<Node> groups = this.extractSpreadGroups(node);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : IR.arraylit(new Node[0]);
        Node joinedGroups = groups.isEmpty() ? baseArrayLit : IR.call(IR.getprop(baseArrayLit, IR.string("concat")), groups.toArray(new Node[0]));
        joinedGroups.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, joinedGroups);
        this.compiler.reportChangeToEnclosingScope(joinedGroups);
    }

    private void visitCallWithSpread(Node node, Node parent) {
        Node joinedGroups;
        Preconditions.checkArgument((boolean)node.isCall());
        Node callee = node.removeFirstChild();
        if (node.hasOneChild() && this.isSpreadOfArguments(node.getOnlyChild())) {
            joinedGroups = node.removeFirstChild().removeFirstChild();
        } else {
            List<Node> groups = this.extractSpreadGroups(node);
            Preconditions.checkState((!groups.isEmpty() ? 1 : 0) != 0);
            if (groups.size() == 1) {
                joinedGroups = groups.remove(0);
            } else {
                Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : IR.arraylit(new Node[0]);
                joinedGroups = groups.isEmpty() ? baseArrayLit : IR.call(IR.getprop(baseArrayLit, IR.string("concat")), groups.toArray(new Node[0]));
            }
        }
        Node result = null;
        if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
            Node statement = node;
            while (!NodeUtil.isStatement(statement)) {
                statement = statement.getParent();
            }
            Node freshVar = IR.name(FRESH_SPREAD_VAR + (String)this.compiler.getUniqueNameIdSupplier().get());
            Node n = IR.var(freshVar.cloneTree());
            n.useSourceInfoIfMissingFromForTree(statement);
            statement.getParent().addChildBefore(n, statement);
            callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
            result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
        } else {
            Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
            result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportChangeToEnclosingScope(result);
    }

    private boolean isSpreadOfArguments(Node n) {
        return n.isSpread() && n.getOnlyChild().matchesQualifiedName("arguments");
    }

    private void visitNewWithSpread(Node node, Node parent) {
        Node joinedGroups;
        Preconditions.checkArgument((boolean)node.isNew());
        Node callee = node.removeFirstChild();
        List<Node> groups = this.extractSpreadGroups(node);
        Node baseArrayLit = groups.get(0).isArrayLit() ? groups.remove(0) : IR.arraylit(new Node[0]);
        baseArrayLit.addChildToFront(IR.nullNode());
        Node node2 = joinedGroups = groups.isEmpty() ? baseArrayLit : IR.call(IR.getprop(baseArrayLit, IR.string("concat")), groups.toArray(new Node[0]));
        if (this.compiler.getOptions().getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3) {
            Es6ToEs3Util.cannotConvert(this.compiler, node, "\"...\" passed to a constructor (consider using --language_out=ES5)");
        }
        Node bindApply = NodeUtil.newQName(this.compiler, "Function.prototype.bind.apply");
        Node result = IR.newNode(IR.call(bindApply, callee, joinedGroups), new Node[0]);
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportChangeToEnclosingScope(result);
    }
}

