/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayDeque;
import java.util.Deque;

public class Es6RewriteArrowFunction
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final String ARGUMENTS_VAR = "$jscomp$arguments";
    static final String THIS_VAR = "$jscomp$this";
    private final AbstractCompiler compiler;
    private final Deque<ThisContext> thisContextStack;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ARROW_FUNCTIONS);

    public Es6RewriteArrowFunction(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.thisContextStack = new ArrayDeque<ThisContext>();
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                this.thisContextStack.push(ThisContext.forScript(n));
                break;
            }
            case FUNCTION: {
                if (n.isArrowFunction()) break;
                this.thisContextStack.push(ThisContext.forFunction(n, parent));
                break;
            }
            case SUPER: {
                ThisContext thisContext = (ThisContext)Preconditions.checkNotNull((Object)this.thisContextStack.peek());
                if (!thisContext.isConstructor || !parent.isCall() || parent.getFirstChild() != n) break;
                thisContext.lastSuperStatement = this.getEnclosingStatement(parent, thisContext.scopeBody);
                break;
            }
        }
        return true;
    }

    private Node getEnclosingStatement(Node n, Node block) {
        while (Preconditions.checkNotNull((Object)n.getParent()) != block) {
            n = (Node)Preconditions.checkNotNull((Object)NodeUtil.getEnclosingStatement(n.getParent()));
        }
        return n;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        ThisContext thisContext = this.thisContextStack.peek();
        if (n.isArrowFunction()) {
            this.visitArrowFunction(t, n, (ThisContext)Preconditions.checkNotNull((Object)thisContext));
        } else if (thisContext != null && thisContext.scopeBody == n) {
            this.thisContextStack.pop();
            this.addVarDecls(thisContext);
        }
    }

    private void visitArrowFunction(NodeTraversal t, Node n, ThisContext thisContext) {
        n.setIsArrowFunction(false);
        n.makeNonIndexable();
        Node body = n.getLastChild();
        if (!body.isNormalBlock()) {
            body.detach();
            body = IR.block(IR.returnNode(body)).useSourceInfoIfMissingFromForTree(body);
            n.addChildToBack(body);
        }
        UpdateThisAndArgumentsReferences updater = new UpdateThisAndArgumentsReferences(this.compiler);
        NodeTraversal.traverseEs6(this.compiler, body, updater);
        thisContext.needsThisVar = thisContext.needsThisVar || updater.changedThis;
        thisContext.needsArgumentsVar = thisContext.needsArgumentsVar || updater.changedArguments;
        t.reportCodeChange();
    }

    private void addVarDecls(ThisContext thisContext) {
        Node name;
        Node scopeBody = thisContext.scopeBody;
        if (thisContext.needsArgumentsVar) {
            name = IR.name(ARGUMENTS_VAR);
            Node argumentsVar = IR.constNode(name, IR.name("arguments"));
            JSDocInfoBuilder jsdoc = new JSDocInfoBuilder(false);
            jsdoc.recordType(new JSTypeExpression(new Node(Token.BANG, IR.string("Arguments")), "<Es6RewriteArrowFunction>"));
            argumentsVar.setJSDocInfo(jsdoc.build());
            argumentsVar.useSourceInfoIfMissingFromForTree(scopeBody);
            scopeBody.addChildToFront(argumentsVar);
            this.compiler.reportChangeToEnclosingScope(argumentsVar);
        }
        if (thisContext.needsThisVar) {
            name = IR.name(THIS_VAR);
            Node thisVar = IR.constNode(name, IR.thisNode());
            thisVar.useSourceInfoIfMissingFromForTree(scopeBody);
            this.makeTreeNonIndexable(thisVar);
            if (thisContext.lastSuperStatement == null) {
                scopeBody.addChildToFront(thisVar);
            } else {
                scopeBody.addChildAfter(thisVar, thisContext.lastSuperStatement);
            }
            this.compiler.reportChangeToEnclosingScope(thisVar);
        }
    }

    private void makeTreeNonIndexable(Node n) {
        n.makeNonIndexable();
        for (Node child : n.children()) {
            this.makeTreeNonIndexable(child);
        }
    }

    private static class UpdateThisAndArgumentsReferences
    implements NodeTraversal.Callback {
        private boolean changedThis = false;
        private boolean changedArguments = false;
        private final AbstractCompiler compiler;

        public UpdateThisAndArgumentsReferences(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                Node name = IR.name(Es6RewriteArrowFunction.THIS_VAR).srcref(n);
                name.makeNonIndexable();
                if (this.compiler.getOptions().preservesDetailedSourceInfo()) {
                    name.setOriginalName("this");
                }
                parent.replaceChild(n, name);
                this.changedThis = true;
            } else if (n.isName() && n.getString().equals("arguments")) {
                Node name = IR.name(Es6RewriteArrowFunction.ARGUMENTS_VAR).srcref(n);
                if (this.compiler.getOptions().preservesDetailedSourceInfo()) {
                    name.setOriginalName("arguments");
                }
                parent.replaceChild(n, name);
                this.changedArguments = true;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }

    private static class ThisContext {
        final Node scopeBody;
        final boolean isConstructor;
        Node lastSuperStatement = null;
        boolean needsThisVar = false;
        boolean needsArgumentsVar = false;

        ThisContext(Node scopeBody, boolean isConstructor) {
            this.scopeBody = scopeBody;
            this.isConstructor = isConstructor;
        }

        static ThisContext forFunction(Node functionNode, Node functionParent) {
            Node scopeBody = functionNode.getLastChild();
            boolean isConstructor = functionParent.isMemberFunctionDef() && functionParent.getString().equals("constructor");
            return new ThisContext(scopeBody, isConstructor);
        }

        static ThisContext forScript(Node scriptNode) {
            return new ThisContext(scriptNode, false);
        }
    }
}

