/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalTypeInfo;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NTIScope;
import com.google.javascript.jscomp.NewTypeInference;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SimpleInference;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionNamespace;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.NominalTypeBuilderNti;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.SimpleSourceFile;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class GlobalTypeInfoCollector
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_NTI_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType REDECLARED_PROPERTY = DiagnosticType.warning("JSC_NTI_REDECLARED_PROPERTY", "Found two declarations for property {0} on {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_NTI_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_NTI_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_NTI_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType STRUCT_WITHOUT_CTOR_OR_INTERF = DiagnosticType.warning("JSC_NTI_STRUCT_WITHOUT_CTOR_OR_INTERF", "@struct used without @constructor, @interface, or @record.");
    static final DiagnosticType DICT_WITHOUT_CTOR = DiagnosticType.warning("JSC_NTI_DICT_WITHOUT_CTOR", "@dict used without @constructor.");
    static final DiagnosticType EXPECTED_CONSTRUCTOR = DiagnosticType.warning("JSC_NTI_EXPECTED_CONSTRUCTOR", "Expected constructor name but found {0}.");
    static final DiagnosticType EXPECTED_INTERFACE = DiagnosticType.warning("JSC_NTI_EXPECTED_INTERFACE", "Expected interface name but found {0}.");
    static final DiagnosticType INEXISTENT_PARAM = DiagnosticType.warning("JSC_NTI_INEXISTENT_PARAM", "parameter {0} does not appear in {1}''s parameter list");
    static final DiagnosticType CONST_WITHOUT_INITIALIZER = DiagnosticType.warning("JSC_NTI_CONST_WITHOUT_INITIALIZER", "Constants must be initialized when they are defined.");
    static final DiagnosticType COULD_NOT_INFER_CONST_TYPE = DiagnosticType.warning("JSC_NTI_COULD_NOT_INFER_CONST_TYPE", "All constants must be typed. The compiler could not infer the type of constant {0}. Please use an explicit type annotation. For more information, see:\nhttps://github.com/google/closure-compiler/wiki/Using-NTI-(new-type-inference)#warnings-about-uninferred-constants");
    static final DiagnosticType MISPLACED_CONST_ANNOTATION = DiagnosticType.warning("JSC_NTI_MISPLACED_CONST_ANNOTATION", "This property cannot be @const. The @const annotation is only allowed for properties of namespaces, prototype properties, static properties of constructors, and properties of the form this.prop declared inside constructors and prototype methods.");
    static final DiagnosticType CANNOT_OVERRIDE_FINAL_METHOD = DiagnosticType.warning("JSC_NTI_CANNOT_OVERRIDE_FINAL_METHOD", "Final method {0} cannot be overriden.");
    static final DiagnosticType CANNOT_INIT_TYPEDEF = DiagnosticType.warning("JSC_NTI_CANNOT_INIT_TYPEDEF", "A typedef variable represents a type name; it cannot be assigned a value.");
    static final DiagnosticType ANONYMOUS_NOMINAL_TYPE = DiagnosticType.warning("JSC_NTI_ANONYMOUS_NOMINAL_TYPE", "Must specify a name when defining a class or interface.");
    static final DiagnosticType MALFORMED_ENUM = DiagnosticType.warning("JSC_NTI_MALFORMED_ENUM", "An enum must be initialized to a non-empty object literal.");
    static final DiagnosticType DUPLICATE_PROP_IN_ENUM = DiagnosticType.warning("JSC_NTI_DUPLICATE_PROP_IN_ENUM", "Property {0} appears twice in the enum declaration.");
    static final DiagnosticType LENDS_ON_BAD_TYPE = DiagnosticType.warning("JSC_NTI_LENDS_ON_BAD_TYPE", "May only lend properties to namespaces, constructors and their prototypes. Found {0}.");
    static final DiagnosticType INVALID_INTERFACE_PROP_INITIALIZER = DiagnosticType.warning("JSC_NTI_INVALID_INTERFACE_PROP_INITIALIZER", "Invalid initialization of interface property.");
    static final DiagnosticType SETTER_WITH_RETURN = DiagnosticType.warning("JSC_NTI_SETTER_WITH_RETURN", "Cannot declare a return type on a setter.");
    static final DiagnosticType WRONG_PARAMETER_COUNT = DiagnosticType.warning("JSC_NTI_WRONG_PARAMETER_COUNT", "Function definition does not have the declared number of parameters.\nExpected: {0}\nFound: {1}");
    static final DiagnosticType CANNOT_ADD_PROPERTIES_TO_TYPEDEF = DiagnosticType.warning("JSC_NTI_CANNOT_ADD_PROPERTIES_TO_TYPEDEF", "A typedef should only be used in type annotations, not as a value. Adding properties to typedefs is not allowed.");
    static final DiagnosticType ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES = DiagnosticType.warning("JSC_NTI_ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES", "Type {0} has a property {1} with incompatible types in its ancestor types: {2}");
    static final DiagnosticType ONE_TYPE_FOR_MANY_VARS = DiagnosticType.warning("JSC_NTI_ONE_TYPE_FOR_MANY_VARS", "Having one type annotation for multiple variables is not allowed.");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_NTI_UNKNOWN_OVERRIDE", "property {0} not defined on any supertype of {1}");
    static final DiagnosticType INTERFACE_METHOD_NOT_IMPLEMENTED = DiagnosticType.warning("JSC_NTI_INTERFACE_METHOD_NOT_IMPLEMENTED", "property {0} on interface {1} is not implemented by type {2}");
    static final DiagnosticType INTERFACE_METHOD_NOT_EMPTY = DiagnosticType.warning("JSC_NTI_INTERFACE_METHOD_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType ABSTRACT_METHOD_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_IN_CONCRETE_CLASS", "Abstract methods can only appear in abstract classes. Please declare class {0} as @abstract");
    static final DiagnosticType ABSTRACT_METHOD_IN_INTERFACE = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_IN_INTERFACE", "Abstract methods cannot appear in interfaces");
    static final DiagnosticType ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS = DiagnosticType.warning("JSC_NTI_ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS", "Abstract method {0} from superclass {1} not implemented");
    static final DiagnosticGroup COMPATIBLE_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_IN_CONCRETE_CLASS, CANNOT_OVERRIDE_FINAL_METHOD, DICT_WITHOUT_CTOR, DUPLICATE_PROP_IN_ENUM, EXPECTED_CONSTRUCTOR, EXPECTED_INTERFACE, INEXISTENT_PARAM, INTERFACE_METHOD_NOT_IMPLEMENTED, INTERFACE_METHOD_NOT_EMPTY, INVALID_INTERFACE_PROP_INITIALIZER, INVALID_PROP_OVERRIDE, LENDS_ON_BAD_TYPE, ONE_TYPE_FOR_MANY_VARS, REDECLARED_PROPERTY, STRUCT_WITHOUT_CTOR_OR_INTERF, ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES, UNKNOWN_OVERRIDE, UNRECOGNIZED_TYPE_NAME, WRONG_PARAMETER_COUNT);
    static final DiagnosticGroup NEW_DIAGNOSTICS = new DiagnosticGroup(ABSTRACT_METHOD_IN_INTERFACE, ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS, ANONYMOUS_NOMINAL_TYPE, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, CANNOT_INIT_TYPEDEF, CONST_WITHOUT_INITIALIZER, COULD_NOT_INFER_CONST_TYPE, CTOR_IN_DIFFERENT_SCOPE, DUPLICATE_JSDOC, MALFORMED_ENUM, MISPLACED_CONST_ANNOTATION, SETTER_WITH_RETURN);
    private NewTypeInference.WarningReporter warnings;
    private final transient AbstractCompiler compiler;
    private final CodingConvention convention;
    private static final String ANON_FUN_PREFIX = "%anon_fun";
    private static final String WINDOW_INSTANCE = "window";
    private static final String WINDOW_CLASS = "Window";
    private DefaultNameGenerator funNameGen;
    private Map<Node, RawNominalType> nominaltypesByNode = new LinkedHashMap<Node, RawNominalType>();
    private HashBasedTable<RawNominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();
    private final Set<RawNominalType> inProgressFreezes = new LinkedHashSet<RawNominalType>();
    private final GlobalTypeInfo globalTypeInfo;
    private final SimpleInference simpleInference;
    private final OrderedExterns orderedExterns;
    private RawNominalType window;
    private final List<NTIScope> scopes;

    public GlobalTypeInfoCollector(AbstractCompiler compiler) {
        this.warnings = new NewTypeInference.WarningReporter(compiler);
        this.compiler = compiler;
        this.funNameGen = new DefaultNameGenerator((Set<String>)ImmutableSet.of(), "", null);
        this.globalTypeInfo = (GlobalTypeInfo)compiler.getGlobalTypeInfo();
        this.simpleInference = new SimpleInference(this.globalTypeInfo);
        this.convention = compiler.getCodingConvention();
        this.orderedExterns = new OrderedExterns();
        this.scopes = new ArrayList<NTIScope>();
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkNotNull((Object)this.warnings, (Object)"Cannot rerun GlobalTypeInfoCollector.process");
        Preconditions.checkArgument((externs == null || externs.isRoot() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)root.isRoot(), (String)"Root must be ROOT, but is %s", (Object)((Object)root.getToken()));
        this.compiler.setMostRecentTypechecker(AbstractCompiler.MostRecentTypechecker.NTI);
        NTIScope globalScope = new NTIScope(root, null, (List<String>)ImmutableList.of(), this.getCommonTypes());
        globalScope.addUnknownTypeNames(this.globalTypeInfo.getUnknownTypeNames());
        this.globalTypeInfo.setGlobalScope(globalScope);
        this.scopes.add(globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(globalScope);
        NodeTraversal.traverseEs6(this.compiler, externs, this.orderedExterns);
        rootCnt.collectNamedTypesInExterns();
        this.defineObjectAndFunctionIfMissing();
        NodeTraversal.traverseEs6(this.compiler, root, rootCnt);
        globalScope.resolveTypedefs(this.getTypeParser());
        globalScope.resolveEnums(this.getTypeParser());
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            CollectNamedTypes cnt = new CollectNamedTypes(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), cnt);
            s.resolveTypedefs(this.getTypeParser());
            s.resolveEnums(this.getTypeParser());
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        ProcessScope rootPs = new ProcessScope(globalScope);
        if (externs != null) {
            NodeTraversal.traverseEs6(this.compiler, externs, rootPs);
        }
        NodeTraversal.traverseEs6(this.compiler, root, rootPs);
        rootPs.finishProcessingScope();
        for (int i = 1; i < this.scopes.size(); ++i) {
            NTIScope s = this.scopes.get(i);
            ProcessScope processScope = new ProcessScope(s);
            NodeTraversal.traverseEs6(this.compiler, s.getBody(), processScope);
            processScope.finishProcessingScope();
            if (!NewTypeInference.measureMem) continue;
            NewTypeInference.updatePeakMem();
        }
        ArrayList<Object> windows = new ArrayList<Object>();
        for (Map.Entry entry : this.nominaltypesByNode.entrySet()) {
            RawNominalType rawType = (RawNominalType)entry.getValue();
            if (this.window != null && rawType.hasAncestorClass(this.window)) {
                windows.add(rawType);
                continue;
            }
            this.checkAndFreezeNominalType(rawType);
        }
        JSType globalThisType = null;
        if (this.window != null) {
            Namespace namespace = globalScope.getNamespace(WINDOW_INSTANCE);
            if (namespace != null) {
                namespace.copyWindowProperties(this.getCommonTypes(), this.window);
            }
            for (RawNominalType rawNominalType : windows) {
                this.checkAndFreezeNominalType(rawNominalType);
            }
            if (namespace != null) {
                ((NamespaceLit)namespace).setWindowType(this.window.getAsNominalType());
                globalThisType = namespace.toJSType();
            }
        }
        if (globalThisType == null) {
            globalThisType = this.getCommonTypes().getTopObject().withLoose();
        }
        this.getCommonTypes().setGlobalThis(globalThisType);
        globalScope.setDeclaredType(new FunctionTypeBuilder(this.getCommonTypes()).addReceiverType(globalThisType).buildDeclaration());
        this.globalTypeInfo.setRawNominalTypes(this.nominaltypesByNode.values());
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (NTIScope s : this.scopes) {
            s.freezeScope();
        }
        this.simpleInference.setScopesAreFrozen();
        NodeTraversal.traverseEs6(this.compiler, externs, new NodeTraversal.AbstractShallowCallback(){

            @Override
            public void visit(NodeTraversal t, Node n, Node parent) {
                if (n.isQualifiedName()) {
                    Declaration d = GlobalTypeInfoCollector.this.getGlobalScope().getDeclaration(QualifiedName.fromNode(n), false);
                    JSType type = GlobalTypeInfoCollector.this.simpleInferDeclaration(d);
                    if (type == null) {
                        type = GlobalTypeInfoCollector.this.simpleInferExpr(n, GlobalTypeInfoCollector.this.getGlobalScope());
                    }
                    n.setTypeI(type != null ? type : ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN);
                }
            }
        });
        Map<Node, String> map = this.getTypeParser().getUnknownTypesMap();
        for (Map.Entry<Node, String> entry : map.entrySet()) {
            this.warnings.add(JSError.make(entry.getKey(), UNRECOGNIZED_TYPE_NAME, entry.getValue()));
        }
        for (JSError jSError : this.getTypeParser().getWarnings()) {
            this.warnings.add(jSError);
        }
        this.warnings = null;
        this.funNameGen = null;
        this.reorderScopesForNTI();
        this.compiler.setExternProperties((Set<String>)ImmutableSet.copyOf(this.getExternPropertyNames()));
    }

    private void reorderScopesForNTI() {
        List<NTIScope> scopes = this.scopes;
        ArrayList<NTIScope> result = new ArrayList<NTIScope>(scopes.size());
        ArrayList<NTIScope> callbacks = new ArrayList<NTIScope>();
        for (int i = scopes.size() - 1; i >= 0; --i) {
            NTIScope s = scopes.get(i);
            if (NodeUtil.isUnannotatedCallback(s.getRoot())) {
                callbacks.add(s);
                continue;
            }
            result.add(s);
        }
        Collections.reverse(callbacks);
        result.addAll(callbacks);
        this.globalTypeInfo.setScopes(result);
    }

    private void setWindow(RawNominalType rawType) {
        this.window = rawType;
    }

    private static boolean isWindowRawType(RawNominalType rawType) {
        return rawType.getName().equals(WINDOW_CLASS) && rawType.getDefSite().isFromExterns();
    }

    private RawNominalType dummyRawTypeForMissingExterns(String name) {
        Node defSite = NodeUtil.emptyFunction();
        defSite.setStaticSourceFile(new SimpleSourceFile("", true));
        return RawNominalType.makeClass(this.getCommonTypes(), defSite, name, (ImmutableList<String>)ImmutableList.of(), ObjectKind.UNRESTRICTED, false);
    }

    private void defineObjectAndFunctionIfMissing() {
        JSTypes commonTypes = this.getCommonTypes();
        if (commonTypes.getObjectType() == null) {
            commonTypes.setObjectType(this.dummyRawTypeForMissingExterns("Object"));
        }
        if (commonTypes.getLiteralObjNominalType() == null) {
            RawNominalType objLitRawType = this.dummyRawTypeForMissingExterns("Object{}");
            objLitRawType.addSuperClass(commonTypes.getObjectType());
            commonTypes.setLiteralObjNominalType(objLitRawType);
        }
        if (commonTypes.getFunctionType() == null) {
            commonTypes.setFunctionType(this.dummyRawTypeForMissingExterns("Function"));
        }
    }

    private ImmutableCollection<PropertyDef> getPropDefsFromType(NominalType nt, String pname) {
        if (nt.isClass()) {
            PropertyDef propdef = this.getPropDefFromClass(nt, pname);
            return propdef == null ? ImmutableSet.of() : ImmutableSet.of((Object)propdef);
        }
        return this.getPropDefsFromInterface(nt, pname);
    }

    private ImmutableCollection<PropertyDef> getPropDefsFromInterface(NominalType nominalType, String pname) {
        Preconditions.checkArgument((boolean)nominalType.isFrozen());
        Preconditions.checkArgument((nominalType.isInterface() || nominalType.isBuiltinObject() ? 1 : 0) != 0);
        if (nominalType.getPropDeclaredType(pname) == null) {
            return ImmutableSet.of();
        }
        if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
            PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
            return ImmutableSet.of((Object)(nominalType.isGeneric() ? propDef.substituteNominalGenerics(nominalType) : propDef));
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : nominalType.getInstantiatedInterfaces()) {
            result.addAll(this.getPropDefsFromInterface(interf, pname));
        }
        return result.build();
    }

    private PropertyDef getPropDefFromClass(NominalType nominalType, String pname) {
        while (nominalType.getPropDeclaredType(pname) != null) {
            Preconditions.checkArgument((boolean)nominalType.isFrozen());
            Preconditions.checkArgument((boolean)nominalType.isClass());
            if (this.propertyDefs.get((Object)nominalType.getId(), (Object)pname) != null) {
                PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType.getId(), (Object)pname);
                return nominalType.isGeneric() ? propDef.substituteNominalGenerics(nominalType) : propDef;
            }
            nominalType = nominalType.getInstantiatedSuperclass();
        }
        return null;
    }

    private void checkAndFreezeNominalType(RawNominalType rawType) {
        NominalType literalObj;
        if (rawType.isFrozen()) {
            return;
        }
        Preconditions.checkState((boolean)this.inProgressFreezes.add(rawType), (String)"Cycle in freeze order: %s (%s)", (Object)rawType, this.inProgressFreezes);
        NominalType superClass = rawType.getSuperClass();
        Set<String> nonInheritedPropNames = rawType.getAllNonInheritedProps();
        if (superClass != null && !superClass.isFrozen()) {
            this.checkAndFreezeNominalType(superClass.getRawNominalType());
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            if (superInterf.isFrozen()) continue;
            this.checkAndFreezeNominalType(superInterf.getRawNominalType());
        }
        LinkedHashMultimap superMethodTypes = LinkedHashMultimap.create();
        LinkedHashMultimap superPropTypes = LinkedHashMultimap.create();
        if (superClass != null) {
            Preconditions.checkState((boolean)superClass.isFrozen());
            for (String pname : superClass.getPropertyNames()) {
                if (superClass.isAbstractClass() && superClass.hasAbstractMethod(pname) && !rawType.isAbstractClass() && !rawType.mayHaveOwnNonStrayProp(pname)) {
                    this.warnings.add(JSError.make(rawType.getDefSite(), ABSTRACT_METHOD_NOT_IMPLEMENTED_IN_CONCRETE_CLASS, pname, superClass.getName()));
                }
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superClass, pname, (Multimap<String, DeclaredFunctionType>)superMethodTypes, (Multimap<String, JSType>)superPropTypes);
            }
        }
        for (NominalType superInterf : rawType.getInterfaces()) {
            Preconditions.checkState((boolean)superInterf.isFrozen());
            for (String pname : superInterf.getPropertyNames()) {
                nonInheritedPropNames.remove(pname);
                this.checkSuperProperty(rawType, superInterf, pname, (Multimap<String, DeclaredFunctionType>)superMethodTypes, (Multimap<String, JSType>)superPropTypes);
            }
        }
        for (String pname : superMethodTypes.keySet()) {
            Collection methodTypes = superMethodTypes.get((Object)pname);
            Preconditions.checkState((!methodTypes.isEmpty() ? 1 : 0) != 0);
            PropertyDef localPropDef = (PropertyDef)Preconditions.checkNotNull((Object)this.propertyDefs.get((Object)rawType, (Object)pname));
            Object superMethodType = DeclaredFunctionType.meet(methodTypes);
            DeclaredFunctionType localMethodType = localPropDef.methodType;
            boolean getsTypeFromParent = GlobalTypeInfoCollector.getsTypeInfoFromParentMethod(localPropDef);
            if (superMethodType == null) {
                superMethodType = (DeclaredFunctionType)methodTypes.iterator().next();
            } else if (getsTypeFromParent && localMethodType.getMaxArity() > ((DeclaredFunctionType)superMethodType).getMaxArity()) {
                this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, ((DeclaredFunctionType)superMethodType).toFunctionType().toString(), localMethodType.toFunctionType().toString()));
            }
            DeclaredFunctionType updatedMethodType = localMethodType.withTypeInfoFromSuper((DeclaredFunctionType)superMethodType, getsTypeFromParent);
            localPropDef.updateMethodType(updatedMethodType);
            superPropTypes.put((Object)pname, (Object)this.getCommonTypes().fromFunctionType(updatedMethodType.toFunctionType()));
        }
        for (String pname : superPropTypes.keySet()) {
            JSType updatedPropType;
            PropertyDef localPropDef;
            Collection defs = superPropTypes.get((Object)pname);
            Preconditions.checkState((!defs.isEmpty() ? 1 : 0) != 0);
            JSType inheritedPropType = this.getCommonTypes().TOP;
            for (JSType inheritedType : defs) {
                if (!(inheritedPropType = JSType.meet(inheritedPropType, inheritedType)).isBottom()) continue;
                this.warnings.add(JSError.make(rawType.getDefSite(), ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), pname, defs.toString()));
                break;
            }
            if ((localPropDef = (PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname)) == null) continue;
            if (localPropDef.methodType == null) {
                JSType t = rawType.getInstancePropDeclaredType(pname);
                updatedPropType = t == null ? inheritedPropType : t.specialize(inheritedPropType);
            } else {
                FunctionType ft = localPropDef.methodType.toFunctionType();
                updatedPropType = this.getCommonTypes().fromFunctionType(ft);
            }
            rawType.addProtoProperty(pname, null, updatedPropType, false);
        }
        if (rawType.inheritsFromIObject()) {
            JSType wrapped = rawType.getInstanceAsJSType();
            if (wrapped.getIndexType() == null) {
                this.warnings.add(JSError.make(rawType.getDefSite(), ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), "IObject<K,V>#index", "the keys K have types that can't be joined."));
            } else if (wrapped.getIndexedType() == null) {
                this.warnings.add(JSError.make(rawType.getDefSite(), ANCESTOR_TYPES_HAVE_INCOMPATIBLE_PROPERTIES, rawType.getName(), "IObject<K,V>#index", "the values V should have a common subtype."));
            }
        }
        for (String pname : nonInheritedPropNames) {
            Node propDefsite;
            JSDocInfo jsdoc;
            PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)rawType, (Object)pname);
            if (propDef == null || (jsdoc = NodeUtil.getBestJSDocInfo(propDefsite = propDef.defSite)) == null || !jsdoc.isOverride()) continue;
            this.warnings.add(JSError.make(propDefsite, UNKNOWN_OVERRIDE, pname, rawType.getName()));
        }
        rawType.freeze();
        if (rawType.isBuiltinObject() && !(literalObj = this.getCommonTypes().getLiteralObjNominalType()).isFrozen()) {
            literalObj.getRawNominalType().freeze();
        }
        this.inProgressFreezes.remove(rawType);
    }

    private void checkSuperProperty(RawNominalType current, NominalType superType, String pname, Multimap<String, DeclaredFunctionType> superMethodTypes, Multimap<String, JSType> superPropTypes) {
        PropertyDef localPropDef;
        JSType localPropType;
        JSType inheritedPropType = superType.getPropDeclaredType(pname);
        if (inheritedPropType == null) {
            return;
        }
        ImmutableCollection<PropertyDef> inheritedPropDefs = this.getPropDefsFromType(superType, pname);
        if (current.isClass() && superType.isInterface()) {
            if (GlobalTypeInfoCollector.isCtorDefinedByCall(current)) {
                for (PropertyDef inheritedDef : inheritedPropDefs) {
                    if (current.mayHaveProp(pname)) continue;
                    this.propertyDefs.put((Object)current, (Object)pname, (Object)inheritedDef);
                }
            } else if (!current.mayHaveNonStrayProp(pname)) {
                this.warnings.add(JSError.make(((PropertyDef)inheritedPropDefs.iterator().next()).defSite, INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superType.toString(), current.toString()));
                return;
            }
        }
        JSType jSType = localPropType = (localPropDef = (PropertyDef)this.propertyDefs.get((Object)current, (Object)pname)) == null ? null : current.getInstancePropDeclaredType(pname);
        if (localPropType != null && superType.isClass() && superType.hasConstantProp(pname) && localPropType.getFunType() != null) {
            this.warnings.add(JSError.make(localPropDef.defSite, CANNOT_OVERRIDE_FINAL_METHOD, pname));
            return;
        }
        if (localPropType != null && !GlobalTypeInfoCollector.getsTypeInfoFromParentMethod(localPropDef) && !this.isValidOverride(localPropType, inheritedPropType)) {
            this.warnings.add(JSError.make(localPropDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
            return;
        }
        superPropTypes.put((Object)pname, (Object)inheritedPropType);
        if (localPropType != null && localPropDef.methodType != null) {
            for (PropertyDef inheritedPropDef : inheritedPropDefs) {
                if (inheritedPropDef.methodType == null) continue;
                superMethodTypes.put((Object)pname, (Object)inheritedPropDef.methodType);
            }
        }
    }

    private boolean isValidOverride(JSType localPropType, JSType inheritedPropType) {
        FunctionType localFunType = localPropType.getFunType();
        FunctionType inheritedFunType = inheritedPropType.getFunType();
        if (localFunType == null) {
            return localPropType.isSubtypeOf(inheritedPropType);
        }
        if (inheritedFunType == null) {
            return false;
        }
        return localFunType.isValidOverride(inheritedFunType);
    }

    private static boolean getsTypeInfoFromParentMethod(PropertyDef pd) {
        if (pd == null || pd.methodType == null) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(pd.defSite);
        if (jsdoc == null) {
            return true;
        }
        return (jsdoc.isOverride() || jsdoc.isExport()) && !jsdoc.containsFunctionDeclaration();
    }

    private boolean isAliasedTypedef(Node lhsQnameNode, NTIScope s) {
        return this.getAliasedTypedef(lhsQnameNode, s) != null;
    }

    @Nullable
    private Typedef getAliasedTypedef(Node lhs, NTIScope s) {
        if (!NodeUtil.isAliasedConstDefinition(lhs)) {
            return null;
        }
        Node rhs = NodeUtil.getRValueOfLValue(lhs);
        Preconditions.checkState((rhs != null && rhs.isQualifiedName() ? 1 : 0) != 0);
        return s.getTypedef(QualifiedName.fromNode(rhs));
    }

    private JSType getDeclaredTypeOfNode(JSDocInfo jsdoc, NTIScope s) {
        return this.getTypeParser().getDeclaredTypeOfNode(jsdoc, null, s);
    }

    private JSType getVarTypeFromAnnotation(Node nameNode, NTIScope currentScope) {
        Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
        Node varNode = nameNode.getParent();
        JSType varType = this.getDeclaredTypeOfNode(varNode.getJSDocInfo(), currentScope);
        if (varNode.hasMoreThanOneChild() && varType != null) {
            this.warnings.add(JSError.make(varNode, ONE_TYPE_FOR_MANY_VARS, new String[0]));
        }
        String varName = nameNode.getString();
        JSType nameNodeType = this.getDeclaredTypeOfNode(nameNode.getJSDocInfo(), currentScope);
        if (nameNodeType != null) {
            if (varType != null) {
                this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
            }
            return nameNodeType;
        }
        return varType;
    }

    private static boolean isPropertyDeclarationOnThis(Node n, NTIScope s) {
        Node parent = n.getParent();
        return n.isGetProp() && n.getFirstChild().isThis() && (parent.isAssign() && parent.getFirstChild().equals(n) || parent.isExprResult()) && (s.isConstructor() || s.isInterface() || s.isPrototypeMethod());
    }

    private static boolean isPrototypeProperty(Node getProp) {
        if (!getProp.isGetProp()) {
            return false;
        }
        Node recv = getProp.getFirstChild();
        return recv.isGetProp() && recv.getLastChild().getString().equals("prototype");
    }

    private boolean isPrototypePropertyDeclaration(Node n) {
        if (NodeUtil.isExprAssign(n) && GlobalTypeInfoCollector.isPrototypeProperty(n.getFirstFirstChild()) && n.getFirstFirstChild().isQualifiedName()) {
            Node protoProp = n.getFirstFirstChild();
            this.recordPropertyName(protoProp.getFirstChild().getLastChild());
            return true;
        }
        if (n.isObjectLit()) {
            Node parent = n.getParent();
            if (parent.isAssign() && parent.getParent().isExprResult() && parent.getFirstChild().isGetProp() && parent.getFirstChild().getLastChild().getString().equals("prototype")) {
                return true;
            }
            JSDocInfo jsdoc = n.getJSDocInfo();
            return jsdoc != null && jsdoc.getLendsName() != null && jsdoc.getLendsName().endsWith("prototype");
        }
        return false;
    }

    private static boolean isAnnotatedAsConst(Node defSite) {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
        return jsdoc != null && jsdoc.hasConstAnnotation() && !jsdoc.isConstructor();
    }

    private static Node fromDefsiteToName(Node defSite) {
        if (defSite.isGetProp()) {
            return defSite.getLastChild();
        }
        if (defSite.isName() || defSite.isStringKey() || defSite.isGetterDef() || defSite.isSetterDef() || defSite.isMemberFunctionDef()) {
            return defSite;
        }
        throw new RuntimeException("Unknown defsite: " + (Object)((Object)defSite.getToken()));
    }

    private boolean isConst(Node defSite) {
        return GlobalTypeInfoCollector.isAnnotatedAsConst(defSite) || !defSite.isFromExterns() && NodeUtil.isConstantByConvention(this.convention, GlobalTypeInfoCollector.fromDefsiteToName(defSite));
    }

    private static boolean isCtorWithoutFunctionLiteral(Node qnameNode) {
        if (!qnameNode.isFromExterns()) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
        if (jsdoc == null || !jsdoc.isConstructor()) {
            return false;
        }
        if (qnameNode.isName()) {
            return qnameNode.getParent().isVar() && !qnameNode.hasChildren();
        }
        if (qnameNode.isGetProp()) {
            return qnameNode.getParent().isExprResult();
        }
        return false;
    }

    private static boolean isCtorDefinedByCall(RawNominalType rawType) {
        return GlobalTypeInfoCollector.isCtorDefinedByCall(NodeUtil.getBestLValue(rawType.getDefSite()));
    }

    static boolean isCtorDefinedByCall(Node qnameNode) {
        if (!qnameNode.isName() && !qnameNode.isGetProp()) {
            return false;
        }
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
        Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
        return jsdoc != null && jsdoc.isConstructor() && rhs != null && rhs.isCall();
    }

    private Map<Node, String> getAnonFunNames() {
        return this.globalTypeInfo.getAnonFunNames();
    }

    private NTIScope getGlobalScope() {
        return this.globalTypeInfo.getGlobalScope();
    }

    private JSTypes getCommonTypes() {
        return this.globalTypeInfo.getCommonTypes();
    }

    private JSTypeCreatorFromJSDoc getTypeParser() {
        return this.globalTypeInfo.getTypeParser();
    }

    private Set<String> getExternPropertyNames() {
        return this.globalTypeInfo.getExternPropertyNames();
    }

    private String getFunInternalName(Node n) {
        return this.globalTypeInfo.getFunInternalName(n);
    }

    private UniqueNameGenerator getVarNameGen() {
        return this.globalTypeInfo.getVarNameGen();
    }

    private void recordPropertyName(Node pnameNode) {
        this.globalTypeInfo.recordPropertyName(pnameNode);
    }

    private JSType simpleInferDeclaration(Declaration decl) {
        return this.simpleInference.inferDeclaration(decl);
    }

    private JSType simpleInferExpr(Node n, NTIScope scope) {
        return this.simpleInference.inferExpr(n, scope);
    }

    private FunctionType simpleInferInstantiatedCallee(Node call, FunctionType calleeType, boolean bailForUntypedArguments, NTIScope scope) {
        return this.simpleInference.inferInstantiatedCallee(call, calleeType, bailForUntypedArguments, scope);
    }

    private static class PropertyDef {
        final Node defSite;
        DeclaredFunctionType methodType;
        final NTIScope methodScope;

        PropertyDef(Node defSite, DeclaredFunctionType methodType, NTIScope methodScope) {
            Preconditions.checkNotNull((Object)defSite);
            Preconditions.checkArgument((defSite.isGetProp() || NodeUtil.isObjectLitKey(defSite) ? 1 : 0) != 0);
            this.defSite = defSite;
            this.methodType = methodType;
            this.methodScope = methodScope;
        }

        PropertyDef substituteNominalGenerics(NominalType nt) {
            Preconditions.checkArgument((boolean)nt.isGeneric(), (Object)nt);
            if (this.methodType == null) {
                return this;
            }
            PropertyDef def = new PropertyDef(this.defSite, this.methodType.substituteNominalGenerics(nt), this.methodScope);
            return def;
        }

        void updateMethodType(DeclaredFunctionType updatedType) {
            this.methodType = updatedType;
            if (this.methodScope != null) {
                this.methodScope.setDeclaredType(updatedType);
            }
        }

        public String toString() {
            return "PropertyDef(" + this.defSite + ", " + this.methodType + ")";
        }
    }

    private static class PropertyType {
        JSType declType = null;
        JSType inferredFunType = null;

        private PropertyType() {
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;
        private final List<NominalTypeBuilder> delegateProxies = new ArrayList<NominalTypeBuilder>();
        private final Map<String, String> delegateCallingConventions = new HashMap<String, String>();
        private Set<Node> lendsObjlits = new LinkedHashSet<Node>();

        ProcessScope(NTIScope currentScope) {
            this.currentScope = currentScope;
        }

        void finishProcessingScope() {
            for (Node objlit : this.lendsObjlits) {
                this.processLendsNode(objlit);
            }
            this.lendsObjlits = null;
            GlobalTypeInfoCollector.this.convention.defineDelegateProxyPrototypeProperties(GlobalTypeInfoCollector.this.globalTypeInfo, this.delegateProxies, this.delegateCallingConventions);
        }

        void processLendsNode(Node objlit) {
            JSDocInfo jsdoc = objlit.getJSDocInfo();
            String lendsName = jsdoc.getLendsName();
            Preconditions.checkNotNull((Object)lendsName);
            QualifiedName lendsQname = QualifiedName.fromQualifiedString(lendsName);
            if (this.currentScope.isNamespace(lendsQname)) {
                this.processLendsToNamespace(lendsQname, lendsName, objlit);
            } else {
                RawNominalType rawType = this.checkValidLendsToPrototypeAndGetClass(lendsQname, lendsName, objlit);
                if (rawType != null) {
                    for (Node prop : objlit.children()) {
                        String pname = NodeUtil.getObjectLitKeyName(prop);
                        this.mayAddPropToPrototype(rawType, pname, prop, prop.getFirstChild());
                    }
                } else {
                    for (Node prop : objlit.children()) {
                        Node propInit = prop.getFirstChild();
                        if (!propInit.isFunction()) continue;
                        this.visitFunctionLate(propInit, null);
                    }
                }
            }
        }

        void processLendsToNamespace(QualifiedName lendsQname, String lendsName, Node objlit) {
            RawNominalType rawType = this.currentScope.getNominalType(lendsQname);
            if (rawType != null && rawType.isInterface()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return;
            }
            Namespace borrowerNamespace = this.currentScope.getNamespace(lendsQname);
            for (Node prop : objlit.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                JSType propDeclType = (JSType)prop.getTypeI();
                if (propDeclType != null) {
                    borrowerNamespace.addProperty(pname, prop, propDeclType, false);
                    continue;
                }
                JSType t = GlobalTypeInfoCollector.this.simpleInferExpr(prop.getFirstChild(), this.currentScope);
                if (t == null) {
                    t = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
                }
                borrowerNamespace.addProperty(pname, prop, t, false);
            }
        }

        RawNominalType checkValidLendsToPrototypeAndGetClass(QualifiedName lendsQname, String lendsName, Node objlit) {
            if (!lendsQname.getRightmostName().equals("prototype")) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
                return null;
            }
            QualifiedName recv = lendsQname.getAllButRightmost();
            RawNominalType rawType = this.currentScope.getNominalType(recv);
            if (rawType == null || rawType.isInterface()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(objlit, LENDS_ON_BAD_TYPE, lendsName));
            }
            return rawType;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case FUNCTION: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && (GlobalTypeInfoCollector.this.isPrototypePropertyDeclaration(grandparent) || GlobalTypeInfoCollector.isPropertyDeclarationOnThis(parent.getFirstChild(), this.currentScope))) break;
                    RawNominalType ownerType = this.maybeGetOwnerType(n, parent);
                    this.visitFunctionLate(n, ownerType);
                    break;
                }
                case NAME: {
                    String name = n.getString();
                    if (name == null || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        this.visitVar(n, parent);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.getTypedef(name) != null || name.equals(this.currentScope.getName()) || this.currentScope.isDefinedLocally(name, false)) break;
                    break;
                }
                case GETPROP: {
                    if (NodeUtil.isPropertyTest(GlobalTypeInfoCollector.this.compiler, n) || this.isPropertyAbsentTest(n)) {
                        GlobalTypeInfoCollector.this.recordPropertyName(n.getLastChild());
                    }
                    if (n.getFirstChild().isName() && n.getFirstChild().getString().startsWith("$jscomp$destructuring$")) {
                        GlobalTypeInfoCollector.this.recordPropertyName(n.getLastChild());
                    }
                    if (parent.isExprResult() && n.isQualifiedName()) {
                        this.visitPropertyDeclaration(n);
                    }
                    GlobalTypeInfoCollector.this.convention.checkForCallingConventionDefinitions(n, this.delegateCallingConventions);
                    break;
                }
                case ASSIGN: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isQualifiedName()) break;
                    this.clearInferredTypeIfVar(NodeUtil.getRootOfQualifiedName(lvalue));
                    if (!lvalue.isGetProp()) break;
                    this.visitPropertyDeclaration(lvalue);
                    break;
                }
                case CAST: {
                    JSType castType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(n.getJSDocInfo(), this.currentScope);
                    Preconditions.checkNotNull((Object)castType, (Object)n);
                    n.setTypeI(castType);
                    break;
                }
                case OBJECTLIT: {
                    if (NodeUtil.isObjectLitKey(parent)) break;
                    Node lval = NodeUtil.getBestLValue(n);
                    this.visitObjectLit(n, QualifiedName.fromNode(lval));
                    break;
                }
                case CALL: {
                    this.visitCall(n);
                    break;
                }
            }
        }

        private void clearInferredTypeIfVar(Node qnameRoot) {
            if (qnameRoot.isName()) {
                String name = qnameRoot.getString();
                this.currentScope.clearInferredTypeOfVar(name);
            }
        }

        private boolean isPropertyAbsentTest(Node propAccessNode) {
            Node parent = propAccessNode.getParent();
            if (parent.getToken() == Token.EQ || parent.getToken() == Token.SHEQ) {
                Node other = parent.getFirstChild() == propAccessNode ? parent.getSecondChild() : parent.getFirstChild();
                return NodeUtil.isUndefined(other);
            }
            return parent.isNot() && parent.getParent().isIf();
        }

        private void visitVar(Node nameNode, Node parent) {
            String name = nameNode.getString();
            boolean isDefinedLocally = this.currentScope.isDefinedLocally(name, false);
            if (GlobalTypeInfoCollector.isCtorDefinedByCall(nameNode)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(nameNode), name, nameNode.getFirstChild(), null, this.currentScope);
                return;
            }
            if (GlobalTypeInfoCollector.isCtorWithoutFunctionLiteral(nameNode)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(nameNode), name, nameNode, null, this.currentScope);
                return;
            }
            if (isDefinedLocally && this.currentScope.isNamespace(name)) {
                return;
            }
            if (NodeUtil.isTypedefDecl(nameNode) || NodeUtil.isEnumDecl(nameNode)) {
                if (!isDefinedLocally) {
                    this.currentScope.addDeclaredLocal(name, ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN, false, nameNode.isFromExterns());
                }
                return;
            }
            Node initializer = nameNode.getFirstChild();
            if (initializer != null && initializer.isFunction()) {
                return;
            }
            if (parent.isCatch()) {
                this.currentScope.addDeclaredLocal(name, ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN, false, false);
            } else {
                boolean isConst = GlobalTypeInfoCollector.this.isConst(nameNode);
                boolean isDeclared = true;
                JSType type = GlobalTypeInfoCollector.this.getVarTypeFromAnnotation(nameNode, this.currentScope);
                if (type == null) {
                    if (isConst) {
                        type = this.mayInferFromRhsIfConst(nameNode);
                    } else if (initializer != null) {
                        isDeclared = false;
                        type = GlobalTypeInfoCollector.this.simpleInferExpr(initializer, this.currentScope);
                    }
                }
                if (isDeclared) {
                    this.currentScope.addDeclaredLocal(name, type, isConst, nameNode.isFromExterns());
                } else {
                    this.currentScope.addInferredLocal(name, type);
                }
            }
        }

        private void visitObjectLit(Node objLitNode, QualifiedName lvalueQname) {
            Node maybeLvalue;
            Node parent = objLitNode.getParent();
            JSDocInfo jsdoc = objLitNode.getJSDocInfo();
            if (jsdoc != null && jsdoc.getLendsName() != null) {
                this.lendsObjlits.add(objLitNode);
            }
            Node node = maybeLvalue = parent.isAssign() ? parent.getFirstChild() : parent;
            if (this.currentScope.isNamespace(lvalueQname)) {
                for (Node prop : objLitNode.children()) {
                    if (prop.isComputedProp()) continue;
                    this.visitNamespacePropertyDeclaration(prop, lvalueQname, prop.getString());
                }
            } else if (!NodeUtil.isEnumDecl(maybeLvalue) && !NodeUtil.isPrototypeAssignment(maybeLvalue)) {
                for (Node prop : objLitNode.children()) {
                    JSDocInfo propJsdoc = prop.getJSDocInfo();
                    if (propJsdoc != null) {
                        JSType propType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(propJsdoc, this.currentScope);
                        prop.setTypeI(propType);
                    }
                    if (!GlobalTypeInfoCollector.isAnnotatedAsConst(prop)) continue;
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(prop, MISPLACED_CONST_ANNOTATION, new String[0]));
                }
            }
            for (Node prop : objLitNode.children()) {
                Node keyNode = NodeUtil.getObjectLitKeyNode(prop);
                if (keyNode != null) {
                    GlobalTypeInfoCollector.this.recordPropertyName(keyNode);
                }
                if (!prop.hasChildren() || !prop.getFirstChild().isObjectLit()) continue;
                QualifiedName nestedQname = lvalueQname == null || keyNode == null ? null : QualifiedName.join(lvalueQname, new QualifiedName(keyNode.getString()));
                this.visitObjectLit(prop.getFirstChild(), nestedQname);
            }
        }

        private void visitCall(Node call) {
            CodingConvention.DelegateRelationship delegateRelationship;
            String className;
            CodingConvention.SubclassRelationship relationship = GlobalTypeInfoCollector.this.convention.getClassesDefinedByCall(call);
            if (relationship != null) {
                this.applySubclassRelationship(relationship);
            }
            if ((className = GlobalTypeInfoCollector.this.convention.getSingletonGetterClassName(call)) != null) {
                this.applySingletonGetter(className);
            }
            if ((delegateRelationship = GlobalTypeInfoCollector.this.convention.getDelegateRelationship(call)) != null) {
                this.applyDelegateRelationship(delegateRelationship);
            }
        }

        private void applySubclassRelationship(CodingConvention.SubclassRelationship rel) {
            if (rel.superclassName.equals(rel.subclassName)) {
                return;
            }
            RawNominalType superClass = this.findInScope(rel.superclassName);
            RawNominalType subClass = this.findInScope(rel.subclassName);
            if (superClass != null && superClass.getConstructorFunction() != null && subClass != null && subClass.getConstructorFunction() != null) {
                GlobalTypeInfoCollector.this.convention.applySubclassRelationship(new NominalTypeBuilderNti(superClass.getAsNominalType()), new NominalTypeBuilderNti(subClass.getAsNominalType()), rel.type);
            }
        }

        private void applySingletonGetter(String className) {
            RawNominalType rawType = this.findInScope(className);
            if (rawType != null) {
                JSType instanceType = rawType.getInstanceAsJSType();
                JSType getInstanceType = new FunctionTypeBuilder(GlobalTypeInfoCollector.this.getCommonTypes()).addRetType(instanceType).buildType();
                GlobalTypeInfoCollector.this.convention.applySingletonGetter(new NominalTypeBuilderNti(rawType.getAsNominalType()), getInstanceType);
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship rel) {
            RawNominalType delegateBase = this.findInScope(rel.delegateBase);
            RawNominalType delegator = this.findInScope(rel.delegator);
            RawNominalType delegateSuper = this.findInScope(GlobalTypeInfoCollector.this.convention.getDelegateSuperclassName());
            if (delegator != null && delegateBase != null && delegateSuper != null) {
                JSType findDelegate = new FunctionTypeBuilder(GlobalTypeInfoCollector.this.getCommonTypes()).addReqFormal(GlobalTypeInfoCollector.this.getCommonTypes().qmarkFunction()).addRetType(JSType.join(((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().NULL, delegateBase.getInstanceAsJSType())).buildType();
                RawNominalType delegateProxy = RawNominalType.makeClass(GlobalTypeInfoCollector.this.getCommonTypes(), delegateBase.getDefSite(), delegateBase.getName() + "(Proxy)", null, ObjectKind.UNRESTRICTED, false);
                GlobalTypeInfoCollector.this.nominaltypesByNode.put(new Node(null), delegateProxy);
                delegateProxy.addSuperClass(delegateBase.getAsNominalType());
                delegateProxy.setCtorFunction(new FunctionTypeBuilder(GlobalTypeInfoCollector.this.getCommonTypes()).addRetType(delegateProxy.getInstanceAsJSType()).addNominalType(delegateProxy.getInstanceAsJSType()).buildFunction());
                GlobalTypeInfoCollector.this.convention.applyDelegateRelationship(new NominalTypeBuilderNti(delegateSuper.getAsNominalType()), new NominalTypeBuilderNti(delegateBase.getAsNominalType()), new NominalTypeBuilderNti(delegator.getAsNominalType()), delegateProxy.getInstanceAsJSType(), findDelegate);
                this.delegateProxies.add(new NominalTypeBuilderNti(delegateProxy.getAsNominalType()));
            }
        }

        private RawNominalType findInScope(String qname) {
            return this.currentScope.getNominalType(QualifiedName.fromQualifiedString(qname));
        }

        private void visitPropertyDeclaration(Node getProp) {
            GlobalTypeInfoCollector.this.recordPropertyName(getProp.getLastChild());
            if (GlobalTypeInfoCollector.isPropertyDeclarationOnThis(getProp, this.currentScope)) {
                this.visitPropertyDeclarationOnThis(getProp);
            } else if (GlobalTypeInfoCollector.isPrototypeProperty(getProp)) {
                this.visitPrototypePropertyDeclaration(getProp);
            } else if (NodeUtil.isPrototypeAssignment(getProp)) {
                getProp.putBooleanProp((byte)76, true);
                this.visitPrototypeAssignment(getProp);
            } else if (this.isStaticCtorProp(getProp)) {
                this.visitConstructorPropertyDeclaration(getProp);
            } else if (this.currentScope.isNamespace(getProp.getFirstChild())) {
                this.visitNamespacePropertyDeclaration(getProp);
            } else {
                this.visitOtherPropertyDeclaration(getProp);
            }
        }

        private boolean isStaticCtorProp(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            if (!getProp.isQualifiedName()) {
                return false;
            }
            return null != this.currentScope.getNominalType(QualifiedName.fromNode(getProp.getFirstChild()));
        }

        private NTIScope visitFunctionLate(Node fn, RawNominalType ownerType) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            String internalName = GlobalTypeInfoCollector.this.getFunInternalName(fn);
            NTIScope fnScope = this.currentScope.getScope(internalName);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(fn);
            DeclaredFunctionType declFunType = fnScope.getDeclaredFunctionType();
            if (declFunType == null) {
                declFunType = this.computeFnDeclaredType(jsdoc, internalName, fn, ownerType, this.currentScope);
                fnScope.setDeclaredType(declFunType);
            }
            return fnScope;
        }

        PropertyType getPropTypeHelper(JSDocInfo jsdoc, Node declNode, RawNominalType thisType) {
            Node initializer = NodeUtil.getRValueOfLValue(declNode);
            PropertyType result = new PropertyType();
            DeclaredFunctionType dft = null;
            if (initializer != null && initializer.isFunction()) {
                dft = this.visitFunctionLate(initializer, thisType).getDeclaredFunctionType();
            }
            if (jsdoc != null && jsdoc.hasType()) {
                result.declType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            } else if (jsdoc != null && jsdoc.containsFunctionDeclaration() && (initializer == null || !initializer.isFunction())) {
                Preconditions.checkState((boolean)declNode.isGetProp(), (Object)declNode);
                dft = this.computeFnDeclaredType(jsdoc, declNode.getLastChild().getString(), declNode, null, this.currentScope);
                result.declType = GlobalTypeInfoCollector.this.getCommonTypes().fromFunctionType(dft.toFunctionType());
            } else if (initializer != null && initializer.isFunction()) {
                JSType funType = GlobalTypeInfoCollector.this.getCommonTypes().fromFunctionType(dft.toFunctionType());
                if (jsdoc != null && jsdoc.containsFunctionDeclaration() || NodeUtil.functionHasInlineJsdocs(initializer)) {
                    result.declType = funType;
                } else {
                    result.inferredFunType = funType;
                }
            }
            return result;
        }

        private void visitPrototypePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType ownerType = this.currentScope.getNominalType(ctorQname);
            if (ownerType != null && !this.currentScope.isDefined(ctorNameNode)) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(getProp, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
            }
            this.visitPrototypePropertyDeclaration(getProp, ownerType);
        }

        private void visitPrototypePropertyDeclaration(Node getProp, RawNominalType ownerType) {
            Node initializer;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node parent = getProp.getParent();
            Node node = initializer = parent.isAssign() ? parent.getLastChild() : null;
            if (ownerType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            if (initializer != null && initializer.isFunction()) {
                parent.putBooleanProp((byte)76, true);
            }
            this.mayWarnAboutInterfacePropInit(ownerType, initializer);
            this.mayAddPropToPrototype(ownerType, getProp.getLastChild().getString(), getProp, initializer);
        }

        private void mayWarnAboutInterfacePropInit(RawNominalType rawType, Node initializer) {
            if (rawType.isInterface() && initializer != null) {
                String abstractMethodName = GlobalTypeInfoCollector.this.convention.getAbstractMethodName();
                if (initializer.isFunction() && !NodeUtil.isEmptyFunctionExpression(initializer)) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(initializer, INTERFACE_METHOD_NOT_EMPTY, new String[0]));
                } else if (!initializer.isFunction() && !initializer.matchesQualifiedName(abstractMethodName)) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(initializer, INVALID_INTERFACE_PROP_INITIALIZER, new String[0]));
                }
            }
        }

        private void visitPrototypeAssignment(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Node protoObjNode = getProp.getParent().getLastChild();
            if (!protoObjNode.isObjectLit()) {
                return;
            }
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getProp);
            QualifiedName ctorQname = QualifiedName.fromNode(ctorNameNode);
            RawNominalType rawType = this.currentScope.getNominalType(ctorQname);
            for (Node objLitChild : protoObjNode.children()) {
                GlobalTypeInfoCollector.this.recordPropertyName(objLitChild);
            }
            if (rawType == null) {
                for (Node objLitChild : protoObjNode.children()) {
                    Node initializer = objLitChild.getLastChild();
                    if (initializer == null || !initializer.isFunction()) continue;
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            getProp.putBooleanProp((byte)76, true);
            for (Node objLitChild : protoObjNode.children()) {
                this.mayAddPropToPrototype(rawType, objLitChild.getString(), objLitChild, objLitChild.getLastChild());
            }
        }

        private void visitConstructorPropertyDeclaration(Node getProp) {
            JSType propDeclType;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            this.mayVisitWeirdCtorDefinition(getProp);
            if (this.isNamedType(getProp)) {
                return;
            }
            QualifiedName ctorQname = QualifiedName.fromNode(getProp.getFirstChild());
            RawNominalType classType = this.currentScope.getNominalType(ctorQname);
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            if (jsdoc != null && !jsdoc.hasType() && jsdoc.containsFunctionDeclaration()) {
                JSTypeCreatorFromJSDoc.FunctionAndSlotType fst = GlobalTypeInfoCollector.this.getTypeParser().getFunctionType(jsdoc, pname, getProp, null, null, this.currentScope);
                propDeclType = GlobalTypeInfoCollector.this.getCommonTypes().fromFunctionType(fst.functionType.toFunctionType());
            } else {
                propDeclType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(jsdoc, this.currentScope);
            }
            boolean isConst = GlobalTypeInfoCollector.this.isConst(getProp);
            if (propDeclType != null || isConst) {
                JSType previousPropType = classType.getCtorPropDeclaredType(pname);
                if (classType.hasStaticProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(getProp, REDECLARED_PROPERTY, pname, "type " + classType));
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(getProp);
                }
                classType.addCtorProperty(pname, getProp, propDeclType, isConst);
                getProp.putBooleanProp((byte)76, true);
                if (isConst) {
                    getProp.putBooleanProp((byte)77, true);
                }
            } else {
                JSType inferredType = null;
                Node initializer = NodeUtil.getRValueOfLValue(getProp);
                if (initializer != null) {
                    inferredType = GlobalTypeInfoCollector.this.simpleInferExpr(initializer, this.currentScope);
                }
                if (inferredType == null) {
                    inferredType = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
                }
                classType.addUndeclaredCtorProperty(pname, getProp, inferredType);
            }
        }

        private void mayVisitWeirdCtorDefinition(Node getProp) {
            if (GlobalTypeInfoCollector.isCtorDefinedByCall(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp.getNext(), null, this.currentScope);
                return;
            }
            if (GlobalTypeInfoCollector.isCtorWithoutFunctionLiteral(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp, null, this.currentScope);
                return;
            }
        }

        private void visitNamespacePropertyDeclaration(Node getProp) {
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            this.mayVisitWeirdCtorDefinition(getProp);
            if (this.isNamedType(getProp) || GlobalTypeInfoCollector.this.isAliasedTypedef(getProp, this.currentScope)) {
                return;
            }
            Node recv = getProp.getFirstChild();
            String pname = getProp.getLastChild().getString();
            this.visitNamespacePropertyDeclaration(getProp, QualifiedName.fromNode(recv), pname);
        }

        private void visitNamespacePropertyDeclaration(Node defSite, QualifiedName nsQname, String pname) {
            QualifiedName propQname;
            Preconditions.checkArgument((defSite.isGetProp() || NodeUtil.isObjLitProperty(defSite) ? 1 : 0) != 0, (Object)defSite);
            Preconditions.checkArgument((boolean)this.currentScope.isNamespace(nsQname));
            if (defSite.isGetterDef()) {
                pname = GlobalTypeInfoCollector.this.getCommonTypes().createGetterPropName(pname);
            } else if (defSite.isSetterDef()) {
                pname = GlobalTypeInfoCollector.this.getCommonTypes().createSetterPropName(pname);
            }
            if (defSite.isStringKey() && this.currentScope.isNamespace(QualifiedName.join(nsQname, propQname = new QualifiedName(defSite.getString())))) {
                return;
            }
            EnumType et = this.currentScope.getEnum(nsQname);
            if (et != null && et.enumLiteralHasKey(pname)) {
                return;
            }
            Namespace ns = this.currentScope.getNamespace(nsQname);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
            PropertyType pt = this.getPropTypeHelper(jsdoc, defSite, null);
            JSType propDeclType = pt.declType;
            JSType propInferredFunType = pt.inferredFunType;
            boolean isConst = GlobalTypeInfoCollector.this.isConst(defSite);
            if (propDeclType != null || isConst) {
                JSType previousPropType = ns.getPropDeclaredType(pname);
                defSite.putBooleanProp((byte)76, true);
                if (ns.hasSubnamespace(new QualifiedName(pname)) || ns.hasStaticProp(pname) && previousPropType != null && !this.suppressDupPropWarning(jsdoc, propDeclType, previousPropType)) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, REDECLARED_PROPERTY, pname, "namespace " + ns));
                    defSite.getParent().putBooleanProp((byte)76, true);
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(defSite);
                }
                ns.addProperty(pname, defSite, propDeclType, isConst);
                if (defSite.isGetProp() && isConst) {
                    defSite.putBooleanProp((byte)77, true);
                }
            } else if (propInferredFunType != null) {
                ns.addUndeclaredProperty(pname, defSite, propInferredFunType, false);
            } else {
                JSType t;
                Node initializer = NodeUtil.getRValueOfLValue(defSite);
                JSType jSType = t = initializer == null ? null : GlobalTypeInfoCollector.this.simpleInferExpr(initializer, this.currentScope);
                if (t == null) {
                    t = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
                }
                ns.addUndeclaredProperty(pname, defSite, t, false);
            }
        }

        private void visitPropertyDeclarationOnThis(Node getProp) {
            Node initializer;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            JSType t = this.currentScope.getDeclaredFunctionType().getThisType();
            NominalType thisType = t == null ? null : t.getNominalTypeIfSingletonObj();
            Node parent = getProp.getParent();
            Node node = initializer = parent.isAssign() ? parent.getLastChild() : null;
            if (thisType == null) {
                if (initializer != null && initializer.isFunction()) {
                    this.visitFunctionLate(initializer, null);
                }
                return;
            }
            RawNominalType rawType = thisType.getRawNominalType();
            if (rawType.isInterface()) {
                this.visitPrototypePropertyDeclaration(getProp, rawType);
                return;
            }
            String pname = getProp.getLastChild().getString();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            PropertyType pt = this.getPropTypeHelper(jsdoc, getProp, rawType);
            JSType propDeclType = pt.declType;
            JSType propInferredFunType = pt.inferredFunType;
            boolean isConst = GlobalTypeInfoCollector.this.isConst(getProp);
            if (initializer != null && initializer.isFunction()) {
                parent.putBooleanProp((byte)76, true);
            }
            if (propDeclType != null || isConst) {
                this.mayWarnAboutExistingProp(rawType, pname, getProp, propDeclType);
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(getProp);
                }
                if (this.mayAddPropToType(getProp, rawType)) {
                    rawType.addInstanceProperty(pname, getProp, propDeclType, isConst);
                }
                if (isConst) {
                    getProp.putBooleanProp((byte)77, true);
                }
            } else if (this.mayAddPropToType(getProp, rawType)) {
                if (propInferredFunType != null) {
                    rawType.addUndeclaredInstanceProperty(pname, propInferredFunType, getProp);
                } else {
                    rawType.addUndeclaredInstanceProperty(pname, ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN, getProp);
                }
            }
            if (!GlobalTypeInfoCollector.this.propertyDefs.contains((Object)rawType, (Object)pname)) {
                GlobalTypeInfoCollector.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)new PropertyDef(getProp, null, null));
            }
        }

        private boolean isTranspiledLoopVariable(Node getProp) {
            Node recv = getProp.getFirstChild();
            return recv.isName() && recv.getString().startsWith("$jscomp$loop$");
        }

        private void visitOtherPropertyDeclaration(Node getProp) {
            Node recv;
            QualifiedName recvQname;
            Declaration d;
            Preconditions.checkArgument((boolean)getProp.isGetProp());
            Preconditions.checkArgument((boolean)getProp.isQualifiedName());
            if (GlobalTypeInfoCollector.isCtorWithoutFunctionLiteral(getProp)) {
                this.computeFnDeclaredType(NodeUtil.getBestJSDocInfo(getProp), getProp.getQualifiedName(), getProp, null, this.currentScope);
                return;
            }
            if (GlobalTypeInfoCollector.isAnnotatedAsConst(getProp) && !this.isTranspiledLoopVariable(getProp)) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(getProp, MISPLACED_CONST_ANNOTATION, new String[0]));
            }
            if ((d = this.currentScope.getDeclaration(recvQname = QualifiedName.fromNode(recv = getProp.getFirstChild()), false)) != null && d.getTypedef() != null) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(getProp, CANNOT_ADD_PROPERTIES_TO_TYPEDEF, new String[0]));
                getProp.getParent().putBooleanProp((byte)76, true);
                return;
            }
            if (GlobalTypeInfoCollector.isPrototypeProperty(getProp.getFirstChild())) {
                this.mayAddPropertyToPrototypeMethod(getProp);
                return;
            }
            JSType recvType = GlobalTypeInfoCollector.this.simpleInferExpr(recv, this.currentScope);
            if (recvType == null) {
                return;
            }
            NominalType nt = (recvType = recvType.removeType(((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().NULL_OR_UNDEFINED)).getNominalTypeIfSingletonObj();
            if (nt == null || nt.equals(GlobalTypeInfoCollector.this.getCommonTypes().getObjectType())) {
                return;
            }
            RawNominalType rawType = nt.getRawNominalType();
            String pname = getProp.getLastChild().getString();
            JSType declType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(NodeUtil.getBestJSDocInfo(getProp), this.currentScope);
            if (declType != null) {
                declType = declType.substituteGenericsWithUnknown();
                JSType prevType = rawType.getInstancePropDeclaredType(pname);
                if (nt.isFunction() && prevType != null) {
                    if ((declType = JSType.join(declType, prevType)).isBottom()) {
                        declType = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
                    }
                } else if (this.mayWarnAboutExistingProp(rawType, pname, getProp, declType)) {
                    return;
                }
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, declType);
            } else if (!rawType.mayHaveProp(pname)) {
                rawType.addPropertyWhichMayNotBeOnAllInstances(pname, null);
            }
        }

        void mayAddPropertyToPrototypeMethod(Node getProp) {
            JSType newPropType;
            Node protoProp = getProp.getFirstChild();
            if (!GlobalTypeInfoCollector.isPrototypeProperty(protoProp)) {
                return;
            }
            String protoPropName = protoProp.getLastChild().getString();
            QualifiedName rawtypeQname = QualifiedName.fromNode(protoProp.getFirstFirstChild());
            RawNominalType ownerType = this.currentScope.getNominalType(rawtypeQname);
            if (ownerType == null) {
                return;
            }
            PropertyDef def = (PropertyDef)GlobalTypeInfoCollector.this.propertyDefs.get((Object)ownerType, (Object)protoPropName);
            if (def == null || def.methodType == null) {
                return;
            }
            Node rhs = NodeUtil.getRValueOfLValue(getProp);
            JSType jSType = newPropType = rhs == null ? null : GlobalTypeInfoCollector.this.simpleInferExpr(rhs, this.currentScope);
            if (newPropType == null) {
                newPropType = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
            }
            if (newPropType.isConstructor() || newPropType.isInterfaceDefinition()) {
                return;
            }
            String newPropName = getProp.getLastChild().getString();
            JSType protoPropType = ownerType.getProtoPropDeclaredType(protoPropName);
            if (protoPropType == null) {
                protoPropType = GlobalTypeInfoCollector.this.getCommonTypes().fromFunctionType(def.methodType.toFunctionType());
            }
            ownerType.updateProtoProperty(protoPropName, protoPropType.withProperty(new QualifiedName(newPropName), newPropType));
        }

        boolean mayWarnAboutNoInit(Node constExpr) {
            if (constExpr.isFromExterns()) {
                return false;
            }
            Node initializer = NodeUtil.getRValueOfLValue(constExpr);
            if (initializer == null) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(constExpr, CONST_WITHOUT_INITIALIZER, new String[0]));
                return true;
            }
            return false;
        }

        private JSType mayInferFromRhsIfConst(Node lvalueNode) {
            JSDocInfo info = NodeUtil.getBestJSDocInfo(lvalueNode);
            if (info != null && info.containsFunctionDeclaration()) {
                return null;
            }
            if (GlobalTypeInfoCollector.this.isConst(lvalueNode) && !this.mayWarnAboutNoInit(lvalueNode)) {
                return this.inferConstTypeFromRhs(lvalueNode);
            }
            return null;
        }

        private JSType inferConstTypeFromRhs(Node constExpr) {
            boolean isUnescapedVar;
            if (constExpr.isFromExterns()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, this.getNodeNameForConstWarning(constExpr)));
                return null;
            }
            Node rhs = NodeUtil.getRValueOfLValue(constExpr);
            JSType rhsType = GlobalTypeInfoCollector.this.simpleInferExpr(rhs, this.currentScope);
            boolean bl = isUnescapedVar = constExpr.isName() && constExpr.getParent().isVar() && !this.currentScope.isEscapedVar(constExpr.getString());
            if ((rhsType == null || rhsType.isUnknown()) && !isUnescapedVar) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(constExpr, COULD_NOT_INFER_CONST_TYPE, this.getNodeNameForConstWarning(constExpr)));
                return null;
            }
            return rhsType;
        }

        private String getNodeNameForConstWarning(Node constExpr) {
            Preconditions.checkArgument((constExpr.isQualifiedName() || constExpr.isStringKey() ? 1 : 0) != 0, (Object)constExpr);
            return constExpr.isQualifiedName() ? constExpr.getQualifiedName() : constExpr.getString();
        }

        private boolean mayAddPropToType(Node getProp, RawNominalType rawType) {
            if (!rawType.isStruct()) {
                return true;
            }
            Node parent = getProp.getParent();
            return (parent.isAssign() && getProp == parent.getFirstChild() || parent.isExprResult()) && this.currentScope.isConstructor();
        }

        private boolean mayWarnAboutExistingProp(RawNominalType classType, String pname, Node propCreationNode, JSType typeInJsdoc) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propCreationNode);
            JSType previousPropType = classType.getInstancePropDeclaredType(pname);
            if (classType.mayHaveNonInheritedProp(pname) && previousPropType != null && !previousPropType.toString().endsWith("(Proxy)") && !this.suppressDupPropWarning(jsdoc, typeInJsdoc, previousPropType)) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(propCreationNode, REDECLARED_PROPERTY, pname, "type " + classType));
                return true;
            }
            return false;
        }

        private boolean suppressDupPropWarning(JSDocInfo propCreationJsdoc, JSType typeInJsdoc, JSType previousType) {
            if (propCreationJsdoc == null || !propCreationJsdoc.getSuppressions().contains("duplicate")) {
                return false;
            }
            return typeInJsdoc == null || typeInJsdoc.equals(previousType);
        }

        private DeclaredFunctionType computeFnDeclaredType(JSDocInfo fnDoc, String functionName, Node declNode, RawNominalType ownerType, NTIScope parentScope) {
            DeclaredFunctionType t;
            Preconditions.checkArgument((declNode.isFunction() || declNode.isQualifiedName() || declNode.isCall() ? 1 : 0) != 0);
            if (fnDoc == null && !NodeUtil.functionHasInlineJsdocs(declNode) && (t = this.getDeclaredFunctionTypeFromContext(functionName, declNode, parentScope)) != null) {
                return t;
            }
            RawNominalType ctorType = (RawNominalType)GlobalTypeInfoCollector.this.nominaltypesByNode.get(declNode);
            JSTypeCreatorFromJSDoc.FunctionAndSlotType result = GlobalTypeInfoCollector.this.getTypeParser().getFunctionType(fnDoc, functionName, declNode, ctorType, ownerType, parentScope);
            if (result.functionType.getReceiverType() == null) {
                JSType bindRecvType = this.getReceiverTypeOfBind(declNode);
                result.functionType = result.functionType.withReceiverType(bindRecvType);
            }
            Node qnameNode = declNode.isQualifiedName() ? declNode : (declNode.isFunction() ? NodeUtil.getNameNode(declNode) : NodeUtil.getBestLValue(declNode));
            if (result.slotType != null && qnameNode != null && qnameNode.isName()) {
                parentScope.addDeclaredLocal(qnameNode.getString(), result.slotType, false, qnameNode.isFromExterns());
            }
            if (ctorType != null) {
                FunctionType ft = result.functionType.toFunctionType();
                ctorType.setCtorFunction(ft);
                if (ctorType.isBuiltinObject()) {
                    GlobalTypeInfoCollector.this.getCommonTypes().getLiteralObjNominalType().getRawNominalType().setCtorFunction(ft);
                }
            }
            if (declNode.isFunction()) {
                this.maybeWarnFunctionDeclaration(declNode, result.functionType);
            }
            return result.functionType;
        }

        private void maybeWarnFunctionDeclaration(Node funNode, DeclaredFunctionType funType) {
            JSType returnType;
            if (funNode.getParent().isSetterDef() && (returnType = funType.getReturnType()) != null && !returnType.isUnknown() && !returnType.isUndefined()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(funNode, SETTER_WITH_RETURN, new String[0]));
            }
            int declaredArity = funType.getOptionalArity();
            int parameterCount = funNode.getSecondChild().getChildCount();
            if (!funType.hasRestFormals() && parameterCount != declaredArity) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(funNode, WRONG_PARAMETER_COUNT, String.valueOf(declaredArity), String.valueOf(parameterCount)));
            }
        }

        private DeclaredFunctionType computeFnDeclaredTypeFromCallee(Node callback, JSType declaredTypeAsJSType) {
            Preconditions.checkArgument((boolean)callback.isFunction());
            Preconditions.checkArgument((boolean)callback.getParent().isCall());
            if (declaredTypeAsJSType == null) {
                return null;
            }
            FunctionType funType = declaredTypeAsJSType.getFunType();
            if (funType == null || funType.isUniqueConstructor() || funType.isInterfaceDefinition()) {
                return null;
            }
            DeclaredFunctionType declType = funType.toDeclaredFunctionType();
            if (declType == null) {
                return null;
            }
            return NodeUtil.getApproxRequiredArity(callback) <= declType.getMaxArity() ? declType : null;
        }

        private DeclaredFunctionType getDeclaredFunctionTypeFromContext(String functionName, Node declNode, NTIScope parentScope) {
            Node parent = declNode.getParent();
            if (parent.isCast()) {
                JSDocInfo jsdoc = parent.getJSDocInfo();
                JSType castType = GlobalTypeInfoCollector.this.getDeclaredTypeOfNode(jsdoc, parentScope);
                FunctionType funType = castType.getFunType();
                if (funType != null) {
                    return funType.toDeclaredFunctionType();
                }
                return null;
            }
            JSType bindRecvType = this.getReceiverTypeOfBind(declNode);
            if (bindRecvType != null) {
                DeclaredFunctionType allButRecvType = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getTypeParser().getFunctionType(null, (String)functionName, (Node)declNode, null, null, (DeclaredTypeRegistry)parentScope).functionType;
                return allButRecvType.withReceiverType(bindRecvType);
            }
            if (NodeUtil.isUnannotatedCallback(declNode)) {
                FunctionType calleeFunType;
                Node callee = parent.getFirstChild();
                JSType calleeType = GlobalTypeInfoCollector.this.simpleInferExpr(callee, this.currentScope);
                FunctionType functionType = calleeFunType = calleeType == null ? null : calleeType.getFunType();
                if (calleeFunType != null) {
                    if (calleeFunType.isGeneric() && (calleeFunType = GlobalTypeInfoCollector.this.simpleInferInstantiatedCallee(parent, calleeFunType, false, this.currentScope)) == null) {
                        return null;
                    }
                    int index = parent.getIndexOfChild(declNode) - 1;
                    JSType callbackType = calleeFunType.getFormalType(index);
                    DeclaredFunctionType t = this.computeFnDeclaredTypeFromCallee(declNode, callbackType);
                    if (t != null) {
                        return t;
                    }
                }
            }
            return null;
        }

        private JSType getReceiverTypeOfBind(Node funDeclNode) {
            Node maybeBind;
            Node parent = funDeclNode.getParent();
            Node node = maybeBind = parent.isCall() ? parent.getFirstChild() : parent;
            if (NodeUtil.isFunctionBind(maybeBind) && !NodeUtil.isGoogPartial(maybeBind)) {
                Node call = maybeBind.getParent();
                CodingConvention.Bind bindComponents = GlobalTypeInfoCollector.this.convention.describeFunctionBind(call, true, false);
                return bindComponents.thisValue == null ? null : GlobalTypeInfoCollector.this.simpleInferExpr(bindComponents.thisValue, this.currentScope);
            }
            return null;
        }

        private void mayAddPropToPrototype(RawNominalType rawType, String pname, Node defSite, Node initializer) {
            FunctionType ft;
            NTIScope methodScope = null;
            DeclaredFunctionType methodType = null;
            JSType propDeclType = null;
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(defSite);
            if (initializer != null && initializer.isFunction()) {
                methodScope = this.visitFunctionLate(initializer, rawType);
                methodType = methodScope.getDeclaredFunctionType();
                if (defSite.isGetterDef()) {
                    pname = GlobalTypeInfoCollector.this.getCommonTypes().createGetterPropName(pname);
                } else if (defSite.isSetterDef()) {
                    pname = GlobalTypeInfoCollector.this.getCommonTypes().createSetterPropName(pname);
                }
            } else if (jsdoc != null && jsdoc.containsFunctionDeclaration() && !defSite.isStringKey()) {
                methodType = this.computeFnDeclaredType(jsdoc, pname, defSite, rawType, this.currentScope);
            }
            if (jsdoc != null && jsdoc.hasType()) {
                propDeclType = GlobalTypeInfoCollector.this.getTypeParser().getDeclaredTypeOfNode(jsdoc, rawType, this.currentScope);
                if ((defSite.isGetterDef() || defSite.isSetterDef()) && propDeclType != null && !propDeclType.isFunctionType()) {
                    propDeclType = null;
                }
            } else if (methodType != null) {
                propDeclType = GlobalTypeInfoCollector.this.getCommonTypes().fromFunctionType(methodType.toFunctionType());
            }
            if (defSite.isGetterDef() && propDeclType != null && (ft = propDeclType.getFunTypeIfSingletonObj()) != null) {
                propDeclType = ft.getReturnType();
            }
            PropertyDef def = new PropertyDef(defSite, methodType, methodScope);
            GlobalTypeInfoCollector.this.propertyDefs.put((Object)rawType, (Object)pname, (Object)def);
            if (methodType != null && methodType.isAbstract() && !rawType.isAbstractClass()) {
                if (rawType.isClass()) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, ABSTRACT_METHOD_IN_CONCRETE_CLASS, rawType.getName()));
                } else if (rawType.isInterface()) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, ABSTRACT_METHOD_IN_INTERFACE, new String[0]));
                }
            }
            boolean isConst = GlobalTypeInfoCollector.this.isConst(defSite);
            if (propDeclType != null || isConst) {
                if (this.mayWarnAboutExistingProp(rawType, pname, defSite, propDeclType)) {
                    return;
                }
                if (propDeclType == null) {
                    propDeclType = this.mayInferFromRhsIfConst(defSite);
                }
                rawType.addProtoProperty(pname, defSite, propDeclType, isConst);
                if (defSite.isGetProp()) {
                    defSite.putBooleanProp((byte)76, true);
                    if (isConst) {
                        defSite.putBooleanProp((byte)77, true);
                    }
                }
            } else {
                JSType inferredType = null;
                if (initializer != null) {
                    inferredType = GlobalTypeInfoCollector.this.simpleInferExpr(initializer, this.currentScope);
                }
                if (inferredType == null) {
                    inferredType = ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN;
                }
                rawType.addUndeclaredProtoProperty(pname, defSite, inferredType);
            }
        }

        private RawNominalType maybeGetOwnerType(Node funNode, Node parent) {
            QualifiedName qname;
            Node recv;
            Preconditions.checkArgument((boolean)funNode.isFunction());
            if (parent.isAssign() && parent.getFirstChild().isGetElem() && (recv = parent.getFirstFirstChild()).isGetProp() && recv.getLastChild().getString().equals("prototype") && (qname = QualifiedName.fromNode(recv.getFirstChild())) != null) {
                return this.currentScope.getNominalType(qname);
            }
            return null;
        }

        private boolean isNamedType(Node getProp) {
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(getProp);
            if (jsdoc != null && jsdoc.hasType() && !jsdoc.containsFunctionDeclaration()) {
                return false;
            }
            return this.currentScope.isNamespace(getProp) || NodeUtil.isTypedefDecl(getProp);
        }
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final NTIScope currentScope;
        private Node nameNodeDefiningWindow = null;

        CollectNamedTypes(NTIScope s) {
            this.currentScope = s;
        }

        void collectNamedTypesInExterns() {
            for (Node definition : GlobalTypeInfoCollector.this.orderedExterns) {
                this.visitNode(definition);
            }
            if (this.nameNodeDefiningWindow != null) {
                this.visitWindowVar(this.nameNodeDefiningWindow);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            this.visitNode(n);
        }

        public void visitNode(Node n) {
            switch (n.getToken()) {
                case FUNCTION: {
                    this.visitFunctionEarly(n);
                    break;
                }
                case VAR: {
                    this.visitVar(n);
                    break;
                }
                case NAME: {
                    this.visitName(n);
                    break;
                }
                case EXPR_RESULT: {
                    this.visitExprResult(n);
                    break;
                }
            }
        }

        private void visitExprResult(Node n) {
            Preconditions.checkArgument((boolean)n.isExprResult());
            Node expr = n.getFirstChild();
            switch (expr.getToken()) {
                case ASSIGN: {
                    Node lhs = expr.getFirstChild();
                    if (GlobalTypeInfoCollector.isCtorDefinedByCall(lhs)) {
                        this.visitNewCtorDefinedByCall(lhs);
                        return;
                    }
                    if (!lhs.isGetProp()) {
                        return;
                    }
                    expr = lhs;
                }
                case GETPROP: {
                    if (GlobalTypeInfoCollector.isCtorWithoutFunctionLiteral(expr)) {
                        this.visitNewCtorWithoutFunctionLiteral(expr);
                        return;
                    }
                    if (GlobalTypeInfoCollector.isPrototypeProperty(expr) || NodeUtil.referencesThis(expr) || !expr.isQualifiedName()) {
                        return;
                    }
                    this.processQualifiedDefinition(expr);
                    break;
                }
            }
        }

        private void visitName(Node n) {
            Preconditions.checkArgument((boolean)n.isName());
            if (this.currentScope.isFunction()) {
                NTIScope.mayRecordEscapedVar(this.currentScope, n.getString());
            }
        }

        private void visitVar(Node n) {
            Preconditions.checkArgument((boolean)n.isVar());
            Node nameNode = n.getFirstChild();
            String varName = nameNode.getString();
            if (NodeUtil.isNamespaceDecl(nameNode)) {
                this.visitObjlitNamespace(new QualifiedName(varName), nameNode);
            } else if (NodeUtil.isTypedefDecl(nameNode)) {
                this.visitTypedef(nameNode);
            } else if (NodeUtil.isEnumDecl(nameNode)) {
                this.visitEnum(nameNode);
            } else if (GlobalTypeInfoCollector.this.isAliasedTypedef(nameNode, this.currentScope)) {
                this.visitAliasedTypedef(nameNode);
            } else if (this.isAliasedNamespaceDefinition(nameNode)) {
                this.visitAliasedNamespace(new QualifiedName(varName), nameNode);
            } else if (varName.equals(GlobalTypeInfoCollector.WINDOW_INSTANCE) && nameNode.isFromExterns()) {
                this.nameNodeDefiningWindow = nameNode;
                this.currentScope.addDeclaredLocal(GlobalTypeInfoCollector.WINDOW_INSTANCE, ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN, false, true);
            } else if (GlobalTypeInfoCollector.isCtorDefinedByCall(nameNode)) {
                this.visitNewCtorDefinedByCall(nameNode);
            } else if (GlobalTypeInfoCollector.isCtorWithoutFunctionLiteral(nameNode)) {
                this.visitNewCtorWithoutFunctionLiteral(nameNode);
            }
            if (!n.isFromExterns() && !this.currentScope.isDefinedLocally(varName, false)) {
                this.currentScope.addDeclaredLocal(varName, ((GlobalTypeInfoCollector)GlobalTypeInfoCollector.this).getCommonTypes().UNKNOWN, false, false);
            }
        }

        private void visitWindowVar(Node nameNode) {
            NominalType maybeWin;
            NTIScope scope = GlobalTypeInfoCollector.this.getGlobalScope();
            JSType typeInJsdoc = GlobalTypeInfoCollector.this.getVarTypeFromAnnotation(nameNode, scope);
            if (!scope.isDefinedLocally(GlobalTypeInfoCollector.WINDOW_INSTANCE, false)) {
                scope.addDeclaredLocal(GlobalTypeInfoCollector.WINDOW_INSTANCE, typeInJsdoc, false, true);
                return;
            }
            NominalType nominalType = maybeWin = typeInJsdoc == null ? null : typeInJsdoc.getNominalTypeIfSingletonObj();
            if (maybeWin != null && maybeWin.getName().equals(GlobalTypeInfoCollector.WINDOW_CLASS)) {
                scope.addDeclaredLocal(GlobalTypeInfoCollector.WINDOW_INSTANCE, typeInJsdoc, false, true);
            }
        }

        private void processQualifiedDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node recv = qnameNode.getFirstChild();
            if (!(this.currentScope.isNamespace(recv) || this.mayCreateFunctionNamespace(recv) || this.mayCreateWindowNamespace(recv))) {
                return;
            }
            if (NodeUtil.isNamespaceDecl(qnameNode)) {
                this.visitObjlitNamespace(QualifiedName.fromNode(qnameNode), qnameNode);
            } else if (NodeUtil.isTypedefDecl(qnameNode)) {
                this.visitTypedef(qnameNode);
            } else if (NodeUtil.isEnumDecl(qnameNode)) {
                this.visitEnum(qnameNode);
            } else if (GlobalTypeInfoCollector.this.isAliasedTypedef(qnameNode, this.currentScope)) {
                this.visitAliasedTypedef(qnameNode);
            } else if (this.isAliasedNamespaceDefinition(qnameNode)) {
                this.visitAliasedNamespace(QualifiedName.fromNode(qnameNode), qnameNode);
            } else if (this.isAliasingGlobalThis(qnameNode)) {
                this.visitGlobalThisAlias(qnameNode);
            } else if (this.isQualifiedFunctionDefinition(qnameNode)) {
                this.maybeAddFunctionToNamespace(qnameNode);
            }
        }

        private boolean isAliasingGlobalThis(Node qnameNode) {
            return GlobalTypeInfoCollector.this.convention.isAliasingGlobalThis(qnameNode.getParent()) && this.currentScope.isTopLevel();
        }

        private void visitGlobalThisAlias(Node qnameNode) {
            Namespace ns = GlobalTypeInfoCollector.this.getGlobalScope().getNamespace(GlobalTypeInfoCollector.WINDOW_INSTANCE);
            if (ns != null) {
                qnameNode.getParent().putBooleanProp((byte)76, true);
                this.currentScope.addNamespace(qnameNode, ns);
            }
        }

        private boolean isAliasedNamespaceDefinition(Node qnameNode) {
            Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
            if (rhs == null || !rhs.isQualifiedName()) {
                return false;
            }
            Node parent = qnameNode.getParent();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            if (jsdoc != null) {
                return jsdoc.isConstructorOrInterface() || jsdoc.hasConstAnnotation();
            }
            if (qnameNode.isName() && !parent.isVar()) {
                return false;
            }
            if (!this.currentScope.isNamespace(rhs)) {
                return false;
            }
            return qnameNode.isFromExterns() || qnameNode.isGetProp() && qnameNode.getLastChild().getString().equals("default") || qnameNode.isStringKey() && this.currentScope.isNamespace(NodeUtil.getBestLValue(parent));
        }

        private boolean isQualifiedFunctionDefinition(Node qnameNode) {
            Preconditions.checkArgument((boolean)qnameNode.isGetProp());
            Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
            Node parent = qnameNode.getParent();
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            return parent.isAssign() && parent.getParent().isExprResult() && parent.getLastChild().isFunction() && (jsdoc == null || jsdoc.containsFunctionDeclaration());
        }

        private boolean mayCreateFunctionNamespace(Node qnameNode) {
            if (!qnameNode.isQualifiedName()) {
                return false;
            }
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Preconditions.checkState((!this.currentScope.isNamespace(qname) ? 1 : 0) != 0);
            if (!this.currentScope.isKnownFunction(qname)) {
                return false;
            }
            if (qnameNode.isGetProp()) {
                this.markAssignNodeAsAnalyzed(qnameNode.getGrandparent());
            }
            NTIScope s = qnameNode.isName() ? this.currentScope.getScope(qnameNode.getString()).getParent() : this.currentScope;
            s.addFunNamespace(qnameNode);
            return true;
        }

        private boolean mayCreateWindowNamespace(Node qnameNode) {
            if (qnameNode.isName() && qnameNode.getString().equals(GlobalTypeInfoCollector.WINDOW_INSTANCE) && this.currentScope.isGlobalVar(GlobalTypeInfoCollector.WINDOW_INSTANCE)) {
                GlobalTypeInfoCollector.this.getGlobalScope().addNamespaceLit(new QualifiedName(GlobalTypeInfoCollector.WINDOW_INSTANCE), qnameNode);
                return true;
            }
            return false;
        }

        private void visitObjlitNamespace(QualifiedName qname, Node defSite) {
            if (defSite.isGetProp()) {
                this.markAssignNodeAsAnalyzed(defSite.getParent());
            }
            if (this.currentScope.isDefined(qname)) {
                if (defSite.isGetProp() && !NodeUtil.getRValueOfLValue(defSite).isOr()) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, REDECLARED_PROPERTY, defSite.getLastChild().getString(), defSite.getFirstChild().getQualifiedName()));
                }
                return;
            }
            this.currentScope.addNamespaceLit(qname, defSite);
            Node maybeObjlit = NodeUtil.getRValueOfLValue(defSite);
            if (maybeObjlit.isOr()) {
                maybeObjlit = maybeObjlit.getLastChild();
            }
            Preconditions.checkState((boolean)maybeObjlit.isObjectLit(), (String)"Expected object literal, found %s", (Object)maybeObjlit);
            for (Node propNode : maybeObjlit.children()) {
                if (!propNode.isStringKey()) continue;
                QualifiedName propQname = new QualifiedName(propNode.getString());
                if (this.isAliasedNamespaceDefinition(propNode)) {
                    this.visitAliasedNamespace(QualifiedName.join(qname, propQname), propNode);
                    continue;
                }
                JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(propNode);
                Node propVal = propNode.getLastChild();
                if (jsdoc == null || !jsdoc.hasConstAnnotation() || !propVal.isObjectLit()) continue;
                this.visitObjlitNamespace(QualifiedName.join(qname, propQname), propNode);
            }
        }

        private void markAssignNodeAsAnalyzed(Node maybeAssign) {
            if (maybeAssign.isAssign()) {
                maybeAssign.putBooleanProp((byte)76, true);
            } else {
                Preconditions.checkState((boolean)maybeAssign.isExprResult());
            }
        }

        private void visitTypedef(Node qnameNode) {
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp((byte)76, true);
            if (NodeUtil.getRValueOfLValue(qnameNode) != null) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(qnameNode, CANNOT_INIT_TYPEDEF, new String[0]));
            }
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Typedef td = Typedef.make(qnameNode, jsdoc.getTypedefType());
            this.currentScope.addTypedef(qnameNode, td);
        }

        private void visitEnum(Node qnameNode) {
            EnumType et;
            Preconditions.checkState((boolean)qnameNode.isQualifiedName());
            qnameNode.putBooleanProp((byte)76, true);
            if (this.currentScope.isDefined(qnameNode)) {
                return;
            }
            Node init = NodeUtil.getRValueOfLValue(qnameNode);
            if (init != null && init.isQualifiedName() && (et = this.currentScope.getEnum(QualifiedName.fromNode(init))) != null) {
                this.currentScope.addNamespace(qnameNode, et);
                return;
            }
            if (init == null || !init.isObjectLit() || init.getFirstChild() == null) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(qnameNode, MALFORMED_ENUM, new String[0]));
                return;
            }
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            LinkedHashSet<String> propNames = new LinkedHashSet<String>();
            for (Node prop : init.children()) {
                String pname = NodeUtil.getObjectLitKeyName(prop);
                if (propNames.contains(pname)) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(qnameNode, DUPLICATE_PROP_IN_ENUM, pname));
                }
                GlobalTypeInfoCollector.this.recordPropertyName(prop);
                propNames.add(pname);
            }
            this.currentScope.addNamespace(qnameNode, EnumType.make(GlobalTypeInfoCollector.this.getCommonTypes(), qnameNode.getQualifiedName(), qnameNode, jsdoc.getEnumParameterType(), (Collection<String>)ImmutableSet.copyOf(propNames)));
        }

        private void visitFunctionEarly(Node fn) {
            boolean isRedeclaration;
            JSDocInfo fnDoc = NodeUtil.getBestJSDocInfo(fn);
            Node nameNode = NodeUtil.getNameNode(fn);
            String internalName = this.createFunctionInternalName(fn, nameNode);
            if (nameNode == null || !nameNode.isQualifiedName()) {
                isRedeclaration = false;
            } else if (nameNode.isName()) {
                isRedeclaration = this.currentScope.isDefinedLocally(nameNode.getString(), false);
            } else {
                Preconditions.checkState((boolean)nameNode.isGetProp(), (String)"Expected getprop, found %s", (Object)((Object)nameNode.getToken()));
                isRedeclaration = this.currentScope.isDefined(nameNode);
                if (isRedeclaration && fnDoc != null) {
                    nameNode.getParent().putBooleanProp((byte)76, true);
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(nameNode, REDECLARED_PROPERTY, nameNode.getLastChild().getString(), nameNode.getFirstChild().getQualifiedName()));
                }
            }
            NTIScope fnScope = new NTIScope(fn, this.currentScope, this.collectFormals(fn, fnDoc), GlobalTypeInfoCollector.this.getCommonTypes());
            if (!fn.isFromExterns()) {
                GlobalTypeInfoCollector.this.scopes.add(fnScope);
            }
            this.currentScope.addLocalFunDef(internalName, fnScope);
            this.maybeRecordNominalType(fn, nameNode, fnDoc, isRedeclaration);
        }

        private String createFunctionInternalName(Node fn, Node nameNode) {
            String internalName = null;
            if (nameNode == fn.getFirstChild() && !NodeUtil.isFunctionDeclaration(fn)) {
                nameNode = null;
            }
            if (nameNode == null || !nameNode.isName() || nameNode.getParent().isAssign()) {
                internalName = GlobalTypeInfoCollector.ANON_FUN_PREFIX + GlobalTypeInfoCollector.this.funNameGen.generateNextName();
                GlobalTypeInfoCollector.this.getAnonFunNames().put(fn, internalName);
            } else if (this.currentScope.isDefinedLocally(nameNode.getString(), false)) {
                String fnName = nameNode.getString();
                Preconditions.checkState((!fnName.contains(".") ? 1 : 0) != 0);
                internalName = GlobalTypeInfoCollector.ANON_FUN_PREFIX + GlobalTypeInfoCollector.this.funNameGen.generateNextName();
                GlobalTypeInfoCollector.this.getAnonFunNames().put(fn, internalName);
            } else {
                internalName = nameNode.getString();
            }
            return internalName;
        }

        private ArrayList<String> collectFormals(Node fn, JSDocInfo fnDoc) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            ArrayList<String> formals = new ArrayList<String>();
            ArrayList<String> tmpRestFormals = new ArrayList<String>();
            for (Node param = NodeUtil.getFunctionParameters(fn).getFirstChild(); param != null; param = param.getNext()) {
                if (JSTypeCreatorFromJSDoc.isRestArg(fnDoc, param.getString()) && param.getNext() == null) {
                    tmpRestFormals.add(param.getString());
                    continue;
                }
                formals.add(param.getString());
            }
            if (fnDoc != null) {
                for (String formalInJsdoc : fnDoc.getParameterNames()) {
                    if (formals.contains(formalInJsdoc) || tmpRestFormals.contains(formalInJsdoc)) continue;
                    String functionName = NodeUtil.getNearestFunctionName(fn);
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(fn, INEXISTENT_PARAM, formalInJsdoc, functionName));
                }
            }
            return formals;
        }

        private void maybeRecordNominalType(Node defSite, Node nameNode, JSDocInfo fnDoc, boolean isRedeclaration) {
            Preconditions.checkState((nameNode == null || nameNode.isQualifiedName() ? 1 : 0) != 0);
            if (fnDoc == null) {
                return;
            }
            if (fnDoc.isConstructorOrInterface()) {
                RawNominalType rawType;
                ObjectKind objKind;
                if (nameNode == null) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, ANONYMOUS_NOMINAL_TYPE, new String[0]));
                    nameNode = IR.name(GlobalTypeInfoCollector.ANON_FUN_PREFIX + GlobalTypeInfoCollector.this.funNameGen.generateNextName());
                    nameNode.useSourceInfoFrom(defSite);
                }
                String qname = nameNode.getQualifiedName();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String typeParam : fnDoc.getTemplateTypeNames()) {
                    builder.add((Object)GlobalTypeInfoCollector.this.getVarNameGen().getNextName(typeParam));
                }
                ImmutableList typeParameters = builder.build();
                ObjectKind objectKind = fnDoc.makesStructs() ? ObjectKind.STRUCT : (objKind = fnDoc.makesDicts() ? ObjectKind.DICT : ObjectKind.UNRESTRICTED);
                if (fnDoc.isConstructor()) {
                    rawType = RawNominalType.makeClass(GlobalTypeInfoCollector.this.getCommonTypes(), defSite, qname, (ImmutableList<String>)typeParameters, objKind, fnDoc.isAbstract());
                } else if (fnDoc.usesImplicitMatch()) {
                    rawType = RawNominalType.makeStructuralInterface(GlobalTypeInfoCollector.this.getCommonTypes(), defSite, qname, (ImmutableList<String>)typeParameters, objKind);
                } else {
                    Preconditions.checkState((boolean)fnDoc.isInterface());
                    rawType = RawNominalType.makeNominalInterface(GlobalTypeInfoCollector.this.getCommonTypes(), defSite, qname, (ImmutableList<String>)typeParameters, objKind);
                }
                if (GlobalTypeInfoCollector.isWindowRawType(rawType)) {
                    GlobalTypeInfoCollector.this.setWindow(rawType);
                }
                GlobalTypeInfoCollector.this.nominaltypesByNode.put(defSite, rawType);
                if (isRedeclaration) {
                    return;
                }
                Node firstChild = nameNode.getFirstChild();
                if (nameNode.isName() || this.currentScope.isNamespace(firstChild) || this.mayCreateFunctionNamespace(firstChild) || this.mayCreateWindowNamespace(firstChild)) {
                    if (nameNode.isGetProp()) {
                        if (defSite.isFunction()) {
                            defSite.getParent().putBooleanProp((byte)76, true);
                        } else {
                            defSite.getParent().getFirstChild().putBooleanProp((byte)76, true);
                        }
                    } else if (this.currentScope.isTopLevel()) {
                        this.maybeRecordBuiltinType(qname, rawType);
                    }
                    this.currentScope.addNamespace(nameNode, rawType);
                }
            } else if (fnDoc.makesStructs()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, STRUCT_WITHOUT_CTOR_OR_INTERF, new String[0]));
            }
            if (fnDoc.makesDicts() && !fnDoc.isConstructor()) {
                GlobalTypeInfoCollector.this.warnings.add(JSError.make(defSite, DICT_WITHOUT_CTOR, new String[0]));
            }
        }

        private void maybeRecordBuiltinType(String name, RawNominalType rawType) {
            switch (name) {
                case "Arguments": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setArgumentsType(rawType);
                    break;
                }
                case "Function": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setFunctionType(rawType);
                    break;
                }
                case "Object": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setObjectType(rawType);
                    RawNominalType objLitRawType = RawNominalType.makeClass(GlobalTypeInfoCollector.this.getCommonTypes(), rawType.getDefSite(), "Object{}", (ImmutableList<String>)ImmutableList.of(), ObjectKind.UNRESTRICTED, false);
                    objLitRawType.addSuperClass(rawType.getAsNominalType());
                    GlobalTypeInfoCollector.this.getCommonTypes().setLiteralObjNominalType(objLitRawType);
                    break;
                }
                case "Number": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setNumberInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "String": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setStringInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "Boolean": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setBooleanInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "RegExp": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setRegexpInstance(rawType.getInstanceAsJSType());
                    break;
                }
                case "Array": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setArrayType(rawType);
                    break;
                }
                case "IObject": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setIObjectType(rawType);
                    break;
                }
                case "IArrayLike": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setIArrayLikeType(rawType);
                    break;
                }
                case "Iterable": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setIterableType(rawType);
                    break;
                }
                case "Iterator": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setIteratorType(rawType);
                    break;
                }
                case "IIterableResult": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setIIterableResultType(rawType);
                    break;
                }
                case "Generator": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setGeneratorType(rawType);
                    break;
                }
                case "ITemplateArray": {
                    GlobalTypeInfoCollector.this.getCommonTypes().setITemplateArrayType(rawType);
                    break;
                }
            }
        }

        private void visitAliasedNamespace(QualifiedName qname, Node lhs) {
            if (this.currentScope.isDefined(qname)) {
                return;
            }
            Node rhs = NodeUtil.getRValueOfLValue(lhs);
            QualifiedName rhsQname = QualifiedName.fromNode(rhs);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(lhs);
            Namespace ns = this.currentScope.getNamespace(rhsQname);
            if (jsdoc != null && jsdoc.isConstructorOrInterface()) {
                RawNominalType rawType;
                RawNominalType rawNominalType = rawType = ns instanceof RawNominalType ? (RawNominalType)ns : null;
                if (jsdoc.isConstructor() && (rawType == null || rawType.isInterface())) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(rhs, EXPECTED_CONSTRUCTOR, rhsQname.toString()));
                    return;
                }
                if (jsdoc.isInterface() && (rawType == null || rawType.isClass())) {
                    GlobalTypeInfoCollector.this.warnings.add(JSError.make(rhs, EXPECTED_INTERFACE, rhsQname.toString()));
                    return;
                }
            }
            if (ns != null) {
                lhs.getParent().putBooleanProp((byte)76, true);
                this.currentScope.addNamespace(qname, lhs, ns);
            }
        }

        private void visitAliasedTypedef(Node lhs) {
            if (this.currentScope.isDefined(lhs)) {
                return;
            }
            lhs.getParent().putBooleanProp((byte)76, true);
            Typedef td = (Typedef)Preconditions.checkNotNull((Object)GlobalTypeInfoCollector.this.getAliasedTypedef(lhs, this.currentScope));
            this.currentScope.addTypedef(lhs, td);
        }

        private void maybeAddFunctionToNamespace(Node funQname) {
            Namespace ns = this.currentScope.getNamespace(QualifiedName.fromNode(funQname.getFirstChild()));
            String internalName = GlobalTypeInfoCollector.this.getFunInternalName(funQname.getParent().getLastChild());
            NTIScope s = this.currentScope.getScope(internalName);
            QualifiedName pname = new QualifiedName(funQname.getLastChild().getString());
            if (!ns.isDefined(pname)) {
                ns.addNamespace(pname, new FunctionNamespace(GlobalTypeInfoCollector.this.getCommonTypes(), funQname.getQualifiedName(), s, funQname));
            }
        }

        private void visitNewCtorDefinedByCall(Node qnameNode) {
            Preconditions.checkState((qnameNode.isName() || qnameNode.isGetProp() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            Node rhs = NodeUtil.getRValueOfLValue(qnameNode);
            this.maybeRecordNominalType(rhs, qnameNode, jsdoc, false);
        }

        private void visitNewCtorWithoutFunctionLiteral(Node qnameNode) {
            Preconditions.checkState((qnameNode.isName() || qnameNode.isGetProp() ? 1 : 0) != 0);
            JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(qnameNode);
            this.maybeRecordNominalType(qnameNode, qnameNode, jsdoc, false);
        }
    }

    private static class OrderedExterns
    extends NodeTraversal.AbstractShallowCallback
    implements Iterable<Node> {
        final ListMultimap<Integer, Node> orderedExternDefs = MultimapBuilder.treeKeys().arrayListValues().build();

        private OrderedExterns() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case VAR: 
                case FUNCTION: {
                    this.addDefinition(n);
                    break;
                }
                case EXPR_RESULT: {
                    Node expr = n.getFirstChild();
                    if (!expr.isAssign() && !expr.isGetProp()) break;
                    this.addDefinition(n);
                    break;
                }
            }
        }

        Node getDefinedQname(Node definition) {
            switch (definition.getToken()) {
                case VAR: {
                    return definition.getFirstChild();
                }
                case FUNCTION: {
                    Node name = NodeUtil.getNameNode(definition);
                    return name == null ? definition.getFirstChild() : name;
                }
                case EXPR_RESULT: {
                    Node expr = definition.getFirstChild();
                    if (expr.isGetProp()) {
                        return expr;
                    }
                    Preconditions.checkState((boolean)expr.isAssign(), (String)"Expected assignment, found %s", (Object)expr);
                    return expr.getFirstChild();
                }
            }
            throw new RuntimeException("Unexpected definition " + definition);
        }

        void addDefinition(Node definition) {
            Node qname = this.getDefinedQname(definition);
            int len = NodeUtil.getLengthOfQname(qname);
            this.orderedExternDefs.put((Object)len, (Object)definition);
        }

        @Override
        public Iterator<Node> iterator() {
            return this.orderedExternDefs.values().iterator();
        }
    }
}

