/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.newtypes.Declaration;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionNamespace;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NamespaceLit;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeIEnv;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class NTIScope
implements DeclaredTypeRegistry,
Serializable,
TypeIEnv<JSType> {
    private final NTIScope parent;
    private final Node root;
    private final String name;
    private final JSTypes commonTypes;
    private boolean isFrozen = false;
    private final Map<String, LocalVarInfo> locals = new LinkedHashMap<String, LocalVarInfo>();
    private final Map<String, JSType> externs;
    private final Set<String> constVars = new LinkedHashSet<String>();
    private final List<String> formals;
    private final Set<String> outerVars = new LinkedHashSet<String>();
    private final Map<String, NTIScope> localFunDefs = new LinkedHashMap<String, NTIScope>();
    private ImmutableSet<String> unknownTypeNames = ImmutableSet.of();
    private final Map<String, Typedef> localTypedefs = new LinkedHashMap<String, Typedef>();
    private Set<Typedef> namespaceTypedefs = new LinkedHashSet<Typedef>();
    private Map<String, Namespace> localNamespaces = new LinkedHashMap<String, Namespace>();
    private Map<String, Namespace> preservedNamespaces;
    private Set<EnumType> localEnums = new LinkedHashSet<EnumType>();
    private DeclaredFunctionType declaredType;
    private DeclaredFunctionType declaredTypeForOwnBody;

    NTIScope(Node root, NTIScope parent, List<String> formals, JSTypes commonTypes) {
        Preconditions.checkNotNull((Object)commonTypes);
        if (parent == null) {
            this.name = null;
            this.externs = new LinkedHashMap<String, JSType>();
        } else {
            String nameOnAst = root.getFirstChild().getString();
            this.name = nameOnAst.isEmpty() ? null : nameOnAst;
            this.externs = ImmutableMap.of();
        }
        this.root = root;
        this.parent = parent;
        this.formals = formals;
        this.commonTypes = commonTypes;
    }

    Node getRoot() {
        return this.root;
    }

    NTIScope getParent() {
        return this.parent;
    }

    Node getBody() {
        Preconditions.checkArgument((boolean)this.root.isFunction());
        return NodeUtil.getFunctionBody(this.root);
    }

    String getReadableName() {
        return this.isTopLevel() ? null : NodeUtil.getName(this.root);
    }

    String getName() {
        return this.name;
    }

    @Override
    public JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    void setDeclaredType(DeclaredFunctionType declaredType) {
        Preconditions.checkNotNull((Object)declaredType);
        this.declaredType = this.declaredTypeForOwnBody = declaredType;
        if (this.root.isFromExterns()) {
            this.root.setTypeI(this.commonTypes.fromFunctionType(declaredType.toFunctionType()));
        }
        if (!declaredType.getTypeParameters().getTypeTransformations().isEmpty()) {
            this.declaredTypeForOwnBody = declaredType.instantiateGenericsWithUnknown();
        }
    }

    @Override
    public DeclaredFunctionType getDeclaredFunctionType() {
        return this.declaredType;
    }

    public DeclaredFunctionType getDeclaredTypeForOwnBody() {
        return this.declaredTypeForOwnBody;
    }

    boolean isFunction() {
        return this.root.isFunction();
    }

    boolean isTopLevel() {
        return this.parent == null;
    }

    boolean isConstructor() {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(this.root);
        return this.isFunction() && jsdoc != null && jsdoc.isConstructor();
    }

    boolean isInterface() {
        JSDocInfo jsdoc = NodeUtil.getBestJSDocInfo(this.root);
        return this.isFunction() && jsdoc != null && jsdoc.isInterface();
    }

    boolean isPrototypeMethod() {
        Preconditions.checkArgument((this.root != null ? 1 : 0) != 0);
        return NodeUtil.isPrototypeMethod(this.root);
    }

    void addUnknownTypeNames(Set<String> names) {
        Preconditions.checkState((boolean)this.isTopLevel());
        this.unknownTypeNames = ImmutableSet.copyOf(names);
    }

    void addLocalFunDef(String name, NTIScope scope) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((!this.isDefinedLocally(name, false) ? 1 : 0) != 0);
        this.localFunDefs.put(name, scope);
    }

    boolean isFormalParam(String name) {
        return this.formals.contains(name);
    }

    boolean isFormalParamInAnyAncestorScope(String name) {
        return this.isFormalParam(name) || this.parent != null && this.parent.isFormalParamInAnyAncestorScope(name);
    }

    boolean isLocalFunDef(String name) {
        return this.localFunDefs.containsKey(name);
    }

    boolean isFunctionNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isFrozen);
        Declaration d = this.getDeclaration(name, false);
        if (d == null || d.getFunctionScope() == null || d.getTypeOfSimpleDecl() == null) {
            return false;
        }
        return d.getTypeOfSimpleDecl().isNamespace();
    }

    boolean isDefinedLocally(String name, boolean includeTypes) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkState((!name.contains(".") ? 1 : 0) != 0);
        if (this.locals.containsKey(name) || this.formals.contains(name) || this.localNamespaces.containsKey(name) || this.localFunDefs.containsKey(name) || "this".equals(name) || this.externs.containsKey(name) || this.localTypedefs.containsKey(name)) {
            return true;
        }
        if (includeTypes) {
            return this.unknownTypeNames.contains((Object)name) || this.declaredType != null && this.declaredType.isTypeVariableDefinedLocally(name);
        }
        return false;
    }

    boolean isDefined(Node qnameNode) {
        Preconditions.checkArgument((boolean)qnameNode.isQualifiedName());
        return this.isDefined(QualifiedName.fromNode(qnameNode));
    }

    boolean isDefined(QualifiedName qname) {
        String leftmost = qname.getLeftmostName();
        if (qname.isIdentifier()) {
            return leftmost.equals("this") || this.isDefinedLocally(leftmost, false);
        }
        if (this.isNamespace(leftmost)) {
            return this.getNamespace(leftmost).isDefined(qname.getAllButLeftmost());
        }
        return this.parent == null ? false : this.parent.isDefined(qname);
    }

    boolean isNamespace(Node expr) {
        if (expr.isName()) {
            return this.isNamespace(expr.getString());
        }
        if (!expr.isGetProp()) {
            return false;
        }
        return this.isNamespace(QualifiedName.fromNode(expr));
    }

    boolean isNamespace(QualifiedName qname) {
        if (qname == null) {
            return false;
        }
        String leftmost = qname.getLeftmostName();
        return this.isNamespace(leftmost) && (qname.isIdentifier() || this.getNamespace(leftmost).hasSubnamespace(qname.getAllButLeftmost()));
    }

    boolean isNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        if (decl == null) {
            return false;
        }
        JSType simpleType = decl.getTypeOfSimpleDecl();
        return decl.getNamespace() != null || simpleType != null && simpleType.isNamespace();
    }

    boolean isVisibleInScope(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return this.isDefinedLocally(name, false) || name.equals(this.name) || this.parent != null && this.parent.isVisibleInScope(name);
    }

    boolean isConstVar(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl != null && decl.isConstant();
    }

    boolean isOuterVarEarly(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return !this.isDefinedLocally(name, false) && this.parent != null && this.parent.isVisibleInScope(name);
    }

    boolean isGlobalVar(String varName) {
        NTIScope s = this;
        while (s.parent != null) {
            if (s.isDefinedLocally(varName, false)) {
                return false;
            }
            s = s.parent;
        }
        return true;
    }

    boolean isUndeclaredFormal(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
    }

    List<String> getFormals() {
        return new ArrayList<String>(this.formals);
    }

    Set<String> getOuterVars() {
        return new LinkedHashSet<String>(this.outerVars);
    }

    ImmutableSet<String> getLocalFunDefs() {
        return ImmutableSet.copyOf(this.localFunDefs.keySet());
    }

    boolean isOuterVar(String name) {
        return this.outerVars.contains(name);
    }

    boolean isUndeclaredOuterVar(String name) {
        return this.outerVars.contains(name) && this.getDeclaredTypeOf(name) == null;
    }

    boolean isEscapedVar(String name) {
        LocalVarInfo info = this.locals.get(name);
        return info != null && info.escapes;
    }

    boolean hasThis() {
        DeclaredFunctionType dft = this.declaredType;
        return dft != null && dft.getThisType() != null;
    }

    JSType getInferredTypeOf(String name) {
        if (this.locals.containsKey(name)) {
            return this.locals.get(name).getInferredType();
        }
        return this.parent == null ? null : this.parent.getInferredTypeOf(name);
    }

    @Override
    public JSType getDeclaredTypeOf(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        if ("this".equals(name)) {
            if (!this.hasThis()) {
                return null;
            }
            return this.getDeclaredTypeForOwnBody().getThisType();
        }
        Declaration decl = this.getLocalDeclaration(name, false);
        if (decl != null) {
            if (decl.getTypeOfSimpleDecl() != null) {
                Preconditions.checkState((!decl.getTypeOfSimpleDecl().isBottom() ? 1 : 0) != 0, (String)"%s was bottom", (Object)name);
                return decl.getTypeOfSimpleDecl();
            }
            NTIScope funScope = (NTIScope)decl.getFunctionScope();
            if (funScope != null) {
                Preconditions.checkNotNull((Object)funScope.getDeclaredFunctionType(), (String)"decl=%s, funScope=%s", (Object)decl, (Object)funScope);
                return this.commonTypes.fromFunctionType(funScope.getDeclaredFunctionType().toFunctionType());
            }
            Preconditions.checkState((decl.getNamespace() == null ? 1 : 0) != 0);
            return null;
        }
        if (name.equals(this.name) && !this.parent.isFunctionNamespace(name)) {
            return this.commonTypes.fromFunctionType(this.getDeclaredFunctionType().toFunctionType());
        }
        return this.parent == null ? null : this.parent.getDeclaredTypeOf(name);
    }

    boolean hasUndeclaredFormalsOrOuters() {
        for (String formal : this.formals) {
            if (this.getDeclaredTypeOf(formal) != null) continue;
            return true;
        }
        for (String outer : this.outerVars) {
            JSType declType = this.getDeclaredTypeOf(outer);
            if (declType != null && (declType.getFunType() == null || declType.getFunType().isSomeConstructorOrInterface() || !declType.getFunType().getReturnType().isUnknown())) continue;
            return true;
        }
        return false;
    }

    private NTIScope getScopeHelper(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : (NTIScope)decl.getFunctionScope();
    }

    boolean isKnownFunction(String fnName) {
        Preconditions.checkArgument((!fnName.contains(".") ? 1 : 0) != 0);
        return this.getScopeHelper(new QualifiedName(fnName)) != null;
    }

    boolean isKnownFunction(QualifiedName qname) {
        return this.getScopeHelper(qname) != null;
    }

    boolean isExternalFunction(String fnName) {
        NTIScope s = this.getScopeHelper(new QualifiedName(fnName));
        return s.root.isFromExterns();
    }

    NTIScope getScope(String fnName) {
        NTIScope s = this.getScopeHelper(new QualifiedName(fnName));
        Preconditions.checkState((s != null ? 1 : 0) != 0);
        return s;
    }

    ImmutableSet<String> getLocals() {
        return ImmutableSet.copyOf(this.locals.keySet());
    }

    ImmutableSet<String> getExterns() {
        return ImmutableSet.copyOf(this.externs.keySet());
    }

    void addDeclaredLocal(String name, JSType type, boolean isConstant, boolean isFromExterns) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        if (isConstant) {
            this.constVars.add(name);
        }
        if (isFromExterns) {
            this.externs.put(name, type);
        } else {
            LocalVarInfo info = this.locals.get(name);
            this.locals.put(name, new LocalVarInfo(type, VarKind.DECLARED, info != null && info.escapes));
        }
    }

    void addInferredLocal(String name, JSType type) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        LocalVarInfo info = this.locals.get(name);
        this.locals.put(name, new LocalVarInfo(type, VarKind.INFERRED, info != null && info.escapes));
    }

    void clearInferredTypeOfVar(String name) {
        LocalVarInfo info = this.locals.get(name);
        if (info != null && info.getInferredType() != null) {
            this.locals.put(name, new LocalVarInfo(null, VarKind.INFERRED, info.escapes));
        } else if (!this.isDefinedLocally(name, false) && this.parent != null) {
            this.parent.clearInferredTypeOfVar(name);
        }
    }

    static void mayRecordEscapedVar(NTIScope s, String name) {
        if (s.isDefinedLocally(name, false)) {
            return;
        }
        while (s != null) {
            if (s.isDefinedLocally(name, false)) {
                LocalVarInfo info = s.locals.get(name);
                if (info != null) {
                    s.locals.put(name, info.withEscaped());
                }
                return;
            }
            s = s.parent;
        }
    }

    RawNominalType getNominalType(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : decl.getNominal();
    }

    Typedef getTypedef(String name) {
        return this.getTypedef(QualifiedName.fromQualifiedString(name));
    }

    Typedef getTypedef(QualifiedName qname) {
        Namespace ns;
        Declaration decl = qname.isIdentifier() ? this.getDeclaration(qname, true) : ((ns = this.getNamespace(qname.getLeftmostName())) == null ? null : ns.getDeclaration(qname.getAllButLeftmost()));
        return decl == null ? null : decl.getTypedef();
    }

    EnumType getEnum(QualifiedName qname) {
        Declaration decl = this.getDeclaration(qname, false);
        return decl == null ? null : decl.getEnum();
    }

    Namespace getNamespace(String name) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getDeclaration(name, false);
        return decl == null ? null : decl.getNamespace();
    }

    Namespace getNamespace(QualifiedName qname) {
        Namespace ns = this.getNamespace(qname.getLeftmostName());
        return ns == null || qname.isIdentifier() ? ns : ns.getSubnamespace(qname.getAllButLeftmost());
    }

    void addFunNamespace(Node qnameNode) {
        if (qnameNode.isName()) {
            String varName = qnameNode.getString();
            Preconditions.checkArgument((boolean)this.isDefinedLocally(varName, false));
            Preconditions.checkState((!this.localNamespaces.containsKey(varName) ? 1 : 0) != 0);
            NTIScope s = (NTIScope)Preconditions.checkNotNull((Object)this.localFunDefs.get(varName));
            this.localNamespaces.put(varName, new FunctionNamespace(this.commonTypes, varName, s, qnameNode));
        } else {
            Preconditions.checkArgument((!this.isNamespace(qnameNode) ? 1 : 0) != 0);
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            NTIScope s = (NTIScope)ns.getDeclaration(qname).getFunctionScope();
            ns.addNamespace(qname.getAllButLeftmost(), new FunctionNamespace(this.commonTypes, qname.toString(), s, qnameNode));
        }
    }

    void addNamespaceLit(QualifiedName qname, Node defSite) {
        this.addNamespace(qname, defSite, new NamespaceLit(this.commonTypes, qname.toString(), defSite));
    }

    void addOuterVar(String name) {
        this.outerVars.add(name);
    }

    void addTypedef(Node qnameNode, Typedef td) {
        if (qnameNode.isName()) {
            Preconditions.checkState((!this.localTypedefs.containsKey(qnameNode.getString()) ? 1 : 0) != 0);
            this.localTypedefs.put(qnameNode.getString(), td);
        } else {
            Preconditions.checkState((!this.isDefined(qnameNode) ? 1 : 0) != 0);
            QualifiedName qname = QualifiedName.fromNode(qnameNode);
            Namespace ns = this.getNamespace(qname.getLeftmostName());
            ns.addTypedef(qname.getAllButLeftmost(), td);
            this.namespaceTypedefs.add(td);
        }
    }

    void addNamespace(Node qnameNode, Namespace ns) {
        this.addNamespace(QualifiedName.fromNode(qnameNode), qnameNode, ns);
    }

    void addNamespace(QualifiedName qname, Node defSite, Namespace ns) {
        if (ns instanceof EnumType) {
            this.localEnums.add((EnumType)ns);
        }
        if (qname.isIdentifier()) {
            String varName = qname.getLeftmostName();
            Preconditions.checkState((!this.localNamespaces.containsKey(varName) ? 1 : 0) != 0, (String)"Namespace %s already defined.", (Object)varName);
            this.localNamespaces.put(varName, ns);
            if (defSite.isFromExterns() && !this.externs.containsKey(varName)) {
                this.externs.put(varName, null);
            }
        } else {
            Preconditions.checkState((!this.isDefined(qname) ? 1 : 0) != 0);
            Namespace rootns = this.getNamespace(qname.getLeftmostName());
            rootns.addNamespace(qname.getAllButLeftmost(), ns);
        }
    }

    private Declaration getLocalDeclaration(String name, boolean includeTypes) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        if (!this.isDefinedLocally(name, includeTypes)) {
            return null;
        }
        DeclaredFunctionType declaredType = this.getDeclaredTypeForOwnBody();
        JSType type = null;
        boolean isTypeVar = false;
        if ("this".equals(name)) {
            type = this.getDeclaredTypeOf("this");
        } else if (this.locals.containsKey(name)) {
            type = this.locals.get(name).getDeclaredType();
        } else if (this.formals.contains(name)) {
            JSType formalType;
            int formalIndex = this.formals.indexOf(name);
            if (declaredType != null && formalIndex != -1 && (formalType = declaredType.getFormalType(formalIndex)) != null && !formalType.isBottom()) {
                type = formalType;
            }
        } else if (this.localFunDefs.containsKey(name)) {
            if (this.isFrozen && this.externs.containsKey(name)) {
                type = this.externs.get(name);
            }
        } else if (!this.localTypedefs.containsKey(name) && !this.localNamespaces.containsKey(name)) {
            if (declaredType != null && declaredType.isTypeVariableDefinedLocally(name)) {
                isTypeVar = true;
                type = JSType.fromTypeVar(this.commonTypes, declaredType.getTypeVariableDefinedLocally(name));
            } else if (this.externs.containsKey(name)) {
                type = this.externs.get(name);
            }
        }
        Namespace ns = null;
        if (this.localNamespaces.containsKey(name)) {
            ns = this.localNamespaces.get(name);
        } else if (this.preservedNamespaces != null) {
            ns = this.preservedNamespaces.get(name);
        }
        return new Declaration(type, this.localTypedefs.get(name), ns, this.localFunDefs.get(name), isTypeVar, this.constVars.contains(name));
    }

    @Override
    public Declaration getDeclaration(QualifiedName qname, boolean includeTypes) {
        if (qname.isIdentifier()) {
            return this.getDeclaration(qname.getLeftmostName(), includeTypes);
        }
        Namespace ns = this.getNamespace(qname.getLeftmostName());
        if (ns == null) {
            return this.maybeGetForwardDeclaration(qname.toString());
        }
        Declaration decl = ns.getDeclaration(qname.getAllButLeftmost());
        return decl != null ? decl : this.maybeGetForwardDeclaration(qname.toString());
    }

    public Declaration getDeclaration(String name, boolean includeTypes) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0);
        Declaration decl = this.getLocalDeclaration(name, includeTypes);
        if (decl != null) {
            return decl;
        }
        return this.parent == null ? null : this.parent.getDeclaration(name, includeTypes);
    }

    private Declaration maybeGetForwardDeclaration(String qname) {
        NTIScope globalScope = this;
        while (globalScope.parent != null) {
            globalScope = globalScope.parent;
        }
        if (globalScope.unknownTypeNames.contains((Object)qname)) {
            return new Declaration(this.commonTypes.UNKNOWN, null, null, null, false, false);
        }
        return null;
    }

    private Namespace getNamespaceAfterFreezing(String typeName) {
        Preconditions.checkNotNull(this.preservedNamespaces, (Object)"Failed to preserve namespaces post-finalization");
        QualifiedName qname = QualifiedName.fromQualifiedString(typeName);
        Namespace ns = this.preservedNamespaces.get(qname.getLeftmostName());
        if (ns != null && !qname.isIdentifier()) {
            ns = ns.getSubnamespace(qname.getAllButLeftmost());
        }
        return ns;
    }

    public JSType getType(String typeName) {
        Namespace ns = this.getNamespaceAfterFreezing(typeName);
        if (ns == null) {
            return null;
        }
        return ns instanceof RawNominalType ? ((RawNominalType)ns).getInstanceAsJSType() : ns.toJSType();
    }

    @Override
    public JSType getNamespaceOrTypedefType(String typeName) {
        Namespace ns = this.getNamespaceAfterFreezing(typeName);
        if (ns != null) {
            return ns.toJSType();
        }
        Typedef td = this.getTypedef(typeName);
        return td == null ? null : td.getType();
    }

    @Override
    public JSDocInfo getJsdocOfTypeDeclaration(String typeName) {
        Node defSite;
        JSType t = this.getType(typeName);
        if (t != null && (defSite = t.getSource()) != null) {
            return NodeUtil.getBestJSDocInfo(defSite);
        }
        return null;
    }

    void resolveTypedefs(JSTypeCreatorFromJSDoc typeParser) {
        for (Typedef td : this.localTypedefs.values()) {
            typeParser.resolveTypedef(td, this);
        }
        for (Typedef td : this.namespaceTypedefs) {
            typeParser.resolveTypedef(td, this);
        }
        this.namespaceTypedefs = null;
    }

    void resolveEnums(JSTypeCreatorFromJSDoc typeParser) {
        for (EnumType e : this.localEnums) {
            typeParser.resolveEnum(e, this);
        }
        this.localEnums = null;
    }

    void freezeScope() {
        Preconditions.checkNotNull((Object)this.declaredType, (String)"No declared type for scope: %s", (Object)this.root);
        this.unknownTypeNames = ImmutableSet.of();
        for (Map.Entry<String, Namespace> entry : this.localNamespaces.entrySet()) {
            String name = entry.getKey();
            Namespace ns = entry.getValue();
            if (ns instanceof NamespaceLit) {
                this.constVars.add(name);
            }
            JSType t = ns.toJSType();
            if (this.externs.containsKey(name)) {
                this.externs.put(name, t);
                continue;
            }
            this.locals.put(name, LocalVarInfo.makeDeclared(t));
        }
        for (String typedefName : this.localTypedefs.keySet()) {
            this.locals.put(typedefName, LocalVarInfo.makeDeclared(this.commonTypes.UNDEFINED));
        }
        NTIScope.copyOuterVarsTransitively(this);
        this.preservedNamespaces = this.localNamespaces;
        this.localNamespaces = ImmutableMap.of();
        this.isFrozen = true;
    }

    private static void copyOuterVarsTransitively(NTIScope s) {
        if (s.isTopLevel()) {
            return;
        }
        NTIScope parent = s.parent;
        Set<String> outerVars = s.outerVars;
        while (parent.isFunction()) {
            boolean copiedOneVar = false;
            for (String v : outerVars) {
                if (parent.isDefinedLocally(v, false)) continue;
                copiedOneVar = true;
                parent.addOuterVar(v);
            }
            if (!copiedOneVar) break;
            outerVars = parent.outerVars;
            parent = parent.parent;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isTopLevel()) {
            sb.append("<TOP SCOPE>");
        } else {
            sb.append(this.getReadableName());
            sb.append('(');
            Joiner.on((char)',').appendTo(sb, this.formals);
            sb.append(')');
        }
        sb.append(" with root: ");
        sb.append(this.root);
        return sb.toString();
    }

    static class LocalVarInfo
    implements Serializable {
        private final JSType type;
        private final VarKind kind;
        private final boolean escapes;

        private LocalVarInfo(JSType type, VarKind kind, boolean escapes) {
            this.type = type;
            this.kind = kind;
            this.escapes = escapes;
        }

        static LocalVarInfo makeDeclared(JSType t) {
            return new LocalVarInfo(t, VarKind.DECLARED, false);
        }

        LocalVarInfo withEscaped() {
            return new LocalVarInfo(this.type, this.kind, true);
        }

        JSType getInferredType() {
            return this.kind == VarKind.INFERRED ? this.type : null;
        }

        JSType getDeclaredType() {
            return this.kind == VarKind.DECLARED ? this.type : null;
        }

        public String toString() {
            return "LocalVarInfo(" + this.type + "," + (Object)((Object)this.kind) + "," + this.escapes + ")";
        }
    }

    static enum VarKind {
        DECLARED,
        INFERRED;

    }
}

