/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.EarlyEs6ToEs3Converter;
import com.google.javascript.jscomp.Es6ConvertSuper;
import com.google.javascript.jscomp.Es6ConvertSuperConstructorCalls;
import com.google.javascript.jscomp.Es6ExtractClasses;
import com.google.javascript.jscomp.Es6ForOfConverter;
import com.google.javascript.jscomp.Es6NormalizeShorthandProperties;
import com.google.javascript.jscomp.Es6RenameVariablesInParamLists;
import com.google.javascript.jscomp.Es6RewriteArrowFunction;
import com.google.javascript.jscomp.Es6RewriteBlockScopedDeclaration;
import com.google.javascript.jscomp.Es6RewriteBlockScopedFunctionDeclaration;
import com.google.javascript.jscomp.Es6RewriteClass;
import com.google.javascript.jscomp.Es6RewriteDestructuring;
import com.google.javascript.jscomp.Es6RewriteGenerators;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.Es6RewriteModulesToCommonJsModules;
import com.google.javascript.jscomp.Es6SplitVariableDeclarations;
import com.google.javascript.jscomp.Es7ToEs6Converter;
import com.google.javascript.jscomp.EsNextToEs8Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.LateEs6ToEs3Converter;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.RewriteAsyncFunctions;
import com.google.javascript.jscomp.RewritePolyfills;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import java.util.List;

public class TranspilationPasses {
    private static final PassFactory es6RewriteModuleToCjs = new PassFactory("es6RewriteModuleToCjs", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteModulesToCommonJsModules(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    private static final PassFactory rewriteAsyncFunctions = new PassFactory.HotSwapPassFactory("rewriteAsyncFunctions"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewriteAsyncFunctions(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private static final PassFactory rewriteObjRestSpread = new PassFactory.HotSwapPassFactory("rewriteObjRestSpread"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new EsNextToEs8Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES_NEXT;
        }
    };
    private static final PassFactory convertEs7ToEs6 = new PassFactory.HotSwapPassFactory("convertEs7ToEs6"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es7ToEs6Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    private static final PassFactory.HotSwapPassFactory es6NormalizeShorthandProperties = new PassFactory.HotSwapPassFactory("es6NormalizeShorthandProperties"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6NormalizeShorthandProperties(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ExtractClasses = new PassFactory.HotSwapPassFactory("Es6ExtractClasses"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ExtractClasses(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteClass = new PassFactory.HotSwapPassFactory("Es6RewriteClass"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteClass(compiler, true);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteDestructuring = new PassFactory.HotSwapPassFactory("Es6RewriteDestructuring"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteDestructuring(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RenameVariablesInParamLists = new PassFactory.HotSwapPassFactory("Es6RenameVariablesInParamLists"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RenameVariablesInParamLists(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6RewriteArrowFunction = new PassFactory.HotSwapPassFactory("Es6RewriteArrowFunction"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteArrowFunction(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewritePolyfills = new PassFactory.HotSwapPassFactory("RewritePolyfills"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new RewritePolyfills(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8_MODULES;
        }
    };
    static final PassFactory.HotSwapPassFactory es6SplitVariableDeclarations = new PassFactory.HotSwapPassFactory("Es6SplitVariableDeclarations"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6SplitVariableDeclarations(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuperConstructorCalls = new PassFactory.HotSwapPassFactory("es6ConvertSuperConstructorCalls"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuperConstructorCalls(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ConvertSuper = new PassFactory.HotSwapPassFactory("es6ConvertSuper"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ConvertSuper(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory earlyConvertEs6ToEs3 = new PassFactory.HotSwapPassFactory("earlyConvertEs6"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new EarlyEs6ToEs3Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory lateConvertEs6ToEs3 = new PassFactory.HotSwapPassFactory("lateConvertEs6"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new LateEs6ToEs3Converter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory es6ForOf = new PassFactory.HotSwapPassFactory("es6ForOf"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6ForOfConverter(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteBlockScopedFunctionDeclaration = new PassFactory.HotSwapPassFactory("Es6RewriteBlockScopedFunctionDeclaration"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteBlockScopedFunctionDeclaration(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteBlockScopedDeclaration = new PassFactory.HotSwapPassFactory("Es6RewriteBlockScopedDeclaration"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteBlockScopedDeclaration(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };
    static final PassFactory.HotSwapPassFactory rewriteGenerators = new PassFactory.HotSwapPassFactory("rewriteGenerators"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new Es6RewriteGenerators(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES8;
        }
    };

    private TranspilationPasses() {
    }

    public static void addEs6ModulePass(List<PassFactory> passes, final PreprocessorSymbolTable.CachedInstanceFactory preprocessorTableFactory) {
        passes.add(new PassFactory.HotSwapPassFactory("es6RewriteModule"){

            @Override
            protected HotSwapCompilerPass create(AbstractCompiler compiler) {
                preprocessorTableFactory.maybeInitialize(compiler);
                return new Es6RewriteModules(compiler, preprocessorTableFactory.getInstanceOrNull());
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.ES_NEXT;
            }
        });
    }

    public static void addEs6ModuleToCjsPass(List<PassFactory> passes) {
        passes.add(es6RewriteModuleToCjs);
    }

    public static void addEs2018Passes(List<PassFactory> passes) {
        passes.add(rewriteObjRestSpread);
    }

    public static void addEs2017Passes(List<PassFactory> passes) {
        passes.add(TranspilationPasses.createFeatureRemovalPass("markTrailingCommasInParameterListsRemoved", FeatureSet.Feature.TRAILING_COMMA_IN_PARAM_LIST, new FeatureSet.Feature[0]));
        passes.add(rewriteAsyncFunctions);
    }

    public static void addEs2016Passes(List<PassFactory> passes) {
        passes.add(convertEs7ToEs6);
    }

    public static void addEs6PreTypecheckPasses(List<PassFactory> passes) {
        passes.add(TranspilationPasses.createFeatureRemovalPass("markEs6FeaturesNotRequiringTranspilationAsRemoved", FeatureSet.Feature.BINARY_LITERALS, FeatureSet.Feature.OCTAL_LITERALS, FeatureSet.Feature.REGEXP_FLAG_U, FeatureSet.Feature.REGEXP_FLAG_Y));
        passes.add(es6NormalizeShorthandProperties);
        passes.add(es6ConvertSuper);
        passes.add(es6RenameVariablesInParamLists);
        passes.add(es6SplitVariableDeclarations);
        passes.add(es6RewriteDestructuring);
        passes.add(es6RewriteArrowFunction);
        passes.add(es6ExtractClasses);
        passes.add(es6RewriteClass);
        passes.add(earlyConvertEs6ToEs3);
        passes.add(lateConvertEs6ToEs3);
        passes.add(es6ForOf);
        passes.add(rewriteBlockScopedFunctionDeclaration);
        passes.add(rewriteBlockScopedDeclaration);
        passes.add(rewriteGenerators);
    }

    public static void addEs6PassesBeforeNTI(List<PassFactory> passes) {
        passes.add(TranspilationPasses.createFeatureRemovalPass("markEs6FeaturesNotRequiringTranspilationAsRemoved", FeatureSet.Feature.BINARY_LITERALS, FeatureSet.Feature.OCTAL_LITERALS, FeatureSet.Feature.REGEXP_FLAG_U, FeatureSet.Feature.REGEXP_FLAG_Y));
        passes.add(es6NormalizeShorthandProperties);
        passes.add(es6ConvertSuper);
        passes.add(es6RenameVariablesInParamLists);
        passes.add(es6SplitVariableDeclarations);
        passes.add(es6RewriteDestructuring);
        passes.add(es6RewriteArrowFunction);
        passes.add(es6ExtractClasses);
        passes.add(es6RewriteClass);
        passes.add(earlyConvertEs6ToEs3);
        passes.add(rewriteBlockScopedFunctionDeclaration);
        passes.add(rewriteBlockScopedDeclaration);
    }

    public static void addEs6PassesAfterNTI(List<PassFactory> passes) {
        passes.add(lateConvertEs6ToEs3);
        passes.add(es6ForOf);
        passes.add(rewriteGenerators);
    }

    public static void addRewritePolyfillPass(List<PassFactory> passes) {
        passes.add(rewritePolyfills);
    }

    static boolean isScriptEs6OrHigher(Node script) {
        FeatureSet features = (FeatureSet)script.getProp((byte)89);
        return features != null && !FeatureSet.ES5.contains(features);
    }

    static void processTranspile(AbstractCompiler compiler, Node combinedRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(featureSet)) {
            for (Node singleRoot : combinedRoot.children()) {
                if (!TranspilationPasses.isScriptEs6OrHigher(singleRoot)) continue;
                for (NodeTraversal.Callback callback : callbacks) {
                    singleRoot.putBooleanProp((byte)93, true);
                    NodeTraversal.traverseEs6(compiler, singleRoot, callback);
                }
            }
        }
    }

    static void hotSwapTranspile(AbstractCompiler compiler, Node scriptRoot, FeatureSet featureSet, NodeTraversal.Callback ... callbacks) {
        if (compiler.getOptions().needsTranspilationFrom(featureSet) && TranspilationPasses.isScriptEs6OrHigher(scriptRoot)) {
            for (NodeTraversal.Callback callback : callbacks) {
                scriptRoot.putBooleanProp((byte)93, true);
                NodeTraversal.traverseEs6(compiler, scriptRoot, callback);
            }
        }
    }

    public static void addEs6PostTypecheckPasses(List<PassFactory> passes) {
    }

    public static void addEs6PostCheckPasses(List<PassFactory> passes) {
        passes.add(es6ConvertSuperConstructorCalls);
    }

    static void markFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet transpiledFeatures) {
        compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeatures));
    }

    static void markFeaturesAsTranspiledAway(AbstractCompiler compiler, FeatureSet.Feature transpiledFeature, FeatureSet.Feature ... moreTranspiledFeatures) {
        compiler.setFeatureSet(compiler.getFeatureSet().without(transpiledFeature, moreTranspiledFeatures));
    }

    private static PassFactory.HotSwapPassFactory createFeatureRemovalPass(String passName, final FeatureSet.Feature featureToRemove, final FeatureSet.Feature ... moreFeaturesToRemove) {
        return new PassFactory.HotSwapPassFactory(passName){

            @Override
            protected HotSwapCompilerPass create(final AbstractCompiler compiler) {
                return new HotSwapCompilerPass(){

                    @Override
                    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                        TranspilationPasses.markFeaturesAsTranspiledAway(compiler, featureToRemove, moreFeaturesToRemove);
                    }

                    @Override
                    public void process(Node externs, Node root) {
                        TranspilationPasses.markFeaturesAsTranspiledAway(compiler, featureToRemove, moreFeaturesToRemove);
                    }
                };
            }

            @Override
            protected FeatureSet featureSet() {
                return FeatureSet.latest();
            }
        };
    }
}

