/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public class CheckRedundantNullabilityModifier
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType REDUNDANT_NULLABILITY_MODIFIER_JSDOC = DiagnosticType.warning("JSC_REDUNDANT_NULLABILITY_MODIFIER_JSDOC", "Type is already not null. Please remove the redundant '!'.");
    private static final ImmutableSet<String> PRIMITIVE_TYPE_NAMES = ImmutableSet.of((Object)"boolean", (Object)"number", (Object)"string", (Object)"symbol", (Object)"undefined");
    private final AbstractCompiler compiler;

    public CheckRedundantNullabilityModifier(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRootsEs6(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node p) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            return;
        }
        if (info.hasType()) {
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getType(), false);
        }
        for (String param : info.getParameterNames()) {
            if (!info.hasParameterType(param)) continue;
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getParameterType(param), false);
        }
        if (info.hasReturnType()) {
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getReturnType(), false);
        }
        if (info.hasEnumParameterType()) {
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getEnumParameterType(), false);
        }
        if (info.hasTypedefType()) {
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getTypedefType(), false);
        }
        if (info.hasThisType()) {
            CheckRedundantNullabilityModifier.checkTypeExpression(t, info.getThisType(), true);
        }
    }

    private static void checkTypeExpression(NodeTraversal t, JSTypeExpression expr, boolean isTopLevelBangAllowed) {
        NodeUtil.visitPreOrder(expr.getRoot(), node -> {
            boolean isRedundantModifierAllowed;
            Node parent = node.getParent();
            Node grandparent = parent != null ? parent.getParent() : null;
            boolean hasModifier = parent != null && parent.getToken() == Token.BANG;
            boolean isModifierRedundant = CheckRedundantNullabilityModifier.isPrimitiveType(node) || node.isFunction() || CheckRedundantNullabilityModifier.isRecordLiteral(node);
            boolean bl = isRedundantModifierAllowed = isTopLevelBangAllowed && grandparent == null;
            if (hasModifier && isModifierRedundant && !isRedundantModifierAllowed) {
                t.report(parent, REDUNDANT_NULLABILITY_MODIFIER_JSDOC, new String[0]);
            }
        });
    }

    private static boolean isPrimitiveType(Node node) {
        return node.isString() && PRIMITIVE_TYPE_NAMES.contains((Object)node.getString());
    }

    private static boolean isRecordLiteral(Node node) {
        return node.getToken() == Token.LC;
    }
}

