/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.TypeParameters;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class DeclaredFunctionType
implements Serializable {
    private final List<JSType> requiredFormals;
    private final List<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final JSType nominalType;
    private final JSType receiverType;
    private final TypeParameters typeParameters;
    private final JSTypes commonTypes;
    private final boolean isAbstract;

    private DeclaredFunctionType(JSTypes commonTypes, List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, TypeParameters typeParameters, boolean isAbstract) {
        Preconditions.checkArgument((retType == null || !retType.isBottom() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)commonTypes);
        this.commonTypes = commonTypes;
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.receiverType = receiverType;
        this.typeParameters = typeParameters;
        this.isAbstract = isAbstract;
    }

    public FunctionType toFunctionType() {
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        for (JSType formal : this.requiredFormals) {
            builder.addReqFormal(formal == null ? this.commonTypes.UNKNOWN : formal);
        }
        for (JSType formal : this.optionalFormals) {
            builder.addOptFormal(formal == null ? this.commonTypes.UNKNOWN : formal);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType == null ? this.commonTypes.UNKNOWN : this.returnType);
        builder.addNominalType(this.nominalType);
        builder.addReceiverType(this.receiverType);
        builder.addTypeParameters(this.typeParameters);
        builder.addAbstract(this.isAbstract);
        return builder.buildFunction();
    }

    static DeclaredFunctionType make(JSTypes commonTypes, List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, TypeParameters typeParameters, boolean isAbstract) {
        if (requiredFormals == null) {
            requiredFormals = new ArrayList<JSType>();
        }
        if (optionalFormals == null) {
            optionalFormals = new ArrayList<JSType>();
        }
        return new DeclaredFunctionType(commonTypes, requiredFormals, optionalFormals, restFormals, retType, nominalType, receiverType, typeParameters, isAbstract);
    }

    static DeclaredFunctionType qmarkFunctionDeclaration(JSTypes commonTypes) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder(commonTypes);
        builder.addRestFormals(commonTypes.UNKNOWN);
        builder.addRetType(commonTypes.UNKNOWN);
        return builder.buildDeclaration();
    }

    public JSType getFormalType(int argpos) {
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            return this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            return this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public int getRequiredArity() {
        return this.requiredFormals.size();
    }

    public int getOptionalArity() {
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public int getMaxArity() {
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.getOptionalArity();
    }

    private int getSyntacticArity() {
        return this.getOptionalArity() + (this.restFormals == null ? 0 : 1);
    }

    public boolean hasRestFormals() {
        return this.restFormals != null;
    }

    public JSType getRestFormalsType() {
        Preconditions.checkState((this.restFormals != null ? 1 : 0) != 0);
        return this.restFormals;
    }

    public JSType getReturnType() {
        return this.returnType;
    }

    public JSType getThisType() {
        if (this.nominalType != null) {
            return this.nominalType;
        }
        return this.receiverType;
    }

    public JSType getNominalType() {
        return this.nominalType;
    }

    public JSType getReceiverType() {
        return this.receiverType;
    }

    public boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public TypeParameters getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isTypeVariableDefinedLocally(String tvar) {
        return this.getTypeVariableDefinedLocally(tvar) != null;
    }

    public String getTypeVariableDefinedLocally(String tvar) {
        RawNominalType rawType;
        NominalType recvType;
        String tmp = UniqueNameGenerator.findGeneratedName(tvar, this.typeParameters.asList());
        if (tmp != null) {
            return tmp;
        }
        if (this.receiverType != null && (recvType = this.receiverType.getNominalTypeIfSingletonObj()) != null && recvType.isUninstantiatedGenericType() && (tmp = UniqueNameGenerator.findGeneratedName(tvar, (rawType = recvType.getRawNominalType()).getTypeParameters())) != null) {
            return tmp;
        }
        return null;
    }

    public DeclaredFunctionType withReceiverType(JSType newReceiverType) {
        return new DeclaredFunctionType(this.commonTypes, this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, newReceiverType, this.typeParameters, this.isAbstract);
    }

    public DeclaredFunctionType withTypeInfoFromSuper(DeclaredFunctionType superType, boolean getsTypeInfoFromParentMethod) {
        if (getsTypeInfoFromParentMethod && this.getSyntacticArity() == superType.getSyntacticArity()) {
            NominalType nt = superType.nominalType == null ? null : superType.nominalType.getNominalTypeIfSingletonObj();
            NominalType rt = this.receiverType == null ? null : this.receiverType.getNominalTypeIfSingletonObj();
            return new DeclaredFunctionType(this.commonTypes, superType.requiredFormals, superType.optionalFormals, superType.restFormals, superType.returnType, nt == null ? null : nt.getInstanceAsJSType(), rt == null ? null : rt.getInstanceAsJSType(), superType.typeParameters, this.isAbstract);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        int i = 0;
        for (JSType formal : this.requiredFormals) {
            builder.addReqFormal(formal != null ? formal : superType.getFormalType(i));
            ++i;
        }
        for (JSType formal : this.optionalFormals) {
            builder.addOptFormal(formal != null ? formal : superType.getFormalType(i));
            ++i;
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals);
        } else if (superType.hasRestFormals()) {
            builder.addRestFormals(superType.restFormals);
        }
        builder.addRetType(this.returnType != null ? this.returnType : superType.returnType);
        builder.addNominalType(this.nominalType);
        builder.addReceiverType(this.receiverType);
        if (!this.typeParameters.isEmpty()) {
            builder.addTypeParameters(this.typeParameters);
        } else if (!superType.typeParameters.isEmpty()) {
            builder.addTypeParameters(superType.typeParameters);
        }
        builder.addAbstract(this.isAbstract);
        return builder.buildDeclaration();
    }

    public DeclaredFunctionType substituteNominalGenerics(NominalType nt) {
        if (!nt.isGeneric()) {
            return this;
        }
        FunctionTypeBuilder builder = this.substituteGenerics((Map<String, JSType>)nt.getTypeMap());
        builder.addReceiverType(null);
        builder.addNominalType(null);
        return builder.buildDeclaration();
    }

    public DeclaredFunctionType instantiateGenericsWithUnknown() {
        return this.substituteGenerics(this.commonTypes.MAP_TO_UNKNOWN).buildDeclaration();
    }

    private FunctionTypeBuilder substituteGenerics(Map<String, JSType> typeMap) {
        Preconditions.checkState((!typeMap.isEmpty() ? 1 : 0) != 0);
        if (!this.commonTypes.MAP_TO_UNKNOWN.equals(typeMap)) {
            for (String typeParam : this.typeParameters.asList()) {
                Preconditions.checkState((!typeMap.containsKey(typeParam) ? 1 : 0) != 0);
            }
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal == null ? null : reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal == null ? null : optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        if (this.returnType != null) {
            builder.addRetType(this.returnType.substituteGenerics(typeMap));
        }
        if (this.receiverType != null) {
            builder.addReceiverType(this.receiverType.substituteGenerics(typeMap));
        }
        if (this.nominalType != null) {
            builder.addNominalType(this.nominalType.substituteGenerics(typeMap));
        }
        builder.addTypeParameters(this.typeParameters);
        return builder;
    }

    public static DeclaredFunctionType meet(Collection<DeclaredFunctionType> toMeet) {
        DeclaredFunctionType result = null;
        for (DeclaredFunctionType declType : toMeet) {
            if (result == null) {
                result = declType;
                continue;
            }
            result = DeclaredFunctionType.meet(result, declType);
        }
        return result;
    }

    private static DeclaredFunctionType meet(DeclaredFunctionType f1, DeclaredFunctionType f2) {
        JSType retType;
        if (f1.equals(f2)) {
            return f1;
        }
        JSTypes commonTypes = f1.commonTypes;
        FunctionTypeBuilder builder = new FunctionTypeBuilder(f1.commonTypes);
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(DeclaredFunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(DeclaredFunctionType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            builder.addRestFormals(DeclaredFunctionType.nullAcceptingJoin(f1.restFormals, f2.restFormals));
        }
        if (commonTypes.BOTTOM.equals(retType = DeclaredFunctionType.nullAcceptingMeet(f1.returnType, f2.returnType))) {
            return null;
        }
        builder.addRetType(retType);
        return builder.buildDeclaration();
    }

    private static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.meet(t1, t2);
    }

    public String toString() {
        return this.toFunctionType().toString();
    }
}

