/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MismatchInfo;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.jscomp.newtypes.TypeParameters;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FunctionType
implements Serializable {
    private final JSTypes commonTypes;
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final boolean isAbstract;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    private final JSType nominalType;
    private final JSType receiverType;
    private final TypeParameters typeParameters;
    private static final boolean DEBUGGING = false;

    private FunctionType(JSTypes commonTypes, ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, ImmutableMap<String, JSType> outerVars, TypeParameters typeParameters, boolean isLoose, boolean isAbstract) {
        Preconditions.checkNotNull((Object)commonTypes);
        this.commonTypes = commonTypes;
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.receiverType = receiverType;
        this.outerVarPreconditions = outerVars;
        this.typeParameters = typeParameters;
        this.isLoose = isLoose;
        this.isAbstract = isAbstract;
        this.checkValid();
    }

    private FunctionType(JSTypes commonTypes, boolean isLoose) {
        Preconditions.checkNotNull((Object)commonTypes);
        this.commonTypes = commonTypes;
        this.requiredFormals = null;
        this.optionalFormals = null;
        this.restFormals = null;
        this.returnType = (JSType)Preconditions.checkNotNull((Object)this.commonTypes.UNKNOWN);
        this.nominalType = null;
        this.receiverType = null;
        this.outerVarPreconditions = null;
        this.typeParameters = TypeParameters.EMPTY;
        this.isLoose = isLoose;
        this.isAbstract = false;
    }

    private void checkValid() {
        if (this.isTopFunction() || this.isQmarkFunction()) {
            return;
        }
        Preconditions.checkNotNull(this.requiredFormals, (String)"null required formals for function: %s", (Object)this);
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkNotNull((Object)formal);
            Preconditions.checkState((this.isLoose || !formal.isBottom() ? 1 : 0) != 0);
        }
        Preconditions.checkNotNull(this.optionalFormals, (String)"null optional formals for function: %s", (Object)this);
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkNotNull((Object)formal);
            Preconditions.checkState((!formal.isBottom() ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.restFormals == null || !this.restFormals.isBottom() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.returnType);
        Preconditions.checkNotNull((Object)this.typeParameters);
    }

    JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isLoose()) {
            return this;
        }
        if (this.isTopFunction()) {
            return this.commonTypes.LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.commonTypes, this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.outerVarPreconditions, this.typeParameters, true, this.isAbstract);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructorOfAbstractClass() {
        return this.isUniqueConstructor() && this.nominalType.getNominalTypeIfSingletonObj().isAbstractClass();
    }

    static FunctionType normalized(JSTypes commonTypes, List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, Map<String, JSType> outerVars, TypeParameters typeParameters, boolean isLoose, boolean isAbstract) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (restFormals != null) {
            for (int i = optionalFormals.size() - 1; i >= 0 && restFormals.equals(optionalFormals.get(i)); --i) {
                optionalFormals.remove(i);
            }
        }
        return new FunctionType(commonTypes, (ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, nominalType, receiverType, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), (TypeParameters)MoreObjects.firstNonNull((Object)typeParameters, (Object)TypeParameters.EMPTY), isLoose, isAbstract);
    }

    static Map<String, FunctionType> createInitialFunctionTypes(JSTypes commonTypes) {
        LinkedHashMap<String, FunctionType> functions = new LinkedHashMap<String, FunctionType>();
        functions.put("QMARK_FUNCTION", FunctionType.normalized(commonTypes, null, null, commonTypes.UNKNOWN, commonTypes.UNKNOWN, null, null, null, null, true, false));
        functions.put("BOTTOM_FUNCTION", FunctionType.normalized(commonTypes, null, null, null, commonTypes.BOTTOM, null, null, null, null, false, false));
        functions.put("TOP_FUNCTION", new FunctionType(commonTypes, false));
        functions.put("LOOSE_TOP_FUNCTION", new FunctionType(commonTypes, true));
        return functions;
    }

    public boolean isTopFunction() {
        return this == this.commonTypes.TOP_FUNCTION || this == this.commonTypes.LOOSE_TOP_FUNCTION;
    }

    private static NominalType getNominalTypeIfSingletonObj(JSType t) {
        return t == null ? null : t.getNominalTypeIfSingletonObj();
    }

    public boolean isSomeConstructorOrInterface() {
        return this.nominalType != null;
    }

    public boolean isUniqueConstructor() {
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        return nt != null && nt.isClass();
    }

    public boolean isInterfaceDefinition() {
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        return nt != null && nt.isInterface();
    }

    public JSType getSuperPrototype() {
        Preconditions.checkState((boolean)this.isUniqueConstructor());
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        NominalType superClass = nt.getInstantiatedSuperclass();
        return superClass == null ? null : superClass.getPrototypeObject();
    }

    public boolean isQmarkFunction() {
        return this == this.commonTypes.QMARK_FUNCTION;
    }

    static boolean isInhabitable(FunctionType f) {
        return f == null || f != f.commonTypes.BOTTOM_FUNCTION;
    }

    public boolean hasRestFormals() {
        return this.restFormals != null;
    }

    public JSType getRestFormalsType() {
        Preconditions.checkNotNull((Object)this.restFormals);
        return this.restFormals;
    }

    public JSType getFormalType(int argpos) {
        if (this.isTopFunction()) {
            return this.commonTypes.UNKNOWN;
        }
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkState((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkState((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public int getMaxArityWithoutRestFormals() {
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public boolean isRequiredArg(int i) {
        return i < this.requiredFormals.size();
    }

    public boolean isOptionalArg(int i) {
        return i >= this.requiredFormals.size() && i < this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getInstanceTypeOfCtor() {
        if (!this.isGeneric()) {
            return this.nominalType;
        }
        NominalType nominal = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        return nominal == null ? null : nominal.substituteGenerics(this.commonTypes.MAP_TO_UNKNOWN).getInstanceAsJSType();
    }

    JSType getPrototypeOfNewInstances() {
        Preconditions.checkState((boolean)this.isSomeConstructorOrInterface());
        return this.nominalType.getPrototypeObject();
    }

    public JSType getThisType() {
        return this.receiverType != null ? this.receiverType : this.nominalType;
    }

    private FunctionTypeBuilder transformCallApplyHelper() {
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        if (this.receiverType == null) {
            builder.addReqFormal(this.commonTypes.UNKNOWN);
            return builder;
        }
        NominalType nt = this.receiverType.getNominalTypeIfSingletonObj();
        if (nt != null && nt.isUninstantiatedGenericType()) {
            builder.addTypeParameters(TypeParameters.make(nt.getTypeParameters()));
            NominalType ntWithIdentity = nt.instantiateGenericsWithIdentity();
            builder.addReqFormal(JSType.fromObjectType(ObjectType.fromNominalType(ntWithIdentity)));
        } else {
            builder.addReqFormal(this.receiverType);
        }
        return builder;
    }

    public FunctionType transformByCallProperty() {
        if (this.isTopFunction() || this.isQmarkFunction() || this.isLoose) {
            return this.commonTypes.QMARK_FUNCTION;
        }
        FunctionTypeBuilder builder = this.transformCallApplyHelper();
        for (JSType type : this.requiredFormals) {
            builder.addReqFormal(type);
        }
        for (JSType type : this.optionalFormals) {
            builder.addOptFormal(type);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType);
        builder.appendTypeParameters(this.typeParameters);
        builder.addAbstract(this.isAbstract);
        return builder.buildFunction();
    }

    public FunctionType transformByApplyProperty() {
        if (this.isTopFunction() || this.isQmarkFunction() || this.isLoose) {
            return this.commonTypes.QMARK_FUNCTION;
        }
        if (this.isGeneric()) {
            return this.instantiateGenericsWithUnknown().transformByApplyProperty();
        }
        FunctionTypeBuilder builder = this.transformCallApplyHelper();
        JSType arrayContents = this.getMaxArityWithoutRestFormals() == 0 && this.hasRestFormals() ? this.getRestFormalsType() : this.commonTypes.UNKNOWN;
        JSType varargsArray = this.commonTypes.getIArrayLikeInstance(arrayContents);
        builder.addOptFormal(JSType.join(this.commonTypes.NULL, varargsArray));
        builder.addRetType(this.returnType);
        builder.addAbstract(this.isAbstract);
        return builder.buildFunction();
    }

    public DeclaredFunctionType toDeclaredFunctionType() {
        if (this.isQmarkFunction()) {
            return DeclaredFunctionType.qmarkFunctionDeclaration(this.commonTypes);
        }
        Preconditions.checkState((!this.isLoose() ? 1 : 0) != 0, (String)"Loose function: %s", (Object)this);
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        if (this.isGeneric()) {
            builder.addTypeParameters(this.typeParameters);
        }
        for (JSType type : this.requiredFormals) {
            builder.addReqFormal(type);
        }
        for (JSType type : this.optionalFormals) {
            builder.addOptFormal(type);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType);
        builder.addNominalType(this.nominalType);
        builder.addReceiverType(this.receiverType);
        builder.addAbstract(this.isAbstract);
        return builder.buildDeclaration();
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        JSType tmp = JSType.meet(t1, t2);
        return tmp.isBottom() ? null : tmp;
    }

    private static FunctionType looseMerge(FunctionType f1, FunctionType f2) {
        JSType t;
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder(f1.commonTypes);
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; !(i >= maxTotalArity || (t = JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i))) != null && t.isBottom()); ++i) {
            builder.addOptFormal(t);
        }
        return builder.addRetType(JSType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isValidOverride(FunctionType other) {
        return this.isSubtypeOfHelper(other, true, SubtypeCache.create(), null);
    }

    boolean isSubtypeOf(FunctionType other, SubtypeCache subSuperMap) {
        return this.isSubtypeOfHelper(other, false, subSuperMap, null);
    }

    static void whyNotSubtypeOf(FunctionType f1, FunctionType f2, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        Preconditions.checkArgument((boxedInfo.length == 1 ? 1 : 0) != 0);
        f1.isSubtypeOfHelper(f2, false, subSuperMap, boxedInfo);
    }

    public boolean acceptsAnyArguments() {
        return this.requiredFormals.isEmpty() && this.optionalFormals.isEmpty() && this.restFormals != null && this.restFormals.isUnknown();
    }

    private boolean isSubtypeOfHelper(FunctionType other, boolean isMethodOverrideCheck, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        boolean areRetTypesSubtypes;
        if (other.isTopFunction() || other.isQmarkFunction() || this.isQmarkFunction()) {
            return true;
        }
        if (this.isTopFunction()) {
            return false;
        }
        Preconditions.checkState((!this.isLoose() && !other.isLoose() ? 1 : 0) != 0);
        if (this.isGeneric()) {
            if (this.equals(other)) {
                return true;
            }
            return this.instantiateGenericsWithUnknown().isSubtypeOfHelper(other, isMethodOverrideCheck, subSuperMap, boxedInfo);
        }
        if (!other.acceptsAnyArguments()) {
            if (this.requiredFormals.size() > other.requiredFormals.size()) {
                return false;
            }
            int otherMaxTotalArity = other.requiredFormals.size() + other.optionalFormals.size();
            for (int i = 0; i < otherMaxTotalArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal, subSuperMap)) continue;
                if (boxedInfo != null) {
                    boxedInfo[0] = MismatchInfo.makeArgTypeMismatch(i, otherFormal, thisFormal);
                }
                return false;
            }
            if (other.restFormals != null) {
                int thisMaxTotalArity = this.requiredFormals.size() + this.optionalFormals.size();
                if (this.restFormals != null) {
                    ++thisMaxTotalArity;
                }
                for (int i = otherMaxTotalArity; i < thisMaxTotalArity; ++i) {
                    JSType thisFormal = this.getFormalType(i);
                    JSType otherFormal = other.getFormalType(i);
                    if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal, subSuperMap)) continue;
                    return false;
                }
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType != null && !this.nominalType.isSubtypeOf(other.nominalType, subSuperMap)) {
            return false;
        }
        if (!this.commonTypes.allowMethodsAsFunctions && !isMethodOverrideCheck && this.receiverType != null && other.receiverType == null) {
            return false;
        }
        if (this.receiverType != null && other.receiverType != null && !JSType.haveCommonSubtype(this.receiverType, other.receiverType)) {
            return false;
        }
        boolean bl = areRetTypesSubtypes = this.returnType.isUnknown() || other.returnType.isUnknown() || this.returnType.isSubtypeOf(other.returnType, subSuperMap);
        if (boxedInfo != null) {
            boxedInfo[0] = MismatchInfo.makeRetTypeMismatch(other.returnType, this.returnType);
        }
        return areRetTypesSubtypes;
    }

    private static JSType joinNominalTypes(JSType nt1, JSType nt2) {
        NominalType tmp;
        if (nt1 == null || nt2 == null) {
            return null;
        }
        NominalType n1 = FunctionType.getNominalTypeIfSingletonObj(nt1);
        NominalType n2 = FunctionType.getNominalTypeIfSingletonObj(nt2);
        if (n1 != null && n2 != null && (tmp = NominalType.join(n1, n2)) != null) {
            return tmp.getInstanceAsJSType();
        }
        return JSType.join(nt1, nt2);
    }

    private static JSType meetNominalTypes(JSType nt1, JSType nt2) {
        if (nt1 == null) {
            return nt2;
        }
        if (nt2 == null) {
            return nt1;
        }
        NominalType n1 = FunctionType.getNominalTypeIfSingletonObj(nt1);
        NominalType n2 = FunctionType.getNominalTypeIfSingletonObj(nt2);
        if (n1 != null && n2 != null) {
            NominalType tmp = NominalType.pickSubclass(n1, n2);
            return tmp == null ? null : tmp.getInstanceAsJSType();
        }
        return JSType.meet(nt1, nt2);
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f1.equals(f2)) {
            return f1;
        }
        if (f1.isQmarkFunction() || f2.isQmarkFunction()) {
            return f1.commonTypes.QMARK_FUNCTION;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return f1.commonTypes.TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseMerge(f1, f2);
        }
        if (f1.isGeneric() && f2.isSubtypeOf(f1, SubtypeCache.create())) {
            return f1;
        }
        if (f2.isGeneric() && f1.isSubtypeOf(f2, SubtypeCache.create())) {
            return f2;
        }
        if (f1.isGeneric()) {
            f1 = f1.instantiateGenericsWithUnknown();
        }
        if (f2.isGeneric()) {
            f2 = f2.instantiateGenericsWithUnknown();
        }
        JSTypes commonTypes = f1.commonTypes;
        FunctionTypeBuilder builder = new FunctionTypeBuilder(commonTypes);
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            if (reqFormal == null) {
                return commonTypes.BOTTOM_FUNCTION;
            }
            builder.addReqFormal(reqFormal);
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = maxRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            if (optFormal == null) {
                return commonTypes.BOTTOM_FUNCTION;
            }
            builder.addOptFormal(optFormal);
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            JSType newRestFormals = FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals);
            if (newRestFormals == null) {
                return commonTypes.BOTTOM_FUNCTION;
            }
            builder.addRestFormals(newRestFormals);
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        builder.addNominalType(FunctionType.joinNominalTypes(f1.nominalType, f2.nominalType));
        builder.addReceiverType(FunctionType.meetNominalTypes(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        if (other == null || other.isQmarkFunction() || other.isTopFunction() || this.equals(other) || !this.isLoose()) {
            return this;
        }
        return this.isTopFunction() || this.isQmarkFunction() ? other.withLoose() : FunctionType.looseMerge(this, other);
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        JSType retType;
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseMerge(f1, f2);
        }
        if (f1.isGeneric() && f1.isSubtypeOf(f2, SubtypeCache.create())) {
            return f1;
        }
        if (f2.isGeneric() && f2.isSubtypeOf(f1, SubtypeCache.create())) {
            return f2;
        }
        if (f1.isGeneric()) {
            f1 = f1.instantiateGenericsWithUnknown();
        }
        if (f2.isGeneric()) {
            f2 = f2.instantiateGenericsWithUnknown();
        }
        JSTypes commonTypes = f1.commonTypes;
        FunctionTypeBuilder builder = new FunctionTypeBuilder(commonTypes);
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormalType = JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i));
            if (optFormalType.isBottom()) {
                return commonTypes.BOTTOM_FUNCTION;
            }
            builder.addOptFormal(optFormalType);
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            JSType restFormalsType = JSType.nullAcceptingJoin(f1.restFormals, f2.restFormals);
            if (restFormalsType.isBottom()) {
                return commonTypes.BOTTOM_FUNCTION;
            }
            builder.addRestFormals(restFormalsType);
        }
        if ((retType = JSType.meet(f1.returnType, f2.returnType)).isBottom()) {
            return commonTypes.BOTTOM_FUNCTION;
        }
        builder.addRetType(retType);
        builder.addNominalType(FunctionType.meetNominalTypes(f1.nominalType, f2.nominalType));
        builder.addReceiverType(FunctionType.joinNominalTypes(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int minRequiredArity = Math.min(this.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            if (JSType.haveCommonSubtype(this.getFormalType(i), f2.getFormalType(i))) continue;
            return false;
        }
        return JSType.haveCommonSubtype(this.getReturnType(), f2.getReturnType());
    }

    public boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public ImmutableList<String> getTypeParameters() {
        return this.typeParameters.asList();
    }

    public ImmutableMap<String, Node> getTypeTransformations() {
        return this.typeParameters.getTypeTransformations();
    }

    List<TypeI> getParameterTypes() {
        int howmanyTypes = this.getMaxArityWithoutRestFormals() + (this.hasRestFormals() ? 1 : 0);
        ArrayList<TypeI> types = new ArrayList<TypeI>(howmanyTypes);
        types.addAll((Collection<TypeI>)this.requiredFormals);
        types.addAll((Collection<TypeI>)this.optionalFormals);
        if (this.hasRestFormals()) {
            types.add(this.restFormals);
        }
        return types;
    }

    boolean unifyWithSubtype(FunctionType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        Preconditions.checkState((boolean)this.typeParameters.isEmpty(), (String)"Non-empty type parameters %s", (Object)this.typeParameters);
        Preconditions.checkState((this == this.commonTypes.LOOSE_TOP_FUNCTION || this.outerVarPreconditions.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this != this.commonTypes.TOP_FUNCTION ? 1 : 0) != 0);
        if (this == this.commonTypes.LOOSE_TOP_FUNCTION || other.isTopFunction() || other.isLoose()) {
            return true;
        }
        if (other.isGeneric()) {
            other = other.instantiateGenericsWithUnknown();
        }
        if (!this.acceptsAnyArguments()) {
            JSType otherRestFormals;
            if (other.requiredFormals.size() > this.requiredFormals.size()) {
                return false;
            }
            int maxNonInfiniteArity = this.getMaxArityWithoutRestFormals();
            for (int i = 0; i < maxNonInfiniteArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (otherFormal == null || thisFormal.unifyWithSubtype(otherFormal, typeParameters, typeMultimap, subSuperMap) || thisFormal.substituteGenericsWithUnknown().isSubtypeOf(otherFormal, SubtypeCache.create())) continue;
                return false;
            }
            if (this.restFormals != null && (otherRestFormals = other.getFormalType(maxNonInfiniteArity)) != null && !this.restFormals.unifyWithSubtype(otherRestFormals, typeParameters, typeMultimap, subSuperMap) && !this.restFormals.substituteGenericsWithUnknown().isSubtypeOf(otherRestFormals, SubtypeCache.create())) {
                return false;
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null) {
            return false;
        }
        if (this.nominalType != null && !this.nominalType.unifyWithSubtype(other.nominalType, typeParameters, typeMultimap, subSuperMap)) {
            return false;
        }
        if (this.receiverType != null && other.receiverType != null && !this.receiverType.unifyWithSubtype(other.receiverType, typeParameters, typeMultimap, subSuperMap) && !this.receiverType.substituteGenericsWithUnknown().isSubtypeOf(other.receiverType, SubtypeCache.create())) {
            return false;
        }
        return this.returnType.unifyWithSubtype(other.returnType, typeParameters, typeMultimap, subSuperMap);
    }

    public FunctionType instantiateGenericsWithUnknown() {
        if (!this.isGeneric()) {
            return this;
        }
        return this.instantiateGenerics(this.commonTypes.MAP_TO_UNKNOWN);
    }

    static FunctionType unifyUnknowns(FunctionType f1, FunctionType f2) {
        JSType t;
        Preconditions.checkState((f1 != null || f2 != null ? 1 : 0) != 0);
        if (f1 == null || f2 == null) {
            return null;
        }
        if (!f1.typeParameters.isEmpty()) {
            f1 = f1.instantiateGenericsWithUnknown();
        }
        if (!f2.typeParameters.isEmpty()) {
            f2 = f2.instantiateGenericsWithUnknown();
        }
        Preconditions.checkState((!f1.isLoose() && !f2.isLoose() ? 1 : 0) != 0);
        if (f1.equals(f2)) {
            return f1;
        }
        ImmutableList<JSType> formals1 = f1.requiredFormals;
        ImmutableList<JSType> formals2 = f2.requiredFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(f1.commonTypes);
        int numReqFormals = formals1.size();
        for (int i = 0; i < numReqFormals; ++i) {
            JSType t2 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t2 == null) {
                return null;
            }
            builder.addReqFormal(t2);
        }
        formals1 = f1.optionalFormals;
        formals2 = f2.optionalFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        int numOptFormals = formals1.size();
        for (int i = 0; i < numOptFormals; ++i) {
            JSType t3 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t3 == null) {
                return null;
            }
            builder.addOptFormal(t3);
        }
        if (f1.restFormals == null && f2.restFormals != null || f1.restFormals != null && f2.restFormals == null) {
            return null;
        }
        if (f1.restFormals != null) {
            JSType t4 = JSType.unifyUnknowns(f1.restFormals, f2.restFormals);
            if (t4 == null) {
                return null;
            }
            builder.addRestFormals(t4);
        }
        if ((t = JSType.unifyUnknowns(f1.returnType, f2.returnType)) == null) {
            return null;
        }
        builder.addRetType(t);
        if (!Objects.equals(f1.nominalType, f2.nominalType)) {
            return null;
        }
        builder.addNominalType(f1.nominalType);
        if (!Objects.equals(f1.receiverType, f2.receiverType)) {
            return null;
        }
        builder.addReceiverType(f1.receiverType);
        return builder.buildFunction();
    }

    private static JSType substGenericsInNomType(JSType t, Map<String, JSType> typeMap) {
        if (t == null) {
            return null;
        }
        NominalType nt = t.getNominalTypeIfSingletonObj();
        if (nt == null) {
            return t.substituteGenerics(typeMap);
        }
        if (!nt.isGeneric()) {
            return nt.getInstanceAsJSType();
        }
        if (typeMap.isEmpty()) {
            return t;
        }
        return JSType.fromObjectType(ObjectType.fromNominalType(nt.substituteGenerics(typeMap)));
    }

    private FunctionType substituteNominalGenerics(Map<String, JSType> typeMap) {
        if (typeMap.isEmpty() || this.isTopFunction()) {
            return this;
        }
        if (!this.commonTypes.MAP_TO_UNKNOWN.equals(typeMap)) {
            for (String typeParam : this.typeParameters.asList()) {
                Preconditions.checkState((!typeMap.containsKey(typeParam) ? 1 : 0) != 0);
            }
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose()) {
            builder.addLoose();
        }
        builder.addNominalType(FunctionType.substGenericsInNomType(this.nominalType, typeMap));
        builder.addReceiverType(FunctionType.substGenericsInNomType(this.receiverType, typeMap));
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        builder.addTypeParameters(this.typeParameters);
        return builder.buildFunction();
    }

    FunctionType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (!this.isGeneric() || this.commonTypes.MAP_TO_UNKNOWN.equals(concreteTypes)) {
            return this.substituteNominalGenerics(concreteTypes);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, JSType> concreteTypeEntry : concreteTypes.entrySet()) {
            if (this.typeParameters.contains(concreteTypeEntry.getKey())) continue;
            builder.put(concreteTypeEntry);
        }
        return this.substituteNominalGenerics((Map<String, JSType>)builder.build());
    }

    public FunctionType instantiateGenerics(Map<String, JSType> typeMap) {
        Preconditions.checkState((boolean)this.isGeneric());
        if (typeMap.isEmpty()) {
            return this;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder(this.commonTypes);
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose()) {
            builder.addLoose();
        }
        builder.addNominalType(FunctionType.substGenericsInNomType(this.nominalType, typeMap));
        builder.addReceiverType(FunctionType.substGenericsInNomType(this.receiverType, typeMap));
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        return builder.buildFunction();
    }

    public FunctionType instantiateGenericsFromArgumentTypes(JSType recvtype, List<JSType> argTypes) {
        Preconditions.checkState((boolean)this.isGeneric());
        if (argTypes.size() < this.getMinArity() || argTypes.size() > this.getMaxArity()) {
            return null;
        }
        LinkedHashMultimap typeMultimap = LinkedHashMultimap.create();
        if (recvtype != null && !this.getThisType().unifyWithSubtype(recvtype, (List<String>)this.typeParameters.asList(), (Multimap<String, JSType>)typeMultimap, SubtypeCache.create())) {
            return null;
        }
        int size = argTypes.size();
        for (int i = 0; i < size; ++i) {
            JSType argType = argTypes.get(i);
            if (argType.isBottom() || this.getFormalType(i).unifyWithSubtype(argType, (List<String>)this.typeParameters.asList(), (Multimap<String, JSType>)typeMultimap, SubtypeCache.create())) continue;
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : this.typeParameters.asList()) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() > 1) {
                return null;
            }
            if (types.isEmpty()) {
                builder.put((Object)typeParam, (Object)this.commonTypes.UNKNOWN);
                continue;
            }
            builder.put((Object)typeParam, Iterables.getOnlyElement((Iterable)types));
        }
        return this.instantiateGenerics((Map<String, JSType>)builder.build());
    }

    FunctionType devirtualize() {
        JSType firstArg = this.receiverType != null ? this.receiverType : this.commonTypes.UNKNOWN;
        return new FunctionType(this.commonTypes, (ImmutableList<JSType>)ImmutableList.builder().add((Object)firstArg).addAll(this.requiredFormals).build(), this.optionalFormals, this.restFormals, this.returnType, this.nominalType, null, this.outerVarPreconditions, this.typeParameters, this.isLoose, this.isAbstract);
    }

    FunctionType withUnknownReceiver() {
        return new FunctionType(this.commonTypes, this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.commonTypes.UNKNOWN, this.outerVarPreconditions, this.typeParameters, this.isLoose, this.isAbstract);
    }

    FunctionType withReturnType(JSType returnType) {
        return new FunctionType(this.commonTypes, this.requiredFormals, this.optionalFormals, this.restFormals, returnType, this.nominalType, this.receiverType, this.outerVarPreconditions, this.typeParameters, this.isLoose, this.isAbstract);
    }

    FunctionType withNoParameters() {
        return new FunctionType(this.commonTypes, (ImmutableList<JSType>)ImmutableList.of(), (ImmutableList<JSType>)ImmutableList.of(), null, this.returnType, this.nominalType, this.receiverType, this.outerVarPreconditions, this.typeParameters, this.isLoose, this.isAbstract);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FunctionType f2 = (FunctionType)obj;
        return Objects.equals(this.requiredFormals, f2.requiredFormals) && Objects.equals(this.optionalFormals, f2.optionalFormals) && Objects.equals(this.restFormals, f2.restFormals) && Objects.equals(this.returnType, f2.returnType) && Objects.equals(this.nominalType, f2.nominalType) && Objects.equals(this.receiverType, f2.receiverType);
    }

    public int hashCode() {
        return Objects.hash(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), ToStringContext.TO_STRING).toString();
    }

    private static Collection<String> getPrettyTypeParams(List<String> typeParams, ToStringContext ctx) {
        return Collections2.transform(typeParams, ctx::formatTypeVar);
    }

    public StringBuilder appendTo(StringBuilder builder, ToStringContext ctx) {
        int i;
        if (this.isLoose() && ctx.forAnnotation()) {
            return builder.append("!Function");
        }
        if (this == this.commonTypes.LOOSE_TOP_FUNCTION) {
            return builder.append("LOOSE_TOP_FUNCTION");
        }
        if (this == this.commonTypes.TOP_FUNCTION) {
            return builder.append("TOP_FUNCTION");
        }
        if (this.isQmarkFunction()) {
            return builder.append(ctx.forAnnotation() ? "!Function" : "Function");
        }
        if (!this.typeParameters.isEmpty()) {
            builder.append("<");
            Joiner.on((String)",").appendTo(builder, FunctionType.getPrettyTypeParams(this.typeParameters.asList(), ctx));
            builder.append(">");
        }
        builder.append("function(");
        if (this.nominalType != null) {
            builder.append("new:");
            builder.append(this.nominalType);
            builder.append(',');
        } else if (this.receiverType != null) {
            builder.append("this:");
            builder.append(this.receiverType);
            builder.append(',');
        }
        for (i = 0; i < this.requiredFormals.size(); ++i) {
            ((JSType)this.requiredFormals.get(i)).appendTo(builder, ctx);
            builder.append(',');
        }
        for (i = 0; i < this.optionalFormals.size(); ++i) {
            ((JSType)this.optionalFormals.get(i)).appendTo(builder, ctx);
            builder.append("=,");
        }
        if (this.restFormals != null) {
            builder.append("...");
            this.restFormals.appendTo(builder, ctx);
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(')');
        if (this.returnType != null) {
            builder.append(": ");
            this.returnType.appendTo(builder, ctx);
        }
        if (this.isLoose()) {
            builder.append(" (loose)");
        }
        return builder;
    }
}

