/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSTypes
implements Serializable {
    public static final String OBJLIT_CLASS_NAME = "Object{}";
    public final JSType BOOLEAN;
    public final JSType BOTTOM;
    public final JSType FALSE_TYPE;
    public final JSType FALSY;
    public final JSType NULL;
    public final JSType NUMBER;
    public final JSType STRING;
    public final JSType TOP;
    public final JSType TOP_SCALAR;
    public final JSType TRUE_TYPE;
    public final JSType TRUTHY;
    public final JSType UNDEFINED;
    public final JSType UNKNOWN;
    public final JSType UNRESOLVED;
    private ObjectType topObjectType;
    final PersistentMap<String, Property> BOTTOM_PROPERTY_MAP;
    private JSType topObject;
    private ObjectType looseTopObject;
    private JSType topStruct;
    private JSType topDict;
    private ObjectType bottomObject;
    final FunctionType QMARK_FUNCTION;
    final FunctionType BOTTOM_FUNCTION;
    final FunctionType TOP_FUNCTION;
    final FunctionType LOOSE_TOP_FUNCTION;
    final Map<String, JSType> MAP_TO_UNKNOWN;
    public final JSType NUMBER_OR_STRING;
    final JSType UNDEFINED_OR_BOOLEAN;
    final JSType UNDEFINED_OR_NUMBER;
    final JSType UNDEFINED_OR_STRING;
    public final JSType NULL_OR_UNDEFINED;
    final JSType NULL_OR_BOOLEAN;
    final JSType NULL_OR_NUMBER;
    final JSType NULL_OR_STRING;
    private JSType numberInstance;
    private JSType booleanInstance;
    private JSType stringInstance;
    private ObjectType numberInstanceObjtype;
    private ObjectType booleanInstanceObjtype;
    private ObjectType stringInstanceObjtype;
    private JSType numberOrNumber;
    private JSType stringOrString;
    private JSType anyNumOrStr;
    private JSType globalThis;
    private JSType regexpInstance;
    private RawNominalType arrayType;
    private RawNominalType builtinObject;
    private RawNominalType literalObject;
    private RawNominalType builtinFunction;
    private RawNominalType arguments;
    private RawNominalType iObject;
    private RawNominalType iArrayLike;
    private RawNominalType iterable;
    private RawNominalType iterator;
    private RawNominalType iIterableResult;
    private RawNominalType iTemplateArray;
    private RawNominalType generator;
    final boolean allowMethodsAsFunctions;
    final boolean looseSubtypingForLooseObjects;
    final boolean bivariantArrayGenerics;

    private JSTypes(boolean inCompatibilityMode) {
        Map<String, JSType> types = JSType.createScalars(this);
        this.BOOLEAN = (JSType)Preconditions.checkNotNull((Object)types.get("BOOLEAN"));
        this.BOTTOM = (JSType)Preconditions.checkNotNull((Object)types.get("BOTTOM"));
        this.FALSE_TYPE = (JSType)Preconditions.checkNotNull((Object)types.get("FALSE_TYPE"));
        this.FALSY = (JSType)Preconditions.checkNotNull((Object)types.get("FALSY"));
        this.NULL = (JSType)Preconditions.checkNotNull((Object)types.get("NULL"));
        this.NUMBER = (JSType)Preconditions.checkNotNull((Object)types.get("NUMBER"));
        this.STRING = (JSType)Preconditions.checkNotNull((Object)types.get("STRING"));
        this.TOP = (JSType)Preconditions.checkNotNull((Object)types.get("TOP"));
        this.TOP_SCALAR = (JSType)Preconditions.checkNotNull((Object)types.get("TOP_SCALAR"));
        this.TRUE_TYPE = (JSType)Preconditions.checkNotNull((Object)types.get("TRUE_TYPE"));
        this.TRUTHY = (JSType)Preconditions.checkNotNull((Object)types.get("TRUTHY"));
        this.UNDEFINED = (JSType)Preconditions.checkNotNull((Object)types.get("UNDEFINED"));
        this.UNKNOWN = (JSType)Preconditions.checkNotNull((Object)types.get("UNKNOWN"));
        this.UNRESOLVED = (JSType)Preconditions.checkNotNull((Object)types.get("UNRESOLVED"));
        this.UNDEFINED_OR_BOOLEAN = (JSType)Preconditions.checkNotNull((Object)types.get("UNDEFINED_OR_BOOLEAN"));
        this.UNDEFINED_OR_NUMBER = (JSType)Preconditions.checkNotNull((Object)types.get("UNDEFINED_OR_NUMBER"));
        this.UNDEFINED_OR_STRING = (JSType)Preconditions.checkNotNull((Object)types.get("UNDEFINED_OR_STRING"));
        this.NULL_OR_BOOLEAN = (JSType)Preconditions.checkNotNull((Object)types.get("NULL_OR_BOOLEAN"));
        this.NULL_OR_NUMBER = (JSType)Preconditions.checkNotNull((Object)types.get("NULL_OR_NUMBER"));
        this.NULL_OR_STRING = (JSType)Preconditions.checkNotNull((Object)types.get("NULL_OR_STRING"));
        this.NULL_OR_UNDEFINED = (JSType)Preconditions.checkNotNull((Object)types.get("NULL_OR_UNDEFINED"));
        this.NUMBER_OR_STRING = (JSType)Preconditions.checkNotNull((Object)types.get("NUMBER_OR_STRING"));
        Map<String, FunctionType> functions = FunctionType.createInitialFunctionTypes(this);
        this.QMARK_FUNCTION = (FunctionType)Preconditions.checkNotNull((Object)functions.get("QMARK_FUNCTION"));
        this.BOTTOM_FUNCTION = (FunctionType)Preconditions.checkNotNull((Object)functions.get("BOTTOM_FUNCTION"));
        this.TOP_FUNCTION = (FunctionType)Preconditions.checkNotNull((Object)functions.get("TOP_FUNCTION"));
        this.LOOSE_TOP_FUNCTION = (FunctionType)Preconditions.checkNotNull((Object)functions.get("LOOSE_TOP_FUNCTION"));
        this.BOTTOM_PROPERTY_MAP = PersistentMap.of("_", Property.make(this.BOTTOM, this.BOTTOM));
        this.allowMethodsAsFunctions = inCompatibilityMode;
        this.looseSubtypingForLooseObjects = inCompatibilityMode;
        this.bivariantArrayGenerics = inCompatibilityMode;
        class MapToUnknown
        implements Map<String, JSType>,
        Serializable {
            MapToUnknown() {
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsKey(Object k) {
                return true;
            }

            @Override
            public boolean containsValue(Object v) {
                return v == JSTypes.this.UNKNOWN;
            }

            @Override
            public Set<Map.Entry<String, JSType>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public JSType get(Object k) {
                return JSTypes.this.UNKNOWN;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Set<String> keySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public JSType put(String k, JSType v) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends JSType> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public JSType remove(Object k) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<JSType> values() {
                return Collections.singleton(JSTypes.this.UNKNOWN);
            }

            public String toString() {
                return "MAP_TO_UNKNOWN";
            }
        }
        this.MAP_TO_UNKNOWN = new MapToUnknown();
    }

    public static JSTypes init(boolean inCompatibilityMode) {
        return new JSTypes(inCompatibilityMode);
    }

    public JSType fromFunctionType(FunctionType fn) {
        return JSType.fromFunctionType(fn, this.getFunctionType());
    }

    public NominalType getFunctionType() {
        if (this.builtinFunction == null) {
            return null;
        }
        return this.builtinFunction.getAsNominalType();
    }

    public JSType looseTopFunction() {
        return this.topFunction().withLoose();
    }

    public JSType topFunction() {
        return this.fromFunctionType(this.TOP_FUNCTION);
    }

    public JSType qmarkFunction() {
        return this.fromFunctionType(this.QMARK_FUNCTION);
    }

    public JSType getArrayInstance() {
        return this.getArrayInstance(this.UNKNOWN);
    }

    public JSType getArrayInstance(JSType t) {
        if (this.arrayType == null) {
            return this.UNKNOWN;
        }
        ImmutableList<String> typeParams = this.arrayType.getTypeParameters();
        if (typeParams.size() == 1) {
            return JSType.fromObjectType(ObjectType.fromNominalType(this.arrayType.getAsNominalType().instantiateGenerics((List<JSType>)ImmutableList.of((Object)t))));
        }
        return this.arrayType.getInstanceAsJSType();
    }

    public JSType getIArrayLikeInstance(JSType t) {
        return this.iArrayLike == null ? this.UNKNOWN : this.iArrayLike.getInstanceAsJSType().instantiateGenerics((List<? extends TypeI>)ImmutableList.of((Object)t));
    }

    public JSType getIterableInstance(JSType t) {
        return this.iterable == null ? this.UNKNOWN : this.iterable.getInstanceAsJSType().instantiateGenerics((List<? extends TypeI>)ImmutableList.of((Object)t));
    }

    public JSType getIteratorInstance(JSType t) {
        return this.iterator == null ? this.UNKNOWN : this.iterator.getInstanceAsJSType().instantiateGenerics((List<? extends TypeI>)ImmutableList.of((Object)t));
    }

    public JSType getIIterableResultInstance(JSType t) {
        return this.iIterableResult == null ? this.UNKNOWN : this.iIterableResult.getInstanceAsJSType().instantiateGenerics((List<? extends TypeI>)ImmutableList.of((Object)t));
    }

    public JSType getGeneratorInstance(JSType t) {
        return this.generator == null ? this.UNKNOWN : this.generator.getInstanceAsJSType().instantiateGenerics((List<? extends TypeI>)ImmutableList.of((Object)t));
    }

    public NominalType getObjectType() {
        return this.builtinObject == null ? null : this.builtinObject.getAsNominalType();
    }

    ObjectType getTopObjectType() {
        return this.topObjectType;
    }

    ObjectType getLooseTopObjectType() {
        return this.looseTopObject;
    }

    public NominalType getLiteralObjNominalType() {
        return this.literalObject == null ? null : this.literalObject.getAsNominalType();
    }

    public JSType getEmptyObjectLiteral() {
        return this.literalObject == null ? null : this.literalObject.getInstanceAsJSType();
    }

    public JSType getTopObject() {
        return this.topObject;
    }

    public JSType getTopStruct() {
        return this.topStruct;
    }

    public JSType getTopDict() {
        return this.topDict;
    }

    ObjectType getBottomObject() {
        return this.bottomObject;
    }

    public RawNominalType getIObjectType() {
        return this.iObject;
    }

    public JSType getArgumentsArrayType(JSType t) {
        if (this.arguments == null) {
            return this.UNKNOWN;
        }
        ImmutableList<String> typeParams = this.arguments.getTypeParameters();
        JSType result = this.arguments.getInstanceAsJSType();
        if (typeParams.size() == 1) {
            String typeParam = (String)Iterables.getOnlyElement(typeParams);
            result = result.substituteGenerics((Map<String, JSType>)ImmutableMap.of((Object)typeParam, (Object)t));
        }
        return result;
    }

    public JSType getArgumentsArrayType() {
        return this.getArgumentsArrayType(this.UNKNOWN);
    }

    public JSType getRegexpType() {
        return this.regexpInstance != null ? this.regexpInstance : this.UNKNOWN;
    }

    public JSType getGlobalThis() {
        return this.globalThis != null ? this.globalThis : this.UNKNOWN;
    }

    public JSType getNumberInstance() {
        return this.numberInstance != null ? this.numberInstance : this.NUMBER;
    }

    public JSType getBooleanInstance() {
        return this.booleanInstance != null ? this.booleanInstance : this.BOOLEAN;
    }

    public JSType getStringInstance() {
        return this.stringInstance != null ? this.stringInstance : this.STRING;
    }

    ObjectType getNumberInstanceObjType() {
        return this.numberInstanceObjtype != null ? this.numberInstanceObjtype : this.topObjectType;
    }

    ObjectType getBooleanInstanceObjType() {
        return this.booleanInstanceObjtype != null ? this.booleanInstanceObjtype : this.topObjectType;
    }

    ObjectType getStringInstanceObjType() {
        return this.stringInstanceObjtype != null ? this.stringInstanceObjtype : this.topObjectType;
    }

    public JSType getITemplateArrayType() {
        return this.iTemplateArray != null ? this.iTemplateArray.getInstanceAsJSType() : this.UNKNOWN;
    }

    public JSType getNativeType(JSTypeNative typeId) {
        switch (typeId) {
            case ALL_TYPE: {
                return this.TOP;
            }
            case NO_TYPE: {
                return this.BOTTOM;
            }
            case UNKNOWN_TYPE: {
                return this.UNKNOWN;
            }
            case VOID_TYPE: {
                return this.UNDEFINED;
            }
            case NULL_TYPE: {
                return this.NULL;
            }
            case FALSE_TYPE: {
                return this.FALSE_TYPE;
            }
            case TRUE_TYPE: {
                return this.TRUE_TYPE;
            }
            case BOOLEAN_TYPE: {
                return this.BOOLEAN;
            }
            case STRING_TYPE: {
                return this.STRING;
            }
            case NUMBER_TYPE: {
                return this.NUMBER;
            }
            case NUMBER_STRING_BOOLEAN: {
                return JSType.join(this.NUMBER_OR_STRING, this.BOOLEAN);
            }
            case REGEXP_TYPE: {
                return this.getRegexpType();
            }
            case ARRAY_TYPE: {
                return this.getArrayInstance();
            }
            case OBJECT_TYPE: {
                return this.getTopObject();
            }
            case EMPTY_OBJECT_LITERAL_TYPE: {
                return this.getEmptyObjectLiteral();
            }
            case OBJECT_FUNCTION_TYPE: {
                return this.fromFunctionType(this.getObjectType().getConstructorFunction());
            }
            case TRUTHY: {
                return this.TRUTHY;
            }
            case NO_OBJECT_TYPE: {
                return JSType.fromObjectType(this.getBottomObject());
            }
            case FUNCTION_PROTOTYPE: {
                return this.getFunctionType().getPrototypeObject();
            }
            case FUNCTION_INSTANCE_TYPE: {
                return this.fromFunctionType(this.QMARK_FUNCTION);
            }
            case FUNCTION_FUNCTION_TYPE: {
                return this.builtinFunction.toJSType();
            }
            case OBJECT_PROTOTYPE: 
            case TOP_LEVEL_PROTOTYPE: {
                return this.getTopObject().getNominalTypeIfSingletonObj().getPrototypeObject();
            }
            case GLOBAL_THIS: {
                return this.getGlobalThis();
            }
            case I_ITERABLE_RESULT_TYPE: {
                return this.getIIterableResultInstance(this.UNKNOWN);
            }
            case I_TEMPLATE_ARRAY_TYPE: {
                return this.getITemplateArrayType();
            }
            case ITERABLE_TYPE: {
                return this.getIterableInstance(this.UNKNOWN);
            }
            case ITERATOR_TYPE: {
                return this.getIteratorInstance(this.UNKNOWN);
            }
            case GENERATOR_TYPE: {
                return this.getGeneratorInstance(this.UNKNOWN);
            }
        }
        throw new RuntimeException("Native type " + typeId.name() + " not found");
    }

    public void setArgumentsType(RawNominalType arguments) {
        this.arguments = arguments;
    }

    public void setFunctionType(RawNominalType builtinFunction) {
        this.builtinFunction = builtinFunction;
    }

    public void setObjectType(RawNominalType builtinObject) {
        NominalType builtinObjectNT = builtinObject.getAsNominalType();
        this.builtinObject = builtinObject;
        this.topObjectType = builtinObject.getInstanceAsJSType().getObjTypeIfSingletonObj();
        this.looseTopObject = ObjectType.makeObjectType(this, builtinObjectNT, PersistentMap.create(), null, null, true, ObjectKind.UNRESTRICTED);
        this.topObject = JSType.fromObjectType(this.topObjectType);
        this.topStruct = JSType.fromObjectType(ObjectType.makeObjectType(this, builtinObjectNT, PersistentMap.create(), null, null, false, ObjectKind.STRUCT));
        this.topDict = JSType.fromObjectType(ObjectType.makeObjectType(this, builtinObjectNT, PersistentMap.create(), null, null, false, ObjectKind.DICT));
        this.bottomObject = ObjectType.createBottomObject(this);
    }

    public void setLiteralObjNominalType(RawNominalType literalObject) {
        this.literalObject = literalObject;
    }

    public void setArrayType(RawNominalType arrayType) {
        this.arrayType = arrayType;
    }

    public void setIObjectType(RawNominalType iObject) {
        this.iObject = iObject;
    }

    public void setIArrayLikeType(RawNominalType iArrayLike) {
        this.iArrayLike = iArrayLike;
    }

    public void setIterableType(RawNominalType iterable) {
        this.iterable = iterable;
    }

    public void setIteratorType(RawNominalType iterator) {
        this.iterator = iterator;
    }

    public void setIIterableResultType(RawNominalType iIterableResult) {
        this.iIterableResult = iIterableResult;
    }

    public void setITemplateArrayType(RawNominalType iTemplateArray) {
        this.iTemplateArray = iTemplateArray;
    }

    public void setGeneratorType(RawNominalType generator) {
        this.generator = generator;
    }

    public void setRegexpInstance(JSType regexpInstance) {
        this.regexpInstance = regexpInstance;
    }

    public void setGlobalThis(JSType globalThis) {
        Preconditions.checkState((this.globalThis == null ? 1 : 0) != 0, (String)"Tried to reassign globalThis from %s to %s", (Object)this.globalThis, (Object)globalThis);
        this.globalThis = globalThis;
    }

    public void setNumberInstance(JSType t) {
        Preconditions.checkState((this.numberInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.numberInstance = t;
        this.numberOrNumber = JSType.join(this.NUMBER, this.numberInstance);
        this.numberInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
        if (this.stringInstance != null) {
            this.anyNumOrStr = JSType.join(this.numberOrNumber, this.stringOrString);
        }
    }

    public void setBooleanInstance(JSType t) {
        Preconditions.checkState((this.booleanInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.booleanInstance = t;
        this.booleanInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
    }

    public void setStringInstance(JSType t) {
        Preconditions.checkState((this.stringInstance == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)t);
        this.stringInstance = t;
        this.stringOrString = JSType.join(this.STRING, this.stringInstance);
        this.stringInstanceObjtype = (ObjectType)Iterables.getOnlyElement(t.getObjs());
        if (this.numberInstance != null) {
            this.anyNumOrStr = JSType.join(this.numberOrNumber, this.stringOrString);
        }
    }

    public boolean isNumberScalarOrObj(JSType t) {
        if (this.numberOrNumber == null) {
            return t.isSubtypeOf(this.NUMBER);
        }
        return t.isSubtypeOf(this.numberOrNumber);
    }

    public boolean isStringScalarOrObj(JSType t) {
        if (this.numberOrNumber == null) {
            return t.isSubtypeOf(this.STRING);
        }
        return t.isSubtypeOf(this.stringOrString);
    }

    public boolean isNumStrScalarOrObj(JSType t) {
        if (this.anyNumOrStr == null) {
            return t.isSubtypeOf(this.NUMBER_OR_STRING);
        }
        return t.isSubtypeOf(this.anyNumOrStr);
    }

    boolean isBottomPropertyMap(PersistentMap<String, Property> map) {
        return map == this.BOTTOM_PROPERTY_MAP;
    }

    public String createGetterPropName(String originalPropName) {
        return "%getter_fun" + originalPropName;
    }

    public String createSetterPropName(String originalPropName) {
        return "%setter_fun" + originalPropName;
    }
}

