/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;

public final class NominalTypeBuilderNti
implements NominalTypeBuilder {
    private final NominalType nt;

    public NominalTypeBuilderNti(NominalType nt) {
        this.nt = nt;
    }

    @Override
    public NominalTypeBuilder superClass() {
        NominalType superClass = this.nt.getInstantiatedSuperclass();
        return superClass != null ? new NominalTypeBuilderNti(superClass) : null;
    }

    @Override
    public FunctionTypeI constructor() {
        FunctionType ctor = this.nt.getConstructorFunction();
        Preconditions.checkState((ctor != null ? 1 : 0) != 0);
        return this.nt.getCommonTypes().fromFunctionType(ctor);
    }

    @Override
    public ObjectTypeI instance() {
        return this.nt.getInstanceAsJSType();
    }

    @Override
    public ObjectTypeI prototypeOrInstance() {
        return this.instance();
    }

    @Override
    public void declarePrototypeProperty(String name, TypeI type, Node defSite) {
        Preconditions.checkArgument((boolean)(type instanceof JSType));
        if (!name.equals("constructor")) {
            this.nt.getRawNominalType().addProtoProperty(name, defSite, (JSType)type, true);
        }
    }

    @Override
    public void declareInstanceProperty(String name, TypeI type, Node defSite) {
        Preconditions.checkArgument((boolean)(type instanceof JSType));
        this.nt.getRawNominalType().addInstanceProperty(name, defSite, (JSType)type, true);
    }

    @Override
    public void declareConstructorProperty(String name, TypeI type, Node defSite) {
        Preconditions.checkArgument((boolean)(type instanceof JSType));
        this.nt.getRawNominalType().addCtorProperty(name, defSite, (JSType)type, true);
    }
}

