/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MismatchInfo;
import com.google.javascript.jscomp.newtypes.Namespace;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectsBuilder;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.ToStringContext;
import com.google.javascript.jscomp.newtypes.TypeWithProperties;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

final class ObjectType
implements TypeWithProperties {
    private final NominalType nominalType;
    private final Namespace ns;
    private final FunctionType fn;
    private final boolean isLoose;
    private final PersistentMap<String, Property> props;
    private final ObjectKind objectKind;
    private final JSTypes commonTypes;

    static ObjectType createBottomObject(JSTypes commonTypes) {
        return new ObjectType(commonTypes, commonTypes.getObjectType(), (PersistentMap)Preconditions.checkNotNull(commonTypes.BOTTOM_PROPERTY_MAP), null, null, false, ObjectKind.UNRESTRICTED);
    }

    private ObjectType(JSTypes commonTypes, NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, Namespace ns, boolean isLoose, ObjectKind objectKind) {
        Preconditions.checkNotNull((Object)commonTypes);
        Preconditions.checkNotNull((Object)nominalType);
        Preconditions.checkArgument((fn == null || fn.isQmarkFunction() || fn.isLoose() == isLoose ? 1 : 0) != 0, (String)"isLoose: %s, fn: %s", (Object)isLoose, (Object)fn);
        Preconditions.checkArgument((boolean)FunctionType.isInhabitable(fn));
        if (ns != null) {
            String name = nominalType.getName();
            Preconditions.checkArgument((name.equals("Object{}") || name.equals("Function") || name.equals("Window") ? 1 : 0) != 0, (String)"Can't create namespace with nominal type %s", (Object)name);
        }
        if (isLoose) {
            Preconditions.checkArgument((nominalType.isBuiltinObject() || nominalType.isFunction() ? 1 : 0) != 0, (String)"Cannot create loose objectType with nominal type %s", (Object)nominalType);
        }
        Preconditions.checkArgument((fn == null || nominalType.isFunction() ? 1 : 0) != 0, (String)"Cannot create objectType of nominal type %s with function (%s)", (Object)nominalType, (Object)fn);
        this.commonTypes = commonTypes;
        this.nominalType = nominalType;
        this.props = isLoose ? ObjectType.loosenProps(props) : props;
        this.fn = fn;
        this.ns = ns;
        this.isLoose = isLoose;
        this.objectKind = isLoose ? ObjectKind.UNRESTRICTED : objectKind;
    }

    private static PersistentMap<String, Property> loosenProps(PersistentMap<String, Property> props) {
        PersistentMap<String, Property> newProps = props;
        for (Map.Entry entry : props.entrySet()) {
            JSType propType = ((Property)entry.getValue()).getType();
            ObjectType objType = propType.getObjTypeIfSingletonObj();
            if (objType == null || objType.nominalType.isClassy() || objType.isLoose()) continue;
            newProps = newProps.with((String)entry.getKey(), Property.make(propType.withLoose(), null));
        }
        return newProps;
    }

    static ObjectType makeObjectType(JSTypes commonTypes, NominalType nominalType, PersistentMap<String, Property> props, FunctionType fn, Namespace ns, boolean isLoose, ObjectKind ok) {
        Preconditions.checkNotNull((Object)nominalType);
        if (props == null) {
            props = PersistentMap.create();
        } else if (ObjectType.containsBottomProp(props) || !FunctionType.isInhabitable(fn)) {
            return commonTypes.getBottomObject();
        }
        if (!(fn == null || props.containsKey("prototype") || ns != null && ns.getNsProp("prototype") != null)) {
            props = props.with("prototype", Property.make(fn.getCommonTypes().UNKNOWN, null));
        }
        return new ObjectType(commonTypes, nominalType, props, fn, ns, isLoose, ok);
    }

    static ObjectType fromFunction(FunctionType fn, NominalType fnNominal) {
        return ObjectType.makeObjectType(fn.getCommonTypes(), fnNominal, null, fn, null, fn.isLoose(), ObjectKind.UNRESTRICTED);
    }

    static ObjectType fromNominalType(NominalType cl) {
        return ObjectType.makeObjectType(cl.getCommonTypes(), cl, null, null, null, false, cl.getObjectKind());
    }

    static ObjectType fromProperties(JSTypes commonTypes, Map<String, Property> oldProps) {
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> entry : oldProps.entrySet()) {
            Property prop = entry.getValue();
            if (prop.getDeclaredType().isBottom()) {
                return commonTypes.getBottomObject();
            }
            newProps = newProps.with(entry.getKey(), prop);
        }
        return new ObjectType(commonTypes, commonTypes.getObjectType(), newProps, null, null, false, ObjectKind.UNRESTRICTED);
    }

    JSTypes getCommonTypes() {
        return this.commonTypes;
    }

    boolean isInhabitable() {
        return this != this.commonTypes.getBottomObject();
    }

    private static boolean containsBottomProp(PersistentMap<String, Property> props) {
        for (Property p : props.values()) {
            if (!p.getType().isBottom()) continue;
            return true;
        }
        return false;
    }

    boolean isStruct() {
        return this.objectKind.isStruct();
    }

    boolean isLoose() {
        return this.isLoose;
    }

    boolean isDict() {
        return this.objectKind.isDict();
    }

    boolean isFunctionWithProperties() {
        return this.fn != null && this.hasNonPrototypeProperties();
    }

    boolean isInterfaceInstance() {
        return this.nominalType.isInterface();
    }

    boolean isNamespace() {
        return this.ns != null;
    }

    private boolean isBuiltinObjectPrototype() {
        return this.nominalType.isBuiltinObject() && this.isPrototypeObject();
    }

    @Nullable
    ObjectType getPrototypeObject() {
        ObjectType proto = this.isPrototypeObject() && !this.isBuiltinObjectPrototype() ? this.nominalType.getInstanceAsObjectType() : this.nominalType.getPrototypeObject().getObjTypeIfSingletonObj();
        if (this.equals(proto)) {
            Preconditions.checkState((boolean)this.isBuiltinObjectPrototype(), (String)"Failed to reach Object.prototype in prototype chain, unexpected self-link found at %s", (Object)this);
            return null;
        }
        return proto;
    }

    boolean isPrototypeObject() {
        return this.getOwnerFunction() != null;
    }

    FunctionType getOwnerFunction() {
        JSType proto;
        FunctionType maybeCtor;
        JSType t = this.getProp(new QualifiedName("constructor"));
        if (t != null && t.isFunctionType() && (maybeCtor = t.getFunTypeIfSingletonObj()).isSomeConstructorOrInterface() && this.nominalType.equals((proto = maybeCtor.getPrototypeOfNewInstances()).getNominalTypeIfSingletonObj())) {
            return maybeCtor;
        }
        return null;
    }

    private boolean hasNonPrototypeProperties() {
        for (String pname : this.props.keySet()) {
            if (pname.equals("prototype")) continue;
            return true;
        }
        return this.ns != null;
    }

    private static boolean hasOnlyBuiltinProps(ObjectType obj, ObjectType someBuiltinObj) {
        for (String pname : obj.props.keySet()) {
            if (someBuiltinObj.mayHaveProp(new QualifiedName(pname))) continue;
            return false;
        }
        return true;
    }

    static JSType mayTurnLooseObjectToScalar(JSType t, JSTypes commonTypes) {
        ObjectType obj = t.getObjTypeIfSingletonObj();
        if (obj == null || !obj.isLoose() || obj.props.isEmpty() || obj.fn != null || ObjectType.hasOnlyBuiltinProps(obj, t.getCommonTypes().getTopObjectType()) || ObjectType.hasOnlyBuiltinProps(obj, commonTypes.getArrayInstance().getObjTypeIfSingletonObj())) {
            return t;
        }
        if (ObjectType.hasOnlyBuiltinProps(obj, commonTypes.getNumberInstanceObjType())) {
            return t.getCommonTypes().NUMBER;
        }
        if (ObjectType.hasOnlyBuiltinProps(obj, commonTypes.getStringInstanceObjType())) {
            return t.getCommonTypes().STRING;
        }
        return t;
    }

    ObjectType withLoose() {
        if (this.isTopObject()) {
            return this.commonTypes.getLooseTopObjectType();
        }
        if (this.isLoose() || !this.nominalType.isBuiltinObject() && !this.nominalType.isFunction() || this.ns != null) {
            return this;
        }
        FunctionType fn = this.fn == null ? null : this.fn.withLoose();
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry propsEntry : this.props.entrySet()) {
            String pname = (String)propsEntry.getKey();
            Property prop = (Property)propsEntry.getValue();
            newProps = newProps.with(pname, prop.withRequired());
        }
        return new ObjectType(this.commonTypes, this.nominalType, newProps, fn, null, true, this.objectKind);
    }

    ObjectType withFunction(FunctionType ft, NominalType fnNominal) {
        Preconditions.checkState((boolean)this.isNamespace());
        Preconditions.checkState((!ft.isLoose() || ft.isQmarkFunction() ? 1 : 0) != 0);
        ObjectType obj = ObjectType.makeObjectType(this.commonTypes, fnNominal, this.props, ft, this.ns, false, this.objectKind);
        this.ns.updateNamespaceType(JSType.fromObjectType(obj));
        return obj;
    }

    static ImmutableSet<ObjectType> withoutProperty(Set<ObjectType> objs, QualifiedName qname) {
        ImmutableSet.Builder newObjs = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            newObjs.add((Object)obj.withProperty(qname, null));
        }
        return newObjs.build();
    }

    private ObjectType withPropertyHelper(QualifiedName qname, JSType type, boolean isDeclared, boolean isConstant) {
        PersistentMap<String, Property> newProps = this.props;
        if (qname.isIdentifier()) {
            JSType inferred;
            String pname = qname.getLeftmostName();
            JSType declType = this.getDeclaredProp(qname);
            JSType jSType = inferred = this.hasProp(qname) ? this.getProp(qname) : null;
            if (type == null) {
                type = declType;
            }
            if (declType != null) {
                isDeclared = true;
                if (this.hasConstantProp(qname)) {
                    isConstant = true;
                }
                if (type != null && !type.isSubtypeOf(declType, SubtypeCache.create())) {
                    type = declType;
                }
            }
            if (type == null) {
                newProps = newProps.without(pname);
            } else if (!type.equals(declType) && !type.equals(inferred)) {
                if (isDeclared && declType == null) {
                    declType = type;
                }
                Node defsite = null;
                if (this.hasProp(qname)) {
                    defsite = this.getLeftmostProp(qname).getDefSite();
                }
                newProps = newProps.with(pname, isConstant ? Property.makeConstant(defsite, type, declType) : Property.makeWithDefsite(defsite, type, isDeclared ? declType : null));
            }
        } else {
            JSType declared;
            Property objProp;
            String objName = qname.getLeftmostName();
            QualifiedName objQname = new QualifiedName(objName);
            if (!this.mayHaveProp(objQname)) {
                Preconditions.checkState((type == null ? 1 : 0) != 0, (String)"Trying to update property %s on type %s, but sub-property %s does not exist", (Object)qname, (Object)this, (Object)objName);
                return this;
            }
            QualifiedName innerProps = qname.getAllButLeftmost();
            JSType inferred = type == null ? objProp.getType().withoutProperty(innerProps) : objProp.getType().withProperty(innerProps, type);
            if (!inferred.equals(declared = (objProp = this.getLeftmostProp(objQname)).getDeclaredType())) {
                newProps = newProps.with(objName, objProp.isOptional() ? Property.makeOptional(null, inferred, declared) : Property.make(inferred, declared));
            }
        }
        if (newProps == this.props) {
            return this;
        }
        return ObjectType.makeObjectType(this.commonTypes, this.nominalType, newProps, this.fn, this.ns, this.isLoose, this.objectKind);
    }

    ObjectType withProperty(QualifiedName qname, JSType type) {
        return this.withPropertyHelper(qname, type, false, false);
    }

    ObjectType withDeclaredProperty(QualifiedName qname, JSType type, boolean isConstant) {
        return this.withPropertyHelper(qname, type, true, isConstant);
    }

    ObjectType withPropertyRequired(String pname) {
        Property oldProp = (Property)this.props.get(pname);
        Property newProp = oldProp == null ? Property.make(this.commonTypes.UNKNOWN, null) : Property.make(oldProp.getType(), oldProp.getDeclaredType());
        return ObjectType.makeObjectType(this.commonTypes, this.nominalType, this.props.with(pname, newProp), this.fn, this.ns, this.isLoose, this.objectKind);
    }

    private static PersistentMap<String, Property> meetPropsHelper(JSTypes commonTypes, boolean specializeProps1, NominalType resultNominalType, PersistentMap<String, Property> props1, PersistentMap<String, Property> props2) {
        String pname;
        Preconditions.checkNotNull((Object)resultNominalType);
        PersistentMap<String, Property> newProps = props1;
        for (Map.Entry propsEntry : props1.entrySet()) {
            pname = (String)propsEntry.getKey();
            Property otherProp = resultNominalType.getProp(pname, RawNominalType.PropAccess.INCLUDE_STRAY_PROPS);
            if (otherProp == null || !commonTypes.isBottomPropertyMap(newProps = ObjectType.addOrRemoveProp(specializeProps1, newProps, pname, otherProp, (Property)propsEntry.getValue()))) continue;
            return commonTypes.BOTTOM_PROPERTY_MAP;
        }
        for (Map.Entry propsEntry : props2.entrySet()) {
            Property newProp;
            pname = (String)propsEntry.getKey();
            Property prop2 = (Property)propsEntry.getValue();
            if (!props1.containsKey(pname)) {
                newProp = prop2;
            } else {
                Property prop1 = (Property)props1.get(pname);
                if (prop1.equals(prop2)) continue;
                newProp = specializeProps1 ? prop1.specialize(prop2) : Property.meet(prop1, prop2);
            }
            Property otherProp = resultNominalType.getProp(pname, RawNominalType.PropAccess.INCLUDE_STRAY_PROPS);
            if (otherProp != null) {
                if (!commonTypes.isBottomPropertyMap(newProps = ObjectType.addOrRemoveProp(specializeProps1, newProps, pname, otherProp, newProp))) continue;
                return commonTypes.BOTTOM_PROPERTY_MAP;
            }
            if (newProp.getType().isBottom()) {
                return commonTypes.BOTTOM_PROPERTY_MAP;
            }
            newProps = newProps.with(pname, newProp);
        }
        return newProps;
    }

    private static PersistentMap<String, Property> addOrRemoveProp(boolean specializeProps1, PersistentMap<String, Property> props, String pname, Property nomProp, Property objProp) {
        JSType nomPropType = nomProp.getType();
        Property newProp = specializeProps1 ? nomProp.specialize(objProp) : Property.meet(nomProp, objProp);
        JSType newPropType = newProp.getType();
        if (newPropType.isBottom()) {
            return newPropType.getCommonTypes().BOTTOM_PROPERTY_MAP;
        }
        if (!newPropType.isUnknown() && newPropType.isSubtypeOf(nomPropType, SubtypeCache.create()) && !newPropType.equals(nomPropType)) {
            return props.with(pname, newProp);
        }
        return props.without(pname);
    }

    private static Property getProp(Map<String, Property> props, NominalType nom, String pname) {
        if (props.containsKey(pname)) {
            return props.get(pname);
        }
        if (nom != null) {
            return nom.getProp(pname, RawNominalType.PropAccess.INCLUDE_STRAY_PROPS);
        }
        return null;
    }

    private static PersistentMap<String, Property> joinProps(Map<String, Property> props1, Map<String, Property> props2, NominalType nom1, NominalType nom2) {
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String pname : Sets.union(props1.keySet(), props2.keySet())) {
            Property prop1 = ObjectType.getProp(props1, nom1, pname);
            Property prop2 = ObjectType.getProp(props2, nom2, pname);
            Property newProp = null;
            newProp = prop1 == null ? prop2.withOptional() : (prop2 == null ? prop1.withOptional() : Property.join(prop1, prop2));
            newProps = newProps.with(pname, newProp);
        }
        return newProps;
    }

    private static PersistentMap<String, Property> joinPropsLoosely(Map<String, Property> props1, Map<String, Property> props2) {
        String pname;
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry<String, Property> propsEntry : props1.entrySet()) {
            pname = propsEntry.getKey();
            if (props2.containsKey(pname)) continue;
            newProps = newProps.with(pname, propsEntry.getValue().withRequired());
        }
        for (Map.Entry<String, Property> propsEntry : props2.entrySet()) {
            pname = propsEntry.getKey();
            Property prop2 = propsEntry.getValue();
            if (props1.containsKey(pname)) {
                newProps = newProps.with(pname, Property.join(props1.get(pname), prop2).withRequired());
                continue;
            }
            newProps = newProps.with(pname, prop2.withRequired());
        }
        return newProps;
    }

    static boolean isUnionSubtype(boolean keepLoosenessOfThis, Set<ObjectType> objs1, Set<ObjectType> objs2, SubtypeCache subSuperMap) {
        return ObjectType.isUnionSubtypeHelper(keepLoosenessOfThis, objs1, objs2, subSuperMap, null);
    }

    static void whyNotUnionSubtypes(boolean keepLoosenessOfThis, Set<ObjectType> objs1, Set<ObjectType> objs2, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        Preconditions.checkArgument((boxedInfo.length == 1 ? 1 : 0) != 0);
        boolean areSubtypes = ObjectType.isUnionSubtypeHelper(keepLoosenessOfThis, objs1, objs2, subSuperMap, boxedInfo);
        Preconditions.checkArgument((!areSubtypes ? 1 : 0) != 0);
    }

    private static boolean isUnionSubtypeHelper(boolean keepLoosenessOfThis, Set<ObjectType> objs1, Set<ObjectType> objs2, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        for (ObjectType obj1 : objs1) {
            boolean foundSupertype = false;
            for (ObjectType obj2 : objs2) {
                if (!obj1.isSubtypeOfHelper(keepLoosenessOfThis, obj2, subSuperMap, null)) continue;
                foundSupertype = true;
                break;
            }
            if (foundSupertype) continue;
            if (boxedInfo != null) {
                boxedInfo[0] = MismatchInfo.makeUnionTypeMismatch(JSType.fromObjectType(obj1));
            }
            return false;
        }
        return true;
    }

    boolean isSubtypeOf(ObjectType obj2, SubtypeCache subSuperMap) {
        return this.isSubtypeOfHelper(true, obj2, subSuperMap, null);
    }

    static void whyNotSubtypeOf(ObjectType obj1, ObjectType obj2, MismatchInfo[] boxedInfo) {
        Preconditions.checkArgument((boxedInfo.length == 1 ? 1 : 0) != 0);
        boolean areSubtypes = obj1.isSubtypeOfHelper(true, obj2, SubtypeCache.create(), boxedInfo);
        Preconditions.checkState((!areSubtypes ? 1 : 0) != 0, (String)"Type %s shouldn't be a subtype of %s", (Object)obj1, (Object)obj2);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, ObjectType other, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        Object otherPropNames;
        if (other.isTopObject()) {
            return true;
        }
        if (keepLoosenessOfThis && this.isLoose || other.isLoose) {
            return this.isLooseSubtypeOf(other, subSuperMap);
        }
        NominalType thisNt = this.nominalType;
        NominalType otherNt = other.nominalType;
        boolean checkOnlyLocalProps = true;
        if (otherNt.isStructuralInterface()) {
            if (otherNt.equals(subSuperMap.get(thisNt))) {
                return true;
            }
            subSuperMap = subSuperMap.with(thisNt, otherNt);
            if (!thisNt.isNominalSubtypeOf(otherNt)) {
                checkOnlyLocalProps = false;
            }
            if (thisNt.inheritsFromIObjectReflexive() && otherNt.inheritsFromIObjectReflexive() && !thisNt.isIObjectSubtypeOf(otherNt)) {
                return false;
            }
            if ((thisNt.isBuiltinObject() || thisNt.isLiteralObject()) && otherNt.isIObject()) {
                return this.compareRecordTypeToIObject(otherNt, subSuperMap);
            }
        } else if (!thisNt.isNominalSubtypeOf(otherNt)) {
            return false;
        }
        if (checkOnlyLocalProps) {
            otherPropNames = other.props.keySet();
        } else {
            otherPropNames = otherNt.getPropertyNames();
            if (otherPropNames == null) {
                return false;
            }
        }
        if (!this.arePropertiesSubtypes(other, (Set<String>)otherPropNames, subSuperMap, boxedInfo)) {
            return false;
        }
        if (other.fn == null) {
            return true;
        }
        if (this.fn == null) {
            return false;
        }
        boolean areFunsSubtypes = this.fn.isSubtypeOf(other.fn, subSuperMap);
        if (boxedInfo != null) {
            FunctionType.whyNotSubtypeOf(this.fn, other.fn, subSuperMap, boxedInfo);
        }
        return areFunsSubtypes;
    }

    private boolean compareRecordTypeToIObject(NominalType otherNt, SubtypeCache subSuperMap) {
        JSType keyType = otherNt.getIndexType();
        if (!(keyType.isNumber() || keyType.isString() || keyType.isUnknown())) {
            return this.props.isEmpty();
        }
        JSType valueType = otherNt.getIndexedType();
        for (Map.Entry entry : this.props.entrySet()) {
            String pname = (String)entry.getKey();
            JSType ptype = ((Property)entry.getValue()).getType();
            if (keyType.isNumber() && Ints.tryParse((String)pname) == null) {
                return false;
            }
            if (ptype.removeType(this.commonTypes.UNDEFINED).isSubtypeOf(valueType, subSuperMap)) continue;
            return false;
        }
        return true;
    }

    private boolean arePropertiesSubtypes(ObjectType other, Set<String> otherPropNames, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        QualifiedName qname;
        for (String pname : otherPropNames) {
            if (ObjectType.isPropertySubtype(pname, this.getLeftmostProp(qname = new QualifiedName(pname)), other.getLeftmostProp(qname), subSuperMap, boxedInfo)) continue;
            return false;
        }
        if (other.ns != null) {
            for (String pname : other.ns.getAllPropsOfNamespace()) {
                if (otherPropNames.contains(pname) || ObjectType.isPropertySubtype(pname, this.getLeftmostProp(qname = new QualifiedName(pname)), other.getLeftmostProp(qname), subSuperMap, boxedInfo)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isPropertySubtype(String pname, Property prop1, Property prop2, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        return boxedInfo != null ? ObjectType.getPropMismatchInfo(pname, prop1, prop2, subSuperMap, boxedInfo) : ObjectType.isPropertySubtypeHelper(prop1, prop2, subSuperMap);
    }

    private static boolean isPropertySubtypeHelper(Property prop1, Property prop2, SubtypeCache subSuperMap) {
        return !(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap));
    }

    private static boolean getPropMismatchInfo(String pname, Property prop1, Property prop2, SubtypeCache subSuperMap, MismatchInfo[] boxedInfo) {
        Preconditions.checkNotNull((Object)pname);
        if (prop2.isOptional()) {
            if (prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap)) {
                boxedInfo[0] = MismatchInfo.makePropTypeMismatch(pname, prop2.getType(), prop1.getType());
                return false;
            }
        } else {
            if (prop1 == null) {
                boxedInfo[0] = MismatchInfo.makeMissingPropMismatch(pname);
                return false;
            }
            if (prop1.isOptional()) {
                boxedInfo[0] = MismatchInfo.makeMaybeMissingPropMismatch(pname);
                return false;
            }
            if (!prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap)) {
                boxedInfo[0] = MismatchInfo.makePropTypeMismatch(pname, prop2.getType(), prop1.getType());
                return false;
            }
        }
        return true;
    }

    boolean isLooseSubtypeOf(ObjectType other, SubtypeCache subSuperMap) {
        Preconditions.checkState((this.isLoose || other.isLoose ? 1 : 0) != 0);
        if (other.isTopObject()) {
            return true;
        }
        if (!this.isLoose) {
            for (String pname : other.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (!(this.isStruct() ? !this.mayHaveProp(qname) || !this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap) : this.mayHaveProp(qname) && !this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap))) continue;
                return false;
            }
        } else {
            for (String pname : this.props.keySet()) {
                QualifiedName qname = new QualifiedName(pname);
                if (!other.mayHaveProp(qname) || this.getProp(qname).isSubtypeOf(other.getProp(qname), subSuperMap)) continue;
                return false;
            }
        }
        if (other.fn == null) {
            return this.fn == null || other.nominalType.isBuiltinObject() || other.isLoose();
        }
        if (this.fn == null) {
            return this.isLoose;
        }
        return this.fn.isLooseSubtypeOf(other.fn);
    }

    ObjectType specialize(ObjectType other) {
        FunctionType newFn;
        PersistentMap<String, Property> newProps;
        Preconditions.checkState((boolean)ObjectType.areRelatedNominalTypes(this.nominalType, other.nominalType));
        if (this.isTopObject() && other.objectKind.isUnrestricted()) {
            return other;
        }
        if (this.ns != null) {
            return this.specializeNamespace(other);
        }
        NominalType resultNomType = this.nominalType.isBuiltinObject() && other.nominalType.isStructuralInterface() ? this.nominalType : NominalType.pickSubclass(this.nominalType, other.nominalType);
        if (resultNomType.isClassy()) {
            if (this.fn != null || other.fn != null) {
                return this.commonTypes.getBottomObject();
            }
            PersistentMap<String, Property> newProps2 = ObjectType.meetPropsHelper(this.commonTypes, true, resultNomType, this.props, other.props);
            if (this.commonTypes.isBottomPropertyMap(newProps2)) {
                return this.commonTypes.getBottomObject();
            }
            return new ObjectType(this.commonTypes, resultNomType, newProps2, null, this.ns, false, this.objectKind);
        }
        FunctionType thisFn = this.fn;
        boolean isLoose = this.isLoose;
        if (resultNomType.isFunction() && this.fn == null) {
            thisFn = other.fn;
            isLoose = other.fn.isLoose();
        }
        if (isLoose && resultNomType.isLiteralObject()) {
            resultNomType = this.commonTypes.getObjectType();
        }
        if (this.commonTypes.isBottomPropertyMap(newProps = ObjectType.meetPropsHelper(this.commonTypes, true, resultNomType, this.props, other.props))) {
            return this.commonTypes.getBottomObject();
        }
        FunctionType functionType = newFn = thisFn == null ? null : thisFn.specialize(other.fn);
        if (!FunctionType.isInhabitable(newFn)) {
            return this.commonTypes.getBottomObject();
        }
        return new ObjectType(this.commonTypes, resultNomType, newProps, newFn, this.ns, isLoose, this.objectKind);
    }

    private static QualifiedName getPropertyPath(ObjectType obj) {
        if (obj.props.size() != 1) {
            return null;
        }
        Map.Entry entry = obj.props.entrySet().iterator().next();
        QualifiedName leftmostPname = new QualifiedName((String)entry.getKey());
        ObjectType propAsObj = ((Property)entry.getValue()).getType().getObjTypeIfSingletonObj();
        if (propAsObj == null) {
            return leftmostPname;
        }
        QualifiedName restPath = ObjectType.getPropertyPath(propAsObj);
        if (restPath == null) {
            return leftmostPname;
        }
        return QualifiedName.join(leftmostPname, restPath);
    }

    ObjectType specializeNamespace(ObjectType other) {
        JSType newPropType;
        Preconditions.checkNotNull((Object)this.ns);
        if (this == other || other.ns != null || !other.nominalType.equals(this.commonTypes.getObjectType())) {
            return this;
        }
        QualifiedName propPath = ObjectType.getPropertyPath(other);
        if (propPath == null) {
            return this;
        }
        JSType otherPropType = other.getProp(propPath);
        JSType thisPropType = this.mayHaveProp(propPath) ? this.getProp(propPath) : null;
        JSType jSType = newPropType = thisPropType == null ? null : thisPropType.specialize(otherPropType);
        if (thisPropType != null && thisPropType.isUnion() && !newPropType.isBottom() && newPropType.isSubtypeOf(thisPropType) && !thisPropType.isSubtypeOf(newPropType)) {
            return this.withProperty(propPath, newPropType);
        }
        return this;
    }

    private boolean isTopObject() {
        return this == this.commonTypes.getTopObjectType();
    }

    private boolean isBottomObject() {
        return this == this.commonTypes.getBottomObject();
    }

    EnumType getEnumType() {
        if (!this.nominalType.isLiteralObject()) {
            return null;
        }
        for (Property p : this.props.values()) {
            JSType t = p.getType();
            if (!t.isEnumElement()) continue;
            EnumType e = (EnumType)Iterables.getOnlyElement(t.getEnums());
            return this.equals(e.toJSType().getObjTypeIfSingletonObj()) ? e : null;
        }
        return null;
    }

    boolean isEnumObject() {
        return this.getEnumType() != null;
    }

    static ObjectType meet(ObjectType obj1, ObjectType obj2) {
        PersistentMap<String, Property> props;
        boolean isLoose;
        NominalType nt1 = obj1.nominalType;
        NominalType nt2 = obj2.nominalType;
        Preconditions.checkState((boolean)ObjectType.areRelatedNominalTypes(nt1, nt2), (String)"Unrelated nominal types %s and %s", (Object)nt1, (Object)nt2);
        if (obj1.isTopObject() || obj2.isBottomObject()) {
            return obj2;
        }
        if (obj2.isTopObject() || obj1.isBottomObject()) {
            return obj1;
        }
        JSTypes commonTypes = obj1.commonTypes;
        NominalType resultNomType = NominalType.pickSubclass(nt1, nt2);
        FunctionType fn = FunctionType.meet(obj1.fn, obj2.fn);
        if (!FunctionType.isInhabitable(fn)) {
            return commonTypes.getBottomObject();
        }
        boolean bl = isLoose = obj1.isLoose && obj2.isLoose || fn != null && fn.isLoose();
        if (resultNomType.isFunction() && fn == null) {
            fn = obj1.fn == null ? obj2.fn : obj1.fn;
            isLoose = fn.isLoose();
        }
        if (commonTypes.isBottomPropertyMap(props = isLoose ? ObjectType.joinPropsLoosely(obj1.props, obj2.props) : ObjectType.meetPropsHelper(commonTypes, false, resultNomType, obj1.props, obj2.props))) {
            return commonTypes.getBottomObject();
        }
        ObjectKind ok = ObjectKind.meet(obj1.objectKind, obj2.objectKind);
        Namespace resultNs = Objects.equals(obj1.ns, obj2.ns) ? obj1.ns : null;
        return new ObjectType(commonTypes, resultNomType, props, fn, resultNs, isLoose, ok);
    }

    static ObjectType join(ObjectType obj1, ObjectType obj2) {
        PersistentMap<String, Property> props;
        if (obj1.isTopObject() || obj2.isTopObject()) {
            return obj1.commonTypes.getTopObjectType();
        }
        if (obj1.equals(obj2)) {
            return obj1;
        }
        if (obj1.isPrototypeObject() && obj2.isPrototypeObject()) {
            return ObjectType.join(obj1.getNominalType().getInstanceAsObjectType(), obj2.getNominalType().getInstanceAsObjectType());
        }
        NominalType nt1 = obj1.nominalType;
        NominalType nt2 = obj2.nominalType;
        Preconditions.checkState((nt1.isRawSubtypeOf(nt2) || nt2.isRawSubtypeOf(nt1) ? 1 : 0) != 0);
        JSTypes commonTypes = obj1.commonTypes;
        boolean isLoose = obj1.isLoose || obj2.isLoose;
        FunctionType fn = FunctionType.join(obj1.fn, obj2.fn);
        if (isLoose) {
            fn = fn == null ? null : fn.withLoose();
            props = ObjectType.joinPropsLoosely(obj1.props, obj2.props);
        } else {
            props = ObjectType.joinProps(obj1.props, obj2.props, nt1, nt2);
        }
        NominalType nominal = NominalType.join(nt1, nt2);
        if (nominal.isBuiltinObject() && fn != null) {
            if (isLoose) {
                nominal = obj1.commonTypes.getFunctionType();
            } else {
                fn = null;
            }
        }
        Namespace ns = Objects.equals(obj1.ns, obj2.ns) ? obj1.ns : null;
        return ObjectType.makeObjectType(commonTypes, nominal, props, fn, ns, isLoose, ObjectKind.join(obj1.objectKind, obj2.objectKind));
    }

    private static boolean canMergeObjectsInJoin(ObjectType obj1, ObjectType obj2) {
        if (obj1.isTopObject() || obj2.isTopObject() || obj1.equals(obj2)) {
            return true;
        }
        NominalType nt1 = obj1.nominalType;
        NominalType nt2 = obj2.nominalType;
        if (!obj1.isPrototypeObject() && (nt1.isBuiltinObject() || nt1.isLiteralObject()) && !obj2.isPrototypeObject() && (nt2.isBuiltinObject() || nt2.isLiteralObject())) {
            return true;
        }
        if (nt1.isBuiltinObject()) {
            return obj1.isLoose && obj2.isSubtypeOf(obj1, SubtypeCache.create());
        }
        if (nt2.isBuiltinObject()) {
            return obj2.isLoose && obj1.isSubtypeOf(obj2, SubtypeCache.create());
        }
        return !obj1.isPrototypeObject() && !obj2.isPrototypeObject() && (ObjectType.areRelatedNominalTypes(nt1, nt2) || NominalType.equalRawTypes(nt1, nt2));
    }

    static ImmutableSet<ObjectType> joinSets(ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2) {
        if (objs1.isEmpty()) {
            return objs2;
        }
        if (objs2.isEmpty()) {
            return objs1;
        }
        ArrayList<ObjectType> objs = new ArrayList<ObjectType>((Collection<ObjectType>)objs1);
        objs.addAll((Collection<ObjectType>)objs2);
        for (int i = 0; i < objs.size() - 1; ++i) {
            ObjectType obj1 = (ObjectType)objs.get(i);
            for (int j = i + 1; j < objs.size(); ++j) {
                ObjectType obj2 = (ObjectType)objs.get(j);
                if (!ObjectType.canMergeObjectsInJoin(obj1, obj2)) continue;
                objs.set(i, null);
                objs.set(j, ObjectType.join(obj1, obj2));
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ObjectType obj : objs) {
            if (obj == null) continue;
            builder.add((Object)obj);
        }
        return builder.build();
    }

    private static boolean areRelatedNominalTypes(NominalType c1, NominalType c2) {
        return c1.isNominalSubtypeOf(c2) || c2.isNominalSubtypeOf(c1);
    }

    static ImmutableSet<ObjectType> meetSetsHelper(boolean specializeObjs1, Set<ObjectType> objs1, Set<ObjectType> objs2) {
        ObjectsBuilder newObjs = new ObjectsBuilder();
        for (ObjectType obj2 : objs2) {
            for (ObjectType obj1 : objs1) {
                if (ObjectType.areRelatedNominalTypes(obj1.nominalType, obj2.nominalType)) {
                    ObjectType newObj;
                    if (specializeObjs1) {
                        newObj = obj1.specialize(obj2);
                        if (newObj == null) {
                            continue;
                        }
                    } else {
                        newObj = ObjectType.meet(obj1, obj2);
                    }
                    newObjs.add(newObj);
                    continue;
                }
                if (obj1.nominalType.isStructuralInterface() && obj2.isSubtypeOf(obj1, SubtypeCache.create())) {
                    newObjs.add(obj2);
                    continue;
                }
                if (!obj2.nominalType.isStructuralInterface() || !obj1.isSubtypeOf(obj2, SubtypeCache.create())) continue;
                newObjs.add(obj1);
            }
        }
        return newObjs.build();
    }

    static ImmutableSet<ObjectType> meetSets(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(false, objs1, objs2);
    }

    static ImmutableSet<ObjectType> specializeSet(Set<ObjectType> objs1, Set<ObjectType> objs2) {
        return ObjectType.meetSetsHelper(true, objs1, objs2);
    }

    FunctionType getFunType() {
        return this.fn;
    }

    NominalType getNominalType() {
        return this.nominalType;
    }

    @Override
    public JSType getProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (qname.isIdentifier()) {
            return p == null ? this.commonTypes.UNDEFINED : p.getType();
        }
        Preconditions.checkState((p != null ? 1 : 0) != 0);
        return p.getType().getProp(qname.getAllButLeftmost());
    }

    @Override
    public JSType getDeclaredProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        if (p == null) {
            return null;
        }
        if (qname.isIdentifier()) {
            return p.isDeclared() ? p.getDeclaredType() : null;
        }
        return p.getType().getDeclaredProp(qname.getAllButLeftmost());
    }

    private Property getLeftmostProp(QualifiedName qname) {
        String pname = qname.getLeftmostName();
        Property p = (Property)this.props.get(pname);
        if (p != null) {
            return p;
        }
        if (this.ns != null && (p = this.ns.getNsProp(pname)) != null) {
            return p;
        }
        return this.nominalType.getProp(pname, RawNominalType.PropAccess.INCLUDE_STRAY_PROPS);
    }

    private Property getLeftmostNonInheritedProp(QualifiedName qname) {
        String pname = qname.getLeftmostName();
        Property p = (Property)this.props.get(pname);
        if (p != null && !this.nominalType.mayHaveProp(pname)) {
            return p;
        }
        if (this.ns != null && (p = this.ns.getNsProp(pname)) != null) {
            return p;
        }
        return this.nominalType.getNonInheritedProp(pname);
    }

    Node getPropertyDefSite(String propertyName) {
        return this.getPropertyDefSiteHelper(propertyName, false);
    }

    Node getNonInheritedPropertyDefSite(String propertyName) {
        return this.getPropertyDefSiteHelper(propertyName, true);
    }

    private Node getPropertyDefSiteHelper(String propertyName, boolean nonInheritedProp) {
        Property p;
        QualifiedName qname = new QualifiedName(propertyName);
        Property property = p = nonInheritedProp ? this.getLeftmostNonInheritedProp(qname) : this.getLeftmostProp(qname);
        if (p == null) {
            p = this.getLeftmostProp(new QualifiedName(this.commonTypes.createGetterPropName(propertyName)));
        }
        if (p == null) {
            p = this.getLeftmostProp(new QualifiedName(this.commonTypes.createSetterPropName(propertyName)));
        }
        return p == null ? null : p.getDefSite();
    }

    @Override
    public boolean mayHaveProp(QualifiedName qname) {
        Property p = this.getLeftmostProp(qname);
        return p != null && (qname.isIdentifier() || p.getType().mayHaveProp(qname.getAllButLeftmost()));
    }

    @Override
    public boolean hasProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null;
    }

    boolean hasNonInheritedProperty(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostNonInheritedProp(qname);
        String pname = qname.getLeftmostName();
        if (p == null) {
            p = this.getLeftmostNonInheritedProp(new QualifiedName(this.commonTypes.createGetterPropName(pname)));
        }
        if (p == null) {
            p = this.getLeftmostProp(new QualifiedName(this.commonTypes.createSetterPropName(pname)));
        }
        return p != null;
    }

    @Override
    public boolean hasConstantProp(QualifiedName qname) {
        Preconditions.checkArgument((boolean)qname.isIdentifier());
        Property p = this.getLeftmostProp(qname);
        return p != null && p.isConstant();
    }

    static ObjectType unifyUnknowns(ObjectType t1, ObjectType t2) {
        if (t1.isLoose()) {
            return t1.equals(t2) ? t1 : null;
        }
        if (t2.isLoose()) {
            return null;
        }
        if (!Objects.equals(t1.ns, t2.ns)) {
            return null;
        }
        if (t1.isTopObject()) {
            return t2.isTopObject() ? t1 : null;
        }
        if (t2.isTopObject()) {
            return null;
        }
        if (t1.isBottomObject()) {
            return t2.isBottomObject() ? t1 : null;
        }
        if (t2.isBottomObject()) {
            return null;
        }
        NominalType nt = NominalType.unifyUnknowns(t1.nominalType, t2.nominalType);
        if (nt == null) {
            return null;
        }
        FunctionType newFn = null;
        if ((t1.fn != null || t2.fn != null) && (newFn = FunctionType.unifyUnknowns(t1.fn, t2.fn)) == null) {
            return null;
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (String propName : t1.props.keySet()) {
            Property prop1 = (Property)t1.props.get(propName);
            Property prop2 = (Property)t2.props.get(propName);
            if (prop2 == null) {
                return null;
            }
            Property p = Property.unifyUnknowns(prop1, prop2);
            if (p == null) {
                return null;
            }
            newProps = newProps.with(propName, p);
        }
        return ObjectType.makeObjectType(t1.commonTypes, nt, newProps, newFn, t1.ns, false, ObjectKind.join(t1.objectKind, t2.objectKind));
    }

    boolean unifyWithSubtype(ObjectType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        Set<String> thisProps;
        if (!(this.fn == null || other.fn != null && this.fn.unifyWithSubtype(other.fn, typeParameters, typeMultimap, subSuperMap))) {
            return false;
        }
        NominalType thisNt = this.nominalType;
        NominalType otherNt = other.nominalType;
        if (!thisNt.isBuiltinObject() && !otherNt.isBuiltinObject()) {
            if (thisNt.unifyWithSubtype(otherNt, typeParameters, typeMultimap, subSuperMap)) {
                return true;
            }
            if (thisNt.isStructuralInterface()) {
                if (thisNt.equals(subSuperMap.get(otherNt))) {
                    return true;
                }
                subSuperMap = subSuperMap.with(otherNt, thisNt);
            } else {
                return false;
            }
        }
        if (!thisNt.isBuiltinObject() && !thisNt.isStructuralInterface() && otherNt.isBuiltinObject()) {
            return false;
        }
        Set<String> set = thisProps = !thisNt.isBuiltinObject() && thisNt.isStructuralInterface() ? thisNt.getPropertyNames() : this.props.keySet();
        if (thisProps == null) {
            return true;
        }
        return this.unifyPropsWithSubtype(other, thisProps, typeParameters, typeMultimap, subSuperMap);
    }

    private boolean unifyPropsWithSubtype(ObjectType other, Set<String> thisProps, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        for (String pname : thisProps) {
            QualifiedName qname = new QualifiedName(pname);
            Property thisProp = this.getLeftmostProp(qname);
            Property otherProp = other.getLeftmostProp(qname);
            if (!(thisProp.isOptional() ? otherProp != null && !thisProp.getType().unifyWithSubtype(otherProp.getType(), typeParameters, typeMultimap, subSuperMap) : otherProp == null || otherProp.isOptional() || !thisProp.getType().unifyWithSubtype(otherProp.getType(), typeParameters, typeMultimap, subSuperMap))) continue;
            return false;
        }
        return true;
    }

    ObjectType substituteGenerics(Map<String, JSType> typeMap) {
        if (this.isTopObject() || typeMap.isEmpty()) {
            return this;
        }
        PersistentMap<String, Property> newProps = PersistentMap.create();
        for (Map.Entry propsEntry : this.props.entrySet()) {
            String pname = (String)propsEntry.getKey();
            Property newProp = ((Property)propsEntry.getValue()).substituteGenerics(typeMap);
            newProps = newProps.with(pname, newProp);
        }
        FunctionType newFn = this.fn == null ? null : this.fn.substituteGenerics(typeMap);
        return ObjectType.makeObjectType(this.commonTypes, this.nominalType.substituteGenerics(typeMap), newProps, newFn, this.ns, newFn != null && newFn.isQmarkFunction() || this.isLoose, this.objectKind);
    }

    boolean isPropDefinedOnSubtype(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return this.nominalType.isBuiltinObject() || this.nominalType.isPropDefinedOnSubtype(pname);
    }

    boolean isAmbiguousObject() {
        ObjectType instance;
        if (this.isEnumObject() || this.isPrototypeObject() || this.ns != null && this.fn != null) {
            return false;
        }
        NominalType nt = this.fn != null && this.fn.isSomeConstructorOrInterface() ? ((instance = this.fn.getInstanceTypeOfCtor().getObjTypeIfSingletonObj()) != null ? instance.nominalType : this.getCommonTypes().getObjectType()) : this.nominalType;
        return nt.isFunction() || nt.isBuiltinObject() || nt.isLiteralObject();
    }

    Set<String> getPropertyNames() {
        LinkedHashSet<String> props = new LinkedHashSet<String>();
        props.addAll(this.props.keySet());
        props.addAll((Collection<String>)this.nominalType.getPropertyNames());
        return props;
    }

    Iterable<String> getNonInheritedPropertyNames() {
        if (this.nominalType.isBuiltinObject() || this.nominalType.isLiteralObject()) {
            return this.props.keySet();
        }
        return Iterables.concat(this.props.keySet(), this.nominalType.getAllNonInheritedProps());
    }

    ObjectType toAnonymousRecord() {
        if (this.nominalType.isBuiltinObject() || this.nominalType.isLiteralObject()) {
            return this;
        }
        LinkedHashMap<String, Property> propMap = new LinkedHashMap<String, Property>();
        for (String pname : this.getNonInheritedPropertyNames()) {
            JSType ptype = this.getProp(new QualifiedName(pname));
            propMap.put(pname, Property.make(ptype, ptype));
        }
        return ObjectType.fromProperties(this.commonTypes, propMap);
    }

    Node getDefSite() {
        if (this.ns != null) {
            return this.ns.getDefSite();
        }
        if (this.fn != null && this.fn.isSomeConstructorOrInterface()) {
            return this.fn.getInstanceTypeOfCtor().getSource();
        }
        if (this.nominalType != null) {
            return this.nominalType.getDefSite();
        }
        return null;
    }

    JSType getNamespaceType() {
        return this.ns.toJSType();
    }

    public String toString() {
        return this.appendTo(new StringBuilder(), ToStringContext.TO_STRING).toString();
    }

    String toString(ToStringContext ctx) {
        return this.appendTo(new StringBuilder(), ctx).toString();
    }

    StringBuilder appendTo(StringBuilder builder, ToStringContext ctx) {
        if (this.isPrototypeObject()) {
            return builder.append(this.getOwnerFunction().getThisType().getDisplayName()).append(".prototype");
        }
        if (ctx.forAnnotation()) {
            if (this.fn != null) {
                this.fn.appendTo(builder, ctx);
            } else if (!this.props.isEmpty()) {
                this.appendPropsTo(builder, ctx);
            } else if (this.nominalType.isLiteralObject()) {
                builder.append("!Object");
            } else {
                this.nominalType.appendTo(builder, ctx);
            }
            return builder;
        }
        if (!this.hasNonPrototypeProperties()) {
            if (this.fn != null) {
                return this.fn.appendTo(builder, ctx);
            }
            return this.nominalType.appendTo(builder, ctx);
        }
        if (!(this.nominalType.isFunction() || this.nominalType.isBuiltinObject() || this.nominalType.isLiteralObject() || this.isNamespace())) {
            this.nominalType.appendTo(builder, ctx);
        } else if (this.isStruct()) {
            builder.append("struct");
        } else if (this.isDict()) {
            builder.append("dict");
        } else if (this.ns != null) {
            if (this.fn != null && (this.fn.isUniqueConstructor() || this.fn.isInterfaceDefinition())) {
                builder.append("class:");
            }
            builder.append(this.ns);
        } else if (this.fn != null) {
            builder.append("<|");
            this.fn.appendTo(builder, ctx);
            builder.append("|>");
        }
        if (this.ns == null) {
            this.appendPropsTo(builder, ctx);
        }
        if (this.isLoose) {
            builder.append(" (loose)");
        }
        return builder;
    }

    private void appendPropsTo(StringBuilder builder, ToStringContext ctx) {
        builder.append('{');
        boolean firstIteration = true;
        for (String pname : new TreeSet(this.props.keySet())) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                builder.append(", ");
            }
            builder.append(pname);
            builder.append(": ");
            ((Property)this.props.get(pname)).appendTo(builder, ctx);
        }
        builder.append('}');
    }

    public boolean equals(Object o) {
        if (!(o instanceof ObjectType)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        ObjectType other = (ObjectType)o;
        return Objects.equals(this.fn, other.fn) && Objects.equals(this.ns, other.ns) && Objects.equals(this.nominalType, other.nominalType) && Objects.equals(this.props, other.props);
    }

    public int hashCode() {
        return Objects.hash(this.fn, this.ns, this.props, this.nominalType);
    }

    @Override
    public Collection<JSType> getSubtypesWithProperty(QualifiedName qname) {
        return this.nominalType.getSubtypesWithProperty(qname);
    }
}

