/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.transpile;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteModulesToCommonJsModules;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.bundle.TranspilationException;
import com.google.javascript.jscomp.transpile.TranspileResult;
import com.google.javascript.jscomp.transpile.Transpiler;
import java.io.IOException;
import java.nio.file.Path;

public final class BaseTranspiler
implements Transpiler {
    private final CompilerSupplier compilerSupplier;
    private final String runtimeLibraryName;
    public static final BaseTranspiler ES5_TRANSPILER = new BaseTranspiler(new CompilerSupplier(), "es6_runtime");
    public static final BaseTranspiler ES_MODULE_TO_CJS_TRANSPILER = new BaseTranspiler(new EsmToCjsCompilerSupplier(), "");

    BaseTranspiler(CompilerSupplier compilerSupplier, String runtimeLibraryName) {
        this.compilerSupplier = (CompilerSupplier)Preconditions.checkNotNull((Object)compilerSupplier);
        this.runtimeLibraryName = (String)Preconditions.checkNotNull((Object)runtimeLibraryName);
    }

    @Override
    public TranspileResult transpile(Path path, String code) {
        CompileResult result = this.compilerSupplier.compile(path, code);
        if (!result.transpiled) {
            return new TranspileResult(path, code, code, "");
        }
        return new TranspileResult(path, code, result.source, result.sourceMap);
    }

    @Override
    public String runtime() {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.runtimeLibraryName)) {
            sb.append(this.compilerSupplier.runtime(this.runtimeLibraryName));
        }
        sb.append(this.compilerSupplier.runtime("modules"));
        return sb.toString();
    }

    public static class CompileResult {
        public final String source;
        public final boolean transpiled;
        public final String sourceMap;

        public CompileResult(String source, boolean transpiled, String sourceMap) {
            this.source = (String)Preconditions.checkNotNull((Object)source);
            this.transpiled = transpiled;
            this.sourceMap = (String)Preconditions.checkNotNull((Object)sourceMap);
        }
    }

    public static class EsmToCjsCompilerSupplier
    extends CompilerSupplier {
        @Override
        public CompileResult compile(Path path, String code) {
            CompilerOptions options = new CompilerOptions();
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
            options.setEmitUseStrict(false);
            options.setSourceMapOutputPath("/dev/null");
            options.setSourceMapIncludeSourcesContent(true);
            options.setPrettyPrint(true);
            Compiler compiler = this.compiler();
            compiler.init(ImmutableList.of(), ImmutableList.of((Object)SourceFile.fromCode(path.toString(), code)), options);
            compiler.parseForCompilation();
            boolean transpiled = false;
            if (!compiler.hasErrors() && compiler.getRoot().getSecondChild().getFirstFirstChild().isModuleBody() && !compiler.getRoot().getSecondChild().getFirstChild().getBooleanProp((byte)87)) {
                new Es6RewriteModulesToCommonJsModules(compiler).process(null, compiler.getRoot().getSecondChild());
                compiler.getRoot().getSecondChild().getFirstChild().putBooleanProp((byte)93, true);
                transpiled = true;
            }
            Result result = compiler.getResult();
            String source = compiler.toSource();
            StringBuilder sourceMap = new StringBuilder();
            if (result.sourceMap != null) {
                try {
                    result.sourceMap.appendTo(sourceMap, path.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (result.errors.length > 0) {
                throw new TranspilationException(compiler, result.errors, result.warnings);
            }
            return new CompileResult(source, transpiled, transpiled ? sourceMap.toString() : "");
        }
    }

    public static class CompilerSupplier {
        protected static final SourceFile EXTERNS = SourceFile.fromCode("externs.js", "function Symbol() {}");
        protected static final SourceFile EMPTY = SourceFile.fromCode("empty.js", "");
        protected static final DiagnosticGroup ES5_WARNINGS = new DiagnosticGroup(new DiagnosticType[]{DiagnosticType.error("JSC_CANNOT_CONVERT", "")});

        public CompileResult compile(Path path, String code) {
            boolean transpiled;
            Compiler compiler = this.compiler();
            Result result = compiler.compile(EXTERNS, SourceFile.fromCode(path.toString(), code), this.options());
            String source = compiler.toSource();
            StringBuilder sourceMap = new StringBuilder();
            if (result.sourceMap != null) {
                try {
                    result.sourceMap.appendTo(sourceMap, path.toString());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean bl = transpiled = !result.transpiledFiles.isEmpty();
            if (result.errors.length > 0) {
                throw new TranspilationException(compiler, result.errors, result.warnings);
            }
            return new CompileResult(source, transpiled, transpiled ? sourceMap.toString() : "");
        }

        public String runtime(String library) {
            Compiler compiler = this.compiler();
            CompilerOptions options = this.options();
            options.setForceLibraryInjection((Iterable<String>)ImmutableList.of((Object)library));
            compiler.compile(EXTERNS, EMPTY, options);
            return compiler.toSource();
        }

        protected Compiler compiler() {
            return new Compiler();
        }

        protected CompilerOptions options() {
            CompilerOptions options = new CompilerOptions();
            this.setOptions(options);
            return options;
        }

        protected void setOptions(CompilerOptions options) {
            options.setLanguageIn(CompilerOptions.LanguageMode.ECMASCRIPT_NEXT);
            options.setLanguageOut(CompilerOptions.LanguageMode.ECMASCRIPT5);
            options.setQuoteKeywordProperties(true);
            options.setSkipNonTranspilationPasses(true);
            options.setVariableRenaming(VariableRenamingPolicy.OFF);
            options.setPropertyRenaming(PropertyRenamingPolicy.OFF);
            options.setWrapGoogModulesForWhitespaceOnly(false);
            options.setPrettyPrint(true);
            options.setSourceMapOutputPath("/dev/null");
            options.setSourceMapIncludeSourcesContent(true);
            options.setWarningLevel(ES5_WARNINGS, CheckLevel.OFF);
            options.setTranspileEs6ModulesToCjsModules(true);
        }
    }
}

