/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import java.io.Serializable;

public final class JSTypeExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Node root;
    private final String sourceName;

    public JSTypeExpression(Node root, String sourceName) {
        this.root = root;
        this.sourceName = sourceName;
    }

    public static JSTypeExpression makeOptionalArg(JSTypeExpression expr) {
        if (expr.isOptionalArg() || expr.isVarArgs()) {
            return expr;
        }
        return new JSTypeExpression(new Node(Token.EQUALS, expr.root), expr.sourceName);
    }

    public boolean isOptionalArg() {
        return this.root.getToken() == Token.EQUALS;
    }

    public boolean isVarArgs() {
        return this.root.getToken() == Token.ELLIPSIS;
    }

    public JSType evaluate(StaticTypedScope<JSType> scope, TypeIRegistry registry) {
        if (registry instanceof JSTypeRegistry) {
            JSType type = ((JSTypeRegistry)registry).createTypeFromCommentNode(this.root, this.sourceName, scope);
            this.root.setJSType(type);
            return type;
        }
        return null;
    }

    public boolean equals(Object other) {
        return other instanceof JSTypeExpression && ((JSTypeExpression)other).root.isEquivalentTo(this.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public Node getRoot() {
        return this.root;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String toString() {
        return "type: " + this.root.toStringTree();
    }

    public JSTypeExpression copy() {
        return new JSTypeExpression(this.root.cloneTree(), this.sourceName);
    }
}

