/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;

class InstanceObjectType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private final FunctionType constructor;

    InstanceObjectType(JSTypeRegistry registry, FunctionType constructor) {
        this(registry, constructor, false);
    }

    InstanceObjectType(JSTypeRegistry registry, FunctionType constructor, boolean isNativeType) {
        super(registry, null, null, isNativeType, constructor.getTemplateTypeMap());
        Preconditions.checkNotNull((Object)constructor);
        this.constructor = constructor;
    }

    @Override
    public String getReferenceName() {
        return this.getConstructor().getReferenceName();
    }

    @Override
    public boolean hasReferenceName() {
        return this.getConstructor().hasReferenceName();
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.getConstructor().getPrototype();
    }

    @Override
    public FunctionType getConstructor() {
        return this.constructor;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        ObjectType proto = this.getImplicitPrototype();
        if (proto != null && proto.hasOwnDeclaredProperty(name)) {
            return false;
        }
        return super.defineProperty(name, type, inferred, propertyNode);
    }

    @Override
    StringBuilder appendTo(StringBuilder sb, boolean forAnnotations) {
        return this.constructor.hasReferenceName() ? sb.append(forAnnotations ? this.constructor.getNormalizedReferenceName() : this.constructor.getReferenceName()) : super.appendTo(sb, forAnnotations);
    }

    @Override
    boolean isTheObjectType() {
        return this.getConstructor().isNativeObjectType() && "Object".equals(this.getReferenceName());
    }

    @Override
    public boolean isInstanceType() {
        return true;
    }

    @Override
    public boolean isArrayType() {
        return this.getConstructor().isNativeObjectType() && "Array".equals(this.getReferenceName());
    }

    @Override
    public boolean isStringObjectType() {
        return this.getConstructor().isNativeObjectType() && "String".equals(this.getReferenceName());
    }

    @Override
    public boolean isSymbolObjectType() {
        return this.getConstructor().isNativeObjectType() && "Symbol".equals(this.getReferenceName());
    }

    @Override
    public boolean isBooleanObjectType() {
        return this.getConstructor().isNativeObjectType() && "Boolean".equals(this.getReferenceName());
    }

    @Override
    public boolean isNumberObjectType() {
        return this.getConstructor().isNativeObjectType() && "Number".equals(this.getReferenceName());
    }

    @Override
    public boolean isDateType() {
        return this.getConstructor().isNativeObjectType() && "Date".equals(this.getReferenceName());
    }

    @Override
    public boolean isRegexpType() {
        return this.getConstructor().isNativeObjectType() && "RegExp".equals(this.getReferenceName());
    }

    @Override
    public boolean isNominalType() {
        return this.hasReferenceName();
    }

    @Override
    public int hashCode() {
        if (this.hasReferenceName()) {
            return this.getReferenceName().hashCode();
        }
        return super.hashCode();
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.getConstructor().getImplementedInterfaces();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.getConstructor().getExtendedInterfaces();
    }
}

