/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.StaticScope;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.TypeIEnv;
import com.google.javascript.rhino.TypeIRegistry;
import com.google.javascript.rhino.jstype.AllType;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.BooleanType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.ErrorFunctionType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.NamespaceType;
import com.google.javascript.rhino.jstype.NoObjectType;
import com.google.javascript.rhino.jstype.NoResolvedType;
import com.google.javascript.rhino.jstype.NoType;
import com.google.javascript.rhino.jstype.NullType;
import com.google.javascript.rhino.jstype.NumberType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.RecordTypeBuilder;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.StringType;
import com.google.javascript.rhino.jstype.SymbolType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.UnknownType;
import com.google.javascript.rhino.jstype.ValueType;
import com.google.javascript.rhino.jstype.VoidType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeRegistry
implements TypeIRegistry {
    private static final long serialVersionUID = 1L;
    private TemplateType iObjectIndexTemplateKey;
    private TemplateType iObjectElementTemplateKey;
    private static final String I_OBJECT_ELEMENT_TEMPLATE = "IObject#VALUE";
    private TemplateType iterableTemplate;
    private TemplateType iteratorTemplate;
    private TemplateType generatorTemplate;
    private TemplateType arrayElementTemplateKey;
    @Deprecated
    public static final String OBJECT_ELEMENT_TEMPLATE = "IObject#VALUE";
    private static final int PROPERTY_CHECKING_UNION_SIZE = 3000;
    private final transient ErrorReporter reporter;
    private final JSType[] nativeTypes;
    private final Map<String, JSType> namesToTypes;
    private final Set<String> nonNullableTypeNames = new LinkedHashSet<String>();
    private final transient Set<String> forwardDeclaredTypes;
    private final Map<String, UnionTypeBuilder> typesIndexedByProperty = new HashMap<String, UnionTypeBuilder>();
    private JSType sentinelObjectLiteral;
    private final Set<String> propertiesOfSupertypesInUnions = new HashSet<String>();
    private final Set<String> droppedPropertiesOfUnions = new HashSet<String>();
    private transient Map<String, Map<String, ObjectType>> eachRefTypeIndexedByProperty = new LinkedHashMap<String, Map<String, ObjectType>>();
    private final Map<String, JSType> greatestSubtypeByProperty = new HashMap<String, JSType>();
    private transient Multimap<String, FunctionTypeI> interfaceToImplementors = LinkedHashMultimap.create();
    private final Multimap<StaticTypedScope<JSType>, NamedType> unresolvedNamedTypes = ArrayListMultimap.create();
    private final Map<String, TemplateType> templateTypes = new HashMap<String, TemplateType>();
    private final TemplateTypeMap emptyTemplateTypeMap;

    public JSTypeRegistry(ErrorReporter reporter) {
        this(reporter, (Set<String>)ImmutableSet.of());
    }

    public JSTypeRegistry(ErrorReporter reporter, Set<String> forwardDeclaredTypes) {
        this.reporter = reporter;
        this.forwardDeclaredTypes = forwardDeclaredTypes;
        this.emptyTemplateTypeMap = new TemplateTypeMap(this, (ImmutableList<TemplateType>)ImmutableList.of(), (ImmutableList<JSType>)ImmutableList.of());
        this.nativeTypes = new JSType[JSTypeNative.values().length];
        this.namesToTypes = new HashMap<String, JSType>();
        this.resetForTypeCheck();
    }

    private JSType getSentinelObjectLiteral() {
        if (this.sentinelObjectLiteral == null) {
            this.sentinelObjectLiteral = this.createAnonymousObjectType(null);
        }
        return this.sentinelObjectLiteral;
    }

    public TemplateType getObjectElementKey() {
        return this.iObjectElementTemplateKey;
    }

    public TemplateType getObjectIndexKey() {
        Preconditions.checkNotNull((Object)this.iObjectIndexTemplateKey);
        return this.iObjectIndexTemplateKey;
    }

    public TemplateType getIterableTemplate() {
        return (TemplateType)Preconditions.checkNotNull((Object)this.iterableTemplate);
    }

    public TemplateType getIteratorTemplate() {
        return (TemplateType)Preconditions.checkNotNull((Object)this.iteratorTemplate);
    }

    public ImmutableList<TemplateType> maybeGetTemplateTypesOfBuiltin(String fnName) {
        ObjectType objType;
        JSType type = this.getType(null, fnName);
        ObjectType objectType = objType = type == null ? null : type.toObjectType();
        if (objType != null && objType.isNativeObjectType()) {
            ImmutableList<TemplateType> templateKeys = objType.getTemplateTypeMap().getUnfilledTemplateKeys();
            return templateKeys;
        }
        return null;
    }

    public ErrorReporter getErrorReporter() {
        return this.reporter;
    }

    public void resetForTypeCheck() {
        this.typesIndexedByProperty.clear();
        this.eachRefTypeIndexedByProperty.clear();
        this.initializeBuiltInTypes();
        this.namesToTypes.clear();
        this.initializeRegistry();
    }

    private void initializeBuiltInTypes() {
        BooleanType BOOLEAN_TYPE = new BooleanType(this);
        this.registerNativeType(JSTypeNative.BOOLEAN_TYPE, BOOLEAN_TYPE);
        NullType NULL_TYPE = new NullType(this);
        this.registerNativeType(JSTypeNative.NULL_TYPE, NULL_TYPE);
        NumberType NUMBER_TYPE = new NumberType(this);
        this.registerNativeType(JSTypeNative.NUMBER_TYPE, NUMBER_TYPE);
        StringType STRING_TYPE = new StringType(this);
        this.registerNativeType(JSTypeNative.STRING_TYPE, STRING_TYPE);
        SymbolType SYMBOL_TYPE = new SymbolType(this);
        this.registerNativeType(JSTypeNative.SYMBOL_TYPE, SYMBOL_TYPE);
        UnknownType UNKNOWN_TYPE = new UnknownType(this, false);
        this.registerNativeType(JSTypeNative.UNKNOWN_TYPE, UNKNOWN_TYPE);
        UnknownType checkedUnknownType = new UnknownType(this, true);
        this.registerNativeType(JSTypeNative.CHECKED_UNKNOWN_TYPE, checkedUnknownType);
        VoidType VOID_TYPE = new VoidType(this);
        this.registerNativeType(JSTypeNative.VOID_TYPE, VOID_TYPE);
        AllType ALL_TYPE = new AllType(this);
        this.registerNativeType(JSTypeNative.ALL_TYPE, ALL_TYPE);
        this.iObjectIndexTemplateKey = new TemplateType(this, "IObject#KEY1");
        this.iObjectElementTemplateKey = new TemplateType(this, "IObject#VALUE");
        this.arrayElementTemplateKey = new TemplateType(this, "T");
        this.iteratorTemplate = new TemplateType(this, "VALUE");
        this.generatorTemplate = new TemplateType(this, "VALUE");
        this.iterableTemplate = new TemplateType(this, "VALUE");
        PrototypeObjectType TOP_LEVEL_PROTOTYPE = new PrototypeObjectType(this, null, null, true, null);
        this.registerNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE, TOP_LEVEL_PROTOTYPE);
        FunctionType iObjectFunctionType = new FunctionType(this, "IObject", null, this.createArrowType(), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.iObjectIndexTemplateKey, (Object)this.iObjectElementTemplateKey), null), FunctionType.Kind.INTERFACE, true, false);
        this.registerNativeType(JSTypeNative.I_OBJECT_FUNCTION_TYPE, iObjectFunctionType);
        this.registerNativeType(JSTypeNative.I_OBJECT_TYPE, iObjectFunctionType.getInstanceType());
        FunctionType OBJECT_FUNCTION_TYPE = new FunctionType(this, "Object", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), null), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.iObjectIndexTemplateKey, (Object)this.iObjectElementTemplateKey), null), FunctionType.Kind.CONSTRUCTOR, true, false);
        OBJECT_FUNCTION_TYPE.getInternalArrowType().returnType = OBJECT_FUNCTION_TYPE.getInstanceType();
        OBJECT_FUNCTION_TYPE.setPrototype(TOP_LEVEL_PROTOTYPE, null);
        this.registerNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE, OBJECT_FUNCTION_TYPE);
        ObjectType OBJECT_TYPE = OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.OBJECT_TYPE, OBJECT_TYPE);
        ObjectType OBJECT_PROTOTYPE = OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.OBJECT_PROTOTYPE, OBJECT_PROTOTYPE);
        FunctionType FUNCTION_FUNCTION_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), UNKNOWN_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        FUNCTION_FUNCTION_TYPE.setPrototypeBasedOn(OBJECT_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_FUNCTION_TYPE, FUNCTION_FUNCTION_TYPE);
        ObjectType FUNCTION_PROTOTYPE = FUNCTION_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.FUNCTION_PROTOTYPE, FUNCTION_PROTOTYPE);
        NoType NO_TYPE = new NoType(this);
        this.registerNativeType(JSTypeNative.NO_TYPE, NO_TYPE);
        NoObjectType NO_OBJECT_TYPE = new NoObjectType(this);
        this.registerNativeType(JSTypeNative.NO_OBJECT_TYPE, NO_OBJECT_TYPE);
        NoResolvedType NO_RESOLVED_TYPE = new NoResolvedType(this);
        this.registerNativeType(JSTypeNative.NO_RESOLVED_TYPE, NO_RESOLVED_TYPE);
        FunctionType ARRAY_FUNCTION_TYPE = new FunctionType(this, "Array", null, this.createArrowType(this.createParametersWithVarArgs(ALL_TYPE), null), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.arrayElementTemplateKey), null).extend(this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.iObjectElementTemplateKey), (ImmutableList<JSType>)ImmutableList.of((Object)this.arrayElementTemplateKey))), FunctionType.Kind.CONSTRUCTOR, true, false);
        ARRAY_FUNCTION_TYPE.getInternalArrowType().returnType = ARRAY_FUNCTION_TYPE.getInstanceType();
        ARRAY_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.ARRAY_FUNCTION_TYPE, ARRAY_FUNCTION_TYPE);
        ObjectType ARRAY_TYPE = ARRAY_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ARRAY_TYPE, ARRAY_TYPE);
        FunctionType iterableFunctionType = new FunctionType(this, "Iterable", null, this.createArrowType(), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.iterableTemplate), null), FunctionType.Kind.INTERFACE, true, false);
        this.registerNativeType(JSTypeNative.ITERABLE_FUNCTION_TYPE, iterableFunctionType);
        this.registerNativeType(JSTypeNative.ITERABLE_TYPE, iterableFunctionType.getInstanceType());
        FunctionType iteratorFunctionType = new FunctionType(this, "Iterator", null, this.createArrowType(), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.iteratorTemplate), null), FunctionType.Kind.INTERFACE, true, false);
        this.registerNativeType(JSTypeNative.ITERATOR_FUNCTION_TYPE, iteratorFunctionType);
        this.registerNativeType(JSTypeNative.ITERATOR_TYPE, iteratorFunctionType.getInstanceType());
        FunctionType generatorFunctionType = new FunctionType(this, "Generator", null, this.createArrowType(), null, this.createTemplateTypeMap((ImmutableList<TemplateType>)ImmutableList.of((Object)this.generatorTemplate), null), FunctionType.Kind.INTERFACE, true, false);
        this.registerNativeType(JSTypeNative.GENERATOR_FUNCTION_TYPE, generatorFunctionType);
        this.registerNativeType(JSTypeNative.GENERATOR_TYPE, generatorFunctionType.getInstanceType());
        FunctionType BOOLEAN_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Boolean", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), BOOLEAN_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        BOOLEAN_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE, BOOLEAN_OBJECT_FUNCTION_TYPE);
        ObjectType BOOLEAN_OBJECT_TYPE = BOOLEAN_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE, BOOLEAN_OBJECT_TYPE);
        FunctionType DATE_FUNCTION_TYPE = new FunctionType(this, "Date", null, this.createArrowType(this.createOptionalParameters(UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE, UNKNOWN_TYPE), STRING_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        DATE_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.DATE_FUNCTION_TYPE, DATE_FUNCTION_TYPE);
        ObjectType DATE_TYPE = DATE_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.DATE_TYPE, DATE_TYPE);
        ErrorFunctionType ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "Error");
        this.registerNativeType(JSTypeNative.ERROR_FUNCTION_TYPE, ERROR_FUNCTION_TYPE);
        ObjectType ERROR_TYPE = ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.ERROR_TYPE, ERROR_TYPE);
        ErrorFunctionType EVAL_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "EvalError");
        EVAL_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.EVAL_ERROR_FUNCTION_TYPE, EVAL_ERROR_FUNCTION_TYPE);
        ObjectType EVAL_ERROR_TYPE = EVAL_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.EVAL_ERROR_TYPE, EVAL_ERROR_TYPE);
        ErrorFunctionType RANGE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "RangeError");
        RANGE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.RANGE_ERROR_FUNCTION_TYPE, RANGE_ERROR_FUNCTION_TYPE);
        ObjectType RANGE_ERROR_TYPE = RANGE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.RANGE_ERROR_TYPE, RANGE_ERROR_TYPE);
        ErrorFunctionType REFERENCE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "ReferenceError");
        REFERENCE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE, REFERENCE_ERROR_FUNCTION_TYPE);
        ObjectType REFERENCE_ERROR_TYPE = REFERENCE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REFERENCE_ERROR_TYPE, REFERENCE_ERROR_TYPE);
        ErrorFunctionType SYNTAX_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "SyntaxError");
        SYNTAX_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE, SYNTAX_ERROR_FUNCTION_TYPE);
        ObjectType SYNTAX_ERROR_TYPE = SYNTAX_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.SYNTAX_ERROR_TYPE, SYNTAX_ERROR_TYPE);
        ErrorFunctionType TYPE_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "TypeError");
        TYPE_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.TYPE_ERROR_FUNCTION_TYPE, TYPE_ERROR_FUNCTION_TYPE);
        ObjectType TYPE_ERROR_TYPE = TYPE_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.TYPE_ERROR_TYPE, TYPE_ERROR_TYPE);
        ErrorFunctionType URI_ERROR_FUNCTION_TYPE = new ErrorFunctionType(this, "URIError");
        URI_ERROR_FUNCTION_TYPE.setPrototypeBasedOn(ERROR_TYPE);
        this.registerNativeType(JSTypeNative.URI_ERROR_FUNCTION_TYPE, URI_ERROR_FUNCTION_TYPE);
        ObjectType URI_ERROR_TYPE = URI_ERROR_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.URI_ERROR_TYPE, URI_ERROR_TYPE);
        FunctionType NUMBER_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Number", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), NUMBER_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        NUMBER_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE, NUMBER_OBJECT_FUNCTION_TYPE);
        ObjectType NUMBER_OBJECT_TYPE = NUMBER_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.NUMBER_OBJECT_TYPE, NUMBER_OBJECT_TYPE);
        FunctionType REGEXP_FUNCTION_TYPE = new FunctionType(this, "RegExp", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE, ALL_TYPE)), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        REGEXP_FUNCTION_TYPE.getInternalArrowType().returnType = REGEXP_FUNCTION_TYPE.getInstanceType();
        REGEXP_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.REGEXP_FUNCTION_TYPE, REGEXP_FUNCTION_TYPE);
        ObjectType REGEXP_TYPE = REGEXP_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.REGEXP_TYPE, REGEXP_TYPE);
        FunctionType STRING_OBJECT_FUNCTION_TYPE = new FunctionType(this, "String", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), STRING_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        STRING_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_FUNCTION_TYPE, STRING_OBJECT_FUNCTION_TYPE);
        ObjectType STRING_OBJECT_TYPE = STRING_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.STRING_OBJECT_TYPE, STRING_OBJECT_TYPE);
        FunctionType SYMBOL_OBJECT_FUNCTION_TYPE = new FunctionType(this, "Symbol", null, this.createArrowType(this.createOptionalParameters(ALL_TYPE), SYMBOL_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        SYMBOL_OBJECT_FUNCTION_TYPE.getPrototype();
        this.registerNativeType(JSTypeNative.SYMBOL_OBJECT_FUNCTION_TYPE, SYMBOL_OBJECT_FUNCTION_TYPE);
        ObjectType SYMBOL_OBJECT_TYPE = SYMBOL_OBJECT_FUNCTION_TYPE.getInstanceType();
        this.registerNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE, SYMBOL_OBJECT_TYPE);
        JSType NULL_VOID = this.createUnionType(NULL_TYPE, VOID_TYPE);
        this.registerNativeType(JSTypeNative.NULL_VOID, NULL_VOID);
        JSType OBJECT_SYMBOL = this.createUnionType(OBJECT_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_SYMBOL, OBJECT_SYMBOL);
        JSType OBJECT_NUMBER_STRING = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING, OBJECT_NUMBER_STRING);
        JSType OBJECT_NUMBER_STRING_BOOLEAN = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN, OBJECT_NUMBER_STRING_BOOLEAN);
        JSType OBJECT_NUMBER_STRING_BOOLEAN_SYMBOL = this.createUnionType(OBJECT_TYPE, NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.OBJECT_NUMBER_STRING_BOOLEAN_SYMBOL, OBJECT_NUMBER_STRING_BOOLEAN_SYMBOL);
        JSType NUMBER_STRING_BOOLEAN = this.createUnionType(NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN, NUMBER_STRING_BOOLEAN);
        JSType NUMBER_STRING_BOOLEAN_SYMBOL = this.createUnionType(NUMBER_TYPE, STRING_TYPE, BOOLEAN_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN_SYMBOL, NUMBER_STRING_BOOLEAN_SYMBOL);
        JSType NUMBER_SYMBOL = this.createUnionType(NUMBER_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_SYMBOL, NUMBER_SYMBOL);
        JSType STRING_SYMBOL = this.createUnionType(STRING_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.STRING_SYMBOL, STRING_SYMBOL);
        JSType NUMBER_STRING = this.createUnionType(NUMBER_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING, NUMBER_STRING);
        JSType NUMBER_STRING_SYMBOL = this.createUnionType(NUMBER_TYPE, STRING_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_STRING_SYMBOL, NUMBER_STRING_SYMBOL);
        JSType STRING_VALUE_OR_OBJECT_TYPE = this.createUnionType(STRING_OBJECT_TYPE, STRING_TYPE);
        this.registerNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE, STRING_VALUE_OR_OBJECT_TYPE);
        JSType NUMBER_VALUE_OR_OBJECT_TYPE = this.createUnionType(NUMBER_OBJECT_TYPE, NUMBER_TYPE);
        this.registerNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE, NUMBER_VALUE_OR_OBJECT_TYPE);
        JSType SYMBOL_VALUE_OR_OBJECT_TYPE = this.createUnionType(SYMBOL_OBJECT_TYPE, SYMBOL_TYPE);
        this.registerNativeType(JSTypeNative.SYMBOL_VALUE_OR_OBJECT_TYPE, SYMBOL_VALUE_OR_OBJECT_TYPE);
        FunctionType U2U_FUNCTION_TYPE = this.createFunctionTypeWithVarArgs(UNKNOWN_TYPE, UNKNOWN_TYPE);
        this.registerNativeType(JSTypeNative.U2U_FUNCTION_TYPE, U2U_FUNCTION_TYPE);
        FunctionType U2U_CONSTRUCTOR_TYPE = new FunctionType(this, "Function", null, this.createArrowType(this.createParametersWithVarArgs(UNKNOWN_TYPE), UNKNOWN_TYPE), UNKNOWN_TYPE, null, FunctionType.Kind.CONSTRUCTOR, true, false){
            private static final long serialVersionUID = 1L;

            @Override
            public FunctionType getConstructor() {
                return this.registry.getNativeFunctionType(JSTypeNative.FUNCTION_FUNCTION_TYPE);
            }
        };
        this.registerNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE, U2U_CONSTRUCTOR_TYPE);
        this.registerNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE, U2U_CONSTRUCTOR_TYPE);
        FUNCTION_FUNCTION_TYPE.setInstanceType(U2U_CONSTRUCTOR_TYPE);
        U2U_CONSTRUCTOR_TYPE.setImplicitPrototype(FUNCTION_PROTOTYPE);
        FunctionType LEAST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(NO_TYPE, ALL_TYPE);
        this.registerNativeType(JSTypeNative.LEAST_FUNCTION_TYPE, LEAST_FUNCTION_TYPE);
        FunctionType GLOBAL_THIS_CTOR = new FunctionType(this, "global this", null, this.createArrowType(this.createParameters(false, ALL_TYPE), NUMBER_TYPE), null, null, FunctionType.Kind.CONSTRUCTOR, true, false);
        ObjectType GLOBAL_THIS = GLOBAL_THIS_CTOR.getInstanceType();
        this.registerNativeType(JSTypeNative.GLOBAL_THIS, GLOBAL_THIS);
        FunctionType GREATEST_FUNCTION_TYPE = this.createNativeFunctionTypeWithVarArgs(ALL_TYPE, NO_TYPE);
        this.registerNativeType(JSTypeNative.GREATEST_FUNCTION_TYPE, GREATEST_FUNCTION_TYPE);
        this.registerPropertyOnType("prototype", OBJECT_FUNCTION_TYPE);
    }

    private void initializeRegistry() {
        this.registerGlobalType(this.getNativeType(JSTypeNative.ARRAY_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.BOOLEAN_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ITERABLE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ITERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.GENERATOR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.DATE_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.I_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NULL_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NULL_TYPE), "Null");
        this.registerGlobalType(this.getNativeType(JSTypeNative.NUMBER_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.URI_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.EVAL_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.TYPE_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.RANGE_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.REFERENCE_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.SYNTAX_ERROR_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.REGEXP_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.STRING_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.STRING_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.SYMBOL_OBJECT_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.SYMBOL_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE));
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE), "Undefined");
        this.registerGlobalType(this.getNativeType(JSTypeNative.VOID_TYPE), "void");
        this.registerGlobalType(this.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), "Function");
        this.registerGlobalType(this.getNativeType(JSTypeNative.GLOBAL_THIS), "Global");
    }

    private static void checkTypeName(String typeName) {
        Preconditions.checkArgument((!typeName.contains("<") ? 1 : 0) != 0, (Object)"Type names cannot contain template annotations.");
    }

    private void registerGlobalType(JSType type) {
        this.registerGlobalType(type, type.toString());
    }

    private void registerGlobalType(JSType type, String name) {
        this.register(type, name);
    }

    private void register(JSType type, String name) {
        JSTypeRegistry.checkTypeName(name);
        this.namesToTypes.put(name, type);
    }

    private void registerNativeType(JSTypeNative typeId, JSType type) {
        this.nativeTypes[typeId.ordinal()] = type;
    }

    private static boolean isObjectLiteralThatCanBeSkipped(JSType t) {
        return (t = t.restrictByNotNullOrUndefined()).isRecordType() || t.isLiteralObject();
    }

    void registerDroppedPropertiesInUnion(RecordType subtype, RecordType supertype) {
        boolean foundDroppedProperty = false;
        for (String pname : subtype.getPropertyMap().getOwnPropertyNames()) {
            if (supertype.hasProperty(pname)) continue;
            foundDroppedProperty = true;
            this.droppedPropertiesOfUnions.add(pname);
        }
        if (foundDroppedProperty) {
            this.propertiesOfSupertypesInUnions.addAll(supertype.getPropertyMap().getOwnPropertyNames());
        }
    }

    public void registerPropertyOnType(String propertyName, JSType type) {
        UnionTypeBuilder typeSet = this.typesIndexedByProperty.get(propertyName);
        if (typeSet == null) {
            typeSet = new UnionTypeBuilder(this, 3000);
            this.typesIndexedByProperty.put(propertyName, typeSet);
        }
        if (JSTypeRegistry.isObjectLiteralThatCanBeSkipped(type)) {
            type = this.getSentinelObjectLiteral();
        }
        typeSet.addAlternate(type);
        this.addReferenceTypeIndexedByProperty(propertyName, type);
        this.greatestSubtypeByProperty.remove(propertyName);
    }

    private void addReferenceTypeIndexedByProperty(String propertyName, JSType type) {
        if (type instanceof ObjectType && ((ObjectType)type).hasReferenceName()) {
            Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
            if (typeSet == null) {
                typeSet = new LinkedHashMap<String, ObjectType>();
                this.eachRefTypeIndexedByProperty.put(propertyName, typeSet);
            }
            ObjectType objType = (ObjectType)type;
            typeSet.put(objType.getReferenceName(), objType);
        } else if (type instanceof NamedType) {
            this.addReferenceTypeIndexedByProperty(propertyName, ((NamedType)type).getReferencedType());
        } else if (type.isUnionType()) {
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                this.addReferenceTypeIndexedByProperty(propertyName, alternate);
            }
        }
    }

    public void unregisterPropertyOnType(String propertyName, JSType type) {
        Map<String, ObjectType> typeSet = this.eachRefTypeIndexedByProperty.get(propertyName);
        if (typeSet != null) {
            typeSet.remove(type.toObjectType().getReferenceName());
        }
    }

    public JSType getGreatestSubtypeWithProperty(JSType type, String propertyName) {
        JSType withProperty = this.greatestSubtypeByProperty.get(propertyName);
        if (withProperty != null) {
            return withProperty.getGreatestSubtype(type);
        }
        UnionTypeBuilder typesWithProp = this.typesIndexedByProperty.get(propertyName);
        if (typesWithProp != null) {
            JSType built = typesWithProp.build();
            this.greatestSubtypeByProperty.put(propertyName, built);
            return built.getGreatestSubtype(type);
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public PropDefinitionKind canPropertyBeDefined(JSType type, String propertyName) {
        if (type.isStruct()) {
            switch (type.getPropertyKind(propertyName)) {
                case KNOWN_PRESENT: {
                    return PropDefinitionKind.KNOWN;
                }
                case MAYBE_PRESENT: {
                    return PropDefinitionKind.KNOWN;
                }
                case ABSENT: {
                    return PropDefinitionKind.UNKNOWN;
                }
            }
        } else {
            if (!type.isEmptyType() && !type.isUnknownType()) {
                switch (type.getPropertyKind(propertyName)) {
                    case KNOWN_PRESENT: {
                        return PropDefinitionKind.KNOWN;
                    }
                    case MAYBE_PRESENT: {
                        return PropDefinitionKind.KNOWN;
                    }
                }
            }
            if (this.typesIndexedByProperty.containsKey(propertyName)) {
                for (JSType alt : this.typesIndexedByProperty.get(propertyName).getAlternates()) {
                    RecordType maybeRecordType;
                    JSType greatestSubtype = alt.getGreatestSubtype(type);
                    if (greatestSubtype.isEmptyType() || (maybeRecordType = greatestSubtype.toMaybeRecordType()) != null && maybeRecordType.isSynthetic()) continue;
                    return PropDefinitionKind.LOOSE;
                }
            }
            if (type.toMaybeRecordType() != null) {
                RecordType rec = type.toMaybeRecordType();
                boolean mayBeInUnion = false;
                for (String pname : rec.getPropertyMap().getOwnPropertyNames()) {
                    if (!this.propertiesOfSupertypesInUnions.contains(pname)) continue;
                    mayBeInUnion = true;
                    break;
                }
                if (mayBeInUnion && this.droppedPropertiesOfUnions.contains(propertyName)) {
                    return PropDefinitionKind.LOOSE;
                }
            }
        }
        return PropDefinitionKind.UNKNOWN;
    }

    public Iterable<ObjectType> getEachReferenceTypeWithProperty(String propertyName) {
        if (this.eachRefTypeIndexedByProperty.containsKey(propertyName)) {
            return this.eachRefTypeIndexedByProperty.get(propertyName).values();
        }
        return ImmutableList.of();
    }

    ObjectType findCommonSuperObject(ObjectType a, ObjectType b) {
        List<ObjectType> stackA = JSTypeRegistry.getSuperStack(a);
        List<ObjectType> stackB = JSTypeRegistry.getSuperStack(b);
        ObjectType result = this.getNativeObjectType(JSTypeNative.OBJECT_TYPE);
        while (!stackA.isEmpty() && !stackB.isEmpty()) {
            ObjectType currentB;
            ObjectType currentA = stackA.remove(stackA.size() - 1);
            if (currentA.isEquivalentTo(currentB = stackB.remove(stackB.size() - 1))) {
                result = currentA;
                continue;
            }
            return result;
        }
        return result;
    }

    private static List<ObjectType> getSuperStack(ObjectType a) {
        ArrayList<ObjectType> stack = new ArrayList<ObjectType>(5);
        for (ObjectType current = a; current != null; current = current.getImplicitPrototype()) {
            stack.add(current);
        }
        return stack;
    }

    void registerTypeImplementingInterface(FunctionType type, ObjectType interfaceInstance) {
        this.interfaceToImplementors.put((Object)interfaceInstance.getReferenceName(), (Object)type);
    }

    public Collection<FunctionTypeI> getDirectImplementors(ObjectType interfaceInstance) {
        return this.interfaceToImplementors.get((Object)interfaceInstance.getReferenceName());
    }

    public boolean declareType(String name, JSType type) {
        return this.declareType(null, name, type);
    }

    public boolean declareType(StaticScope scope, String name, JSType type) {
        if (this.namesToTypes.containsKey(name)) {
            return false;
        }
        this.register(type, name);
        return true;
    }

    public void overwriteDeclaredType(String name, JSType type) {
        this.overwriteDeclaredType(null, name, type);
    }

    public void overwriteDeclaredType(StaticScope scope, String name, JSType type) {
        Preconditions.checkState((boolean)this.namesToTypes.containsKey(name));
        this.register(type, name);
    }

    public boolean isForwardDeclaredType(String name) {
        return this.forwardDeclaredTypes.contains(name);
    }

    @Override
    public String getReadableTypeName(Node n) {
        return this.getReadableJSTypeName(n, true);
    }

    public String getReadableTypeNameNoDeref(Node n) {
        return this.getReadableJSTypeName(n, false);
    }

    @Override
    public String createGetterPropName(String originalPropName) {
        return originalPropName;
    }

    @Override
    public String createSetterPropName(String originalPropName) {
        return originalPropName;
    }

    private String getSimpleReadableJSTypeName(JSType type) {
        if (type instanceof AllType) {
            return type.toString();
        }
        if (type instanceof ValueType) {
            return type.toString();
        }
        if (type.isFunctionPrototypeType()) {
            return type.toString();
        }
        if (type instanceof ObjectType) {
            if (type.toObjectType() != null && type.toObjectType().getConstructor() != null) {
                Node source = type.toObjectType().getConstructor().getSource();
                if (source != null) {
                    Preconditions.checkState((boolean)source.isFunction(), (Object)source);
                    String readable = source.getFirstChild().getOriginalName();
                    if (readable != null) {
                        return readable;
                    }
                }
                return type.toString();
            }
            return null;
        }
        if (type instanceof UnionType) {
            UnionType unionType = type.toMaybeUnionType();
            String union = null;
            for (JSType alternate : unionType.getAlternates()) {
                String name = this.getSimpleReadableJSTypeName(alternate);
                if (name == null) {
                    return null;
                }
                if (union == null) {
                    union = "(" + name;
                    continue;
                }
                union = union + "|" + name;
            }
            union = union + ")";
            return union;
        }
        return null;
    }

    @VisibleForTesting
    String getReadableJSTypeName(Node n, boolean dereference) {
        ObjectType objectType;
        String name;
        JSType autoboxed;
        JSType type = this.getJSTypeOrUnknown(n);
        if (dereference && !(autoboxed = type.autobox()).isNoType()) {
            type = autoboxed;
        }
        if ((name = this.getSimpleReadableJSTypeName(type)) != null) {
            return name;
        }
        if (n.isGetProp() && (objectType = this.getJSTypeOrUnknown(n.getFirstChild()).dereference()) != null) {
            String propName = n.getLastChild().getString();
            if (objectType.getConstructor() != null && objectType.getConstructor().isInterface()) {
                objectType = objectType.getTopDefiningInterface(propName);
            } else {
                while (objectType != null && !objectType.hasOwnProperty(propName)) {
                    objectType = objectType.getImplicitPrototype();
                }
            }
            if (objectType != null && (objectType.getConstructor() != null || objectType.isFunctionPrototypeType())) {
                return objectType + "." + propName;
            }
        }
        if (n.isQualifiedName()) {
            return n.getQualifiedName();
        }
        if (type.isFunctionType()) {
            return "function";
        }
        return type.toString();
    }

    private JSType getJSTypeOrUnknown(Node n) {
        JSType jsType = n.getJSType();
        if (jsType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jsType;
    }

    public void removeType(String jsTypeName) {
        this.namesToTypes.remove(jsTypeName);
    }

    @Override
    public JSType getGlobalType(String jsTypeName) {
        return this.getType(null, jsTypeName);
    }

    @Override
    public JSType getType(String jsTypeName) {
        return this.getType(null, jsTypeName);
    }

    @Override
    public JSType getType(StaticScope scope, String jsTypeName) {
        TemplateType templateType = this.templateTypes.get(jsTypeName);
        if (templateType != null) {
            return templateType;
        }
        return this.namesToTypes.get(jsTypeName);
    }

    public JSType getType(StaticTypedScope<JSType> scope, String jsTypeName, String sourceName, int lineno, int charno) {
        return this.getType(scope, jsTypeName, sourceName, lineno, charno, true);
    }

    private JSType getType(StaticTypedScope<JSType> scope, String jsTypeName, String sourceName, int lineno, int charno, boolean recordUnresolvedTypes) {
        switch (jsTypeName) {
            case "boolean": {
                return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            case "number": {
                return this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            case "string": {
                return this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            case "undefined": 
            case "void": {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
        }
        JSType type = null;
        JSType thisType = null;
        if (scope != null && scope.getTypeOfThis() != null) {
            thisType = scope.getTypeOfThis().toObjectType();
        }
        if (thisType != null && (type = thisType.getTemplateTypeMap().getTemplateTypeKeyByName(jsTypeName)) != null) {
            Preconditions.checkState((boolean)type.isTemplateType(), (String)"expected:%s", (Object)type);
            return type;
        }
        type = this.getType(scope, jsTypeName);
        if (type == null) {
            NamedType namedType = this.createNamedType(scope, jsTypeName, sourceName, lineno, charno);
            if (recordUnresolvedTypes) {
                this.unresolvedNamedTypes.put(scope, (Object)namedType);
            }
            type = namedType;
        }
        return type;
    }

    @Override
    public JSType getNativeType(JSTypeNative typeId) {
        return this.nativeTypes[typeId.ordinal()];
    }

    @Override
    public ObjectType getNativeObjectType(JSTypeNative typeId) {
        return (ObjectType)this.getNativeType(typeId);
    }

    @Override
    public FunctionType getNativeFunctionType(JSTypeNative typeId) {
        return (FunctionType)this.getNativeType(typeId);
    }

    public void clearNamedTypes() {
        this.unresolvedNamedTypes.clear();
    }

    public void resolveTypesInScope(StaticTypedScope<JSType> scope) {
        for (NamedType type : this.unresolvedNamedTypes.get(scope)) {
            type.resolve(this.reporter, scope);
        }
        this.unresolvedNamedTypes.removeAll(scope);
        if (scope != null && scope.getParentScope() == null) {
            PrototypeObjectType globalThis = (PrototypeObjectType)this.getNativeType(JSTypeNative.GLOBAL_THIS);
            JSType windowType = this.getType("Window");
            if (globalThis.isUnknownType()) {
                ObjectType windowObjType = ObjectType.cast(windowType);
                if (windowObjType != null) {
                    globalThis.setImplicitPrototype(windowObjType);
                } else {
                    globalThis.setImplicitPrototype(this.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
                }
            }
        }
    }

    @Override
    public JSType evaluateTypeExpressionInGlobalScope(JSTypeExpression expr) {
        return expr.evaluate(null, this);
    }

    public JSType createOptionalType(JSType type) {
        if (type instanceof UnknownType || type.isAllType()) {
            return type;
        }
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE));
    }

    public JSType createDefaultObjectUnion(JSType type) {
        if (type.isTemplateType()) {
            return type;
        }
        return this.createNullableType(type);
    }

    public JSType createNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createOptionalNullableType(JSType type) {
        return this.createUnionType(type, this.getNativeType(JSTypeNative.VOID_TYPE), this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType createUnionType(JSType ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSType type : variants) {
            builder.addAlternate(type);
        }
        return builder.build();
    }

    @Override
    public JSType createUnionType(List<? extends TypeI> variants) {
        return this.createUnionType(variants.toArray(new JSType[0]));
    }

    public JSType createUnionType(JSTypeNative ... variants) {
        UnionTypeBuilder builder = new UnionTypeBuilder(this);
        for (JSTypeNative typeId : variants) {
            builder.addAlternate(this.getNativeType(typeId));
        }
        return builder.build();
    }

    public EnumType createEnumType(String name, Node source, JSType elementsType) {
        return new EnumType(this, name, source, elementsType);
    }

    ArrowType createArrowType(Node parametersNode, JSType returnType) {
        return new ArrowType(this, parametersNode, returnType);
    }

    ArrowType createArrowType(Node parametersNode) {
        return new ArrowType(this, parametersNode, null);
    }

    ArrowType createArrowType() {
        return new ArrowType(this, new Node(Token.PARAM_LIST), null);
    }

    public FunctionType createFunctionType(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParameters(parameterTypes));
    }

    public FunctionType createFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).build();
    }

    public FunctionType createFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    private FunctionType createNativeFunctionTypeWithVarArgs(JSType returnType, JSType ... parameterTypes) {
        return this.createNativeFunctionType(returnType, this.createParametersWithVarArgs(parameterTypes));
    }

    public JSType createFunctionTypeWithInstanceType(ObjectType instanceType, JSType returnType, List<JSType> parameterTypes) {
        Node paramsNode = this.createParameters(parameterTypes.toArray(new JSType[parameterTypes.size()]));
        return new FunctionBuilder(this).withParamsNode(paramsNode).withReturnType(returnType).withTypeOfThis(instanceType).build();
    }

    public Node createParameters(JSType ... parameterTypes) {
        return this.createParameters(false, parameterTypes);
    }

    private Node createParameters(boolean lastVarArgs, JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        int max = parameterTypes.length - 1;
        for (int i = 0; i <= max; ++i) {
            if (lastVarArgs && i == max) {
                builder.addVarArgs(parameterTypes[i]);
                continue;
            }
            builder.addRequiredParams(parameterTypes[i]);
        }
        return builder.build();
    }

    public Node createParametersWithVarArgs(JSType ... parameterTypes) {
        return this.createParameters(true, parameterTypes);
    }

    public Node createOptionalParameters(JSType ... parameterTypes) {
        FunctionParamBuilder builder = new FunctionParamBuilder(this);
        builder.addOptionalParams(parameterTypes);
        return builder.build();
    }

    public FunctionType createFunctionTypeWithNewReturnType(FunctionType existingFunctionType, JSType returnType) {
        return new FunctionBuilder(this).copyFromOtherFunction(existingFunctionType).withReturnType(returnType).build();
    }

    private FunctionType createNativeFunctionType(JSType returnType, Node parameters) {
        return new FunctionBuilder(this).withParamsNode(parameters).withReturnType(returnType).forNativeType().build();
    }

    @Override
    public JSType buildRecordTypeFromObject(ObjectTypeI obj) {
        ObjectType objType = (ObjectType)obj;
        RecordType recType = objType.toMaybeRecordType();
        if (recType != null) {
            return recType;
        }
        Iterable propNames = objType.getOwnPropertyNames();
        if (propNames.isEmpty()) {
            return this.getNativeType(JSTypeNative.OBJECT_TYPE);
        }
        ImmutableMap.Builder props = new ImmutableMap.Builder();
        for (String propName : propNames) {
            props.put((Object)propName, (Object)objType.getPropertyType(propName));
        }
        return this.createRecordType((Map)props.build());
    }

    @Override
    public JSType createRecordType(Map<String, ? extends TypeI> props) {
        Map<String, ? extends TypeI> propMap = props;
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Map.Entry<String, ? extends TypeI> e : propMap.entrySet()) {
            builder.addProperty(e.getKey(), (JSType)e.getValue(), null);
        }
        return builder.build();
    }

    public ObjectType createObjectType(String name, ObjectType implicitPrototype) {
        return new PrototypeObjectType(this, name, implicitPrototype);
    }

    public ObjectType createAnonymousObjectType(JSDocInfo info) {
        PrototypeObjectType type = new PrototypeObjectType(this, null, null, true);
        type.setPrettyPrint(true);
        type.setJSDocInfo(info);
        return type;
    }

    public void resetImplicitPrototype(JSType type, ObjectType newImplicitProto) {
        if (type instanceof PrototypeObjectType) {
            PrototypeObjectType poType = (PrototypeObjectType)type;
            poType.clearCachedValues();
            poType.setImplicitPrototype(newImplicitProto);
        }
    }

    public FunctionType createConstructorType(String name, Node source, Node parameters, JSType returnType, ImmutableList<TemplateType> templateKeys, boolean isAbstract) {
        Preconditions.checkArgument((source == null || source.isFunction() ? 1 : 0) != 0);
        return new FunctionType(this, name, source, this.createArrowType(parameters, returnType), null, this.createTemplateTypeMap(templateKeys, null), FunctionType.Kind.CONSTRUCTOR, false, isAbstract);
    }

    public FunctionType createInterfaceType(String name, Node source, ImmutableList<TemplateType> templateKeys, boolean struct) {
        FunctionType fn = FunctionType.forInterface(this, name, source, this.createTemplateTypeMap(templateKeys, null));
        if (struct) {
            fn.setStruct();
        }
        return fn;
    }

    public TemplateType createTemplateType(String name) {
        return new TemplateType(this, name);
    }

    public TemplateType createTemplateTypeWithTransformation(String name, Node expr) {
        return new TemplateType(this, name, expr);
    }

    public TemplateTypeMap createTemplateTypeMap(ImmutableList<TemplateType> templateKeys, ImmutableList<JSType> templateValues) {
        if (templateKeys == null) {
            templateKeys = ImmutableList.of();
        }
        if (templateValues == null) {
            templateValues = ImmutableList.of();
        }
        return templateKeys.isEmpty() && templateValues.isEmpty() ? this.emptyTemplateTypeMap : new TemplateTypeMap(this, (ImmutableList<TemplateType>)templateKeys, (ImmutableList<JSType>)templateValues);
    }

    public ObjectTypeI instantiateGenericsWithUnknown(ObjectType obj) {
        if (obj.isTemplatizedType()) {
            ImmutableList.Builder unknowns = ImmutableList.builder();
            for (TemplateType unused : obj.getTemplateTypeMap().getTemplateKeys()) {
                unknowns.add((Object)this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
            }
            return this.createTemplatizedType(obj.toMaybeTemplatizedType().getRawType(), (ImmutableList<JSType>)unknowns.build());
        }
        return obj;
    }

    @Override
    public TypeI instantiateGenericType(ObjectTypeI genericType, ImmutableList<? extends TypeI> typeArgs) {
        return this.createTemplatizedType((ObjectType)genericType, typeArgs);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, ImmutableList<JSType> templatizedTypes) {
        return new TemplatizedType(this, baseType, templatizedTypes);
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, Map<TemplateType, JSType> templatizedTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TemplateTypeMap baseTemplateTypeMap = baseType.getTemplateTypeMap();
        for (TemplateType key : baseTemplateTypeMap.getUnfilledTemplateKeys()) {
            JSType templatizedType = templatizedTypes.containsKey(key) ? templatizedTypes.get(key) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.add((Object)templatizedType);
        }
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)builder.build());
    }

    public TemplatizedType createTemplatizedType(ObjectType baseType, JSType ... templatizedTypes) {
        return this.createTemplatizedType(baseType, (ImmutableList<JSType>)ImmutableList.copyOf((Object[])templatizedTypes));
    }

    @VisibleForTesting
    public NamedType createNamedType(String reference, String sourceName, int lineno, int charno) {
        return this.createNamedType(null, reference, sourceName, lineno, charno);
    }

    @VisibleForTesting
    public NamedType createNamedType(StaticTypedScope<JSType> scope, String reference, String sourceName, int lineno, int charno) {
        if (reference.endsWith(".")) {
            return new NamespaceType(this, reference, sourceName, lineno, charno);
        }
        return new NamedType(scope, this, reference, sourceName, lineno, charno);
    }

    public void identifyNonNullableName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.nonNullableTypeNames.add(name);
    }

    @Override
    public JSType evaluateTypeExpression(JSTypeExpression expr, TypeIEnv<TypeI> scope) {
        return this.createTypeFromCommentNode(expr.getRoot(), expr.getSourceName(), (StaticTypedScope)((Object)scope));
    }

    @Override
    public JSType createTypeFromCommentNode(Node n) {
        return this.createTypeFromCommentNode(n, "[internal]", null);
    }

    public JSType createTypeFromCommentNode(Node n, String sourceName, StaticTypedScope<? extends TypeI> scope) {
        return this.createFromTypeNodesInternal(n, sourceName, scope, true);
    }

    private JSType createFromTypeNodesInternal(Node n, String sourceName, StaticTypedScope<JSType> scope, boolean recordUnresolvedTypes) {
        switch (n.getToken()) {
            case LC: {
                return this.createRecordTypeFromNodes(n.getFirstChild(), sourceName, scope);
            }
            case BANG: {
                return this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes).restrictByNotNullOrUndefined();
            }
            case QMARK: {
                Node firstChild = n.getFirstChild();
                if (firstChild == null) {
                    return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
                }
                return this.createNullableType(this.createFromTypeNodesInternal(firstChild, sourceName, scope, recordUnresolvedTypes));
            }
            case EQUALS: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes));
            }
            case ELLIPSIS: {
                return this.createOptionalType(this.createFromTypeNodesInternal(n.getFirstChild(), sourceName, scope, recordUnresolvedTypes));
            }
            case STAR: {
                return this.getNativeType(JSTypeNative.ALL_TYPE);
            }
            case PIPE: {
                UnionTypeBuilder builder = new UnionTypeBuilder(this);
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    builder.addAlternate(this.createFromTypeNodesInternal(child, sourceName, scope, recordUnresolvedTypes));
                }
                return builder.build();
            }
            case EMPTY: {
                return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            case VOID: {
                return this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            case STRING: 
            case NAME: {
                JSType namedType = this.getType(scope, n.getString(), sourceName, n.getLineno(), n.getCharno(), recordUnresolvedTypes);
                if (namedType instanceof ObjectType && !(namedType instanceof NamespaceType) && !this.nonNullableTypeNames.contains(n.getString())) {
                    boolean isUnknownForwardDeclared;
                    Node typeList = n.getFirstChild();
                    boolean bl = isUnknownForwardDeclared = namedType.isUnknownType() && this.isForwardDeclaredType(n.getString());
                    if ((!namedType.isUnknownType() || isUnknownForwardDeclared) && typeList != null) {
                        ImmutableList.Builder templateTypes = ImmutableList.builder();
                        if ((n.getString().equals("Object") || n.getString().equals("window.Object")) && typeList.hasZeroOrOneChild()) {
                            templateTypes.add((Object)this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                        }
                        int nAllowedTypes = isUnknownForwardDeclared ? Integer.MAX_VALUE : namedType.getTemplateTypeMap().numUnfilledTemplateKeys();
                        boolean recordTemplateArgs = recordUnresolvedTypes && !isUnknownForwardDeclared;
                        int templateNodeIndex = 0;
                        for (Node templateNode : typeList.children()) {
                            if (++templateNodeIndex > nAllowedTypes) {
                                this.reporter.warning("Too many template parameters", sourceName, templateNode.getLineno(), templateNode.getCharno());
                                break;
                            }
                            templateTypes.add((Object)this.createFromTypeNodesInternal(templateNode, sourceName, scope, recordTemplateArgs));
                        }
                        namedType = isUnknownForwardDeclared ? new NamedType(scope, this, n.getString(), sourceName, n.getLineno(), n.getCharno(), (ImmutableList<JSType>)templateTypes.build()) : this.createTemplatizedType((ObjectType)namedType, (ImmutableList<JSType>)templateTypes.build());
                        Preconditions.checkNotNull((Object)namedType);
                    }
                    return this.createDefaultObjectUnion(namedType);
                }
                return namedType;
            }
            case FUNCTION: {
                JSType thisType = null;
                boolean isConstructor = false;
                Node current = n.getFirstChild();
                if (current.isThis() || current.isNew()) {
                    Node contextNode = current.getFirstChild();
                    JSType candidateThisType = this.createFromTypeNodesInternal(contextNode, sourceName, scope, recordUnresolvedTypes);
                    if (candidateThisType.isNullType() || candidateThisType.isVoidType()) {
                        thisType = candidateThisType;
                    } else if (current.isThis()) {
                        thisType = candidateThisType.restrictByNotNullOrUndefined();
                    } else if (current.isNew() && (thisType = ObjectType.cast(candidateThisType.restrictByNotNullOrUndefined())) == null) {
                        this.reporter.warning(SimpleErrorReporter.getMessage0("msg.jsdoc.function.newnotobject"), sourceName, contextNode.getLineno(), contextNode.getCharno());
                    }
                    isConstructor = current.getToken() == Token.NEW;
                    current = current.getNext();
                }
                FunctionParamBuilder paramBuilder = new FunctionParamBuilder(this);
                if (current.getToken() == Token.PARAM_LIST) {
                    for (Node arg = current.getFirstChild(); arg != null; arg = arg.getNext()) {
                        if (arg.getToken() == Token.ELLIPSIS) {
                            if (!arg.hasChildren()) {
                                paramBuilder.addVarArgs(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
                                continue;
                            }
                            paramBuilder.addVarArgs(this.createFromTypeNodesInternal(arg.getFirstChild(), sourceName, scope, recordUnresolvedTypes));
                            continue;
                        }
                        JSType type = this.createFromTypeNodesInternal(arg, sourceName, scope, recordUnresolvedTypes);
                        if (arg.getToken() == Token.EQUALS) {
                            boolean addSuccess = paramBuilder.addOptionalParams(type);
                            if (addSuccess) continue;
                            this.reporter.warning(SimpleErrorReporter.getMessage0("msg.jsdoc.function.varargs"), sourceName, arg.getLineno(), arg.getCharno());
                            continue;
                        }
                        paramBuilder.addRequiredParams(type);
                    }
                    current = current.getNext();
                }
                JSType returnType = this.createFromTypeNodesInternal(current, sourceName, scope, recordUnresolvedTypes);
                return new FunctionBuilder(this).withParamsNode(paramBuilder.build()).withReturnType(returnType).withTypeOfThis(thisType).setIsConstructor(isConstructor).build();
            }
        }
        throw new IllegalStateException("Unexpected node in type expression: " + n);
    }

    private JSType createRecordTypeFromNodes(Node n, String sourceName, StaticTypedScope<JSType> scope) {
        RecordTypeBuilder builder = new RecordTypeBuilder(this);
        for (Node fieldTypeNode = n.getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            String fieldName;
            Node fieldNameNode = fieldTypeNode;
            boolean hasType = false;
            if (fieldTypeNode.getToken() == Token.COLON) {
                fieldNameNode = fieldTypeNode.getFirstChild();
                hasType = true;
            }
            if ((fieldName = fieldNameNode.getString()).startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = null;
            fieldType = hasType ? this.createFromTypeNodesInternal(fieldTypeNode.getLastChild(), sourceName, scope, true) : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            builder.addProperty(fieldName, fieldType, fieldNameNode);
        }
        return builder.build();
    }

    public void setTemplateTypeNames(List<TemplateType> keys) {
        Preconditions.checkNotNull(keys);
        for (TemplateType key : keys) {
            this.templateTypes.put(key.getReferenceName(), key);
        }
    }

    public void clearTemplateTypeNames() {
        this.templateTypes.clear();
    }

    @GwtIncompatible(value="ObjectOutputStream")
    public void saveContents(ObjectOutputStream out) throws IOException {
        out.writeObject(this.eachRefTypeIndexedByProperty);
        out.writeObject(this.interfaceToImplementors);
    }

    @GwtIncompatible(value="ObjectInputStream")
    public void restoreContents(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.eachRefTypeIndexedByProperty = (Map)in.readObject();
        this.interfaceToImplementors = (Multimap)in.readObject();
    }

    public static enum PropDefinitionKind {
        UNKNOWN,
        KNOWN,
        LOOSE,
        LOOSE_UNION;

    }
}

