/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.ConformanceConfig;
import com.google.javascript.jscomp.ForwardingCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Requirement;
import com.google.javascript.rhino.Node;

@GwtIncompatible(value="Conformance")
public class ConformanceWhitelister {
    private ConformanceWhitelister() {
    }

    public static ImmutableSet<String> getViolatingPaths(AbstractCompiler compiler, Node externs, Node ast, Requirement requirement) {
        ConformanceViolationRecordingCompiler recordingCompiler = new ConformanceViolationRecordingCompiler(compiler);
        Requirement cleanedRequirement = requirement.toBuilder().clearWhitelist().setSeverity(Requirement.Severity.ERROR).build();
        ConformanceConfig cleanedConfig = ConformanceConfig.newBuilder().addRequirement(cleanedRequirement).build();
        CheckConformance check = new CheckConformance(recordingCompiler, (ImmutableList<ConformanceConfig>)ImmutableList.of((Object)cleanedConfig));
        check.process(externs, ast);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JSError e : recordingCompiler.getConformanceErrors()) {
            result.add((Object)e.sourceName);
        }
        return result.build();
    }

    private static class ConformanceViolationRecordingCompiler
    extends ForwardingCompiler {
        private final ImmutableList.Builder<JSError> conformanceErrors = ImmutableList.builder();

        private ConformanceViolationRecordingCompiler(AbstractCompiler abstractCompiler) {
            super(abstractCompiler);
        }

        ImmutableList<JSError> getConformanceErrors() {
            return this.conformanceErrors.build();
        }

        @Override
        public void report(JSError error) {
            if (error.getType().equals(CheckConformance.CONFORMANCE_ERROR)) {
                this.conformanceErrors.add((Object)error);
            } else {
                super.report(error);
            }
        }
    }
}

