/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;

public final class Es7ToEs6Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.EXPONENT_OP);
    private final boolean addTypes;
    private final Supplier<Node> mathPow = Suppliers.memoize((Supplier)new MathPowSupplier());

    public Es7ToEs6Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.addTypes = AbstractCompiler.MostRecentTypechecker.NTI.equals((Object)compiler.getMostRecentTypechecker());
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, transpiledFeatures, this);
        TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, transpiledFeatures, this);
        TranspilationPasses.markFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case EXPONENT: {
                this.visitExponentiationExpression(n, parent);
                break;
            }
            case ASSIGN_EXPONENT: {
                this.visitExponentiationAssignmentExpression(n, parent);
                break;
            }
        }
    }

    private void visitExponentiationExpression(Node n, Node parent) {
        Node left = n.removeFirstChild();
        Node right = n.removeFirstChild();
        Node mathDotPowCall = Es6ToEs3Util.withType(IR.call(((Node)this.mathPow.get()).cloneTree(), left, right), n.getTypeI()).useSourceInfoIfMissingFromForTree(n);
        parent.replaceChild(n, mathDotPowCall);
        this.compiler.reportChangeToEnclosingScope(mathDotPowCall);
    }

    private void visitExponentiationAssignmentExpression(Node n, Node parent) {
        Node left = n.removeFirstChild();
        Node right = n.removeFirstChild();
        Node mathDotPowCall = Es6ToEs3Util.withType(IR.call(((Node)this.mathPow.get()).cloneTree(), left.cloneTree(), right), n.getTypeI());
        Node assign = Es6ToEs3Util.withType(IR.assign(left, mathDotPowCall), n.getTypeI()).useSourceInfoIfMissingFromForTree(n);
        parent.replaceChild(n, assign);
        this.compiler.reportChangeToEnclosingScope(assign);
    }

    private class MathPowSupplier
    implements Supplier<Node> {
        private MathPowSupplier() {
        }

        public Node get() {
            Node n = NodeUtil.newQName(Es7ToEs6Converter.this.compiler, "Math.pow");
            if (Es7ToEs6Converter.this.addTypes) {
                TypeI mathType = Es7ToEs6Converter.this.compiler.getTypeIRegistry().getGlobalType("Math");
                TypeI mathPowType = mathType.toMaybeObjectType().getPropertyType("pow");
                TypeI stringType = Es6ToEs3Util.createType(Es7ToEs6Converter.this.addTypes, Es7ToEs6Converter.this.compiler.getTypeIRegistry(), JSTypeNative.STRING_TYPE);
                n.setTypeI(mathPowType);
                n.getFirstChild().setTypeI(mathType);
                n.getSecondChild().setTypeI(stringType);
            }
            return n;
        }
    }
}

