/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final String ARGUMENTS = "arguments";
    private static final String PARAMETER_PREFIX = "JSCompiler_OptimizeArgumentsArray_p";
    private final String paramPrefix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = new ArrayDeque<List<Node>>();
    private List<Node> currentArgumentsAccess = null;

    OptimizeArgumentsArray(AbstractCompiler compiler) {
        this(compiler, PARAMETER_PREFIX);
    }

    OptimizeArgumentsArray(AbstractCompiler compiler, String paramPrefix) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.paramPrefix = (String)Preconditions.checkNotNull((Object)paramPrefix);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, (Node)Preconditions.checkNotNull((Object)root), this);
    }

    @Override
    public void enterScope(NodeTraversal traversal) {
        Preconditions.checkNotNull((Object)traversal);
        Node function = traversal.getScopeRoot();
        if (!function.isFunction()) {
            return;
        }
        if (this.currentArgumentsAccess != null) {
            this.argumentsAccessStack.push(this.currentArgumentsAccess);
        }
        this.currentArgumentsAccess = new ArrayList<Node>();
    }

    @Override
    public void exitScope(NodeTraversal traversal) {
        Preconditions.checkNotNull((Object)traversal);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        Node function = traversal.getScopeRoot();
        if (!function.isFunction()) {
            return;
        }
        if (function.isArrowFunction()) {
            return;
        }
        if (this.tryReplaceArguments(traversal.getScope())) {
            traversal.reportCodeChange();
        }
        this.currentArgumentsAccess = !this.argumentsAccessStack.isEmpty() ? this.argumentsAccessStack.pop() : null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        Preconditions.checkNotNull((Object)traversal);
        Preconditions.checkNotNull((Object)node);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (node.isName() && ARGUMENTS.equals(node.getString())) {
            this.currentArgumentsAccess.add(node);
        }
    }

    private boolean tryReplaceArguments(Scope scope) {
        Node parametersList = scope.getRootNode().getSecondChild();
        Preconditions.checkState((boolean)parametersList.isParamList());
        int numParameters = parametersList.getChildCount();
        int highestIndex = numParameters - 1;
        highestIndex = this.getHighestIndex(highestIndex);
        if (highestIndex < 0) {
            return false;
        }
        int numExtraArgs = highestIndex - numParameters + 1;
        String[] argNames = new String[numExtraArgs];
        boolean changed = false;
        boolean changedSignature = this.changeMethodSignature(numExtraArgs, parametersList, argNames);
        boolean changedBody = this.changeBody(numParameters, argNames, parametersList);
        changed = changedSignature;
        if (changedBody) {
            changed = changedBody;
        }
        return changed;
    }

    private int getHighestIndex(int highestIndex) {
        for (Node ref : this.currentArgumentsAccess) {
            Node getElem = ref.getParent();
            if (!getElem.isGetElem() || ref != getElem.getFirstChild()) {
                return -1;
            }
            Node index = ref.getNext();
            if (!index.isNumber() || index.getDouble() < 0.0) {
                return -1;
            }
            if (index.getDouble() != Math.floor(index.getDouble())) {
                return -1;
            }
            Node getElemParent = getElem.getParent();
            if (getElemParent.isCall() && getElemParent.getFirstChild() == getElem) {
                return -1;
            }
            int value = (int)index.getDouble();
            if (value <= highestIndex) continue;
            highestIndex = value;
        }
        return highestIndex;
    }

    private boolean changeMethodSignature(int numExtraArgs, Node parametersList, String[] argNames) {
        boolean changed = false;
        for (int i = 0; i < numExtraArgs; ++i) {
            String name;
            argNames[i] = name = this.getNewName();
            parametersList.addChildToBack(IR.name(name).useSourceInfoIfMissingFrom(parametersList));
            changed = true;
        }
        return changed;
    }

    private boolean changeBody(int numNamedParameter, String[] argNames, Node parametersList) {
        boolean changed = false;
        boolean nextArguments = true;
        while (nextArguments) {
            nextArguments = false;
            for (Node ref : this.currentArgumentsAccess) {
                if (NodeUtil.getEnclosingFunction(ref).isArrowFunction()) {
                    nextArguments = true;
                }
                Node index = ref.getNext();
                Node grandParent = ref.getGrandparent();
                Node parent = ref.getParent();
                if (!index.isNumber()) continue;
                int value = (int)index.getDouble();
                if (value >= numNamedParameter) {
                    grandParent.replaceChild(parent, IR.name(argNames[value - numNamedParameter]));
                    this.compiler.reportChangeToEnclosingScope(grandParent);
                } else {
                    Node name = parametersList.getFirstChild();
                    for (int i = 0; i < value; ++i) {
                        name = parametersList.getChildAtIndex(value);
                    }
                    grandParent.replaceChild(parent, IR.name(name.getString()));
                    this.compiler.reportChangeToEnclosingScope(grandParent);
                }
                changed = true;
            }
            if (!nextArguments) continue;
            if (!this.argumentsAccessStack.isEmpty()) {
                this.currentArgumentsAccess = this.argumentsAccessStack.pop();
                continue;
            }
            this.currentArgumentsAccess = null;
        }
        return changed;
    }

    private String getNewName() {
        return this.paramPrefix + this.uniqueId++;
    }
}

