/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AutoValue_RemoveUnusedPolyfills_PrototypeMethod;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.GuardedCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TypeI;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

class RemoveUnusedPolyfills
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final ImmutableSet<String> GLOBAL_NAMES = ImmutableSet.of((Object)"goog.global.", (Object)"goog$global.", (Object)"window.");
    private static final ImmutableList<String> POLYFILL_PARAMETERS = ImmutableList.of((Object)"target", (Object)"polyfill", (Object)"fromLang", (Object)"toLang");
    private static final ImmutableMap<String, String> PRIMITIVE_WRAPPERS = ImmutableMap.of((Object)"Boolean", (Object)"boolean", (Object)"Number", (Object)"number", (Object)"String", (Object)"string");

    RemoveUnusedPolyfills(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        CollectUnusedPolyfills collector = new CollectUnusedPolyfills();
        NodeTraversal.traverseEs6(this.compiler, root, collector);
        for (Node node : collector.removableNodes()) {
            Node parent = node.getParent();
            NodeUtil.removeChild(parent, node);
            NodeUtil.markFunctionsDeleted(node, this.compiler);
            this.compiler.reportChangeToEnclosingScope(parent);
        }
    }

    private static String getLastPartOfQualifiedName(Node n) {
        if (n.isName()) {
            return n.getString();
        }
        if (n.isGetProp()) {
            return n.getLastChild().getString();
        }
        return null;
    }

    private static String removeExplicitGlobalPrefix(String qname) {
        for (String global : GLOBAL_NAMES) {
            if (!qname.startsWith(global)) continue;
            return qname.substring(global.length());
        }
        return qname;
    }

    private static boolean isPolyfillDefinition(Node callee) {
        if (callee.matchesQualifiedName("$jscomp.polyfill") || callee.matchesQualifiedName("$jscomp$polyfill")) {
            return true;
        }
        if (callee.isFunction()) {
            Node paramList = callee.getSecondChild();
            Node param = paramList.getFirstChild();
            if (paramList.hasXChildren(4)) {
                for (String name : POLYFILL_PARAMETERS) {
                    if (!param.isName() || !param.getString().startsWith(name)) {
                        return false;
                    }
                    param = param.getNext();
                }
                return true;
            }
        }
        return false;
    }

    private static String unwrapPrimitiveWrapperTypename(String type) {
        return (String)PRIMITIVE_WRAPPERS.get((Object)type);
    }

    @Immutable
    static abstract class PrototypeMethod {
        private static final String PROTOTYPE = ".prototype.";

        PrototypeMethod() {
        }

        abstract String type();

        abstract String method();

        @Nullable
        static PrototypeMethod split(String name) {
            int index = name.indexOf(PROTOTYPE);
            return index < 0 ? null : new AutoValue_RemoveUnusedPolyfills_PrototypeMethod(name.substring(0, index), name.substring(index + PROTOTYPE.length()));
        }

        public String toString() {
            return this.type() + PROTOTYPE + this.method();
        }
    }

    private class CollectUnusedPolyfills
    extends GuardedCallback<String> {
        final SetMultimap<String, PrototypeMethod> methodsByName;
        final Map<PrototypeMethod, Node> unusedMethodPolyfills;
        final Map<String, Node> unusedStaticPolyfills;
        final Set<String> suffixes;

        CollectUnusedPolyfills() {
            super(RemoveUnusedPolyfills.this.compiler);
            this.methodsByName = HashMultimap.create();
            this.unusedMethodPolyfills = new HashMap<PrototypeMethod, Node>();
            this.unusedStaticPolyfills = new HashMap<String, Node>();
            this.suffixes = new HashSet<String>();
        }

        Iterable<Node> removableNodes() {
            return Iterables.concat(this.unusedMethodPolyfills.values(), this.unusedStaticPolyfills.values());
        }

        @Override
        public void visitGuarded(NodeTraversal traversal, Node n, Node parent) {
            Node call;
            Node callee;
            if (NodeUtil.isExprCall(n) && RemoveUnusedPolyfills.isPolyfillDefinition(callee = (call = n.getFirstChild()).getFirstChild())) {
                String polyfillName = call.getSecondChild().getString();
                this.visitPolyfillDefinition(n, polyfillName);
            }
            if (n.isQualifiedName() && this.suffixes.contains(RemoveUnusedPolyfills.getLastPartOfQualifiedName(n))) {
                this.visitPossibleStaticPolyfillUse(n);
            }
            if (n.isGetProp()) {
                this.visitPossibleMethodPolyfillUse(n);
            }
        }

        void visitPolyfillDefinition(Node n, String polyfillName) {
            PrototypeMethod method = PrototypeMethod.split(polyfillName);
            if (method != null) {
                if (this.unusedMethodPolyfills.put(method, n) != null) {
                    throw new RuntimeException(method + " polyfilled multiple times.");
                }
                this.methodsByName.put((Object)method.method(), (Object)method);
                this.suffixes.add(method.method());
            } else {
                if (this.unusedStaticPolyfills.put(polyfillName, n) != null) {
                    throw new RuntimeException(polyfillName + " polyfilled multiple times.");
                }
                this.suffixes.add(polyfillName.substring(polyfillName.lastIndexOf(46) + 1));
            }
        }

        void visitPossibleStaticPolyfillUse(Node n) {
            String qname = RemoveUnusedPolyfills.removeExplicitGlobalPrefix(n.getQualifiedName());
            if (!this.isGuarded(qname)) {
                this.unusedStaticPolyfills.remove(qname);
                this.unusedMethodPolyfills.remove(PrototypeMethod.split(qname));
            }
        }

        void visitPossibleMethodPolyfillUse(Node n) {
            String methodName = n.getLastChild().getString();
            Set methods = this.methodsByName.get((Object)methodName);
            if (methods.isEmpty() || this.isGuarded("." + methodName)) {
                return;
            }
            TypeI receiverType = this.determineReceiverType(n);
            for (PrototypeMethod method : ImmutableSet.copyOf((Collection)methods)) {
                if (!this.isTypeCompatible(receiverType, method.type())) continue;
                this.unusedMethodPolyfills.remove(method);
            }
        }

        TypeI determineReceiverType(Node n) {
            TypeI maybeCtor;
            TypeI receiverType = n.getFirstChild().getTypeI();
            if (NodeUtil.isPrototypeProperty(n) && (maybeCtor = n.getFirstFirstChild().getTypeI()) != null && maybeCtor.isConstructor()) {
                receiverType = maybeCtor.toMaybeFunctionType().getInstanceType();
            }
            if (receiverType == null) {
                return null;
            }
            if ((receiverType = receiverType.restrictByNotNullOrUndefined()).isUnknownType() || receiverType.isBottom() || receiverType.isTop() || receiverType.isEquivalentTo(RemoveUnusedPolyfills.this.compiler.getTypeIRegistry().getNativeType(JSTypeNative.OBJECT_TYPE))) {
                return null;
            }
            return receiverType;
        }

        boolean isTypeCompatible(TypeI receiverType, String typeName) {
            if (receiverType == null) {
                return true;
            }
            TypeI type = RemoveUnusedPolyfills.this.compiler.getTypeIRegistry().getGlobalType(typeName);
            if (type == null) {
                throw new RuntimeException("Missing built-in type: " + typeName);
            }
            if (!receiverType.meetWith(type).isBottom()) {
                return true;
            }
            String primitiveType = RemoveUnusedPolyfills.unwrapPrimitiveWrapperTypename(typeName);
            return primitiveType != null && this.isTypeCompatible(receiverType, primitiveType);
        }
    }
}

